#include <time.h>
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>

extern void normal(void);
extern void read(char filename[]);
extern void readdata(char ext[]);
extern void readinst(char filename[]);
extern int sort_function( const void *a, const void *b);
void run3(void);

extern void sternber(void) {

 char choice;

 for(;;) {
  normal();
  _setcursortype(_NOCURSOR);
  window(18,6,62,19);
  textbackground(LIGHTGRAY);
  clrscr();
  window(20,7,60,18);
  textcolor(WHITE);
  textbackground(BLUE);
  clrscr();
  gotoxy(15,2);
  cprintf("STERNBERG MENU:");
  gotoxy(5,4);
  cprintf("1. Run the experiment");
  gotoxy(5,5);
  cprintf("2. Show individual results ");
  gotoxy(5,6);
  cprintf("3. Show SPSS ready file ");
  gotoxy(5,7);
  cprintf("4. Details of design");
  gotoxy(5,8);
  cprintf("5. References for further reading");
  gotoxy(5,9);
  cprintf("6. Return to main menu");
  gotoxy(2,12);
  cprintf("Enter choice (1-6)");

  Repeat:
  choice=getch();
  switch (choice) {

   case '1': run3();break;
   case '2': readdata(".ste");break;
   case '3': read("Sternber.cat");break;
   case '4': read("STEdets.txt");break;
   case '5': read("STErefs.txt");break;
   case '6': return;
   default: goto Repeat;
  }
 }
}


 /*RUN3(): Runs the experiment */

 void run3(void)
 {

  clock_t start, end;
  char *strng;
  float value,temp;
  int dec, sign;
  int ndig = 1;
  int b,correct, type;
  int cond[300];
  int count,a,i,sexno, x, y, comp;
  int rnumber, rnum[300],let;
  int error=0;
  int negtrial1=0, postrial1=0;
  int negtrial2=0, postrial2=0;
  int negtrial3=0, postrial3=0;
  int negtrial4=0, postrial4=0;
  int negtrial5=0, postrial5=0;
  int negtrial6=0, postrial6=0;
  double negRT1=0, posRT1=0;
  double negRT2=0, posRT2=0;
  double negRT3=0, posRT3=0;
  double negRT4=0, posRT4=0;
  double negRT5=0, posRT5=0;
  double negRT6=0, posRT6=0;
  double RT;
  double posMRT1,posMRT2,posMRT3,posMRT4,posMRT5,posMRT6;
  double negMRT1, negMRT2, negMRT3, negMRT4, negMRT5, negMRT6;
  float PC;
  float total;
  char pposset[40][7],posset[200][7];
  char init[5], sex,ch_ins,resp;
  char sexstr[2];
  char filename[20],filetemp[20],fileinfo[20];
  char ch, string[80];
  FILE *fpdat,*fpins,*fpmaster,*fp;
  struct find_t ffblk;

   normal();

  /* record personal data */
   textcolor(WHITE);
   for(;;) {

    do{
     clrscr();
     printf("\nPlease, enter up to four initials\n(press 'enter' when finished): ");
     gets(init);
    } while (strlen(init)>4);

    do {
     clrscr();
     printf("\nMale or female? (just press 'm' or 'f'): ");
     sex=getche();
     delay(300);
    } while (tolower(sex)!='m'&&tolower(sex)!='f');
    sexstr[0]=sex;
    sexstr[1]=0;



    do {
     clrscr();
     printf("\nInitials: %s\nSex: %c\n",init, sex);
     printf("\nAre these correct? (press 'y' or 'n')");
     resp=getche();
    } while (tolower(resp)!='y' && tolower(resp)!='n');

    if (tolower(resp)=='y') break;
    clrscr();
   }


   /*CHECK IF THE FILE EXISTS, ADD NUMBER AND SAVE*/

   value=0;
   ndig=1;
   strcpy(filename,init);
   strcat(filename,sexstr);

   for(;;){
    strcpy(filetemp,filename);
    if(value>9) ndig=2;
    strng = ecvt(value, ndig, &dec, &sign);
    strcat(filetemp,strng);
    strcpy(fileinfo,filetemp);
    strcat(filetemp,".STE");
    if(ch=='q') exit(0);
    if(!_dos_findfirst(filetemp,_A_NORMAL,&ffblk)) value++;
    else break;
   }


   if((fp=fopen(filetemp,"w"))==NULL) {
    printf("Error: Cannot open %s file",filename);
    exit(1);
   }

   fprintf(fp,"Initials: %s \nSex: %c\n",init,sex);
   fclose(fp);
   clrscr();


    /* instructions */

   readinst("steins.txt");
   textcolor(WHITE);
   clrscr();
   printf("\a");
   delay(1000);
   textcolor(WHITE);




   //CREATE STIMULI.........




   randomize();
   y=0;
   for(x=0;x<144;x++) {
    if(y>5) y=0;
    y++;
    for(a=0;a<y;) {
     comp=0;
     rnumber=random(10);
     for(i=0;i<a;i++) if(rnumber+48==posset[x][i]) comp++;
     if(!comp) {
      posset[x][a]=rnumber+48;
      a++;
     }
    }
    posset[x][y]=0;
   }


   //create stimuli for practice trials.............

   y=0;
   for(x=0;x<24;x++) {
    if(y>5) y=0;
    y++;
    for(a=0;a<y;) {
     comp=0;
     rnumber=random(10);
     for(i=0;i<a;i++) if(rnumber+48==pposset[x][i]) comp++;
     if(!comp) {
      pposset[x][a]=rnumber+48;
      a++;
     }
    }
    pposset[x][y]=0;
   }



  /* PRACTICE TRIALS*/



   /*present Practice trials*/
   _setcursortype(_NOCURSOR);

    /* create random numbers */

   for(a=0;a<24;) {
    comp=0;
    rnumber=random(24);
    for(i=0;i<a;i++) if(rnumber==rnum[i]) comp++;
    if(comp==0) {
     rnum[a]=rnumber;
     a++;
    }
   }

   for(count=0;count<24;count++) {


    correct=1;
     /* present cue*/
    clrscr();
    gotoxy(38,10);
    cprintf("+");
    delay(500);
    clrscr();

    delay(500);

     /*present numbers*/
    for(a=0;a<strlen(pposset[rnum[count]]);a++) {
     gotoxy(38,10);
     putchar(pposset[rnum[count]][a]);
     delay(1200);
     clrscr();
    }
    sound(200);
    delay(200);
    nosound();
    delay(1800);

    // chose whether to present negative or positive target
    if(random(100)%2) type=1;
    else type=0;

    // present number

    if(type) {
     rnumber=random(strlen(pposset[rnum[count]]));
     gotoxy(38,10);
     putchar(pposset[rnum[count]][rnumber]);
    }

    else {
     Again:
     comp=0;
     rnumber=random(10);
     for(i=0;i<a;i++) if(rnumber+48==pposset[rnum[count]][i]) comp++;
     if(!comp) {
      gotoxy(38,10);
      putchar(rnumber+48);
     }
     else goto Again;
    }


    while(kbhit()) getch();
    //start clock
    start = clock();

    //get response

    do{
     ch=getch();
    } while (tolower(ch)!='q' && tolower(ch)!='p');

    // stop clock
    end = clock();
    RT=(end-start)/CLK_TCK*1000;

    clrscr();

    if((type&&tolower(ch)=='p')||(!type&&tolower(ch)=='q')) {
     correct=0;
     sound(50);
     delay(200);
     nosound();
    }
    //FEEDBACK
    gotoxy(20,11);
    cprintf("Positive set:  %s", pposset[rnum[count]]);
    gotoxy(20,12);
    if(type) cprintf("Target number: %c", pposset[rnum[count]][rnumber]);
    else cprintf("Target number: %c", rnumber+48);
    gotoxy(22,9);
    if(correct) cprintf("CORRECT");
    else cprintf("ERROR");
    gotoxy(20,13);
    if(correct) cprintf("Reaction time=%7.0lf ms.",RT);
    gotoxy(1,25);
    cprintf("Press any key to continue...");
    getch();

   }


     /* Pause between sessions*/
   gotoxy(1,25);
   cprintf("Press any key to go on to experimental trials...");
   window(1,1,80,24);
   textcolor(BLACK);
   textbackground(LIGHTGRAY);
   clrscr();

   if((fpins=fopen("steins2.txt","r"))==NULL) {
    printf("Cannot open 'STEINS2.TXT' file!");
    exit(1);
   }

   while((ch_ins=fgetc(fpins))!=EOF) putchar(ch_ins);
   fclose(fpins);
   while(kbhit()) getch();
   getch();
   window(1,1,80,25);
   textcolor(WHITE);
   textbackground(BLACK);
   clrscr();
   printf("\a");
   delay(1000);




     /* EXPERIMENTAL TRIALS*/



   for(a=0;a<144;) {
    comp=0;
    rnumber=random(144);
    for(i=0;i<a;i++) if(rnumber==rnum[i]) comp++;
    if(comp==0) {
     rnum[a]=rnumber;
     a++;
    }
   }


   for(count=0;count<144;count++) {

    correct=1;
     /* present cue*/
    clrscr();
    gotoxy(38,10);
    cprintf("+");
    delay(500);
    clrscr();

    delay(500);

     /*present numbers*/
    for(a=0;a<strlen(posset[rnum[count]]);a++) {
     gotoxy(38,10);
     putchar(posset[rnum[count]][a]);
     delay(1200);
     clrscr();
    }
    sound(200);
    delay(200);
    nosound();
    delay(1800);

    // chose whether to present negative or positive target
    if(random(100)%2) type=1;
    else type=0;

    // present number

    if(type) {
     rnumber=random(strlen(posset[rnum[count]]));
     gotoxy(38,10);
     putchar(posset[rnum[count]][rnumber]);
    }

    else {
     Repeat:
     comp=0;
     rnumber=random(10);
     for(i=0;i<a;i++) if(rnumber+48==posset[rnum[count]][i]) comp++;
     if(!comp) {
      gotoxy(38,10);
      putchar(rnumber+48);
     }
     else goto Repeat;
    }


    while(kbhit()) getch();

    //start clock
    start = clock();

    //get response

    do{
     ch=getch();
    } while (tolower(ch)!='q' && tolower(ch)!='p');

    // stop clock
    end = clock();

    RT=(end-start)/CLK_TCK*1000;
    if(RT>2000) RT=2000;

    clrscr();

    if((type&&tolower(ch)=='p')||(!type&&tolower(ch)=='q')) {
     correct=0;
     error++;
     sound(50);
     delay(200);
     nosound();
    }
    if(type&&tolower(ch)=='q') {
     switch(strlen(posset[rnum[count]])) {
      case 1:posRT1=posRT1+RT;postrial1++;break;
      case 2:posRT2=posRT2+RT;postrial2++;break;
      case 3:posRT3=posRT3+RT;postrial3++;break;
      case 4:posRT4=posRT4+RT;postrial4++;break;
      case 5:posRT5=posRT5+RT;postrial5++;break;
      case 6:posRT6=posRT6+RT;postrial6++;break;

     }

    }
    if(!type&&tolower(ch)=='p') {
     switch(strlen(posset[rnum[count]])) {
      case 1:negRT1=negRT1+RT;negtrial1++;break;
      case 2:negRT2=negRT2+RT;negtrial2++;break;
      case 3:negRT3=negRT3+RT;negtrial3++;break;
      case 4:negRT4=negRT4+RT;negtrial4++;break;
      case 5:negRT5=negRT5+RT;negtrial5++;break;
      case 6:negRT6=negRT6+RT;negtrial6++;break;

     }

      /*pause after every 20 trials*/
     if(count>0 && count%24==0) {
      clrscr();
      printf("\a");
      gotoxy(20,10);
      printf("Have a short rest.\n");
      gotoxy(1,25);
      printf("Press any key to continue...");
      getch();
      clrscr();
      delay(500);
     }


    }

    delay(1000);
   }

   if(postrial1) posMRT1=posRT1/postrial1;
   else posMRT1=0;
   if(postrial2) posMRT2=posRT2/postrial2;
   else posMRT2=0;
   if(postrial3) posMRT3=posRT3/postrial3;
   else posMRT3=0;
   if(postrial4) posMRT4=posRT4/postrial4;
   else posMRT4=0;
   if(postrial5) posMRT5=posRT5/postrial5;
   else posMRT5=0;
   if(postrial6) posMRT6=posRT6/postrial6;
   else posMRT6=0;

   if(negtrial1) negMRT1=negRT1/negtrial1;
   else negMRT1=0;
   if(negtrial2) negMRT2=negRT2/negtrial2;
   else negMRT2=0;
   if(negtrial3) negMRT3=negRT3/negtrial3;
   else negMRT3=0;
   if(negtrial4) negMRT4=negRT4/negtrial4;
   else negMRT4=0;
   if(negtrial5) negMRT5=negRT5/negtrial5;
   else negMRT5=0;
   if(negtrial6) negMRT6=negRT6/negtrial6;
   else negMRT6=0;

   total=error+negtrial1+negtrial2+negtrial3+negtrial4+negtrial5+negtrial6+postrial1+postrial2+postrial3+postrial4+postrial5+postrial6;
   PC=(100*(total-error))/total;



     /*Record results*/
   if((fpdat=fopen(filetemp,"a"))==NULL) {
    printf("Cannot open '%s' file!",filetemp);
    exit(1);
   }


   fprintf(fpdat,"\nPositive set size:\t\t    Mean Reaction Time ");
   fprintf(fpdat,"\n                  \t\tPositive         Negative");
   fprintf(fpdat,"\n                1:\t\t%6.0lf\t\t%6.0lf  ",posMRT1,negMRT1);
   fprintf(fpdat,"\n                2:\t\t%6.0lf\t\t%6.0lf  ",posMRT2,negMRT2);
   fprintf(fpdat,"\n                3:\t\t%6.0lf\t\t%6.0lf  ",posMRT3,negMRT3);
   fprintf(fpdat,"\n                4:\t\t%6.0lf\t\t%6.0lf  ",posMRT4,negMRT4);
   fprintf(fpdat,"\n                5:\t\t%6.0lf\t\t%6.0lf  ",posMRT5,negMRT5);
   fprintf(fpdat,"\n                6:\t\t%6.0lf\t\t%6.0lf  ",posMRT6,negMRT6);
   fprintf(fpdat,"\n\nTotal percentage correct: %6.2f %%",PC);
   fclose(fpdat);

      /* Update master catalogue */
   if((fpmaster=fopen("sternber.cat","a"))==NULL) {
    printf("Error: Cannot open STERNBER.CAT file\n");
    exit(1);
   }
   if (tolower(sex)=='m') sexno=1;
   else if(tolower(sex)=='f') sexno=2;

   fprintf(fpmaster,"%4s %d %6.2f%5.0lf%5.0lf%5.0lf%5.0lf%5.0lf%5.0lf\n", init, sexno, PC,posMRT1,posMRT2,posMRT3,posMRT4,posMRT5,posMRT6);
   fprintf(fpmaster,"%5.0lf%5.0lf%5.0lf%5.0lf%5.0lf%5.0lf\n", negMRT1,negMRT2,negMRT3,negMRT4,negMRT5,negMRT6);
   fclose(fpmaster);






      /* END MESSAGE*/

   normal();
   _setcursortype(_NOCURSOR);
   window(9,8,71,17);
   textbackground(LIGHTGRAY);
   clrscr();
   window(10,9,70,16);
   textbackground(GREEN);
   textcolor(BLACK);
   clrscr();
   gotoxy(3,2);
   printf("THIS IS THE END OF THE EXPERIMENT");
   gotoxy(3,3);
   printf("YOUR SCORE IS %6.2f %% CORRECT",PC);
   gotoxy(3,5);
   printf("Your complete results were saved in the '%s' file.",filetemp);
   while(kbhit()) getch();
   getch();
   return;






 }



