{source code of the DataBase Interface for SuperMemo 6 Public Domain.
 Written in Borland Pascal 7.0. (C) Copyright 1991 SuperMemo World}

UNIT DBI; { DataBase Interface }


INTERFACE

uses dos,
     wind,getf,scan,dial,tim,ed,
     help,huff;

type
      fdistr_array=array[1..20] of word;
      idistr_array=array[1..13] of word;
      factor_array=array[1..20,1..20] of word;
      retention_array=array[1..20,1..20,1..20] of byte;
      info_record=record
           unclosed:boolean;
           reserved1:longint;
           reserved2:boolean;
           reserved3:word;
           FI_assumed:byte;
           total,memorized,
           current_record,current_position, {pointers to the ITM file}
           first_intact,last_intact,
           first_day,last_day,date_base, {date pointers}
           fi_sup:word; {forgetting index support}
           burden,AR,AL,AI,AF,AT,AG,FI:real; {AverageInterval,
             AverageRepetition, AverageLapses, AverageFactor, AverageTime,
             AverageQuality, ForgettingIndex}
           fdistr:fdistr_array; {distribution of factors}
           idistr:idistr_array; {distribution of intervals}
           RFs,ofs_, {array of R-factors and O-factors}
           Cases:factor_array; {support for optimal factors}
           ret,ret_sup:retention_array;
           end;

var   {INFO RECORD - exact copy of the above}
           unclosed:boolean;
           reserved1:longint;
           reserved2:boolean;
           reserved3:word;
           FI_assumed:byte;
           total,memorized,
           current_record,current_position, {pointers to the ITM file}
           first_intact,last_intact,
           first_day,last_day,date_base, {date pointers}
           fi_sup:word; {forgetting index support}
           burden,AR,AL,AI,AF,AT,AG,FI:real; {AverageInterval,
             AverageRepetition, AverageLapses, AverageFactor, AverageTime,
             AverageQuality, ForgettingIndex}
           fdistr:fdistr_array; {distribution of factors}
           idistr:idistr_array; {distribution of intervals}
           RFs,ofs_, {array of R-factors and O-factors}
           Cases:factor_array; {support for optimal factors}
           ret,ret_sup:retention_array;

var item_no,outstanding,
    next_rep,FCases,
    dno,optimal_interval,new_interval:word;
    old_burden,old_AI,old_FI,
    OldRF,NewRF,OldOF,NewOF:real;
    par_path:string[40];
    search_string:string[20];
    arrays_initialized,recovery:boolean;
    ReportAddr:pointer;

type
     ITM_record=string[250];

     ITI_record=record
                  rec:word; {record of the ITM file where the item is stored}
                  pos:byte; {position in the ITM file record}
                  next:word; {next item to repeat on a given day}
                  rep:byte; {number of repetitions}
                  lapses:byte; {number of memory lapses}
                  interval:word; {last interval used}
                  last_rep:word; {last repetition day}
                  factor:word; {e-factor multiplied by 1000}
                  case boolean of
                    true:(factor_used:word);
                    false:(next_intact:word);
                  end;

     DAT_record=record  {DATes}
                  no:word; {number of items scheduled for a given day}
                  ptr:word; {pointer to the ITI file were the first
                        item scheduled for a given day is stored. It is
                        zero if no items scheduled}
                  end;


     ITM_file=file of ITM_record;
     ITI_file=file of ITI_record;
     DAT_file=file of DAT_record;

var
    ITM_file_ptr:^ITM_file;
    ITI_file_ptr:^ITI_file;
    itemi:ITI_record;
    dbpath:pathstr;
    dbname,db_template,datS:filestr;
    datN:word;
    opened:boolean;
    path_used:string[48];

   {HANDLING THE INFO FILE}

function RETENTION:real;
procedure UPDATE_AT(time:real);
procedure UPDATE_AG(quality:real);
procedure UPDATE_AI(old,new:word);
procedure UPDATE_AR(old,new:byte);
procedure UPDATE_AL(old,new:byte);
procedure UPDATE_AF(old,new:word);
procedure UPDATE_FI(forgotten:boolean);
function FCATEG(factor:word):byte; {factor category}
function ICATEG(interval:word):byte; {interval category}
function DCAT(factor:real;rep:byte):byte; {factor -> category}
function DFACTOR(cat:real;rep:byte):real;   {category -> factor}
function TH_OF(cat,rep,FI:byte):real; {theoretical OF}
procedure CORRECT_OF(cat,rep:byte);
procedure UPDATE_FDISTR(factor:word;dir:integer);
procedure UPDATE_IDISTR(interval:word;dir:integer);
procedure READ_INFO;
procedure WRITE_INFO;

   {HANDLING ITEM MANIPULATION}

procedure ADD_ITEM;
procedure GET_ITEM(no:word);
procedure CHANGE_ITEM(no:word);
procedure DELETE_ITEM;

   {HANDLING THE FILE WITH ITEMS: ITM
     all procedures use the global variables QUESTION and ANSWER}

procedure READ_ITEM(rec,position:word);
procedure WRITE_ITEM(var rec,position:word);
procedure SUFFUSE(rec,position,length:word);

   {HANDLING THE FILE WITH INFORMATION ABOUT ITEMS
    all procedures use the global variable ITEMI}

procedure READ_ITEMI(no:word);
procedure WRITE_ITEMI(no:word);
procedure ADD_ITI_RECORD(var no:word);
procedure RETRACT_ITEMI;


   {HANDLING THE FUTURE SCHEDULE}

procedure SCHEDULE_ITEM(day,no:word);
procedure REMOVE_ITEM(day,no:word);
procedure CLEAN_DAY(day:word);

function DAY_BURDEN(day:word):integer;
function FIRST_ITEM(day:word):word;
function NEXT_ITEM(item:word):word;
function CHECK_ITEM(day,no:word):boolean;

function DAYS:word;

   {HANDLING THE PRIORITY QUEUE}

procedure ADD_PRIOR(no:word);
procedure CLEAN_PRIOR;
procedure REMOVE_PRIOR(item_no:word);

   {HANDLING THE REPS QUEUE FILE}

procedure ADD_REP(no:word);
function GET_REP:word;
function REP_NO:word;
procedure ERASE_REPEATS;

    {GLOBAL DATABASE OPERATIONS}

procedure OPEN_FILES;
procedure CLOSE_FILES;
procedure CREATE_DATABASE;
procedure INITIALIZE_ARRAYS;
function EXISTS_DB:boolean;
procedure SWITCH_FILES(a,b:pointer);
function ITM_SIZE:longint;
function ITI_SIZE:longint;
function DAT_SIZE:longint;
procedure DB_ERROR(no:byte);

procedure write_parameters;
procedure load_parameters(confirm:boolean);

     {OTHER}

function DISPERSE(interval,distance:real):word;
procedure MEMORIZE_ITEM;

IMPLEMENTATION

var
    itm:ITM_file;
    iti:ITI_file;
    dat:DAT_file;
    repeats:file of word;
    datrec:DAT_record;
    repeated:word;
    error:boolean;

procedure external_call;
  Inline($FF/$1E/ReportAddr);

procedure db_error(no:byte);
  var a:attributes;
      o1,o2,o3:string;
  begin
    o1:=m1;
    o2:=m2;
    o3:=m3;
    error:=true;
    get_attributes(a);
    m1:='WARNING! DATABASE INTEGRITY ERROR!';
    m3:='(Press ESC)';
    str(item_no,strg);
    case no of
      1:M2:='Wrong ITM record';
      2:M2:='Wrong ITM position';
      3:M2:='Wrong assignment pointer';
      4:M2:='Wrong interval';
      5:M2:='Wrong repetition date';
      6:M2:='Wrong E-factor';
      7:M2:='Wrong U-factor';
      8:M2:='Wrong intact pointer';
      9:M2:='Wrong intact queue';
     10:M2:='Wrong optimal factor';
     11:M2:='Removing unscheduled item';
     12:M2:='Circular intact queue';
     13:M2:='Wrong distribution of intervals';
     14:M2:='Wrong distribution of factors';
     15:M2:='Wrong ratio interval/U-factor';
     end;
    m2:=m2+' (item/day '+strg+')';
    help_no:=113;
    if recovery then external_call
       else begin
         peep1;
         ESC_dialog;
         end;
    set_attributes(a);
    m1:=o1;
    m2:=o2;
    m3:=o3;
    end;

procedure switch_files(a,b:pointer);
  begin
    if a=nil then begin
       ITM_file_ptr:=Addr(itm);
       ITI_file_ptr:=Addr(iti);
       end
    else begin
       ITM_file_ptr:=a;
       ITI_file_ptr:=b;
       end;
    end;

function DISPERSE(interval,distance:real):word;
  const a=0.04652;
        b=0.09210;
  var y,p:real;
  begin
    if distance>=interval then distance:=interval-1;
    p:=random/2;
    y:=-1/b*ln(1-b/a*p);
    if random>0.5 then y:=-y;
    r:=interval+y/50*distance;
    if r<1 then r:=1;
    disperse:=round(r);
    end;

procedure memorize_item;
  begin
    memorized:=memorized+1;
    correct_OF(fcateg(2500),1);
    r:=ofs_[fcateg(2500),1]/1000;
    optimal_interval:=round(r);
    new_interval:=disperse(r,r*0.7);
    itemi.factor_used:=new_interval*1000;
    itemi.last_rep:=dno;
    itemi.interval:=new_interval;
    itemi.rep:=1;
    write_itemi(item_no);
    schedule_item(dno+new_interval,item_no);
    next_rep:=dno+new_interval;
    update_fdistr(itemi.factor,+1);
    update_idistr(new_interval,+1);
    AI:=(AI*(memorized-1)+new_interval)/memorized;
    AR:=(AR*(memorized-1)+1)/memorized;
    AL:=AL*(memorized-1)/memorized;
    AF:=(AF*(memorized-1)+itemi.factor)/memorized;
    burden:=burden+1/new_interval;
    end;

function RETENTION:real;

  {estimates the retention in percent}

  const ratio=2.2; {FI/(100-retention) for low FI}
  begin
    retention:=100-FI/(1+(100-FI)/(100/(ratio-1)));
    end;

procedure UPDATE_AT(time:real);

   {updates the average time, TIME is expressed in seconds}

   begin
     r:=memorized/10;
     AT:=(AT*r+time)/(r+1);
     end;

procedure UPDATE_AG(quality:real);

   {updates the average quality}

   begin
     r:=memorized/20;
     AG:=(AG*r+quality)/(r+1);
     end;


procedure UPDATE_AI(old,new:word);

   {updates the average interval}

   begin
     AI:=(AI*memorized-old+new)/memorized;
     end;

procedure UPDATE_AR(old,new:byte);

   {updates the average repetition number}

   begin
     AR:=(AR*memorized-old+new)/memorized;
     end;

procedure UPDATE_AL(old,new:byte);

   {updates the average repetition number}

   begin
     AL:=(AL*memorized-old+new)/memorized;
     end;

procedure UPDATE_AF(old,new:word);

   {updates the average factor}

   begin
     AF:=(AF*memorized-old+new)/memorized;
     end;


procedure UPDATE_FI(forgotten:boolean);

  {updates F_INDEX after a repetition}

  begin
    FI:=(FI*FI_sup+100*byte(forgotten))/(FI_sup+1);
    if FI_sup<65534 then FI_sup:=FI_sup+1;
    end;

function FCATEG(factor:word):byte; {factor category}

  {returns the category of the FACTOR: 1..20}

  begin
    n:=trunc((factor-1)/100)-11;
    if n>20 then n:=20;
    fcateg:=n;
    end;

function ICATEG(interval:word):byte; {interval category}

  {returns the category of the INTERVAL: 1..13}

  begin
    if interval=1 then icateg:=1;
    if interval>1 then begin
       n:=trunc(ln(interval-0.5)/ln(2))+2;
       if n>13 then n:=13;
       icateg:=n;
       end;
    end;

function DFACTOR(cat:real;rep:byte):real;

   {returns the factor corresponding to a given distribution
    category}

  begin
    if rep=1 then dfactor:=cat;
    if rep=2 then dfactor:=1.0+cat*0.2;
    if rep>2 then dfactor:=1.0+cat*0.1;
    end;

function DCAT(factor:real;rep:byte):byte;

  {returns the distribution category of a given factor}

  begin
    if rep=1 then r:=factor;
    if rep=2 then r:=(factor-1)/0.2;
    if rep>2 then r:=(factor-1)/0.1;
    if r>20 then r:=20;
    if r<1 then r:=1;
    dcat:=round(r);
    end;

procedure UPDATE_FDISTR(factor:word;dir:integer);

   {updates the distribution of factors}
   var n:byte;
   begin
     n:=fcateg(factor);
     if dir=-1 then if fdistr[n]=0 then begin
        db_error(14);
        exit;
        end;
     fdistr[n]:=fdistr[n]+dir;
     end;

procedure UPDATE_IDISTR(interval:word;dir:integer);

   {updades the distribution of intervals}
   var n:byte;
   begin
     n:=icateg(interval);
     if dir=-1 then if idistr[n]=0 then begin
        db_error(13);
        exit;
        end;
     idistr[n]:=idistr[n]+dir;
     end;

procedure WRITE_INFO;

  {writes info to the INF file}

  var f:file;
      error:byte;
      len:word;
      workptr:pointer;
  begin
    assign(f,path_used+'.INF');
    GetMem(workptr,15000);
    len:=0;
    if workptr<>nil then
       huffman_coding(Addr(unclosed),workptr,SizeOf(info_record),len);
    if (workptr=nil)or(len>20000) then begin
       m1:='';
       m2:='OUT OF MEMORY';
       m3:='';
       ESC_dialog;
       exit;
       end;
    repeat
      {$I-}
      rewrite(f,1);
      error:=IOresult;
      if error=0 then begin
         BlockWrite(f,workptr^,len);
         error:=IOresult;
      {$I+}
         close(f);
         end;
      until not(disk_error(error));
    FreeMem(workptr,15000);
    end;

procedure READ_INFO;

  {reads info from the INF file}

  var f:file;
      info:file of byte;
      error,one:byte;
      workptr:pointer;
  begin
    path_used:=dbpath+dbname;
    assign(f,path_used+'.INF');
    GetMem(workptr,15000);
    if workptr=nil then begin
       m1:='';
       m2:='OUT OF MEMORY';
       m3:='';
       dialog;
       exit;
       end;
    repeat
      reset(f,1);
      error:=IOresult;
      if error=0 then begin
         BlockRead(f,workptr^,FileSize(f));
         error:=IOResult;
         close(f);
         end;
      until not(disk_error(error));
    huffman_decoding(workptr,Addr(unclosed),SizeOf(info_record));
    FreeMem(workptr,15000);
    arrays_initialized:=true;
    if unclosed then begin
       m1:='THIS DATABASE HAS NOT BEEN CLOSED RECENTLY!';
       m2:='USE YOUR BACK-UPS OR RECOV6.EXE/RESCUE.EXE';
       m3:='(press ESC)';
       ESC_dialog;
       end;
    unclosed:=true;
    write_info;
    unclosed:=false;
    end;

function f1_13(x:real):real;
  const x1=2;y1=1.2;
        x2=5;y2=3;
  begin
    f1_13:=(y2-y1)/(x2-x1)*(x-x1)+y1;
    end;

function f1_25(x:real):real;
  const x1=2;y1=2;
        x2=5;y2=4;
  begin
    f1_25:=(y2-y1)/(x2-x1)*(x-x1)+y1;
    end;

function f1(x,y1,y2:real):real;
  const x1=1.3;
        x2=2.5;
  begin
    f1:=(y2-y1)/(x2-x1)*(x-x1)+y1;
    end;

function f2_13(x:real):real;
  const x1=2;y1=1.2;
        x2=5;y2=1.3;
  begin
    f2_13:=(y2-y1)/(x2-x1)*(x-x1)+y1;
    end;

function f2_25(x:real):real;
  const x1=2;y1=1.8;
        x2=5;y2=2.6;
  begin
    f2_25:=(y2-y1)/(x2-x1)*(x-x1)+y1;
    end;

function f2(x,y1,y2:real):real;
  const x1=1.3;
        x2=2.5;
  begin
    f2:=(y2-y1)/(x2-x1)*(x-x1)+y1;
    end;

function f3_13(x:real):real;
  const x1=2;y1=1.2;
        x2=5;y2=1.25;
  begin
    f3_13:=(y2-y1)/(x2-x1)*(x-x1)+y1;
    end;

function f3_25(x:real):real;
  const x1=2;y1=1.5;
        x2=5;y2=2.0;
  begin
    f3_25:=(y2-y1)/(x2-x1)*(x-x1)+y1;
    end;

function f3(x,y1,y2:real):real;
  const x1=1.3;
        x2=2.5;
  begin
    f3:=(y2-y1)/(x2-x1)*(x-x1)+y1;
    end;

function th_OF(cat,rep,FI:byte):real;

  {returns the theoretically predicted value of the optimal factor}

  var a,b,x:real;
  begin
    case rep of
      1:begin
	  a:=f1_13(FI); {value of OF for category 1.3}
	  b:=f1_25(FI); {value of OF for category 2.5}
	  x:=f1(1.2+cat*0.1,a,b);
	  end;
      2:begin
	  a:=f2_13(FI); {value of OF for category 1.3}
	  b:=f2_25(FI); {value of OF for category 2.5}
	  x:=f2(1.2+cat*0.1,a,b);
	  if x>5 then x:=5;
	  end;
      else begin
	  a:=f3_13(FI); {value of OF for category 1.3}
	  b:=f3_25(FI); {value of OF for category 2.5}
	  x:=f3(1.2+cat*0.1,a,b);
	  if x>3 then x:=3;
	  end;
      end;
  th_OF:=x;
  end;


procedure INITIALIZE_ARRAYS;

  {initializes ofs_, Sofs_, RET, RET_SUP arrays}

  begin
    for n:=1 to 20 do
        for m:=1 to 20 do begin
            RFs[n,m]:=round(th_OF(n,m,FI_assumed)*1000);
            ofs_[n,m]:=RFs[n,m];
            Cases[n,m]:=0;
            end;
    FillChar(ret,SizeOf(ret)+SizeOf(ret_sup),#0);
    end;

procedure CREATE_INFO;

   {initializes the info file}

  begin
    FI_assumed:=10;
    total:=0;
    memorized:=0;
    current_record:=1;
    current_position:=1;
    first_intact:=0;
    last_intact:=0;
    first_day:=read_date;
    last_day:=1;
    date_base:=0;
    fi_sup:=0;
    burden:=0;
    AI:=0;
    AR:=0;
    AL:=0;
    AF:=0;
    AT:=0;
    AG:=4;
    FI:=0;
    for n:=1 to 20 do fdistr[n]:=0;
    for n:=1 to 13 do idistr[n]:=0;
    if not arrays_initialized then initialize_arrays;
    unclosed:=false;
    path_used:=dbpath+dbname;
    write_info;
    end;

procedure SET_FILE_POINTERS;

   {sets pointer to file variables for procedures that use more than
    one file as input}

   begin
     ITM_file_ptr:=Addr(itm);
     ITI_file_ptr:=Addr(iti);
     end;

procedure READ_ITEM(rec,position:word);

  {reads a question and answer from the specified RECORD and POSITION in
   the ITM file}

  var item:ITM_record;
  begin
    question:='';
    answer:='';
    if position=0 then exit;
    if rec>ITM_size then exit;
    seek(itm,rec-1);
    read(itm,item);
    delete(item,1,position-1);
    n:=pos('',item);
    if n=0 then begin
      question:=item;
      if eof(ITM) then exit;
      read(itm,item);
      n:=pos('',item);
      end;
    question:=question+copy(item,1,n-1);
    delete(item,1,n);
    n:=pos('',item);
    if n=0 then begin
      answer:=item;
      if eof(itm) then exit;
      read(itm,item);
      n:=pos('',item);
      end;
    answer:=answer+copy(item,1,n-1);
    end;

procedure WRITE_STRING(var rec,position:word;item:string);

   {writes the ITEM string to the specified location of the
    ITM file. The new writing location is specified by RECORD and
    POSITION variables}

  var buffer,ins:ITM_record;
  begin
    if rec>FileSize(ITM_file_ptr^) then begin
       seek(ITM_file_ptr^,FileSize(ITM_file_ptr^));
       buffer:=chars(250,'');
       repeat
         write(ITM_file_ptr^,buffer);
         until not(disk_error(IOresult));
       end;
    while length(item)>0 do begin
      seek(ITM_file_ptr^,rec-1);
      read(ITM_file_ptr^,buffer);
      n:=251-position;
      if n>length(item) then n:=length(item);
      delete(buffer,position,n);
      ins:=copy(item,1,n);
      insert(ins,buffer,position);
      delete(item,1,n);
      position:=position+n;
      seek(ITM_file_ptr^,rec-1);
      write(ITM_file_ptr^,buffer);
      if position>250 then begin
        rec:=rec+1;
        if rec=filesize(ITM_file_ptr^)+1 then begin
          seek(ITM_file_ptr^,rec-1);
          buffer:=chars(250,'');
          write(ITM_file_ptr^,buffer);
          end;
        position:=1;
        end;
      end;
    end;

procedure WRITE_ITEM(var rec,position:word);

  {writes the question and item strings to the ITM file at the specified
  RECORD:POSITION location.
  New writing location is given by RECORD and POSITION}

  begin
    write_string(rec,position,question+'');
    write_string(rec,position,answer+'');
    end;

procedure SUFFUSE(rec,position,length:word);

   {writes ''s into the ITM file}

   var ins:ITM_record;
       chrs:byte;
   begin
     while length>0 do begin
         chrs:=((length-1) mod 250)+1;
         ins:=chars(chrs,'');
         write_string(rec,position,ins);
         length:=length-chrs;
         end;
     end;

procedure correct_itemi(no:word);
  var ok:boolean;
  begin
    if itemi.factor=0 then exit;
    error:=false;
    if (itemi.rec>ITM_size)or(itemi.rec=0) then begin
       db_error(1);
       itemi.factor:=0;
       end;
    if itemi.pos>250 then begin
       db_error(2);
       itemi.pos:=250;
       end;
    if itemi.next>ITI_size then if itemi.interval<>0 then begin
       db_error(3);
       itemi.next:=0;
       end;
    if itemi.interval=0 then if itemi.rep>0 then begin
       db_error(4);
       itemi.interval:=1;
       end;
    if itemi.factor<>0 then
       if (itemi.factor<1300)or(itemi.factor>4500) then begin
          db_error(6);
          itemi.factor:=2500;
          end;
    if itemi.rep>1 then if itemi.factor_used<1000 then begin
       db_error(7);
       itemi.factor_used:=1100;
       end;
    if itemi.rep=0 then
       if itemi.next_intact>ITI_size then begin
          db_error(8);
          itemi.next_intact:=0;
          end;
    if error then write_itemi(no);
    end;

procedure correct_OF(cat,rep:byte);
  begin
    if rep=1 then begin
       if ofs_[cat,rep]>60000 then begin
          ofs_[cat,rep]:=60000;
          db_error(10);
          end;
       if ofs_[cat,rep]<1000 then begin
          ofs_[cat,rep]:=1000;
          db_error(10);
          end;
       exit;
       end;
    if ofs_[cat,rep]<1200 then begin
       ofs_[cat,rep]:=1200;
       db_error(10);
       exit;
       end;
    if rep=2 then begin
       if ofs_[cat,rep]>5000 then begin
          ofs_[cat,rep]:=5000;
          db_error(10);
          end;
       exit;
       end;
    if ofs_[cat,rep]>3000 then begin
       ofs_[cat,rep]:=3000;
       db_error(10);
       end;
    end;


procedure READ_ITEMI(no:word);

   {reads to ITEMI the ITI record of the given item}

   begin
     seek(iti,no-1);
     read(iti,itemi);
     correct_itemi(no);
     end;

procedure WRITE_ITEMI(no:word);

   {writes ITEMI to the ITI record of the given item}

   begin
     seek(iti,no-1);
     write(iti,itemi);
     end;

procedure init_itemi;
  begin
      itemi.rec:=current_record;
      itemi.pos:=current_position;
      itemi.factor:=2500;
      itemi.factor_used:=0;
      itemi.next:=0;
      itemi.rep:=0;
      itemi.lapses:=0;
      itemi.interval:=0;
      itemi.last_rep:=0;
      end;

procedure ADD_ITI_RECORD(var no:word);

    {adds ITEMI as a new record to the ITI_file}

    begin
      no:=FileSize(ITI_file_ptr^)+1;
      seek(ITI_file_ptr^,no-1);
      repeat
        write(ITI_file_ptr^,itemi);
        until not(disk_error(IOresult));
      end;

function ITI_SIZE:longint;

  {returns the number of records stored in the ITI file}

  begin
    ITI_size:=FileSize(ITI);
    end;

function ITM_SIZE:longint;

  {returns the number of records stored in the ITM file}

  begin
    ITM_size:=FileSize(ITM);
    end;

function DAT_SIZE:longint;

  {returns the number of records stored in the DAT file}

  begin
    DAT_size:=FileSize(DAT);
    end;

procedure SCHEDULE_ITEM(day,no:word);

  {schedules the ITEM for the given DAY expressed relative to the
   first_day which corresponds to DAY=1.
   DAT_file_ptr indicates the file which will be used in scheduling.
   WARNING! When used in conjunction with REMOVE_ITEM, IT MUST COME
   SECOND!}

  var itirec:ITI_record;
  begin
    while filesize(dat)<(day-date_base) do begin
          seek(dat,filesize(dat));
          datrec.no:=0;
          datrec.ptr:=0;
          repeat
            write(dat,datrec);
            until not(disk_error(IOresult));
          end;
    seek(dat,day-date_base-1);
    read(dat,datrec);
    n:=datrec.ptr;
    datrec.ptr:=no;
    datrec.no:=datrec.no+1;
    seek(dat,day-date_base-1);
    write(dat,datrec);
    seek(iti,no-1);
    read(iti,itirec);
    itirec.next:=n;
    seek(iti,no-1);
    write(iti,itirec);
    end;

procedure REMOVE_ITEM(day,no:word);

  {removes the ITEM from the schedule of a given DAY.
   The removed item has its NEXT pointer set to zero.
   If no such item is scheduled then integrity error is
   reported by SuperMemo}

  var last_ptr,ptr:word;
      itirec:ITI_record;
  begin
    seek(dat,day-date_base-1);
    read(dat,datrec);
    seek(dat,day-date_base-1);
    datrec.no:=datrec.no-1;
    if datrec.ptr=no then begin
       seek(iti,datrec.ptr-1);
       read(iti,itirec);
       n:=itirec.next;
       itirec.next:=0;
       seek(iti,datrec.ptr-1);
       write(iti,itirec);
       datrec.ptr:=n;
       write(dat,datrec);
       exit;
       end
     else write(dat,datrec);
    ptr:=datrec.ptr;
    repeat
      if ptr=0 then begin
         db_error(11);
         exit;
         end;
      seek(iti,ptr-1);
      read(iti,itirec);
      last_ptr:=ptr;
      ptr:=itirec.next;
      until ptr=no;
    seek(iti,ptr-1);
    read(iti,itirec);
    n:=itirec.next;
    itirec.next:=0;
    seek(iti,ptr-1);
    write(iti,itirec);
    seek(iti,last_ptr-1);
    read(iti,itirec);
    itirec.next:=n;
    seek(iti,last_ptr-1);
    write(iti,itirec);
    end;

procedure CLEAN_DAY(day:word);

   {resets the schedule for a given day}

   begin
    datrec.no:=0;
    datrec.ptr:=0;
    seek(dat,day-date_base-1);
    write(dat,datrec);
    end;

function DAY_BURDEN(day:word):integer;

  {reports the number of items scheduled for a given day.
   Requests past the DAT file return -1}

  begin
    if filesize(dat)+date_base<day then begin
       day_burden:=-1;
       exit;
       end;
    if day<last_day then begin
       day_burden:=0;
       exit;
       end;
    if day<date_base+1 then begin
       day_burden:=0;
       exit;
       end;
    seek(dat,day-date_base-1);
    read(dat,datrec);
    day_burden:=datrec.no;
    end;

function FIRST_ITEM(day:word):word;

   {returns the first item scheduled for a given day, or zero
    if no items scheduled}

    begin
      if day-date_base-1>=FileSize(dat) then begin
         first_item:=0;
         exit;
         end;
      seek(dat,day-date_base-1);
      read(dat,datrec);
      first_item:=datrec.ptr;
      end;

function NEXT_ITEM(item:word):word;

    {returns the item scheduled after the ITEM}

    begin
      seek(iti,item-1);
      read(iti,itemi);
      next_item:=itemi.next;
      end;

function CHECK_ITEM(day,no:word):boolean;

  {checks if the ITEM is scheduled for the given DAY}

  var itirec:ITI_record;
  begin
    check_item:=false;
    seek(dat,day-date_base-1);
    read(dat,datrec);
    itirec.next:=datrec.ptr;
    while itirec.next<>0 do begin
      seek(iti,itirec.next-1);
      read(iti,itirec);
      if itirec.next=no then begin
         check_item:=true;
         exit;
         end;
      end;
  end;

function DAYS:word;

   {returns the number of days stored in the DAT file}

   begin
     days:=filesize(dat)+date_base;
     end;

procedure ADD_PRIOR(no:word);

  {adds the item NO to the priority queue}

  var itirec:ITI_record;
  begin
    seek(iti,no-1);
    read(iti,itirec);
    itirec.next_intact:=0;
    seek(iti,no-1);
    write(iti,itirec);
    if last_intact<>0 then begin
       seek(iti,last_intact-1);
       read(iti,itirec);
       itirec.next_intact:=no;
       seek(iti,last_intact-1);
       write(iti,itirec);
       end;
    last_intact:=no;
    if first_intact=0 then first_intact:=no;
    end;

procedure CLEAN_PRIOR;

    {removes the first item from the priority queue}

  var itirec:ITI_record;
  begin
    if first_intact=0 then exit;
    if first_intact>ITI_size then begin
       db_error(9);
       exit;
       end;
    seek(iti,first_intact-1);
    read(iti,itirec);
    first_intact:=itirec.next_intact;
    if first_intact=0 then last_intact:=0;
    end;

procedure REMOVE_PRIOR(item_no:word);

    {removes ITEM_NO from the priority queue. If such items is not
     scheduled, runtime error will follow.
     Used by MEMORIZE in ADDONS}

     var itirec:ITI_record;
	 next,position,intact:word;
     begin
       intact:=ITI_size-memorized+1;
       seek(iti,item_no-1);
       read(iti,itirec);
       next:=itirec.next_intact;
       itirec.next_intact:=0;
       seek(iti,item_no-1);
       write(iti,itirec);
       if first_intact=item_no then begin
	  first_intact:=next;
	  if first_intact=0 then last_intact:=0;
	  exit;
	  end;
       itirec.next_intact:=first_intact;
       repeat
         intact:=intact-1;
         if intact=0 then begin
            db_error(12);
            exit;
            end;
	 seek(iti,itirec.next_intact-1);
	 position:=itirec.next_intact;
	 read(iti,itirec);
	 until itirec.next_intact=item_no;
      seek(iti,position-1);
      read(iti,itirec);
      itirec.next_intact:=next;
      seek(iti,position-1);
      write(iti,itirec);
      if next=0 then last_intact:=position;
      end;

procedure ADD_ITEM;

   {adds QUESTION, ANSWER and ITEMI as a new item in the database.
    Values LAST_RECORD and LAST_POSITION are updated accordingly}

   begin
     init_itemi;
     add_ITI_record(item_no);  {ITEM_NO is set by the procedure}
     write_item(current_record,current_position);
     add_prior(item_no);
     end;

procedure GET_ITEM(no:word);

   {returns QUESTION, ANSWER and ITEMI of the NO item}

   begin
     read_itemi(no);
     if itemi.factor=0 then exit;
     read_item(itemi.rec,itemi.pos);
     end;

procedure CHANGE_ITEM(no:word);

   {replace the text of the NO item with the new QUESTION and ANSWER.
    If no space available, then the old location is suffused, new
    position is allocated and the LAST_RECORD and LAST_POSITION are
    updated}

   var new_question,new_answer:ITM_record;
       old_length,new_length,position:word;
   begin
     new_question:=question;
     new_answer:=answer;
     get_item(no);
     old_length:=length(question)+length(answer);
     new_length:=length(new_question)+length(new_answer);
     question:=new_question;
     answer:=new_answer;
     position:=itemi.pos;
     suffuse(itemi.rec,itemi.pos,old_length+1);
     if new_length<=old_length then write_item(itemi.rec,position)
        else begin
               itemi.rec:=current_record;
               itemi.pos:=current_position;
               write_itemi(no);
               write_item(current_record,current_position);
               end;
     end;

procedure RETRACT_ITEMI;

   {updates all parameters changed by removal of an item. All
    data for the ITEM_NO item are provided by the ITEMI record.
    The AF, AI, FDISTR, IDISTR, BURDEN, MEMORIZED, TOTAL and
    OUTSTANDING parameters are readjusted.
    REMOVE_ITEM is called to clean the future list.
    The procedure is used by DBI.DELETE_ITEM and ADDONS.RESET}

    begin
      if itemi.interval=0 then exit;
      update_idistr(itemi.interval,-1);
      update_fdistr(itemi.factor,-1);
      if memorized>1 then begin
         AI:=(AI*memorized-itemi.interval)/(memorized-1);
         AF:=(AF*memorized-itemi.factor)/(memorized-1);
         AR:=(AR*memorized-itemi.rep)/(memorized-1);
         AL:=(AL*memorized-itemi.lapses)/(memorized-1);
         burden:=burden-1/itemi.interval;
         end
       else begin
         AI:=0;
         AF:=0;
         AL:=0;
         AR:=0;
         burden:=0;
         end;
      memorized:=memorized-1;
      if itemi.last_rep+itemi.interval<=dno then
         outstanding:=outstanding-1;
      remove_item(itemi.last_rep+itemi.interval,item_no);
      end;

procedure DELETE_ITEM;

   {deletes the ITEM_NO item by setting its factor to zero. The ITM file
   location is suffused and the future files are updated. The AF, AI,
   FDISTR, IDISTR, BURDEN, MEMORIZED, TOTAL and OUTSTANDING are
   readjusted. The item is removed from the repetition schedule, but
   if it is intact, it is not removed from the intact queue.
   Used only in the BROWSE_LOOP}

   begin
     n:=length(question)+length(answer);
     if itemi.rec<>0 then suffuse(itemi.rec,itemi.pos,n+1);
     retract_itemi;
     total:=total-1;
     itemi.factor:=0;
     write_itemi(item_no);
     end;

procedure ADD_REP(no:word);

  {adds the NO item to the repetition queue}

  begin
    seek(repeats,FileSize(repeats));
    repeat
      write(repeats,no);
      until not(disk_error(IOresult));
    end;

function GET_REP:word;

  {returns the first item from the repetition queue}

  begin
    seek(repeats,repeated+1);
    read(repeats,n);
    get_rep:=n;
    repeated:=repeated+1;
    end;

function REP_NO:word;

   {returns the number of items pending in the repetition queue}

   begin
     REP_NO:=FileSize(repeats)-1-repeated;
     end;

procedure OPEN_REPEATS;

   {opens or creats the REPEATS file}

   begin
     assign(repeats,path_used+'.DRL');
     {$I-}
     reset(repeats);
     if IOresult=0 then begin
        read(repeats,repeated);
        if IOresult=0 then exit
           else close(repeats);
        rewrite(repeats);
        end
     else rewrite(repeats);
     if disk_error(IOResult) then begin
        m1:='';
        m2:='CANNOT REWRITE THE FINALL DRILL FILE';
        m3:='(press ESC)';
        ESC_dialog;
        opened:=false;
        exit;
        end;
     repeated:=0;
     write(repeats,repeated);
     if disk_error(IOResult) then opened:=false;
     {$I+}
     end;

procedure CLOSE_REPEATS;

    {closes the REPEATS file and erases it if empty}

    begin
      if rep_no=0 then begin
         close(repeats);
         erase(repeats);
         end
      else begin
         seek(repeats,0);
         write(repeats,repeated);
         close(repeats);
         end;
      end;

procedure ERASE_REPEATS;

     {erases the REPEATS file}

     begin
       {$I-}
       erase(repeats);
       {$I+}
       n:=IOresult;
       end;

procedure ASSIGN_FILES;

  {assigns or files of the database and the REPEATS file according
   to the PATH+DBNAME specification}

  begin
    assign(itm,path_used+'.ITM');
    assign(iti,path_used+'.ITI');
    assign(dat,path_used+'.DAT');
    end;

procedure OPEN_FILES;

  {opens all the files of a SuperMemo database according to the
   assignment by ASSIGN FILES.
   Global variable OPENED indicates if the operation was
   successful}

  var error:byte;
  begin
    assign_files;
    {$I-}
    repeat
      reset(itm);
      error:=IOresult;
      if error=0 then begin
         reset(iti);
         error:=IOresult;
         end;
      if error=0 then begin
         reset(dat);
         error:=IOresult;
         end;
      until not(disk_error(error));
    {$I+}
    open_repeats;
    set_file_pointers;
    opened:=true;
    end;

procedure CLOSE_FILES;

  {closes all files of the SuperMemo database if they are opened.
   The OPENED=false indicates that the operation was successful}

  begin
    repeat
      close(itm);
      until not(disk_error(IOresult));
    close(iti);
    close(dat);
    close_repeats;
    opened:=false;
    end;

procedure CREATE_DATABASE;

  {initializes a database according to PATH+DBNAME specification}

  var error:byte;
  begin
    create_info;
    assign_files;
    repeat
      rewrite(itm);
      error:=IOresult;
      if error=0 then begin
         rewrite(iti);
         error:=IOresult;
         end;
      if error=0 then begin
         rewrite(dat);
         error:=IOresult;
         end;
      if error=0 then begin
         datrec.no:=0;
         datrec.ptr:=0;
         write(dat,datrec);
         error:=IOresult;
         end;
      until not(disk_error(error));
    opened:=true;
    open_repeats;
    if not opened then exit;
    erase_repeats;
    open_repeats;
    if not opened then exit;
    set_file_pointers;
    end;

function EXISTS_DB:boolean;

  {checks if the database defined by DBPATH+DBNAME exists}

  var f:file;
  begin
    assign(f,dbpath+dbname+'.INF');
    {$I-}
    reset(f,1);
    {$I+}
    n:=IOresult;
    if n=0 then close(f);
    exists_db:=n=0;
    end;

procedure WRITE_PARAMETERS;

   {writes parameters to the parameter file in the PAR_PATH directory}

  var params:text;
      ptr:pointer;
  begin
    if exists_file(par_path+'sm6.par') then begin
       m1:='';
       m2:='OVERWRITE SM6.PAR (Y/N)?';
       m3:='(Path='+par_path+')';
       help_no:=47;
       querry;
       if ch<>'Y' then exit;
       end;
    assign(params,par_path+'sm6.par');
    {$I-}
    rewrite(params);
    {$I+}
    if IOresult<>0 then begin
       m1:='';
       m2:='INCORRECT PARAMETER PATH';
       m3:='';
       dialog;
       exit;
       end;
    writeln(params,snd);
    writeln(params,dbpath);
    writeln(params,help_path);
    writeln(params,par_path);
    writeln(params,comspec_path);
    writeln(params,UK_date);
    writeln(params,mono);
    writeln(params,search_string);
    writeln(params,FI_assumed);
    close(params);
    beep;
    end;

procedure LOAD_PARAMETERS(confirm:boolean);

  {loads parameters from the parameter path in the PAR_PATH directory.
   If the CONFIRM variable is true then a confirmation of the operation
   is requested}

  var params:text;
      ptr:pointer;
  begin
    escape:=false;
    filename:='SM6.PAR';
    if confirm then
       while (not(exists_file(par_path+'sm6.par')))and(not escape) do
             fix_path(par_path,filename);
    if escape then exit;
    if confirm then begin
       m1:='';
       m2:='LOAD FROM SM6.PAR (Y/N)?';
       m3:='(Path='+par_path+')';
       help_no:=48;
       querry;
       if ch<>'Y' then exit;
       end;
    if not(exists_file(par_path+'sm6.par')) then exit;
    assign(params,par_path+'sm6.par');
    reset(params);
    readln(params,strg);
    snd:=strg='TRUE';
    readln(params,dbpath);
    readln(params,help_path);
    readln(params,par_path);
    readln(params,comspec_path);
    readln(params,strg);
    UK_date:=strg='TRUE';
    readln(params,strg);
    mono:=strg='TRUE';
    readln(params,search_string);
    {$I-}
    readln(params,FI_assumed);
    {$I+}
    if IOResult<>0 then;
    close(params);
    if confirm then beep;
    end;

BEGIN
  db_template:='*.INF';
  opened:=false;
  dbpath:='';
  dbname:='';
  arrays_initialized:=false;
  FI_assumed:=10;
  recovery:=false;
END.

