#ifndef TCG_CLASS
#define TCG_CLASS
/* =============================================================================
File name:	tcg.h
Purpose:	define a tcg class for Typing Course Generator
Author:		Zijian Huang
Date:		9, Feb, 96
==============================================================================*/

#include <fstream.h>
#include "list.h"

const TWD_MAX=100;		// the max number of TWD
const DIC_MAX=24000;		// the max number of dictionary words
const BASKET_MAX=10000;		// the max number of basket words including descriptions

const MAX_DEF_LEN=80;		// the max definition string length
const MAX_LINE_LEN=200;		// the max line length of the dictionary

typedef char CHAR;

struct listIndexTWD
{
  CHAR* camp[TWD_MAX];
  unsigned sum;
};

class tcgClass
{
  protected:
  listIndexTWD  TWDtext;
  List<CHAR*>   dicText;		// a list of char pointer point strings
  List<CHAR*>  basketText[TWD_MAX];	// an array of lists

  CHAR  TWDdescription[TWD_MAX];	// description of  TWD text, for the basket text
  int  basketLen[TWD_MAX];			// lengths of each basket, just staticstic

  ifstream* TWDsource;
  ifstream* dicSource;
  ofstream* basketDestination;

  public:
  tcgClass(ifstream*,      	// the TWDF
		ifstream*,	// the dictionary file
		ofstream*);	// the basket file
				// then initialize the databases

  ~tcgClass();			// release some dynamic structure

  bool defineTWD();		// define TWD, if the file stream is not null,
				// -- then read file, otherwies read data from keyboard
  bool readDic();		// read all words in dictionary file into dicText
  bool writeBasket();		// write all words and descriptions in basket into the file

  bool sieve(CHAR*&);	// sieve a word in dicText into basketText
  void mainExec();
  void exec();
};


#endif   // TCG_CLASS