DEFINT A-Z
'       Editor for VERBALIST's dictionary files.
'       John Higgins, March 92
'       Written in BASIC PDS 7.1 with Crescent Software PRO.LIB extensions
'       The program requires the following data records:
'       the verbs and definitions in a sorted index file (VERBLIST.VRB)
'       with pointers to notes which are stored in a binary file
'       to which new records are appended (VERBNOTE.VRB).
'       At present neither verbs nor notes can be deleted once saved.

'       NB!! Load this file with /AH option and PRO7.QLB library

'       The verb file contains signals regarding the following
'       Verb is strong verb with 3 principal parts
'       Verb is infinitive form of a strong verb
'       Verb is (also) a weak verb
'       Verb must be intransitive
'       Verb is normally intransitive, but transitive phrase possible
'       Verb must be transitive (with object present)
'       Verb must be stative
'       Verb is usually stative
'       Verb must have inanimate/impersonal subject
'       Verb is usually impersonal
'       Verb usually has animate subject
'       Verb usually has animate object
'       Verb usually has inanimate object
'       Verb usually reflexive

        DECLARE SUB Dosort ()
        DECLARE SUB Findverb (x$, x)
        DECLARE SUB Processverb (n, m, w)
        DECLARE SUB Readwrite ()
        DECLARE SUB Showverb ()
        DECLARE SUB Wipe (row1, row2)

        DECLARE FUNCTION Exist (f$)
        DECLARE FUNCTION Keycode ()
        DECLARE FUNCTION QPTrim$ (x$)

'       Constants
        CONST BACKSPACE = 8
        CONST DELKEY = 21248
        CONST DOWNARROW = 20480
        CONST ENDKEY = 20224
        CONST ENTER = 13
        CONST ESCAPE = 27
        CONST DEFINIT = 15104 ' f1 key for definitions
        CONST NOTEIT = 15360  ' f2 key for notes
        CONST NEWVERB = 15616 ' f3 key for entering a new verb
        CONST SCRUB = 15872   ' f4 key for deleting entry
        CONST HOME = 18176
        CONST INSERTKEY = 20992
        CONST LEFTARROW = 19200
        CONST LOSTFILE = 53
        CONST NONOISE = 17152
        CONST PAGEUP = 18688
        CONST PAGEDOWN = 20736
        CONST QUITKEY = 17408
        CONST RIGHTARROW = 19712
        CONST TABKEY = 9
        CONST UPARROW = 18432
        CONST TRUE = -1
        CONST FALSE = 0

        TYPE vrecd
          spell AS STRING * 24
          limits AS INTEGER
          recpoint AS LONG
          reclong AS INTEGER
          defin AS STRING * 64
        END TYPE
          
        DIM SHARED verb AS vrecd, vv AS vrecd
                                             
        DIM SHARED note$, lastnote, lastrecord
        Readwrite
        CLS
        END


        SUB Dosort STATIC
        ' sorts all the verbs before saving

          GET #1, lastrecord, verb
          x$ = verb.spell
          IF QPTrim$(x$) = "" THEN lastrecord = lastrecord - 1

          DIM verbs(lastrecord) AS vrecd
          CLS
          PRINT "Please wait while the verbs are sorted."
          PRINT
          clipit = 0
          FOR n = 1 TO lastrecord
            GET #1, n, verbs(n)
            v1$ = verbs(n).spell
            IF ASC(v1$) = 126 THEN clipit = clipit + 1
          NEXT n
          
          CALL SortT2(SEG verbs(1), lastrecord, 0, 96, 0, 24)

          PRINT "Verbs sorted; now saving"
          BEEP
          FOR n = 1 TO lastrecord
            PUT #1, n, verbs(n)
          NEXT n

          CLOSE
          IF clipit > 0 THEN
            ll& = lastrecord
            cc& = clipit
            newlen& = (ll& - cc&) * 96
            CALL Clipfile("verblist.vrb", newlen&)
          END IF
          PRINT "All done"
        
        END SUB

        SUB Findverb (x$, x) STATIC
        ' test new verb against list

          x = lastrecord \ 2
          increment = x \ 2
          retried = 0
          
          DO
            IF x > (lastrecord - 1) THEN x = lastrecord - 1
            IF x < 1 THEN x = 1
            GET #1, x, vv
            IF x$ = vv.spell THEN
            ' we have found the verb
              EXIT DO
            ELSEIF x$ < QPTrim$(vv.spell) THEN
            ' we need to look earlier in the list
              x = x - increment
              ' reduce pointer
            ELSEIF x$ > QPTrim$(vv.spell) THEN
            ' we need to look later
              x = x + increment
              ' increase pointer
            END IF

            IF increment MOD 2 = 1 THEN
            ' divide by 2 and round up
              increment = increment \ 2 + 1
            ELSE
              increment = increment \ 2
            END IF
            IF increment = 1 THEN retried = retried + 1

            IF retried > 3 THEN
            ' put this new verb on to the end of the file
              x = lastrecord + 1
              vv.spell = x$
              vv.limits = 4
              vv.recpoint = 0
              vv.reclong = 0
              vv.defin = ""
              PUT #1, x, vv
              lastrecord = lastrecord + 1
              EXIT DO
            END IF
          LOOP

        END SUB

        FUNCTION Keycode STATIC
        ' returns extended code of key pressed

          DO
            k$ = INKEY$
          LOOP UNTIL k$ <> ""
          Keycode = CVI(k$ + CHR$(0))

        END FUNCTION

SUB Processverb (rec, more, worth) STATIC

  more = 1
  ' get records in forwards order
  Worthsaving = FALSE
  ' no changes made yet
  DO
    action = Keycode
    SELECT CASE action
      CASE 65 TO 78, 97 TO 110
      ' reverse this feature
        IF action > 78 THEN action = action - 32
        ' uppercase values
        a = 2 ^ (action - 65)
        IF (a AND verb.limits) = a THEN
        ' a is on
          verb.limits = verb.limits - a
          ' switch it off
        ELSE
          verb.limits = verb.limits + a
          ' switch it on
        END IF
        Worthsaving = TRUE
        Showverb
      CASE DEFINIT
        x$ = verb.defin
        CALL Editor(x$, ll, sc, 0, 0, 7, 7, 21, 1)
        verb.defin = x$
        Worthsaving = TRUE
        Showverb
      CASE NEWVERB
        x$ = SPACE$(24)
        CALL Editor(x$, ll, sc, 0, 0, 7, 7, 13, 30)
        Wipe 13, 13
        IF QPTrim(x$) <> "" THEN
          Findverb x$, this
          ' returns place in array of entered verb
          more = -this
          EXIT SUB
        END IF
      CASE NOTEIT
        IF note$ <> "" THEN
        ' once saved notes cannot be lengthened or shortened
          x$ = note$
          howlong = LEN(note$)
          CALL Editor(x$, ll, sc, 0, 0, 7, 7, 13, 1)
          Wipe 13, 14
          note$ = LEFT$(x$ + SPACE$(howlong), howlong)
          ' pad out if necessary so notes just fill available space
        ELSE
          x$ = SPACE$(160)
          CALL Editor(x$, ll, sc, 0, 0, 7, 7, 13, 1)
          note$ = QPTrim$(x$)
          Wipe 13, 14
          verb.recpoint = LOF(2) + 1
          verb.reclong = LEN(note$)
        END IF
        Showverb
      CASE LEFTARROW
      ' start notes earlier
        verb.recpoint = verb.recpoint - 1
        IF verb.recpoint > 0 AND verb.reclong > 0 THEN
          note$ = SPACE$(verb.reclong)
          GET #2, verb.recpoint, note$
        ELSE
          verb.recpoint = 0
          verb.reclong = 0
        END IF
        Worthsaving = TRUE
        Showverb
      CASE RIGHTARROW
      ' start notes later
        verb.recpoint = verb.recpoint + 1
        IF verb.reclong > 0 THEN
          IF verb.reclong + verb.recpoint < LOF(2) THEN
            note$ = SPACE$(verb.reclong)
            GET #2, verb.recpoint, note$
          END IF
        END IF
        Worthsaving = TRUE
        Showverb
      CASE DOWNARROW
      ' lengthen notes
        verb.reclong = verb.reclong + 1
        IF verb.recpoint > 0 THEN
          IF verb.reclong + verb.recpoint < LOF(2) THEN
            note$ = SPACE$(verb.reclong)
            GET #2, verb.recpoint, note$
          END IF
        END IF
        Worthsaving = TRUE
        Showverb
      CASE UPARROW
      ' shorten notes
        verb.reclong = verb.reclong - 1
        IF verb.reclong > 0 AND verb.recpoint > 0 THEN
          note$ = SPACE$(verb.reclong)
          GET #2, verb.recpoint, note$
        ELSE
          verb.reclong = 0
          verb.recpoint = 0
        END IF
        Worthsaving = TRUE
        Showverb
      CASE ENTER
      ' next verb
        IF Worthsaving THEN GOSUB saving
        EXIT SUB
      CASE BACKSPACE
        IF Worthsaving THEN GOSUB saving
        more = 2
        EXIT SUB
      CASE SCRUB
        worth = TRUE
        verb.spell = "~" + verb.spell
        ' make it begin with chr$(126) so that it sorts to end
        PUT #1, rec, verb
        EXIT SUB
      CASE ESCAPE, 81, 113
      ' quit
        more = 0
        IF Worthsaving THEN GOSUB saving
        EXIT SUB
    END SELECT
  LOOP

saving:
  LOCATE 22, 30
  PRINT "Save this entry? (Y/N)"
  a$ = INPUT$(1)
  IF UCASE$(a$) = "Y" THEN
    PUT #1, rec, verb
    IF verb.recpoint > 0 AND note$ <> "" THEN
      PUT #2, verb.recpoint, note$
    END IF
    worth = TRUE
  END IF
  RETURN
  
END SUB

        SUB Readwrite STATIC
        ' opens record files

        f$ = "verblist.vrb"
        IF Exist(f$) THEN
          OPEN f$ FOR RANDOM AS #1 LEN = 96
          lastrecord = LOF(1) \ 96
        ELSE
          EXIT SUB
        END IF
        f$ = "Verbnote.vrb"
        IF Exist(f$) THEN
          OPEN f$ FOR BINARY AS #2
          lastnote = LOF(2)
        ELSE
          EXIT SUB
        END IF

        CLS
        this = 1
        worthsorting = FALSE
        DO
          GET #1, this, verb
          IF verb.recpoint > 0 AND verb.recpoint < LOF(2) THEN
            note$ = SPACE$(verb.reclong)
            GET #2, verb.recpoint, note$
          ELSE
            note$ = ""
          END IF
          Showverb
          Processverb this, more, worthsorting
          SELECT CASE more
            CASE 1
            ' go to next record
              this = this + 1
              IF this > lastrecord THEN this = lastrecord
            CASE 2
            ' go to previous if not at start
              this = this - 1
              IF this < 1 THEN this = 1
            CASE IS < 0: this = ABS(more)
            ' go to particular record found by searching
            CASE 0: EXIT DO
          END SELECT
        LOOP
        IF worthsorting THEN Dosort

        END SUB

        SUB Showverb STATIC
        ' display the verb, constraints, notes, and definition

          Wipe 1, 2
          LOCATE 2, 1
          PRINT verb.spell; SPC(4);
          PRINT "Type: "; verb.limits; SPC(5);
          PRINT "Notes start: "; verb.recpoint;
          PRINT " length: "; verb.reclong
          a = verb.limits
          LOCATE 4, 1
          PRINT "(A) Strong verb: ";
          IF (a AND 1) = 1 THEN PRINT "+" ELSE PRINT "-"
          LOCATE 4, 29
          PRINT "(B) This is infinitive: ";
          IF (a AND 2) = 2 THEN PRINT "+" ELSE PRINT "-"
          LOCATE 4, 57
          PRINT "(C) Also a weak verb: ";
          IF (a AND 4) = 4 THEN PRINT "+" ELSE PRINT "-"
          LOCATE 5, 1
          PRINT "(D) Always intransitive: ";
          IF (a AND 8) = 8 THEN PRINT "+" ELSE PRINT "-"
          LOCATE 5, 29
          PRINT "(E) Often intransitive: ";
          IF (a AND 16) = 16 THEN PRINT "+" ELSE PRINT "-"
          LOCATE 5, 57
          PRINT "(F) Always transitive: ";
          IF (a AND 32) = 32 THEN PRINT "+" ELSE PRINT "-"
          LOCATE 6, 1
          PRINT "(G) Always stative: ";
          IF (a AND 64) = 64 THEN PRINT "+" ELSE PRINT "-"
          LOCATE 6, 29
          PRINT "(H) Often stative: ";
          IF (a AND 128) = 128 THEN PRINT "+" ELSE PRINT "-"
          LOCATE 6, 57
          PRINT "(I) Impersonal: ";
          IF (a AND 256) = 256 THEN PRINT "+" ELSE PRINT "-"
          LOCATE 7, 1
          PRINT "(J) Inanimate subject: ";
          IF (a AND 512) = 512 THEN PRINT "+" ELSE PRINT "-"
          LOCATE 7, 29
          PRINT "(K) Animate subject: ";
          IF (a AND 1024) = 1024 THEN PRINT "+" ELSE PRINT "-"
          LOCATE 7, 57
          PRINT "(L) Animate object: ";
          IF (a AND 2048) = 2048 THEN PRINT "+" ELSE PRINT "-"
          LOCATE 8, 1
          PRINT "(M) Inanimate object: ";
          IF (a AND 4096) = 4096 THEN PRINT "+" ELSE PRINT "-"
          LOCATE 8, 29
          PRINT "(N) Usually reflexive: ";
          IF (a AND 8192) = 8192 THEN PRINT "+" ELSE PRINT "-"
          Wipe 10, 23
          PRINT "="; note$; "+"
          LOCATE 21, 1
          PRINT "DEFINITION: "; verb.defin
          IF verb.recpoint > 0 THEN
            LOCATE 23, 19
            PRINT CHR$(24); "=Shorten note "; CHR$(25); "=Extend note "; CHR$(26); CHR$(27); "=shift note"
          END IF
          LOCATE 24, 4
          PRINT "A-N=Change f1=Define f2=Notes f3=Verb f4=Del ENTER=Next BS=Last Q=quit";

        END SUB

        SUB Wipe (row1, row2) STATIC
        ' wipes selected screen areas
        
          FOR n = row1 TO row2
            LOCATE n, 1, 0
            PRINT SPACE$(80);
          NEXT n

          LOCATE row1, 1, 0
        
        END SUB

