--//*** PROGRAM XTIX *** By Jim Gallagher - jimandmo@surfside.net
-------------------------------------------------------------------------------
--                                                                           --
--    This is an anacrostics program.  It is written in EUPHORIA - an        --
--    interpretive language from Rapid Deployment Software -                 --
--    www.rapideuphoria.com.                                                 --
--                                                                           --
--    The puzzles that I have written have been done with the help of an     --
--    anacrostics editor from Country Roads Software - www.entrypoints.com.  --
--                                                                           --
--    First you must select the puzzle you wish to work on from a list       --
--    displayed on the screen.                                               --
--                                                                           --
--    After you select the puzzle you wish to work on, the puzzle will be    --
--    displayed on the screen - you may input letters or cursor control      --
--    characters - use the underscore character to erase letters and the F1  --
--    key to toggle from top to bottom.  When you are finished with the      --
--    puzzle or want to quit enter period (.), at this time you may enter X  --
--    to exit immediately, C to continue solving or S to save the answers    --
--    you have so far for future solving.                                    --
--                                                                           --
--    For the file layout of the puzzle files; see the end of this file.     --
--                                                                           --
-------------------------------------------------------------------------------
--with trace
--trace (1)
  include file.e
  include get.e
  include misc.e
  include wildcard.e
  constant SCREEN = 1
  object INITIALS
	 INITIALS = {}
  procedure P_0010_GET_INITIALS ()
	    object PROC_1
		   PROC_1 = "PUZ"
	    while compare (PROC_1, "PUZ") = 0 do
		  PROC_1 = prompt_string ("ENTER YOUR INITIALS? ")
		  if  length (PROC_1) > 0 then
		      if  PROC_1 [1] > 96
		      and PROC_1 [1] < 123 then
			  PROC_1 [1] = PROC_1 [1] - 32
		      end if
		  end if
		  if  length (PROC_1) > 1 then
		      if  PROC_1 [2] > 96
		      and PROC_1 [2] < 123 then
			  PROC_1 [2] = PROC_1 [2] - 32
		      end if
		  end if
		  if  length (PROC_1) > 2 then
		      if  PROC_1 [3] > 96
		      and PROC_1 [3] < 123 then
			  PROC_1 [3] = PROC_1 [3] - 32
		      end if
		  end if
	    end while
	    INITIALS = PROC_1
  end procedure
  object P_0010_ROUTINE_ID
	 P_0010_ROUTINE_ID = routine_id ("P_0010_GET_INITIALS")
  object DIR
	 DIR = current_dir ()
  object DIRECTORY
	 DIRECTORY = dir (DIR)
  if  length (DIR) = 3 then
      DIR = DIR [1..2]
  end if
  object XTIX_FILE_NAME
	 XTIX_FILE_NAME = "XTIX9999.PUZ"
  object XTIX_FILE,
	 XTIX_RECORD
  object PUZZLE_NAMES
	 PUZZLE_NAMES = {}
  object PUZZLE_DESCRIPTIONS
	 PUZZLE_DESCRIPTIONS = {}
  for FOR_1 = 1 to length (DIRECTORY) do
      if  wildcard_file ("XTIX????.PUZ", DIRECTORY [FOR_1] [1]) = 1 then
	  if  DIRECTORY [FOR_1] [1] [5] >= '0'
	  and DIRECTORY [FOR_1] [1] [5] <= '9'
	  and DIRECTORY [FOR_1] [1] [6] >= '0'
	  and DIRECTORY [FOR_1] [1] [6] <= '9'
	  and DIRECTORY [FOR_1] [1] [7] >= '0'
	  and DIRECTORY [FOR_1] [1] [7] <= '9'
	  and DIRECTORY [FOR_1] [1] [8] >= '0'
	  and DIRECTORY [FOR_1] [1] [8] <= '9' then
	      XTIX_FILE_NAME [5] = DIRECTORY [FOR_1] [1] [5]
	      XTIX_FILE_NAME [6] = DIRECTORY [FOR_1] [1] [6]
	      XTIX_FILE_NAME [7] = DIRECTORY [FOR_1] [1] [7]
	      XTIX_FILE_NAME [8] = DIRECTORY [FOR_1] [1] [8]
	      XTIX_FILE = open (DIR & "\\" & XTIX_FILE_NAME, "r")
	      if  XTIX_FILE = -1 then
		  puts (SCREEN, "ERROR OPENING XTIX FILE XTIXXXXX.PUZ")
		  abort (1)
	      end if
	      XTIX_RECORD = gets (XTIX_FILE)
	      if  atom (XTIX_RECORD) then
		  puts (SCREEN, "EMPTY XTIX FILE")
		  abort (2)
	      end if
	      if  match ("DEFINITIONS AND LOCATIONS FOR ",
			 XTIX_RECORD) != 0 then
		  PUZZLE_NAMES = append (PUZZLE_NAMES, DIRECTORY [FOR_1] [1])
		  PUZZLE_DESCRIPTIONS = append (PUZZLE_DESCRIPTIONS,
						XTIX_RECORD [31..70])
	      end if
	      close (XTIX_FILE)
	  end if
      end if
  end for
  clear_screen ()
  printf (SCREEN, "%s\n", ' ')
  printf (SCREEN, "%s\n\n", {" NUMBER    FILE NAME       DESCRIPTION"})
  for FOR_1 = 1 to length (PUZZLE_NAMES) do
      printf (SCREEN, "%s", {"    "})
      printf (SCREEN, "%d", FOR_1)
      printf (SCREEN, "%s", {"      "})
      printf (SCREEN, "%s", {PUZZLE_NAMES [FOR_1]})
      printf (SCREEN, "%s", {"    "})
      printf (SCREEN, "%s\n", {PUZZLE_DESCRIPTIONS [FOR_1]})
  end for
  printf (SCREEN, "%s\n", ' ')
  object PUZZLE_NUMBER
	 PUZZLE_NUMBER =
	 prompt_number ("           ENTER NUMBER OF PUZZLE TO PROCESS? ",
			{1, length (PUZZLE_NAMES)})
  object SAVED_NAMES
	 SAVED_NAMES = {}
  for FOR_1 = 1 to length (DIRECTORY) do
      if  match (PUZZLE_NAMES [PUZZLE_NUMBER] [1..8],
		 DIRECTORY [FOR_1] [1]) != 0 then
	  if  DIRECTORY [FOR_1] [3] = 2002 then
	      SAVED_NAMES = append (SAVED_NAMES, DIRECTORY [FOR_1] [1])
	  end if
      end if
  end for
  object SAVED_FILE_NAME
	 SAVED_FILE_NAME = {}
  if  length (SAVED_NAMES) > 0 then
      printf (SCREEN, "%s\n", ' ')
      printf (SCREEN, "%s", {"ANSWER FILES EXIST FOR THIS PUZZLE, "})
      call_proc (P_0010_ROUTINE_ID, {})
      if  length (INITIALS) != 0 then
	  for FOR_1 = 1 to length (SAVED_NAMES) do
	      if  match (INITIALS, SAVED_NAMES [FOR_1] [10..length (SAVED_NAMES [FOR_1])]) != 0 then
		  SAVED_FILE_NAME = SAVED_NAMES [FOR_1]
	      end if
	  end for
      end if
  end if
  object TOP
	 TOP = repeat (repeat (' ', 40), 40)
  object TOP_TO_BOTTOM
	 TOP_TO_BOTTOM = repeat (repeat (0, 11), 41)
  object BOTTOM
	 BOTTOM = repeat (' ', 320)
  object BOTTOM_TO_TOP
	 BOTTOM_TO_TOP = repeat (repeat (0, 2), 321)
  object WORD_ENDINGS
	 WORD_ENDINGS = repeat (0, 100)
  XTIX_FILE_NAME [5] = PUZZLE_NAMES [PUZZLE_NUMBER] [5]
  XTIX_FILE_NAME [6] = PUZZLE_NAMES [PUZZLE_NUMBER] [6]
  XTIX_FILE_NAME [7] = PUZZLE_NAMES [PUZZLE_NUMBER] [7]
  XTIX_FILE_NAME [8] = PUZZLE_NAMES [PUZZLE_NUMBER] [8]
  XTIX_FILE = open (DIR & "\\" & XTIX_FILE_NAME, "r")
  if  XTIX_FILE = -1 then
      puts (SCREEN, "ERROR OPENING XTIX FILE XTIXXXXX.PUZ")
      abort (1)
  end if
  XTIX_RECORD = gets (XTIX_FILE)
  if  atom (XTIX_RECORD) then
      puts (SCREEN, "EMPTY XTIX FILE")
      abort (2)
  end if
  if  match ("DEFINITIONS AND LOCATIONS", XTIX_RECORD) = 0 then
      puts (SCREEN, "FIRST XTIX RECORD IS INVALID:")
      puts (SCREEN, XTIX_RECORD)
      abort (3)
  end if
  XTIX_RECORD = gets (XTIX_FILE)
  if  atom (XTIX_RECORD) then
      puts (SCREEN, "PREMATURE END OF XTIX FILE")
      abort (4)
  end if
  function F_0010_GET_NUMBER (object FUNC_1)
	   if  XTIX_RECORD [FUNC_1] >= '0'
	   and XTIX_RECORD [FUNC_1] <= '9'
	   and XTIX_RECORD [FUNC_1 + 1] >= '0'
	   and XTIX_RECORD [FUNC_1 + 1] <= '9'
	   and XTIX_RECORD [FUNC_1 + 2] >= '0'
	   and XTIX_RECORD [FUNC_1 + 2] <= '9'
	   and XTIX_RECORD [FUNC_1 + 3] = ' ' then
	       return ((XTIX_RECORD [FUNC_1] - '0') * 100) +
		      ((XTIX_RECORD [FUNC_1 + 1] - '0') * 10) +
		      (XTIX_RECORD [FUNC_1 + 2] - '0')
	   else
	       return 0
	   end if
  end function
  object F_0010_ROUTINE_ID
	 F_0010_ROUTINE_ID = routine_id ("F_0010_GET_NUMBER")
  object SUB_1
	 SUB_1 = 0
  object SEQ_1
	 SEQ_1 = {0}
  object SUB_2
	 SUB_2 = 0
  object SUB_3,
	 SUB_4,
	 TOP_END_1,
	 TOP_END_2,
	 BOTTOM_END
  while match ("QUOTATION WORD ENDINGS:", XTIX_RECORD) = 0 do
	SUB_1 = SUB_1 + 1
	for FOR_1 = 1 to 40 by 1 do
	    TOP [SUB_1] [FOR_1] = XTIX_RECORD [FOR_1]
	end for
	SUB_3 = 29
	SUB_4 = 0
	for FOR_1 = 30 to 66 by 4 do
	    SEQ_1 [1] = FOR_1
	    SUB_2 = call_func (F_0010_ROUTINE_ID, SEQ_1)
	    SUB_3 = SUB_3 + 1
	    SUB_4 = SUB_4 + 1
	    if  SUB_3 < 33 then
		if  SUB_2 != 0 then
		    TOP [SUB_1] [FOR_1] = ' '
		    TOP [SUB_1] [FOR_1 + 1] = ' '
		    TOP [SUB_1] [FOR_1 + 2] = ' '
		end if
	    end if
	    if  SUB_2 != 0 then
		TOP [SUB_1] [SUB_3] = '_'
		TOP_END_1 = SUB_1
		TOP_END_2 = SUB_4
		TOP_TO_BOTTOM [SUB_1] [SUB_4] = SUB_2
	    end if
	end for
	XTIX_RECORD = gets (XTIX_FILE)
	if  atom (XTIX_RECORD) then
	    puts (SCREEN, "PREMATURE END OF XTIX FILE")
	    abort (5)
	end if
  end while
  SUB_3 = 0
  XTIX_RECORD = gets (XTIX_FILE)
  while atom (XTIX_RECORD) = 0 do
	for FOR_1 = 2 to 66 by 4 do
	    SEQ_1 [1] = FOR_1
	    SUB_2 = call_func (F_0010_ROUTINE_ID, SEQ_1)
	    if  SUB_2 != 0 then
		SUB_3 = SUB_3 + 1
		WORD_ENDINGS [SUB_3] = SUB_2
	    end if
	end for
	XTIX_RECORD = gets (XTIX_FILE)
  end while
  close (XTIX_FILE)
  SUB_1 = 0
  SUB_2 = 0
  for FOR_1 = 1 to 100 by 1 do
      while WORD_ENDINGS [FOR_1] != 0 do
	    SUB_1 = SUB_1 + 1
	    SUB_2 = SUB_2 + 1
	    BOTTOM [SUB_2] = '_'
	    BOTTOM_END = SUB_2
	    if  SUB_1 = WORD_ENDINGS [FOR_1] then
		SUB_2 = SUB_2 + 1
		exit
	    end if
      end while
  end for
  for FOR_1 = 1 to 40 by 1 do
      for FOR_2 = 1 to 10 by 1 do
	  if  TOP_TO_BOTTOM [FOR_1] [FOR_2] != 0 then
	      SUB_1 = 1
	      while WORD_ENDINGS [SUB_1] < TOP_TO_BOTTOM [FOR_1] [FOR_2] do
		    SUB_1 = SUB_1 + 1
	      end while
	      TOP_TO_BOTTOM [FOR_1] [FOR_2] = TOP_TO_BOTTOM [FOR_1] [FOR_2]
		  + SUB_1 - 1
	      SUB_2 = TOP_TO_BOTTOM [FOR_1] [FOR_2]
	      BOTTOM_TO_TOP [SUB_2] [1] = FOR_1
	      BOTTOM_TO_TOP [SUB_2] [2] = FOR_2
	  end if
      end for
  end for
  function F_0020_GET_LOCATION (object FUNC_1, object FUNC_2)
	   object FUNC_3
	   if  FUNC_1 = 99 then
	       if  FUNC_2 > 320 then
		   FUNC_2 = 1
	       else
		   FUNC_2 = FUNC_2 + 1
	       end if
	   else
	       if  FUNC_2 > 10 then
		   FUNC_2 = 1
		   if  FUNC_1 > 40 then
		       FUNC_1 = 1
		   else
		       FUNC_1 = FUNC_1 + 1
		   end if
	       else
		   FUNC_2 = FUNC_2 + 1
	       end if
	   end if
	   if  FUNC_1 = 99 then
	       while BOTTOM_TO_TOP [FUNC_2] [1] = 0 do
		     if  FUNC_2 > 320 then
			 FUNC_2 = 1
		     else
			 FUNC_2 = FUNC_2 + 1
		     end if
	       end while
	       FUNC_3 = FUNC_2
	   else
	       while TOP_TO_BOTTOM [FUNC_1] [FUNC_2] = 0 do
		     if  FUNC_2 > 10 then
			 FUNC_2 = 1
			 if  FUNC_1 > 40 then
			     FUNC_1 = 1
			 else
			     FUNC_1 = FUNC_1 + 1
			 end if
		     else
			 FUNC_2 = FUNC_2 + 1
		     end if
	       end while
	       FUNC_3 = TOP_TO_BOTTOM [FUNC_1] [FUNC_2]
	   end if
	   return {FUNC_3,
		   BOTTOM_TO_TOP [FUNC_3] [1],
		   BOTTOM_TO_TOP [FUNC_3] [2]}
  end function
  object F_0020_ROUTINE_ID
	 F_0020_ROUTINE_ID = routine_id ("F_0020_GET_LOCATION")
  object CHARACTERS,
	 OLD_SUB_1,
	 OLD_SUB_2,
	 SUB_5,
	 SUB_6
  SUB_1 = 41
  SUB_2 = 11
  procedure P_0020_BACKSPACE_OR_LEFT ()
	    object PROC_1
		   PROC_1 = 0
	    while PROC_1 < 2 do
		  if  SUB_1 = 99 then
		      if  SUB_2 > 0 then
			  if  BOTTOM_TO_TOP [SUB_2] [1] != 0 then
			      PROC_1 = PROC_1 + 1
			  end if
			  SUB_2 = SUB_2 - 1
		      else
			  SUB_2 = 321
		      end if
		  else
		      if  SUB_2 > 0 then
			  if  TOP_TO_BOTTOM [SUB_1] [SUB_2] != 0 then
			      PROC_1 = PROC_1 + 1
			  end if
			  SUB_2 = SUB_2 - 1
		      else
			  SUB_2 = 11
			  if  SUB_1 > 1 then
			      SUB_1 = SUB_1 - 1
			  else
			      SUB_1 = 41
			  end if
		      end if
		  end if
	    end while
  end procedure
  object P_0020_ROUTINE_ID
	 P_0020_ROUTINE_ID = routine_id ("P_0020_BACKSPACE_OR_LEFT")
  procedure P_0030_TAB ()
	    if  SUB_1 = 99 then
		while BOTTOM_TO_TOP [SUB_2] [1] != 0 do
		      SUB_2 = SUB_2 + 1
		end while
	    else
		if  SUB_1 = 41 then
		    SUB_1 = 1
		else
		    SUB_1 = SUB_1 + 1
		end if
		while TOP_TO_BOTTOM [SUB_1] [1] = 0 do
		      if  SUB_1 = 41 then
			  SUB_1 = 1
		      else
			  SUB_1 = SUB_1 + 1
		      end if
		end while
	    end if
	    if  SUB_1 != 99 then
		if  SUB_1 = 1 then
		    SUB_1 = 41
		else
		    SUB_1 = SUB_1 - 1
		end if
	    SUB_2 = 11
	    end if
  end procedure
  object P_0030_ROUTINE_ID
	 P_0030_ROUTINE_ID = routine_id ("P_0030_TAB")
  procedure P_0040_BACKTAB ()
	    if  SUB_1 = 99 then
		if  SUB_2 < 3 then
		    SUB_2 = BOTTOM_END
		else
		    SUB_2 = SUB_2 - 2
		end if
		while BOTTOM_TO_TOP [SUB_2] [1] != 0 do
		      if  SUB_2 = 1 then
			  SUB_2 = 321
		      else
			  SUB_2 = SUB_2 - 1
		      end if
		end while
	    else
		if  SUB_2 = 1 then
		    if  SUB_1 = 1 then
			SUB_1 = 41
		    else
			SUB_1 = SUB_1 - 1
		    end if
		end if
		while TOP_TO_BOTTOM [SUB_1] [1] = 0 do
		      if  SUB_1 = 1 then
			  SUB_1 = 41
		      else
			  SUB_1 = SUB_1 - 1
		      end if
		end while
	    end if
	    if  SUB_1 != 99 then
		if  SUB_1 = 1 then
		    SUB_1 = 41
		else
		    SUB_1 = SUB_1 - 1
		end if
		SUB_2 = 11
	    end if
  end procedure
  object P_0040_ROUTINE_ID
	 P_0040_ROUTINE_ID = routine_id ("P_0040_BACKTAB")
  procedure P_0050_UP ()
	    if  SUB_1 = 99 then
		if  SUB_2 > 80 then
		    SUB_2 = SUB_2 - 80
		else
		    SUB_2 = SUB_2 + 240
		end if
		while BOTTOM_TO_TOP [SUB_2] [1] = 0 do
		      if  SUB_2 > 80 then
			  SUB_2 = SUB_2 - 80
		      else
			  SUB_2 = SUB_2 + 240
		      end if
		end while
	    else
		if  SUB_1 = 1 then
		    SUB_1 = 41
		else
		    SUB_1 = SUB_1 - 1
		end if
		while TOP_TO_BOTTOM [SUB_1] [SUB_2] = 0 do
		      if  SUB_1 = 1 then
			  SUB_1 = 41
		      else
			  SUB_1 = SUB_1 - 1
		      end if
		end while
	    end if
	    if  SUB_1 = 99 then
		if  SUB_2 = 1 then
		    SUB_2 = 321
		else
		    SUB_2 = SUB_2 - 1
		end if
	    else
		if  SUB_2 = 1 then
		    if  SUB_1 = 1 then
			SUB_1 = 41
		    else
			SUB_1 = SUB_1 - 1
		    end if
		    SUB_2 = 11
		else
		    SUB_2 = SUB_2 - 1
		end if
	    end if
  end procedure
  object P_0050_ROUTINE_ID
	 P_0050_ROUTINE_ID = routine_id ("P_0050_UP")
  procedure P_0060_DOWN ()
	    if  SUB_1 = 99 then
		if  SUB_2 > 240 then
		    SUB_2 = SUB_2 - 240
		else
		    SUB_2 = SUB_2 + 80
		end if
		while BOTTOM_TO_TOP [SUB_2] [1] = 0 do
		      if  SUB_2 > 240 then
			  SUB_2 = SUB_2 - 240
		      else
			  SUB_2 = SUB_2 + 80
		      end if
		end while
	    else
		SUB_1 = SUB_1 + 1
		while TOP_TO_BOTTOM [SUB_1] [SUB_2] = 0 do
		      if  SUB_1 = 41 then
			  SUB_1 = 1
		      else
			  SUB_1 = SUB_1 + 1
		      end if
		end while
	    end if
	    if  SUB_1 = 99 then
		if  SUB_2 = 1 then
		    SUB_2 = 321
		else
		    SUB_2 = SUB_2 - 1
		end if
	    else
		if  SUB_2 = 1 then
		    if  SUB_1 = 1 then
			SUB_1 = 41
		    else
			SUB_1 = SUB_1 - 1
		    end if
		    SUB_2 = 11
		else
		    SUB_2 = SUB_2 - 1
		end if
	    end if
  end procedure
  object P_0060_ROUTINE_ID
	 P_0060_ROUTINE_ID = routine_id ("P_0060_DOWN")
  object SAVED_RECORD
  if  length (SAVED_FILE_NAME) != 0 then
      XTIX_FILE = open (DIR & "\\" & SAVED_FILE_NAME, "r")
      if  XTIX_FILE = -1 then
	  puts (SCREEN, "CANNOT OPEN SAVED FILE")
	  abort (9)
      end if
      for FOR_1 = 1 to 40 do
	  SAVED_RECORD = gets (XTIX_FILE)
	  for FOR_2 = 1 to 40 do
	      TOP [FOR_1] [FOR_2] = SAVED_RECORD [FOR_2]
	  end for
      end for
      SAVED_RECORD = gets (XTIX_FILE)
      for FOR_1 = 1 to 320 do
	  BOTTOM [FOR_1] = SAVED_RECORD [FOR_1]
      end for
      close (XTIX_FILE)
  end if
  procedure P_0080_THE_MAIN_PART ()
	    clear_screen ()
	    for FOR_1 = 1 to 20 do
		puts (SCREEN, TOP [FOR_1])
		puts (SCREEN, TOP [FOR_1 + 20])
	    end for
	    puts (SCREEN, BOTTOM)
	    while CHARACTERS [1] != '.' do
		  CHARACTERS [2] = CHARACTERS [1]
		  OLD_SUB_1 = SUB_1
		  OLD_SUB_2 = SUB_2
		  SEQ_1 = call_func (F_0020_ROUTINE_ID, {SUB_1, SUB_2})
		  if  SUB_1 = 99 then
		      SUB_2 = SEQ_1 [1]
		  else
		      SUB_1 = SEQ_1 [2]
		      SUB_2 = SEQ_1 [3]
		  end if
		  SUB_3 = 21
		  SUB_4 = SEQ_1 [1]
		  while SUB_4 > 80 do
			SUB_3 = SUB_3 + 1
			SUB_4 = SUB_4 - 80
		  end while
		  SUB_5 = SEQ_1 [2]
		  SUB_6 = SEQ_1 [3]
		  if  SUB_5 > 20 then
		      SUB_5 = SUB_5 - 20
		      SUB_6 = SUB_6 + 69
		  else
		      SUB_6 = SUB_6 + 29
		  end if
		  if  SUB_1 = 99 then
		      position (SUB_3, SUB_4)
		  else
		      position (SUB_5, SUB_6)
		  end if
		  CHARACTERS [1] = wait_key ()
		  if  CHARACTERS [1] = 9 then
		      --TAB
		      call_proc (P_0030_ROUTINE_ID, {})
		  elsif
		      CHARACTERS [1] = 271 then
		      --BACKTAB
		      call_proc (P_0040_ROUTINE_ID, {})
		  elsif
		      CHARACTERS [1] = 327 then
		      --HOME
		      if  SUB_1 = 99 then
			  SUB_2 = 321
		      else
			  SUB_1 = 41
			  SUB_2 = 11
		      end if
		  elsif
		      CHARACTERS [1] = 335 then
		      --END
		      if  SUB_1 = 99 then
			  SUB_2 = BOTTOM_END - 1
		      else
			  SUB_1 = TOP_END_1
			  SUB_2 = TOP_END_2 - 1
		      end if
		  elsif
		      CHARACTERS [1] = 8 then
		      --BACKSPACE
		      call_proc (P_0020_ROUTINE_ID, {})
		  elsif
		      CHARACTERS [1] = 331 then
		      --LEFT
		      call_proc (P_0020_ROUTINE_ID, {})
		  elsif
		      CHARACTERS [1] = 328 then
		      --UP
		      call_proc (P_0050_ROUTINE_ID, {})
		  elsif
		      CHARACTERS [1] = 336 then
		      --DOWN
		      call_proc (P_0060_ROUTINE_ID, {})
		  elsif
		      CHARACTERS [1] < 65
		  or  CHARACTERS [1] > 90 then
		      if  CHARACTERS [1] > 96
		      and CHARACTERS [1] < 123 then
			  CHARACTERS [1] = CHARACTERS [1] - 32
		      else
			  if  CHARACTERS [1] != 95
			  and CHARACTERS [1] != 32
			  and CHARACTERS [1] != 333 then
			      SUB_1 = OLD_SUB_1
			      SUB_2 = OLD_SUB_2
			      if  CHARACTERS [1] = 315 then
				  if  SUB_1 = 99 then
				      SUB_1 = SEQ_1 [2]
				      SUB_2 = SEQ_1 [3] - 1
				  else
				      SUB_1 = 99
				      SUB_2 = SEQ_1 [1] - 1
				  end if
			      end if
			  end if
		      end if
		  end if
		  if  CHARACTERS [1] > 64
		  and CHARACTERS [1] < 96 then
		      TOP [SEQ_1 [2]] [SEQ_1 [3] + 29] = CHARACTERS [1]
		      BOTTOM [SEQ_1 [1]] = CHARACTERS [1]
		      printf (SCREEN, "%s", CHARACTERS [1])
		      if  SUB_1 = 99 then
			  position (SUB_5, SUB_6)
		      else
			  position (SUB_3, SUB_4)
		      end if
		      printf (SCREEN, "%s", CHARACTERS [1])
		      if  SUB_1 = 99 then
			  position (SUB_3, SUB_4)
		      else
			  position (SUB_5, SUB_6)
		      end if
		  end if
	    end while
	    position (25, 10)
	    printf (SCREEN, "%s",
	      {"ENTER X TO EXIT, C TO CONTINUE OR S TO SAVE YOUR ANSWERS? "})
  end procedure
  object P_0080_ROUTINE_ID
	 P_0080_ROUTINE_ID = routine_id ("P_0080_THE_MAIN_PART")
  procedure P_0090_SAVE_ANSWERS ()
	    position (25, 10)
	    printf (SCREEN, "%s",
	      {"                                                           "})
	    position (25, 10)
	    if  length (SAVED_FILE_NAME) = 0 then
		if  length (INITIALS) = 0 then
		    call_proc (P_0010_ROUTINE_ID, {})
		end if
		if  length (INITIALS) != 0 then
		    SAVED_FILE_NAME = XTIX_FILE_NAME [1..9]
		    SAVED_FILE_NAME = append (SAVED_FILE_NAME, INITIALS [1])
		    if  length (INITIALS) > 1 then
			SAVED_FILE_NAME = append (SAVED_FILE_NAME, INITIALS [2])
			if  length (INITIALS) > 2 then
			    SAVED_FILE_NAME = append (SAVED_FILE_NAME,
						      INITIALS [3])
			end if
		    end if
		end if
	    end if
	    if  length (INITIALS) != 0 then
		XTIX_FILE = open (DIR & "\\" & SAVED_FILE_NAME, "w")
		if  XTIX_FILE = -1 then
		    puts (SCREEN, "CANNOT OPEN OUTPUT SAVED FILE")
		    abort (10)
		end if
		for FOR_1 = 1 to 40 do
		    printf (XTIX_FILE, "%s\n", {TOP [FOR_1]})
		end for
		printf (XTIX_FILE, "%s\n", {BOTTOM})
		close (XTIX_FILE)
	    end if
	    --position (25, 10)
	    --printf (SCREEN, "%s",
	      --{"ENTER X TO EXIT, C TO CONTINUE OR S TO SAVE YOUR ANSWERS? "})
  end procedure
  object P_0090_ROUTINE_ID
	 P_0090_ROUTINE_ID = routine_id ("P_0090_SAVE_ANSWERS")
  CHARACTERS = {0, 0}
  call_proc (P_0080_ROUTINE_ID, {})
  object KEY_ENTERED
	 KEY_ENTERED = wait_key ()
  if  KEY_ENTERED = 'x' then
      KEY_ENTERED = 'X'
  end if
  printf (SCREEN, "%s", KEY_ENTERED)
  position (25, 68)
  while KEY_ENTERED != 'X' do
	if  KEY_ENTERED = 'c'
	or  KEY_ENTERED = 'C' then
	    CHARACTERS = {0, 0}
	    call_proc (P_0080_ROUTINE_ID, {})
	end if
	if  KEY_ENTERED = 's'
	or  KEY_ENTERED = 'S' then
	    call_proc (P_0090_ROUTINE_ID, {})
	    exit
	end if
	KEY_ENTERED = wait_key ()
	if  KEY_ENTERED = 'x' then
	    KEY_ENTERED = 'X'
	end if
	printf (SCREEN, "%s", KEY_ENTERED)
	position (25, 68)
  end while
-------------------------------------------------------------------------------
--                                                                           --
--    Puzzle files need to reside on the same directory as the XTIX.EX file  --
--    or the XTIX.EXE file.                                                  --
--                                                                           --
--    The first 4 characters of their name is "XTIX".                        --
--                                                                           --
--    The last 4 characters of their name must be digits.                    --
--                                                                           --
--    The extension of the puzzle files are "PUZ".                           --
--                                                                           --
--    An example of a valid puzzle name is:                                  --
--                                                                           --
--        "XTIX0001.PUZ".                                                    --
--                                                                           --
--    The first record identifies the file and gives a title and author to   --
--    the puzzle for the selection list at the beginning of the program.     --
--                                                                           --
--    The second through forty-first records give the definitions and        --
--    locations for the top part of the puzzle.   The second through         --
--    twenty-first records refer to the left hand side of the screen, the    --
--    twenty-second through forty-first refer to the right hand side of the  --
--    screen.  The pointers point to the corresponding letter on the bottom  --
--    - lines 21 through 24 - of the screen - these point to the actual      --
--    occurence of the letter on the bottom regardless of spaces.            --
--                                                                           --
--    The next record must contain the literal starting in column 1:         --
--    "QUOTATION WORD ENDINGS:"; this record is followed by records which    --
--    contain the number of the last letter in every word of the quotation.  --
--                                                                           --
-------------------------------------------------------------------------------
--                                                                           --
--    The first 30 characters of the first record of the puzzle file must    --
--    be "DEFINITIONS AND LOCATIONS FOR ", columns 31 thru 70 of the first   --
--    record should contain a name for the puzzle and the author.            --
--                                                                           --
--    The second through forty-first records have the following format:      --
--                                                                           --
--        column  1 - 29 = Definition for top entry.                         --
--                                                                           --
--        column 30 - 69 = 10 occurences of a three digit pointer to the     --
--                         quotation followed by a space.                    --
--                                                                           --
--        column 70 - 79 = Corresponding answer letter value, 1 through 10.  --
--                         These columns are not used at this time and may   --
--                         not be included.                                  --
--                                                                           --
--        column 80 - 81 = A space and a small "x" - you do not need to      --
--                         include these.                                    --
--                                                                           --
--    The forty-second record must contain "QUOTATION WORD ENDINGS:" in      --
--    columns 1 thru 23.                                                     --
--                                                                           --
--    The forty-third and subsequent records contain 17 occurences of the    --
--    number of the last letter in each word of the quotation in columns 2   --
--    through 69.                                                            --
--                                                                           --
--    Look at any of the PUZ files with a text editor to get a better idea   --
--    of how these files are built.                                          --
--                                                                           --
-------------------------------------------------------------------------------

