From:	IN%"lenoil@APPLE.COM"  "Robert Lenoil"  9-DEC-1988 16:59
To:	p150bk19@VB.CC.CMU.EDU
Subj:	STICKY.E

Received: from apple.com by VB.CC.CMU.EDU; Fri, 9 Dec 88 16:57 EST
Received: by apple.com (5.59/25-eef) id AA17246; Fri, 9 Dec 88 13:10:24 PST
Date: Fri, 9 Dec 88 13:10:24 PST
From: Robert Lenoil <lenoil@APPLE.COM>
Subject: STICKY.E
To: p150bk19@VB.CC.CMU.EDU
Message-Id: <8812092110.AA17246@apple.com>

/* The following copyright and trademark notice applies to some of the code
 * herein; all other material is Copyright (c) 1986, 1987 by Robert Lenoil,
 * with free copying allowed for any purpose, provided that this copyright
 * notice is included.
 */

/************************************************************************
* "Epsilon", "EEL" and "Lugaru" are trademarks of Lugaru Software, Ltd. *
*                                                                       *
*     Copyright (C) 1985 Lugaru Software Ltd.  All rights reserved.     *
*                                                                       *
* Limited permission is hereby granted to reproduce and modify this     *
* copyrighted material provided that the resulting code is used only in *
* conjunction with Lugaru products and that this notice is retained in  *
* any such reproduction or modification.                                *
************************************************************************/

/*
 * Sticky file defaulting for Epsilon
 */

#include <eel.h>

/* This file modifies the following Epsilon commands/procedures:
COMMAND              SOURCE FROM VERSION
comp_read               3.1
f_match                 3.1
get_file                3.1
list_matches            3.1

   And defines the following globals:
GLOBAL            WRITTEN FOR VERSION
sticky_file_defaulting  3.1
*/

int sticky_file_defaulting = 1;

/* F_MATCH modified to prepend current drive and path, if not specified.  Also
 * changed to ignore . and .. entries.
 * Modified from version 3.1 source.
 */
char *f_match(s, start) 
char *s;
{  char *name, tmp[FNAMELEN];
   int i, t = 0;

   if (sticky_file_defaulting && filename)
      switch (*s)
      {  case 0:
            goto doit;
         case '/':
         case '\\':
            break;
         default:
            if (s[1] != ':')
            {  doit:
               relative(filename, tmp);
               t = get_tail(tmp, 1) - tmp;
               strcpy(tmp + t, s);
               s = tmp;
            }
      }
   do
   {  name = file_match(s, start);
      start = 0;
   }  while (name && name[i = strlen(name) - 1] == '\\' && name[i-1] == '.');

   if (t && name && !strncmp(name, tmp, t))
      name += t; /* keep relative to visited file's dir */

   return name;
}

/* LIST_MATCHES modified to call finder with bufname set to original buffer,
 * not the temp buffer.  This is necessary for our new f_match to work.
 * Modified from version 3.1 source.
 */
list_matches(s, finder)    /* display matches for s */
char *s;
char *(*finder)();
{
char *oldbuf = bufname, *t;

t = "One of the following:                                               \
            ";
term_write(0, 0, t, strlen(t), normcolor);
zap("-temp");
if (t = (*finder) (s, 1))
   do {
      bufname = "-temp";
      bprintf("%s\n", t);
   } while (bufname = oldbuf, t = (*finder) (s, 0));
 bufname = "-temp";
 if (re_search(-1, "^-temp\n"))
   delete(point, point + 6);
zap("help");
buffer_sort("help");
bufname = "help";
delete_buffer("-temp");
point = 0;
stuff("One of the following:\n");
point = 0;
bufname = oldbuf;
view_buffer("help");
}

/* GET_FILE modified to prepend current drive and path, if not specified.
 * Modified from version 3.1 source.
 */
get_file(res, pr)
char *res, *pr;
{  char tmp[FNAMELEN];

   comp_read(res, pr, f_match, 1);
   switch (*res)
   {  case 0:
         return;
      case '/':
      case '\\':
         break;
      default:
         if (res[1] != ':' && sticky_file_defaulting && filename)
         {  relative(filename, tmp);
            strcpy(get_tail(tmp, 1), res);
            strcpy(res, tmp);
         }
   }
   absolute(res);
}

/* COMP_READ modified to "go all the way"; i.e. if completion yields a single
 * entry, complete on that entry, ad nauseum, until you can't go any further.
 * Modified from version 3.1 source.
 */
comp_read(trystr, prmpt, finder, cautious)
char *trystr, *prmpt;
char *(*finder)();
int cautious;     /* for files: make fewer assumptions about patterns */
{
int i = 0, j, num_match = 0;
int yanked_pos = 0;
char msg[80], *p;
char *origbuf = bufname;

strcpy(msg, prmpt);
p = msg + strlen(msg);
for (;;) {
   if (p + i >= msg + 78) i = 78 - (p - msg);
   trystr[i] = 0;
   sprintf(p, "%s%s", trystr, num_match == 1? " ": "");
   sayput("%s", msg);
   getkey();
   if (key == '\n' || key == '\r' || key == ' ' && num_match == 1)
      break;
   check_abort();
   if (root_keys[key] == (short) help)
      help_on_current();
   else if (key == '?' && finder)
      list_matches(trystr, finder);
   else if (finder && (key == ' ' || key == '\33')) {
      num_match = complete(trystr, finder, cautious);
      if (num_match && (j = strlen(trystr)) != i)
         i = j;
      else if (num_match != 1)
         maybe_ding();
      while (num_match == 1) /* might be directory */
      {  num_match = complete(trystr, finder, cautious);
         if ((j = strlen(trystr)) > i) i = j;
         else break;
      }
      if (key == '\33' && num_match == 1)
         break;
   } else {
      if (key == CTRL('Q')) {
         do getkey(); while (key >= 256);
         trystr[i++] = key;
         user_abort=0;
      } else if (key == (0x80|'y') || key == CTRL('Y')) {
         if (!killed_yet)
            continue;
         if (key == (0x80|'y'))
            pop_kill();
         bufname = cur_kill_buf;
         point = 0;
         if (key == (0x80|'y'))
            i = yanked_pos;
         else
            yanked_pos = i;
         while (point < size() && p + i < msg + 78) {
            trystr[i++] = curchar();
            point++;
         }
         trystr[i] = 0;
         bufname = origbuf;
      } else if (key == '\b' || key == DEL) {
         if (i > 0)
            i--;
      } else if (key < 256)
         trystr[i++] = key;
      num_match = 0;
   }
}
say("");
}
