/* moseq1.f -- translated by f2c (version of 3 February 1990  3:36:42).
   You must link the resulting object file with the libraries:
	-lF77 -lI77 -lm -lc   (in that order)
*/

#include "f2c.h"

/* Common Block Declarations */

struct {
    doublereal vto, beta, gamma, phi, phib, cox, xnsub, xnfs, xd, xj, xld, 
	    xlamda, uo, uexp, vbp, utra, vmax, xneff, xl, xw, vbi, von, vdsat,
	     qspof, beta0, beta1, cdrain, xqco, xqc, fnarrw, fshort;
    integer lev;
} mosarg_;

#define mosarg_1 mosarg_

struct {
    doublereal omega, time, delta, delold[7], ag[7], vt, xni, egfet, xmu, 
	    sfactr;
    integer mode, modedc, icalc, initf, method, iord, maxord, noncon, iterno, 
	    itemno, nosolv, modac, ipiv, ivmflg, ipostp, iscrch, iofile;
} status_;

#define status_1 status_

struct {
    doublereal twopi, xlog2, xlog10, root2, rad, boltz, charge, ctok, gmin, 
	    reltol, abstol, vntol, trtol, chgtol, eps0, epssil, epsox, pivtol,
	     pivrel;
} knstnt_;

#define knstnt_1 knstnt_

/*<       subroutine moseq1(vds,vbs,vgs,gm,gds,gmbs) >*/
/* Subroutine */ int moseq1_(vds, vbs, vgs, gm, gds, gmbs)
doublereal *vds, *vbs, *vgs, *gm, *gds, *gmbs;
{
    /* Builtin functions */
    double sqrt();

    /* Local variables */
    static doublereal sarg, vgst, betap, arg, vbd, vgb;

/*<       implicit double precision (a-h,o-z) >*/

/*     this routine evaluates the drain current and its derivatives */
/*     using the shichman-hodges model and the charges associated */
/*     with the gate, channel and bulk for mosfets */

/* spice version 2g.6  sccsid=mosarg 3/15/83 */
/*<       common /mosarg/ vto,beta,gamma,phi,phib,cox,xnsub,xnfs,xd,xj,xld, >*/
/*<      1   xlamda,uo,uexp,vbp,utra,vmax,xneff,xl,xw,vbi,von,vdsat,qspof, >*/
/*<      2   beta0,beta1,cdrain,xqco,xqc,fnarrw,fshort,lev >*/
/* spice version 2g.6  sccsid=status 3/15/83 */
/*<       common /status/ omega,time,delta,delold(7),ag(7),vt,xni,egfet, >*/
/*<      1   xmu,sfactr,mode,modedc,icalc,initf,method,iord,maxord,noncon, >*/
/*<      2   iterno,itemno,nosolv,modac,ipiv,ivmflg,ipostp,iscrch,iofile >*/
/* spice version 2g.6  sccsid=knstnt 3/15/83 */
/*<       common /knstnt/ twopi,xlog2,xlog10,root2,rad,boltz,charge,ctok, >*/
/*<      1   gmin,reltol,abstol,vntol,trtol,chgtol,eps0,epssil,epsox, >*/
/*<      2   pivtol,pivrel >*/
/*<       vbd=vbs-vds >*/
    vbd = *vbs - *vds;
/*<       vgb=vgs-vbs >*/
    vgb = *vgs - *vbs;


/*<       if (vbs.gt.0.0d0) go to 102 >*/
    if (*vbs > 0.) {
	goto L102;
    }
/*<       sarg=dsqrt(phi-vbs) >*/
    sarg = sqrt(mosarg_1.phi - *vbs);
/*<       go to 104 >*/
    goto L104;
/*<   102 sarg=dsqrt(phi) >*/
L102:
    sarg = sqrt(mosarg_1.phi);
/*<       sarg=sarg-vbs/(sarg+sarg) >*/
    sarg -= *vbs / (sarg + sarg);
/*<       sarg=dmax1(0.0d0,sarg) >*/
    sarg = max(0.,sarg);
/*<   104 von=vbi+gamma*sarg >*/
L104:
    mosarg_1.von = mosarg_1.vbi + mosarg_1.gamma * sarg;
/*<       vgst=vgs-von >*/
    vgst = *vgs - mosarg_1.von;
/*<       vdsat=dmax1(vgst,0.0d0) >*/
    mosarg_1.vdsat = max(vgst,0.);
/*<       if (sarg.gt.0.0d0) go to 105 >*/
    if (sarg > 0.) {
	goto L105;
    }
/*<       arg=0.0d0 >*/
    arg = 0.;
/*<       go to 108 >*/
    goto L108;
/*<   105 arg=gamma/(sarg+sarg) >*/
L105:
    arg = mosarg_1.gamma / (sarg + sarg);
/*<   108 if (vgst.gt.0.0d0) go to 110 >*/
L108:
    if (vgst > 0.) {
	goto L110;
    }

/*     cutoff region */

/*<       cdrain=0.0d0 >*/
    mosarg_1.cdrain = 0.;
/*<       gm=0.0d0 >*/
    *gm = 0.;
/*<       gds=0.0d0 >*/
    *gds = 0.;
/*<       gmbs=0.0d0 >*/
    *gmbs = 0.;
/*<       go to 1000 >*/
    goto L1000;

/*     saturation region */

/*<   110 betap=beta*(1.0d0+xlamda*vds) >*/
L110:
    betap = mosarg_1.beta * (mosarg_1.xlamda * *vds + 1.);
/*<       if (vgst.gt.vds) go to 120 >*/
    if (vgst > *vds) {
	goto L120;
    }
/*<       cdrain=betap*vgst*vgst*0.5d0 >*/
    mosarg_1.cdrain = betap * vgst * vgst * .5;
/*<       gm=betap*vgst >*/
    *gm = betap * vgst;
/*<       gds=xlamda*beta*vgst*vgst*0.5d0 >*/
    *gds = mosarg_1.xlamda * mosarg_1.beta * vgst * vgst * .5;
/*<       gmbs=gm*arg >*/
    *gmbs = *gm * arg;
/*<       go to 1000 >*/
    goto L1000;

/*     linear region */

/*<   120 cdrain=betap*vds*(vgst-0.5d0*vds) >*/
L120:
    mosarg_1.cdrain = betap * *vds * (vgst - *vds * .5);
/*<       gm=betap*vds >*/
    *gm = betap * *vds;
/*<       gds=betap*(vgst-vds)+xlamda*beta*vds*(vgst-0.5d0*vds) >*/
    *gds = betap * (vgst - *vds) + mosarg_1.xlamda * mosarg_1.beta * *vds * (
	    vgst - *vds * .5);
/*<       gmbs=gm*arg >*/
    *gmbs = *gm * arg;

/*     finished */

/*<  1000 return >*/
L1000:
    return 0;
/*<       end >*/
} /* moseq1_ */

