#ifndef _FLAGS_H_
 #define _FLAGS_H_

  /* functions to manipulate the 8085 flags */

 /* **************************************************************
  *
  *
  *   Ŀ
  *     S    Z              Ac        P    Cy 
  *   
  *
  *
  * **************************************************************
 */
/**/

/*------------------------------------------------------------------------*/
 int SetSign(int x)
 {
  /* Set corresponding flag to true if x is 1 or reset ii */
   return (!!x) ? SetFlag(GetFlag() | SIGN) : SetFlag(GetFlag() & ~SIGN);
 }
/*------------------------------------------------------------------------*/
 int SetZero(int x)
 {
  /* Set corresponding flag to true if x is 1 or reset ii */
   return (!!x) ? SetFlag(GetFlag() | ZERO) : SetFlag(GetFlag() & ~ZERO);
 }
/*------------------------------------------------------------------------*/
 int SetAuxCarry(int x)
 {
  /* Set corresponding flag to true if x is 1 or reset ii */
   return (!!x) ? SetFlag(GetFlag() | AUX_CARRY) :
         SetFlag(GetFlag() & ~AUX_CARRY);
 }
/*------------------------------------------------------------------------*/
 int SetParity(int x)
 {
  /* Set corresponding flag to true if x is 1 or reset ii */
   return !!x ? SetFlag(GetFlag() | PARITY) : SetFlag(GetFlag() & ~PARITY);
 }
/*------------------------------------------------------------------------*/
 int SetCarry(int x)
 {
  /* Set corresponding flag to true if x is 1 or reset ii */
   return !!x ? SetFlag(GetFlag() | CARRY) : SetFlag(GetFlag() & ~CARRY);
 }
/*------------------------------------------------------------------------*/
 int SetParityFlag(void)
 {
   /* set the parity flag */
   word temp;
   int  i;

    for(i=0,temp=GetTemp();  temp  ; temp >>=1)
      if(temp & 1) i++;
    return SetParity((i+1)%2);
 }
/*-----------------------------------------------------------------------*/
 int SetAllButCarry(void)
 {
  uchar x;
   /* set all flags but the carry , for flags to be correctly, all
      operations should be done on the 'temp' variable provided in the
      KIT
   */
   /* Note :- Auxillary flag is not set using this function
              It should be set by each individual instruction by using
              the function 'ShouldSetAuxillaryFlag()'
   */
   x = GetTemp() & MAX_INT;     /* extract lowest 8 bits */
   SetSign(x & SIGN);
   SetZero(!x);
   SetParityFlag();
   return GetFlag();
 }
/*-----------------------------------------------------------------------*/
 int Set8085Flag(void)
 {
   SetCarry(GetTemp()>MAX_INT ? 1 : 0);
   return SetAllButCarry();
 }
/*-----------------------------------------------------------------------*/
 int GetSign(void)
 {
   /* If sign flag is set return 1 else return 0 */
   return GetFlag() & SIGN ? 1 : 0;
 }
/*-----------------------------------------------------------------------*/
 int GetZero(void)
 {
   /* If zero flag is set return 1 else return 0 */
   return GetFlag() & ZERO ? 1 : 0;
 }
/*-----------------------------------------------------------------------*/
 int GetAuxCarry(void)
 {
   /* If Auxillary carry flag is set return 1 else return 0 */
   return GetFlag() & AUX_CARRY ? 1 : 0;
 }
/*-----------------------------------------------------------------------*/
 int GetParity(void)
 {
   /* If parity flag is set return 1 else return 0 */
   return GetFlag() & PARITY ? 1 : 0;
 }
/*-----------------------------------------------------------------------*/
 int GetCarry(void)
 {
   /* If carry flag is set return 1 else return 0 */
   return GetFlag() & CARRY ? 1 : 0;
 }
/*-----------------------------------------------------------------------*/
 int ShouldSetAuxillaryFlag(word accumulator,word temp,int operation)
 {
   /* an auxillary carry is set whenever a carry is generated by digit
      D3 and passed on to digit D4.
   */
   word temp1,temp2;

    temp1 = accumulator & 0xf;  /*  extract lower four bits */
    if(operation==PLUS)
    {  /* don't remove these braces */
      temp2 = temp & 0xf;         /*        - do -            */
      if((temp1+temp2)&0x10) return 1;
    }
    else
    {
      temp2 = (~temp+1)&0xf;
      /* take 2's complement and then extract lower four bits */
      if((temp1+temp2)&0x10) return 1;
    /* take the 2's complement and then add it */
    }
    return 0;
 }
/*-----------------------------------------------------------------------*/

#endif