                                                                     
/*
**  Additional PC-Dragon Services.
**
**  Copyright 1993-97 by Paul D. Burgin. All rights reserved.
*/

#include "dos.h"
#include "stdio.h"
#include "conio.h"
#include "time.h"
#include "bios.h"
#include "ctype.h"

#include "key.h"
#include "build.h"
#include "types.h"
#include "extern.h"
#include "6809cpu.h"
#include "6809regs.h"

/* It's not worth the trouble to put this prototype into extern.h! */
extern clock_t this_time;

/* Variables used for services. */
boolean					mouse_on = FALSE;
union REGS				regs;

/* Last service number supported by this version. */
#define MAX_SERVICE		27

/* Execute PC-Dragon service. */
unsigned char emu_service(boolean use_registers)
{
	/* Input variables. */
	unsigned char	_aa, _bb;
	unsigned int	_xx, _yy, _uu;

	/* Output variables. */
	unsigned char	__aa, __bb;
	unsigned int	__xx, __yy, __uu;

	unsigned int	dump_address;
	unsigned char	pal, cols;

	/* Value returned to Dragon. */
	unsigned char	return_condition = 0;

	if ((memory[0xffee] == 'P') && (memory[0xffef] == 'C'))
	{
		if (use_registers)
		{
			_aa = __aa = a_reg.u_value;
			_bb = __bb = b_reg.u_value;
			_xx = __xx = x_reg.u_value;
			_yy = __yy = y_reg.u_value;
			_uu = __uu = u_reg.u_value;
		}
		else
		{
			dump_address = (memory[0xffec] << 8) + memory[0xffed];
			_aa = __aa =  memory[dump_address];
			_bb = __bb =  memory[dump_address+1];
			_xx = __xx = (memory[dump_address+2] << 8) + memory[dump_address+3];
			_yy = __yy = (memory[dump_address+4] << 8) + memory[dump_address+5];
			_uu = __uu = (memory[dump_address+6] << 8) + memory[dump_address+7];
		}
		switch(_bb)
		{
			case 0:		/* Installation check. */
						__xx = (('P' << 8) + 'C');
						__aa = MAX_SERVICE;
						__yy = ((VER_MAJOR << 8) + VER_MINOR);
						break;

			case 1:		/* Close DOS files. */
						close_files(TRUE);
						break;

			case 2:		/* Cursor change. */
						__aa = cursortype;
						if (_aa < 0x80)
						{
							if (_aa > 1)
								cursortype = 2;
							else
								cursortype = (_aa & 0x01);
							if (vmode < 0)
								_setcursortype(cursortype);
						}
						break;

			case 3:		/* Lower case toggle. */
						__aa = lower_case;
						if (_aa < 0x80)
						{
							lower_case = (_aa & 0x01);
							if (((_aa & 0x02) != 0) && (vmode < 0))
								refresh_video();
						}
						break;

			case 4:		/* Joystick type. */
						__aa = digital_joysticks;
						if (_aa < 0x80)
							digital_joysticks = (_aa != 0);
						break;

			case 5:		/* Set text colours. */
						__xx = (fore_ary[0] << 12)
							+ (back_ary[0] << 8)
							+ (fore_ary[1] << 4)
							+ (back_ary[1]);
						if (_aa < 0x80)
						{
							fore_ary[0] = (_xx >> 12);
							back_ary[0] = (_xx >> 8) & 0x000f;
							fore_ary[1] = (_xx >> 4) & 0x000f;
							back_ary[1] = _xx & 0x000f;
							if ((_aa & 0x01) && (vmode < 0))
								refresh_video();
						}
						break;

			case 6:		/* Set graphics palette. */
						cols = _aa & 0x01;
						pal  = (_aa >> 1) & 0x01;
						__xx = (vmode_ary[cols][pal][1] << 8)
							  + vmode_ary[cols][pal][2];
						__yy = (vmode_ary[cols][pal][3] << 8)
							  + vmode_ary[cols][pal][4];
						__uu = (vmode_ary[cols][pal][0] << 8)
							  + vmode_ary[cols][pal][5];
						if (_aa < 0x80)
						{
							vmode_ary[cols][pal][0] = (_uu >> 8) & 63;
							vmode_ary[cols][pal][1] = (_xx >> 8) & 63;
							vmode_ary[cols][pal][2] = _xx & 63;
							vmode_ary[cols][pal][3] = (_yy >> 8) & 63;
							vmode_ary[cols][pal][4] = _yy & 63;
							vmode_ary[cols][pal][5] = _uu & 63;
							if (((_aa & 0x04) != 0) && (vmode >= 0))
								refresh_palette();
						}
						break;

			case 7:		/* Set graphics border. */
						__xx = (border_ary[0][0] << 8) + border_ary[0][1];
						if (_aa < 0x80)
						{
							border_ary[0][0] =
								border_ary[1][0] = (_xx >> 8) & 63;
							border_ary[0][1] =
								border_ary[1][1] = _xx & 63;
							if ((_aa & 0x01) && (vmode >= 0))
								refresh_palette();
						}
						break;

			case 8:		/* Get mouse status. */
						if (mouse_okay())
						{
							regs.x.ax = 3; /* get position */
							int86(MOUSE_INT, &regs, &regs);
							if (regs.x.cx < 64)
								__xx = 0xff00;
							else if (regs.x.cx > 574)
								__xx = (vmode < 0) ? 0xff1f : 0xffff;
							else
								__xx = ((regs.x.cx - 64)>>1);
							__yy = regs.x.dx;
							if (vmode < 0)
							{
								if (__xx < 0xff00)
									__xx >>= 3;
								__yy -= ((5 - 1) << 3);
								__yy >>= 3;
								if (__yy > 2000)
									__yy = 0xff00;
								else if (__yy > 15)
									__yy = 0xff0f;
							}
							else
							{
								if (__yy > 191)
								__yy = 191;
							}
							__aa = regs.x.bx & 7;
						}
						else
							return_condition = 1;
						break;

			case 9:		/* Exit. */
						quit("-= Exit Service =-",3);

			case 10:	/* Mouse pointer on/off. */

						/* Note: This service isn't very friendly - the */
						/* pointer should really be turned off before   */
						/* and after any future mode changes. But this  */
						/* would be a real pain to implement...         */

						__aa = mouse_on;
						if (_aa < 0x80)
						{
							if (mouse_okay())
							{
								if ((mouse_on = (_aa != 0)) == TRUE)
								{
									regs.x.ax = 1; /* show pointer */
									int86(MOUSE_INT, &regs, &regs);
								}
								else if (__aa)
								{
									regs.x.ax = 2; /* hide pointer */
									int86(MOUSE_INT, &regs, &regs);
								}
							}
							else
								return_condition = 1;
						}
						break;

			case 11:    /* Cassette status. */
						if (cassette_disabled)
							__aa = 0;
						else
							__aa = file_mode + 1;
						break;

			case 12:	/* SAM configuration. */
						__aa = mapmode1;
						__bb = new_vmode;
						__xx = new_screen_base;
						__yy = new_screen_end();
						break;

			case 13:	/* Date and time. */
						{
							struct date local_date;
							struct time local_time;

							getdate(&local_date);
							gettime(&local_time);
							__uu = local_date.da_year;
							__yy = local_date.da_mon;
							__xx = local_date.da_day;
							__aa = local_time.ti_hour;
							__bb = local_time.ti_min;
						}
						break;

			case 14:	/* Ignore illegal instructions toggle. */
						__aa = ignore_illegal_opcodes;
						if (_aa < 0x80)
							ignore_illegal_opcodes = (_aa != 0);
						break;

			case 15:	/* Prompt for filenames. */
						__aa = ask_filenames;
						if (_aa < 0x80)
							ask_filenames = (_aa != 0);
						break;

			case 16:	/* Keyboard type toggle. */
						__aa = new_int9_set;
						if (_aa < 0x80)
						{
							if (new_int9_set)
								Set_Old_Int9();
							new_int9_set = (_aa != 0);
							if (new_int9_set)
								Set_New_Int9();
						}
						break;

			case 17:	/* Printer support. */
						if (printfile)
							__aa = 0;
						else
							__aa = lpt + 1;
						if (_aa < 0x80)
						{
							change_printfile(_aa == 0);
							if (!printfile)
								return_condition = !change_lpt(_aa - 1);
						}
						break;

			case 18:	/* CRLF toggle. */
						__aa = crlf;
						if (_aa < 0x80)
							crlf = (_aa != 0);
						break;

			case 19:	/* Printer mode toggle. */
						__aa = !printsimple;
						if (_aa < 0x80)
							printsimple = (_aa == 0);
						break;

			case 20:	/* Serial baud rate setting. */
						switch (comspeed)
						{
							case _COM_1200:	__aa = 0;	break;
							case _COM_2400:	__aa = 1;	break;
							case _COM_4800:	__aa = 2;	break;
							case _COM_9600:	__aa = 3;	break;
						}
						if (_aa < 0x80)
						{
							switch (_aa & 0x03)
							{
								case 0:	set_comspeed(_COM_1200);	break;
								case 1:	set_comspeed(_COM_2400);	break;
								case 2:	set_comspeed(_COM_4800);	break;
								case 3:	set_comspeed(_COM_9600);	break;
							}
						}
						break;

			case 21:	/* IRQ rate. */
						__xx = irq_rate;
						if (_aa < 0x80)
						{
							irq_rate = _xx;
							should_be_seconds = (double)irq_rate / 89.0;
							this_time = 0;
						}
						break;

			case 22:	/* Artifacting control. */
						__aa = get_artifact();
						if (_aa < 0x80)
						{
							set_artifact(_aa & 0x03);
							if ((_aa & 0x04) && (vmode >= 0))
								refresh_palette();
						}
						break;

			case 23:	/* Set graphics border V2. */
						__xx = (border_ary[0][0] << 8) + border_ary[0][1];
						__yy = (border_ary[1][0] << 8) + border_ary[1][1];
						if (_aa < 0x80)
						{
							border_ary[0][0] = (_xx >> 8) & 63;
							border_ary[0][1] = _xx & 63;
							border_ary[1][0] = (_yy >> 8) & 63;
							border_ary[1][1] = _yy & 63;
							if ((_aa & 0x01) && (vmode >= 0))
								refresh_palette();
						}
						break;

			case 24:	/* Joystick device. */
						__aa = realjoy;
						__xx = hardjoy_resolution;
						if (_aa < 0x80)
						{
							realjoy = (_aa != 0);
							if (realjoy && !hasjoystick)
							{
								realjoy = FALSE;
								return_condition = 1;
								hardjoy_resolution = _xx & 0x00ff;
							}
						}
						break;

			case 25:	/* Get function key string. */
						{
							unsigned int	ptemp = 0;
							unsigned char	kword = tolower(_aa) - 'a';

							if (_aa == '#')
								_aa = 11;
							if ((_aa >= 1) && (_aa <= 11))
							{
								do
								{
									far_set_mem8(_xx, presets[_aa-1][ptemp]);
									_xx++;
								} while (presets[_aa-1][ptemp++] != '\0');
							}
							else if (kword <= 25)
							{
								do
								{
									far_set_mem8(_xx, keywords[kword][ptemp]);
									_xx++;
								} while (keywords[kword][ptemp++] != '\0');
							}
							else
								return_condition = 1;
						}
						break;

			case 26:	/* Set function key string. */
						{
							unsigned int	ptemp = 0;
							unsigned char	kword = tolower(_aa) - 'a';

							if ((_aa >= 1) && (_aa <= 11))
							{
								do
								{
									presets[_aa-1][ptemp++] = far_get_mem8(_xx);
									_xx++;
								} while (ptemp < PRESET_LEN);
								presets[_aa-1][PRESET_LEN] = '\0';
							}
							else if (kword <= 25)
							{
								do
								{
									keywords[kword][ptemp++] = far_get_mem8(_xx);
									_xx++;
								} while (ptemp < 10);
								keywords[kword][10] = '\0';
							}
							else
								return_condition = 1;
						}
						break;

			case 27:	/* Beep. */
						if (_xx > 0)
						{
							sound(_xx);
							if (_yy > 0)
							{
								delay(_yy);
								nosound();
							}
						}
						else
							nosound();
						break;

			default:	return(0xff);
		}
		if (use_registers)
		{
			a_reg.u_value = __aa;
			b_reg.u_value = __bb;
			x_reg.u_value = __xx;
			y_reg.u_value = __yy;
			u_reg.u_value = __uu;
		}
		else
		{
			far_set_mem8(dump_address,   __aa);
			far_set_mem8(dump_address+1, __bb);
			far_set_mem8(dump_address+2, __xx >> 8);
			far_set_mem8(dump_address+3, __xx & 0x00ff);
			far_set_mem8(dump_address+4, __yy >> 8);
			far_set_mem8(dump_address+5, __yy & 0x00ff);
			far_set_mem8(dump_address+6, __uu >> 8);
			far_set_mem8(dump_address+7, __uu & 0x00ff);
		}
	}
	else
	{
		return_condition = (use_registers ?
			memory[0xffee - 0x4000] : memory[0xffef - 0x4000]);
	}

	return(return_condition);
}
