#include <stdio.h>
#include <alloc.h>

#pragma warn -aus                         /* don't warn unused vars */

#define clear_screen asm {mov ax, 0003h; int 10h}    /* non portable */

float *seq[3] = {NULL, NULL, NULL};
unsigned sqc[3] = {0, 0, 0};
unsigned soc[3] = {0, 0, 0};

#define XN seq[0]
#define HN seq[1]
#define YN seq[2]

#define XNC sqc[0]
#define HNC sqc[1]
#define YNC sqc[2]

#define XNO soc[0]
#define HNO soc[1]
#define YNO soc[2]

char *action_list[] = {
                       "1. (Re)define the input signal sequence x[n]",
                       "2. (Re)define the impulse response sequence h[n]",
                       "3. Perform discrete convolution sum operation",
                       "4. View the tabulated results of convolution",
                       "5. Goodbye! Have a nice day! See ya later!",
                      };

unsigned show_menu (unsigned y, unsigned x, char *menu_options[], unsigned max_choices);

void pause (void) {
    char dummy;
    fflush (stdin);
    dummy = getchar ();
}

/*--------------------------------------------------------------------------*/
void define_seq (float **seq, unsigned *snc, unsigned *sno) {
    unsigned i;
    unsigned is_correct = 0;
    char ch;

    do {
        clear_screen;

        printf ("Defining sequence...\n\n");
        printf ("Tell me how many elements are there in the sequence ? ");
        fflush (stdin);
        scanf ("%u", snc);

        if (*seq != NULL) free (*seq);
        *seq = (float *) malloc ((*snc) * sizeof (float));

        printf ("\nOk, now key in the elements (separated by spaces) for me.\n");
        printf ("(I'll ignore extra elements beyond the specified range)\n");
        fflush (stdin);
        for (i = 0; i < *snc; ++i) {
            scanf ("%f", &(*seq)[i]);
        }

        printf ("\nTell me which element is at 0-position ? (0 for CLTI system) ");

        do {
            fflush (stdin);
            scanf ("%u", sno);
            if (*sno >= *snc) {
                printf ("\nUh..huh, I don't think that position is valid.\n");
                printf ("Can I have that position again ? ");
            }
        } while (*sno >= *snc);

        printf ("\n\nAre you sure this info is correct ? ");
        fflush (stdin);

        ch = getchar ();
        if (ch == 'y' || ch == 'Y') is_correct = 1;
    } while (is_correct == 0);
}

/*-------------------------------------------------------------------------*/
void convolve (void) {
    unsigned i, j;
    float *workpad;

    clear_screen;

    printf ("Convolving sequences x[n] and h[n]...\n\n");

    if (XN == NULL || HN == NULL) {
        printf ("Looks like we have a small problem here :-(\n");
        printf ("I can't convolve the sequence(s) 'cause they haven't been defined.\n");
        printf ("\nLet me give you some tips on how to get around this problem...\n");
        printf ("\t1. define the input sequence x[n] (menu op. 1).\n");
        printf ("\t2. define the impulse response sequence h[n] (menu op. 2).\n");
        printf ("\nFollow these steps and try the convolve option again.\n\n");
        printf ("Hit ENTER to return to main menu.");
        pause ();
        return;
    }

    printf ("\nHang on a moment while I do the dirty work...\n\n");

    printf ("Initializing scratch workpad...\n");
    workpad = (float *) malloc (((HNC - 1)*2 + XNC) * sizeof (float));

    for (i = 0; i < (HNC - 1); ++i) workpad[i] = 0;
    for (; i < (HNC + XNC - 1); ++i) workpad[i] = XN[i - (HNC - 1)];
    for (; i < ((HNC - 1) * 2 + XNC); ++i) workpad[i] = 0;

    printf ("Calculating size of y[n]...\n");
    YNC = XNC + HNC - 1;

    if (YN != NULL) free (YN);
    YN = (float *) malloc (YNC * sizeof (float));

    printf ("Performing discrete time convolution");
    for (i = 0; i < YNC; ++i) {
        printf (".");
        YN[i] = 0;
        for (j = 0; j < HNC; ++j) {
            YN[i] = YN[i] + workpad[j+i] * HN[HNC - 1 - j];
            if ((j+i) == (HNC-1+XNO) && (HNC-1-j) == HNO) {
                YNO = i;
            }
        }
    }

    free (workpad);

    printf (" done!\n\n");
    printf ("Hit ENTER to return to main menu.");

    pause ();
}

/*--------------------------------------------------------------------------*/
void tabulate (void) {
    unsigned i, j, max;

    clear_screen;

    printf ("Viewing results of convolution sum...\n\n");

    if (XN == NULL || HN == NULL || YN == NULL) {
        printf ("Looks like we have a small problem here :-(\n");
        printf ("I can't show the sequence(s) 'cause they haven't been defined/generated.\n");
        printf ("\nLet me give you some tips on how to get around this problem...\n");
        printf ("\t1. define the input sequence x[n] (menu op. 1).\n");
        printf ("\t2. define the impulse response sequence h[n] (menu op. 2).\n");
        printf ("\t3. perform the convolution operation (menu op. 3).\n");
        printf ("\nFollow these steps and try the view option again.\n\n");
        printf ("Hit ENTER to return to main menu.");
        pause ();
        return;
    }

    printf ("\tx[n]\t\t\th[n]\t\t\ty[n]\n");
    printf ("*******************************************************************************");

    max = (XNC > HNC) ? ((XNC > YNC) ? XNC:YNC):((HNC > YNC) ? HNC:YNC);

    for (i = 0; i < max; ++i) {
        printf ("\n\t");
        for (j = 0; j < 3; ++j) {
            if (j > 0) printf ("\t\t\t");
            if (i < sqc[j]) {
                if (i == soc[j]) printf ("-->");
                printf ("%3.1f", seq[j][i]);
            }
            else {
                printf ("---");
            }
        }

        if ((i > 0) && (i % 18 == 0)) {
            printf ("\n** MORE **");
            pause ();
        }
    }

    printf ("\n*******************************************************************************");
    printf ("\n\nHit ENTER to return to main menu.");
    pause ();
}
/*--------------------------------------------------------------------------*/
void main (void) {
    unsigned user_choice, i;
    unsigned quit_flag = 0;

    do {
        clear_screen;
        printf ("Hi!... Welcome to Convolve-It! by Shanks a.k.a Web-Nut. Comments welcome.");
        printf ("\n\n\n\n\n\n\n\t\t\tWhat would you like to do ?");
        printf ("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nUse the arrow keys and ENTER to select a task for me.");
        user_choice = show_menu (10, 17, action_list, 5);

        switch (user_choice) {
            case 0: quit_flag = 1; break;
            case 1: define_seq (&XN, &XNC, &XNO); break;
            case 2: define_seq (&HN, &HNC, &HNO); break;
            case 3: convolve (); break;
            case 4: tabulate (); break;
            case 5: quit_flag = 1; break;
        }
    } while (quit_flag == 0);

    for (i = 0; i < 3; ++i) {
        if (seq[i] != NULL) free (seq[i]);
    }

    clear_screen;
}
/*-------------------------------------------------------------------------*/
