/**
 **
 ** FINDENV -- A utility for finding the active DOS environment
 **
 ** Version 1.1  05/26/90  (for Microsoft C Version 5.1)
 ** Copyright (c) D. E. Ekman 1990.  All rights reserved.
 **
 ** FINDENV locates the active DOS environment.  This is the copy used by the
 ** current DOS shell (usually COMMAND.COM), and the one that the shell
 ** passes to programs that it invokes.  After finding the active environment,
 ** FINDENV prints the segment location (in Hex), the size, the amount used,
 ** and the remaining space in the environment (all in decimal bytes).  It then
 ** prints the contents of the environment for inspection.
 **
 ** This program forms the basis for other programs that may change the active
 ** environment.  For example, it provides a means of generating PATH statements
 ** that are not limited by the 128-byte size of the command buffer.
 **
 **/ 
#include <stdio.h>
#include <stdlib.h>

main()
{
    unsigned envseg, envsize, envinuse;
    int count;
    char far *ptr;

    getsysenv(&envseg, &envsize, &envinuse);
    printf("\nThe Ekman Utility FINDENV, V1.1\n");
    printf("Copyright (c) Donald E. Ekman 1990.  All rights reserved.\n");
    printf("\nThe active environment begins at %X:0 (Hex).\n",envseg);
    printf("The size of the environment is %d bytes,\n",envsize);
    printf(" of which %d bytes are used,",envinuse);
    printf(" leaving %d bytes free.\n\n",(envsize-envinuse));
    printf("Environment contents:\n\n");
    ptr = (char far *) ((long) envseg << 16);
    for (count=0; count<envinuse; count++)
        {
        if(*(ptr + count) == '\0')
            putchar('\370');
        else
            putchar(*(ptr + count));
        }
    printf("\n");
    return(0);
}

getsysenv(envseg, envsize, envinuse)
unsigned *envseg, *envsize, *envinuse;
{
    unsigned getdospsp(), computeenvinuse(), dospsp, temp;
    unsigned far *ptr;

    dospsp = getdospsp();
    ptr = (unsigned far *) (((long) dospsp << 16) | 0x2c);
    temp = *ptr;
    if((temp != 0) && (_osmajor != 3 || _osminor <= 19 || _osminor >= 30))
        {
        *envseg = temp;
        }
    else
        {
        ptr = (unsigned far *) (((long) (dospsp-1) << 16) | 3);
        *envseg = dospsp + (*ptr) + 1;
        }
    ptr = (unsigned far *) (((long) ((*envseg)-1) << 16) | 3);
    *envsize = 16*(*ptr);
    *envinuse = computeenvinuse(*envsize, *envseg);
    return(0);
}

unsigned getdospsp()
{
    unsigned temp, temp1;
    unsigned far *ptr;

    ptr = (unsigned far *) (((long) _psp << 16) | 0x16);
    temp = *ptr;	
    while(1)
        {
        ptr = (unsigned far *) (((long) temp << 16) | 0x16);
        temp1 = *ptr;
        if((!temp1) || (temp1 == temp))
            return(temp);
        else
            temp = temp1;
        }
}

unsigned computeenvinuse(envsize, envseg)
unsigned envsize, envseg;
{
    unsigned j;
    unsigned far *ptr;

    for(j=0; j<=(envsize-3); j++)
        {
        ptr = (unsigned far *) (((long) envseg << 16) | j);
        if(*ptr == 0)
            {
            return(j+2);
            }
        }
    return(envsize);
}
