		Page 60,132
;----------------------------------------------------------------------
; RECORDER.ASM - A resident program which counts file operations.
; Run it once to install and initialize it.  Run it again later to
; view a list of files which have been accessed.  The table
; shows how many disk accesses have been made while reading and
; writing to the file.
;
; SYNTAX:   RECORDER  [n] [/R]
; USE   n to specify the maximum number of files (default=200)
; Use  /R to reset the file table.
;Toad Hall Tweak, Jul 88
; - tightened code a little
; - no functional changes
;David Kirschbaum
;Toad Hall
;kirsch@braggvax.ARPA
;----------------------------------------------------------------------

CSEG	SEGMENT para public 'CODE'
	ASSUME	CS:CSEG,DS:CSEG, ES:CSEG

	ORG	100H	;Beginning for .COM programs

Start	proc	near
	JMP	Initialize		;Initialization code is at end

;-----------------------------------------------------------------------
; Data area used by this program
;-----------------------------------------------------------------------
COPYRIGHT	DB	'RECORDER 1.1',0DH,0AH,'$'
;		db	' (c) 1988 Ziff Communications Co.'
;PROGRAMMER	DB	13,10,'PC Magazine ',254,' Tom Kihlken$',1AH

full_mess	DB	'*Table is saturated*$'
oldint21	DD	?	;Old DOS function interrupt vector
oldint13	DD	?	;Old BIOS disk I/O interrupt vector
num_files	DW	200	;Default size of the table
file_table_end	DW	?
last_file	DW	?
last_handle	DW	?

current_file	DB	11 DUP (?)
current_handle	DW	?
function_id	DW	?
busy_flag	DB	0
bios_IO_count	DW	0	;Counts disk accesses made by BIOS

HANDLE_TABLE	EQU	OFFSET header	;TH was Initialize
FILE_TABLE	EQU	HANDLE_TABLE + NUM_HANDLES * 4
NUM_HANDLES	EQU	30
ENTRY_SIZE	EQU	20
Start	endp

;-----------------------------------------------------------------------
; Interrupt 13 (Diskette I/O) This routine counts disk sector accesses.
;-----------------------------------------------------------------------
NewInt13	PROC	FAR
	ASSUME	DS:NOTHING, ES:NOTHING
	CMP	AH,2			;Is function lower than 2?
	JB	Dont_Count		;If yes, then ignore it
	CMP	AH,4			;Is function higher than 4?
	JA	Dont_Count		;If yes, then ignore it
	INC	CS:bios_IO_count	;Add sectors count to total
Dont_Count:
	JMP	CS:oldint13		;Continue with disk interrupt
NewInt13	ENDP

;-----------------------------------------------------------------------
; Interrupt 21 (DOS functions)  This routine counts file accesses.
;-----------------------------------------------------------------------
NewInt21	PROC	FAR
	ASSUME	DS:NOTHING, ES:NOTHING

	PUSHF				;Save callers flags
	STI				;Get interrupts back on
	CMP	CS:busy_flag,0		;Are we busy now?
	JNE	Old_Dos			;If busy, just pass it to DOS
	CMP	AH,4BH			;Is it the EXEC function?
	JE	Exec			;Handle EXEC specially
	CMP	AH,0EH			;Is it below 0EH?
	JBE	Old_Dos			;If yes, ignore it
	CMP	AH,31H			;Is it TSR function?
	JE	Old_Dos			;Dont intercept this call
	CMP	AH,45H			;Is it above 45H?
	JB	Intercept_It		;If yes, then ignore it
Old_Dos:
	POPF				;Recover callers flags
	CLI
	JMP	CS:oldint21		;Allow interrupt to proceed

Exec:
	PUSH	AX			;Save these registers
	PUSH	BX
	PUSH	CX
	PUSH	SI
	PUSH	DI
	PUSH	DS
	PUSH	ES
	MOV	CS:busy_flag,1		;Set the busy flag
	MOV	SI,OFFSET Parse_String	;Point to parse routine
	CALL	Enter_Filename		;Search file table for the file
	JC	Exec_Continue
	 INC	WORD PTR [SI+12]	;TH
	 INC	WORD PTR [SI+12]	;TH
Exec_Continue:
	MOV	CS:busy_flag,0		;Not busy any more
	POP	ES			;Restore the registers
	POP	DS
	POP	DI
	POP	SI
	POP	CX
	POP	BX
	POP	AX
	JMP	Old_Dos

Intercept_It:
	MOV	busy_flag,1		;Ignore any other calls
	MOV	function_id,AX		;Save the function ident.,
	MOV	bios_IO_count,0
	CLI
	CALL	CS:oldint21		;Do the DOS function
	STI				;Reenable interrupts
	PUSHF				;Save DOS result flags
	PUSH	AX			;Save these registers
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	DS
	PUSH	ES
	JNC	Check_Function		;If no error, continue
	 JMP	Pop_Ret			;Otherwise just return

Check_Function:
	MOV	CX,function_id
	SUB	CH,0FH		;Is it 0Fh?
	JZ	Read_FCB
	DEC	CH		;Is it 10h?
	JZ	Write_FCB
	SUB	CH,4		;Is it 14h?
	JZ	Read_FCB
	DEC	CH		;Is it 15h?
	JZ	Write_FCB
	DEC	CH		;Is it 16h?
	JZ	Read_FCB
	SUB	CH,0BH		;Is it 21h?
	JZ	Read_FCB
	DEC	CH		;Is it 22h?
	JZ	Write_FCB
	DEC	CH		;Is it 23h?
	JZ	Read_FCB
	SUB	CH,4		;Is it 27h?
	JZ	Read_FCB
	DEC	CH		;Is it 28h?
	JZ	Write_FCB
	JMP	SHORT Not_FCB_Functn

Read_FCB:
	MOV	BX,14			;Index for the read column
	JMP	SHORT Inc_FCB_Count

Write_FCB:
	MOV	BX,16			;Index for the write column
Inc_FCB_Count:
	MOV	SI,OFFSET Parse_FCB
	CALL	Enter_Filename		;Search file table for the file
	JC	Jump_Pop_Ret		;Quit if file not in table
	MOV	AX,bios_IO_count	;This many disk operations made
	ADD	CS:[SI][BX],AX		;Add it to the indexed column
	ADD	CS:[SI+12],AX		;Add it to the total
	JMP	Pop_Ret

; If it was not a FCB function, see if it was handle I/O

Not_FCB_Functn:
	SUB	CH,14H		;Is it 3Ch?
	JE	New_Handle
	DEC	CH		;Is it 3Dh?
	JE	New_Handle
	DEC	CH		;Is it 3Eh?
	JE	Write_Handle
	DEC	CH		;Is it 3Fh?
	JE	Read_Handle
	DEC	CH		;Is it 40h?
	JE	Write_Handle
	SUB	CH,2		;Is it 42h?
	JE	Read_Handle
	SUB	CH,2		;Is it 44h?
	JE	IO_Control
	JMP	Pop_Ret

New_Handle:
	CMP	AX,5			;Is it a standard handle?
	JGE	Good_Handle		;If not, then record it
Jump_Pop_Ret:
	JMP	Pop_Ret			;Jump to the return

Read_Handle:
	MOV	CX,14			;Index for the read column
	JMP	SHORT Inc_Dev_Count

IO_Control:
	CMP	CL,2			;Is it a read request?
	JE	Read_Handle		;Treat it as a read
	CMP	CL,3			;Is it a write request?
	JNE	Jump_Pop_Ret		;If not read or write, ignore it
Write_Handle:
	MOV	CX,16			;Index for the write column
Inc_Dev_Count:
	CMP	BX,5			;Is it a standard handle?
	JB	Jump_Pop_Ret		;If it is, then ignore it
	PUSH	CX			;Put index on the stack

; Now search the handle table for the handle in BX.

	CALL	Add_PSP			;Add in the current PSP segment
	MOV	DI,HANDLE_TABLE		;Point to the handle table
	MOV	CX,NUM_HANDLES		;Search the entire table
Handle_Loop:
	CMP	BX,CS:[DI]		;Is it a match?
	JE	Handle_Match		;If it is, we've found it
	ADD	DI,4			;If not, look at next entry
	LOOP	Handle_Loop
	POP	BX			;Restore the stack
	JMP	SHORT Pop_Ret		;Return if handle was not found

; If the handle is being closed, then the entry is deleted.

Handle_Match:
	CMP	BYTE PTR function_id+1,3EH ;Closing this file?
	JNE	Not_Close
	 MOV	WORD PTR CS:[DI],0
Not_Close:
	MOV	DI,CS:[DI+2]		;Get pointer to file table entry
	POP	BX			;Get the index back
	MOV	AX,bios_IO_count	;Get the sector count
	ADD	CS:[DI][BX],AX		;Add it to selected column
	ADD	CS:[DI+12],AX		;And also to the total column
	JMP	SHORT Pop_Ret

Good_Handle:
	MOV	current_handle,AX	;Save the handle
	MOV	SI,OFFSET Parse_String	;Point to parse routine
	CALL	Enter_Filename		;Add the file to the table
	JC	Jump_Pop_Ret		;If table is full, return
	MOV	AX,bios_IO_count	;Get number of sectors
	add	[SI+12],ax		;TH Add to the total column
	add	[SI+14],ax		;TH Add to the read column

; Now enter this new handle to the handle table

	MOV	DI,last_handle		;Get location of last entry
	ADD	DI,4			;Advance it one position
	CMP	DI,HANDLE_TABLE+NUM_HANDLES*4
	JNE	Keep_Going
	 MOV	DI,HANDLE_TABLE
Keep_Going:
	MOV	last_handle,DI		;Now this is the last handle
	MOV	BX,current_handle	;Get handle back
	CALL	Add_PSP			;Add in the current PSP segment
	MOV	CS:[DI],BX		;Store the handle
	MOV	CS:[DI+2],SI		;Store location in file table
Pop_Ret:
	MOV	CS:busy_flag,0		;Not busy any more
	POP	ES			;Restore all registers
	POP	DS
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	POPF				;Recover DOS result flags
	STI				;Return with interrupts on
	RET	2			;Return with these flags
NewInt21	ENDP

;-----------------------------------------------------------------------
; Enter_Filename adds the file at DS:DX to the table.
; It returns with DS:SI pointing to the entry.  If CF=1, then the name
; was not in the table and no more entries could be added.
;-----------------------------------------------------------------------
	ASSUME	DS:NOTHING, ES:CSEG
Enter_Filename	PROC	NEAR
	CLD				;String moves forward
	mov	ax,CS			;TH
	mov	ES,ax			;Th set up the ES reg

	MOV	DI,OFFSET current_file
	mov	ax,'  '			;TH fill with blanks
;TH 11 letters in name
	mov	cx,5			;TH 10 letters
	rep	stosw			;TH stuff 2 at a time
	stosb				;TH the 11th byte

	CALL	SI			;Call the parse routine

; Now search the file table for the current filename
	CLD
	mov	ax,CS			;TH
	mov	DS,ax			;TH set DS to this segment
	ASSUME	DS:CSEG

	MOV	CX,num_files		;Try all entries
	MOV	SI,FILE_TABLE		;Setup for a string compare
	mov	bx,11			;TH constant for adding
Search_Loop:
	MOV	DI,OFFSET current_file
	mov	ax,cx			;TH Save the loop counter
	PUSH	SI			;Save the source also
	MOV	CX,bx	;TH 11		;Compare 11 characters
	REPE	CMPSB			;Do they all match?
	POP	SI
	JCXZ	Clear_Return		;If matched, return CF=0
	ADD	SI,ENTRY_SIZE		;Point to next name in table
	MOV	CX,AX			;Get loop counter back to CX
	LOOP	Search_Loop
	MOV	DI,last_file		;Get location of last entry
	CMP	DI,-1			;Is table saturated?
	JE	Table_Full		;If yes, then return

	MOV	CX,num_files		;Loop through file table
Find_Oldest:
	ADD	DI,ENTRY_SIZE		;Point to next entry in table
	CMP	DI,file_table_end
	JB	No_Wrap
	MOV	DI,FILE_TABLE
No_Wrap:
	MOV	AX,[DI+12]		;Get total for this record
	CMP	AX,1			;Is it less than one?
	JBE	Found_Oldest		;If it is, then we'll use it
	LOOP	Find_Oldest		;Search entire table for a space
	MOV	last_file,-1		;If none found, table is full
Table_Full:
	STC				;Carry flag indicates table full
	RET

; At this point ES:DI points to newest table entry

Found_Oldest:
	MOV	last_file,DI
	PUSH	DI
	CLD				;String moves forward
	MOV	SI,OFFSET current_file
;TH 11 bytes in name, so move by word
	mov	cx,5			;TH Copy the filename to table
	rep	movsw			;TH by word
	movsb				;TH last byte
	XOR	AX,AX
	INC	DI			;Point to the totals column
;TH set total,open,read,write columns to zero
	mov	cx,5			;TH
	rep	stosw			;TH
	POP	SI
Clear_Return:
	CLC				;Indicates sucessful return
	RET
Enter_Filename	ENDP

;-----------------------------------------------------------------------
; This subroutine parses a filename from the FCB at DS:DX
;-----------------------------------------------------------------------
	ASSUME	DS:NOTHING, ES:CSEG
Parse_FCB	PROC	NEAR
	INC	DX			;Point to filename in FCB
	MOV	SI,DX			;Get address in index register
	ADD	SI,8			;Point to file extension
	MOV	DI,OFFSET current_file+8 ;DI Points to extension
	MOV	CX,3
Copy_Ext_1:
	LODSB				;Get a letter of the extension
	CALL	Upper_Case		;Make it upper case
	STOSB				;Store it in current file
	LOOP	Copy_Ext_1
	SUB	SI,3
	JMP	SHORT Copy_Name		;Finish copying the name
Parse_FCB	ENDP

;-----------------------------------------------------------------------
;This routine parses an ASCII filename from DS:DX and places it at
; current_file
;-----------------------------------------------------------------------
Parse_String	PROC	NEAR
	ASSUME	DS:NOTHING, ES:CSEG
	MOV	SI,DX			;Get address in index register
Look_For_Dot:
	LODSB				;Next letter of name
	OR	AL,AL			;Is it the last letter
	JZ	Copy_Name1		;If yes, begin to copy the name
	CMP	AL,'.'			;Is this the dot?
	JNE	Look_For_Dot
;Got_The_Dot:
	PUSH	SI			;Now SI points to the extension
	MOV	DI,OFFSET current_file+8 ;DI points to extension
	MOV	CX,3
Copy_Extension:
	LODSB				;Next letter of the extension
	OR	AL,AL			;Is it the last letter?
	JZ	End_Copy
	CALL	Upper_Case		;Convert letter to upper case
	STOSB				;And store it
	LOOP	Copy_Extension
End_Copy:
	POP	SI			;Recover location of name
Copy_Name1:
	DEC	SI
Copy_Name:
	DEC	SI
	STD				;Copy name right to left
	MOV	CX,8			;Eight letters in filename
	MOV	DI,OFFSET current_file+7 ;Point to end of name
Name_Loop:
	CMP	SI,DX			;At start of name yet?
	JB	Parse_Done		;If yes, then quit copying
	LODSB				;Get letter of name
	CMP	AL,'\'			;At path specification?
	JE	Parse_Done		;If yes, then quit copying
	CMP	AL,'/'			;At path specification?
	JE	Parse_Done		;If yes, then quit copying
	CMP	AL,':'			;At drive specification?
	JE	Parse_Done		;If yes, then quit copying
	CMP	AL,' '			;Is this letter a space?
	JE	Skip_Space		;Don't copy any spaces
	CALL	Upper_Case		;Convert letters to upper case
	STOSB				;Store the letter
Skip_Space:
	CMP	SI,0FFFFH		;Did SI wrap around segment?
	JE	Parse_Done		;If yes, then quit copying
	LOOP	Name_Loop		;Loop through entire name
Parse_Done:
	cld				;TH insure fwd again
	RET				;Done parsing the name
Parse_String	ENDP

;-----------------------------------------------------------------------
; This subroutine converts the letter in AL to upper case.
;-----------------------------------------------------------------------
Upper_Case	PROC	NEAR
	ASSUME	DS:NOTHING, ES:NOTHING
	CMP	AL,'a'			;Is it lower case?
	JB	No_Change		;If not, don't change it
	CMP	AL,'z'			;Is it a letter?
	JA	No_Change		;If not, don't change it
	AND	AL,11011111B		;This convert to upper case
No_Change:
	RET
Upper_Case	ENDP

;-----------------------------------------------------------------------
; This subroutine adds the current PSP segment address to the handle
; in BX.  This creates a unique number for each open handle.
;-----------------------------------------------------------------------
Add_PSP		PROC	NEAR
	ASSUME	DS:NOTHING, ES:NOTHING
	PUSH	BX			;Save the starting handle
	MOV	AH,51H			;Get current PSP
	INT	21H
	POP	AX			;Get back starting handle
	ADD	BX,AX			;And add it to the PSP
	RET
Add_PSP		ENDP

;-----------------------------------------------------------------------
; This subroutine zeros out the file and handle tables.
; on entry DS points to the tables segment.
;-----------------------------------------------------------------------
Reset_Table	PROC	NEAR
	ASSUME	DS:NOTHING, ES:NOTHING
	mov	ax,DS
	mov	ES,ax			;TH
	MOV	DI,FILE_TABLE
	MOV	CX,num_files		;TH DS:num_files
	XOR	AX,AX
	mov	bx,10			;TH constant for adding
	mov	si,ENTRY_SIZE-14	;TH constant for adding
Zero_Files:
	STOSW				;Erase the old filename
	ADD	DI,bx			;TH 10
	STOSW				;Zero the total count
	ADD	DI,si			;TH ENTRY_SIZE-14
	LOOP	Zero_Files
	MOV	DI,HANDLE_TABLE		;Point to the handle table
	MOV	CX,NUM_HANDLES		;Number of entries in it.
	mov	ax,FILE_TABLE		;TH constant
	xor	bx,bx			;TH constant
Zero_Handles:
	xchg	ax,bx			;TH ax=0,bx=FILE_TABLE
	stosw
	xchg	ax,bx			;TH ax=FILE_TABLE, bx=0
	stosw
	loop	Zero_Handles		;Zero the handle table entries
	mov	last_file,ax		;TH FILE_TABLE
	ret
Reset_Table	ENDP

;-----------------------------------------------------------------------
; To install, store existing interrupt vectors and replace them with the
; new ones.  Then exit and remain resident.
;-----------------------------------------------------------------------
Install:
	ASSUME	CS:CSEG, DS:CSEG, ES:NOTHING
	CALL	Load_Params
	JCXZ	No_Digits
	XOR	AX,AX			;Clear AX for the total
Get_Digit:
	MOV	BL,[si]			;Get next letter
	SUB	BL,30H			;Convert ascii to integer
	JC	Not_A_Digit		;Was it below a 0?
	CMP	BL,9			;Was it above a 9?
	JA	Not_A_Digit		;Ignore if not 0-9
	MOV	BH,10
	MUL	BH			;Times 10 for next digit
	XOR	BH,BH
	ADD	AX,BX			;Add in the new digit
Not_A_Digit:
	INC	SI
	LOOP	Get_Digit		;Look at all characters
	OR	AX,AX			;Did we get anything
	JZ	No_Digits
	CMP	AX,2000			;Above the upper limit?
	JBE	Size_Ok
	MOV	AX,2000
Size_Ok:
	MOV	num_files,AX
No_Digits:
	MOV	AX,3513H		;Get BIOS disk I/O vector
	INT	21H
	MOV	WORD PTR [oldint13]  ,BX
	MOV	WORD PTR [oldint13+2],ES
	MOV	DX, OFFSET NewInt13
	MOV	AX, 2513H		;reset Int 13H vector
	INT	21H

	MOV	AX,3521H		;Get int 21H vector
	INT	21H
	MOV	WORD PTR [oldint21]  ,BX	;save it
	MOV	WORD PTR [oldint21+2],ES
	MOV	DX, OFFSET NewInt21
	MOV	AX, 2521H		;reset Int 21H vector
	INT	21H

;-----------------------------------------------------------------------
; Deallocate our copy of the environment.
; Exit using INT 27H. Leave code and space for the tables resident.
;-----------------------------------------------------------------------

	CALL	Reset_Table		;Clear out the file table
	MOV	AX,DS:[002CH]		;Get segment of environment
	MOV	ES,AX			;Put it into ES
	MOV	AH,49H			;Release environment segment
	INT	21H

	MOV	AX,num_files		;Get number of files
	MOV	BX,ENTRY_SIZE		;Times size of each entry
	MUL	BX
	ADD	AX,FILE_TABLE		;Add in beginning of table
	MOV	file_table_end,AX
	ADD	AX,15
	MOV	CL,4
	SHR	AX,CL
	MOV	DX,AX			;Leave this much resident
	MOV	AX,3100H
	INT	21H			;Terminate and stay resident

;-----------------------------------------------------------------------
; Here is the code used to initialize RECORDER.COM.  First determine
; if RECORDER is already installed.
;-----------------------------------------------------------------------
	ASSUME	CS:CSEG, DS:CSEG, ES:Cseg

	EVEN			;Align to an even byte boundry

;TH some data is ONLY used to display the table results.
;No use having that stuff taking up room in the resident code.

;--to help count spaces-012345678901234567890123456789012345678901-----
header		DB	'   File Name  Total   Read  Write   EXEC$'

Initialize	proc	near
	ASSUME	DS:CSEG, ES:CSeg
	MOV	DX,OFFSET COPYRIGHT
	CALL	String_CrLf		;Display the string

; Search for a previously installed copy of RECORDER

	NOT	WORD PTR Start		;Modify to avoid false match
	XOR	BX,BX			;Start search at segment zero
	MOV	AX,CS			;Compare to this code segment
Next_Segment:
	INC	BX			;Look at next segment
	CMP	AX,BX			;Until reaching this segment
	MOV	ES,BX
	ASSUME	ES:Nothing

	JNE	Not_Found
	 JMP	Install

Not_Found:
	MOV	SI,OFFSET Start		;Setup to compare strings
	MOV	DI,SI
	MOV	CX,16			;16 bytes must match
	REP	CMPSB			;Compare DS:SI to ES:DI
	OR	CX,CX
	JNZ	Next_Segment		;If no match, try next segment

; When all 16 bytes match, an installed copy already exists and
; ES points to resident code segment. Display the file table

;TH display our header BEFORE losing DS
	CALL	New_Line
	MOV	DX,OFFSET header	;Point to header text
	CALL	String_CrLf		;Display the string

	mov	ax,ES			;TH
	mov	DS,ax			;TH point DS to resident file table

	MOV	DI,FILE_TABLE+11	;TH Point to the table +11
	MOV	CX,num_files		;Number of entries in table
	mov	bx,cx			;TH save a sec
	mov	dx,ENTRY_SIZE		;TH constant for adding
	xor	ax,ax			;TH 0 for stuffing
Zero_Loop:
	MOV	[DI],al			;TH Zero the displayed byte
	ADD	DI,dx			;TH Move to next entry
	LOOP	Zero_Loop		;Do entire table

	MOV	CX,bx			;TH Number of entries in table
File_Loop:
	PUSH	CX
	MOV	DI,FILE_TABLE		;Point to the table
	XOR	AX,AX
	MOV	CX,num_files		;TH Number of entries in table
	mov	dx,ENTRY_SIZE		;TH constant for adding
Find_Biggest:
	CMP	[DI+12],AX
	JBE	Not_Bigger
	 CMP	BYTE PTR [DI+11],0
	 JNE	Not_Bigger
	  MOV	SI,DI
	  MOV	AX,[DI+12]
Not_Bigger:
	ADD	DI,dx			;TH ENTRY_SIZE
	LOOP	Find_Biggest

	CMP	BYTE PTR [SI+11],1
	JE	Last_One
	MOV	BYTE PTR [SI+11],1
	MOV	DX,SI
	ADD	SI,12
	CMP	WORD PTR [SI],0
	JZ	Last_One
	MOV	AH,40H
	MOV	BX,1
	MOV	CX,8			;8 letters in name
	INT	21H
	PUSH	DX
	MOV	DL,'.'			;TH Display a dot
	MOV	AH,02			;TH char output
	INT	21H

	POP	DX
	ADD	DX,8			;Now point to extension
	MOV	AH,40H
	MOV	CX,3			;3 letters in extension
	INT	21H

	LODSW
	PUSH	AX			;Save the total
	CALL	Number_Out		;Display the totals column
	LODSW
	CALL	Number_Out
	LODSW
	CALL	Number_Out
	LODSW
	CALL	Number_Out
	CALL	New_Line
	POP	AX			;Recover the total count
	POP	CX
	LOOP	File_Loop
	CMP	AX,2			;Was the last total less than 2?
	JB	Last_One		;If yes, table is not full yet.
	 CALL	New_Line
	 MOV	DX,OFFSET full_mess
	 CALL	String_CrLf		;Display the string
Last_One:
	CALL	Load_Params
	JCXZ	No_Params
	mov	ah,'r'			;TH constant for testing
	mov	dl,32			;TH constant for ORing
Scan_Params:
	MOV	AL,CS:[SI]
	OR	AL,dl			;TH 32	;Convert it to lower case
	CMP	AL,ah			;TH 'r'	;Is it the R parameter?
	JE	Slash_R			;If yes, then reset the table
	INC	SI
	LOOP	Scan_Params		;Look at all parameters
No_Params:
	MOV	AX,4C00H		;terminate, ERRORLEVEL 0
	INT	21H
Slash_R:
	CALL	Reset_Table
	JMP	No_Params
Initialize	endp

;-----------------------------------------------------------------------
; Number_Out Outputs the number in AX to the standard output device
;-----------------------------------------------------------------------
Number_Out	PROC	NEAR
	mov	bx,ax			;TH Save the number
	MOV	DL,' '			;TH Send a space
	MOV	AH,02			;TH display char
	INT	21H

	MOV	DL,' '			;TH Send another space
	MOV	AH,02			;TH display char
	INT	21H
	mov	ax,bx			;TH restore the number
	XOR	CX,CX			;Indicates no digit yet

	MOV	BX,10000		;Get 10000's digit
	CALL	Divide_Out		;Display it
	MOV	BX,1000			;Get 1000's digit
	CALL	Divide_Out		;Display it
	MOV	BX,100			;Get 100's digit
	CALL	Divide_Out		;Display it
	MOV	BX,10			;Get 10's digit
	CALL	Divide_Out		;Display it

	ADD	AL,30H			;Get 1's digit
	jmp	short Display_Char	;TH display last char,
					;return from there
Number_Out	ENDP

;-----------------------------------------------------------------------
; This divides AX by BX and displays the result. Remainder is in AX.
;-----------------------------------------------------------------------
Divide_Out	PROC	NEAR
	XOR	DX,DX
	DIV	BX			;Divide to get this digit
	mov	bx,dx			;TH save the remainder
	OR	CX,AX
	OR	CX,CX			;Any digits yet?
	JNZ	Not_A_Space
	 MOV	AL,' '-30H
Not_A_Space:
	ADD	AL,30H			;Convert it to ASCII
	CALL	Display_Char		;Write the character
	mov	ax,bx			;TH get the remainder back
	RET
Divide_Out	ENDP

;-----------------------------------------------------------------------
; Display_Char outputs the character in AL to the standard output device
;-----------------------------------------------------------------------
Display_Char	PROC	NEAR
	MOV	DL,AL			;Get the character into DL
	MOV	AH,02			;TH display char
	INT	21H
	RET
Display_Char	ENDP

;-----------------------------------------------------------------------
; STRING_CR displays a string followed by a CR and LF
; Entry point New_Line displays only the CR and LF
;-----------------------------------------------------------------------
String_CrLf	PROC	NEAR
	MOV	AH,9			;Display string function
	INT	21H
New_Line:
	MOV	DL,13			;The carriage return
	MOV	AH,02			;TH display char
	INT	21H
	MOV	DL,10			;The line feed
	MOV	AH,02			;TH display char
	INT	21H
	RET
String_CrLf	ENDP

;-----------------------------------------------------------------------
; This subroutine sets DI to the command line and CX to the byte count
;-----------------------------------------------------------------------
Load_Params	PROC	NEAR
	MOV	SI,80H			;Point to parameter area
	MOV	CL,CS:[SI]		;Get number of chars into CL
	XOR	CH,CH			;Make it a word
	INC	SI			;Point to first character
	CLD				;String searchs forward
	RET
Load_Params	ENDP

CSEG	ENDS
	END	Start
