/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.GUIPrefs;
import com.izforge.izpack.Info;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.gui.IzPackMetalTheme;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;
import java.util.TreeMap;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLBuilder;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;

public class Installer {
    private LocaleDatabase langpack;
    private InstallData installdata;

    private void loadXMLData(File file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        StdXMLParser stdXMLParser = new StdXMLParser();
        stdXMLParser.setBuilder(new StdXMLBuilder());
        stdXMLParser.setReader(new StdXMLReader(fileInputStream));
        stdXMLParser.setValidator(new NonValidator());
        this.installdata.xmlData = (XMLElement)stdXMLParser.parse();
        fileInputStream.close();
    }

    private void loadLangPack() throws Exception {
        String string;
        Object object;
        ArrayList arrayList = this.getAvailableLangPacks();
        int n = arrayList.size();
        if (n == 0) {
            throw new Exception("no language pack available");
        }
        if (n != 1) {
            Installer installer = this;
            if (installer == null) {
                throw null;
            }
            object = installer.new LanguageDialog(arrayList.toArray());
            ((LanguageDialog)object).setSelection(Locale.getDefault().getISO3Country().toLowerCase());
            ((Dialog)object).setModal(true);
            ((Dialog)object).show();
            string = (String)((LanguageDialog)object).getSelection();
            if (string == null) {
                throw new Exception("installation canceled");
            }
        } else {
            string = (String)arrayList.get(0);
        }
        this.installdata.xmlData.setAttribute("langpack", string);
        this.installdata.localeISO3 = string;
        object = this.getClass().getResourceAsStream("/langpacks/" + string + ".xml");
        this.langpack = new LocaleDatabase((InputStream)object);
    }

    private ArrayList getAvailableLangPacks() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        InputStream inputStream = this.getClass().getResourceAsStream("/langpacks");
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(dataInputStream.readUTF());
            ++n2;
        }
        dataInputStream.close();
        return arrayList;
    }

    private void loadInstallData() throws Exception {
        InputStream inputStream = this.getClass().getResourceAsStream("/info");
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Info info = (Info)objectInputStream.readObject();
        objectInputStream.close();
        inputStream = this.getClass().getResourceAsStream("/GUIPrefs");
        objectInputStream = new ObjectInputStream(inputStream);
        GUIPrefs gUIPrefs = (GUIPrefs)objectInputStream.readObject();
        objectInputStream.close();
        inputStream = this.getClass().getResourceAsStream("/panelsOrder");
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(dataInputStream.readUTF());
            ++n2;
        }
        dataInputStream.close();
        inputStream = this.getClass().getResourceAsStream("/packs");
        objectInputStream = new ObjectInputStream(inputStream);
        n = objectInputStream.readInt();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        n2 = 0;
        while (n2 < n) {
            arrayList2.add(objectInputStream.readObject());
            ++n2;
        }
        objectInputStream.close();
        String string = System.getProperty("os.name");
        String string2 = string.regionMatches(true, 0, "windows", 0, 7) ? System.getProperty("user.home").substring(0, 3) + "Program Files" + File.separator : (string.regionMatches(true, 0, "macosx", 0, 6) ? "/Applications" + File.separator : (string.regionMatches(true, 0, "mac", 0, 3) ? "" : "/usr/local" + File.separator));
        String string3 = string2 + info.getAppName();
        inputStream = this.getClass().getResourceAsStream("/kind");
        dataInputStream = new DataInputStream(inputStream);
        String string4 = dataInputStream.readUTF();
        dataInputStream.close();
        this.installdata = new InstallData();
        this.installdata.installPath = string3;
        this.installdata.guiPrefs = gUIPrefs;
        this.installdata.info = info;
        this.installdata.kind = string4;
        this.installdata.panelsOrder = arrayList;
        this.installdata.availablePacks = arrayList2;
        this.installdata.selectedPacks = (ArrayList)arrayList2.clone();
    }

    private void loadLookAndFeel() throws Exception {
        if (this.installdata.kind.equalsIgnoreCase("standard") || this.installdata.kind.equalsIgnoreCase("web")) {
            MetalLookAndFeel.setCurrentTheme(new IzPackMetalTheme());
        } else if (this.installdata.kind.equalsIgnoreCase("standard-kunststoff") || this.installdata.kind.equalsIgnoreCase("web-kunststoff")) {
            this.installdata.buttonsHColor = new Color(255, 255, 255);
            Class<?> clazz = Class.forName("com.incors.plaf.kunststoff.KunststoffLookAndFeel");
            Class<?> clazz2 = Class.forName("javax.swing.plaf.metal.MetalTheme");
            Class[] classArray = new Class[]{clazz2};
            Class<?> clazz3 = Class.forName("com.izforge.izpack.gui.IzPackKMetalTheme");
            Method method = clazz.getMethod("setCurrentTheme", classArray);
            LookAndFeel lookAndFeel = (LookAndFeel)clazz.newInstance();
            MetalTheme metalTheme = (MetalTheme)clazz3.newInstance();
            Object[] objectArray = new Object[]{metalTheme};
            UIManager.setLookAndFeel(lookAndFeel);
            method.invoke((Object)lookAndFeel, objectArray);
        }
    }

    private void loadGUI() throws Exception {
        UIManager.put("OptionPane.yesButtonText", this.langpack.getString("installer.yes"));
        UIManager.put("OptionPane.noButtonText", this.langpack.getString("installer.no"));
        UIManager.put("OptionPane.cancelButtonText", this.langpack.getString("installer.cancel"));
        String string = this.langpack.getString("installer.title") + this.installdata.info.getAppName();
        InstallerFrame installerFrame = new InstallerFrame(string, this.langpack, this.installdata);
    }

    public static void main(String[] stringArray) {
        try {
            System.setErr(new PrintStream(new MyOutputStream()));
            int n = stringArray.length;
            if (n == 0) {
                Installer installer = new Installer();
            } else {
                Installer installer = new Installer(new File(stringArray[0]));
            }
        }
        catch (Exception exception) {
            System.err.println("- Error -");
            System.err.println(exception.toString());
            System.exit(0);
        }
    }

    public Installer() throws Exception {
        this.loadInstallData();
        this.loadLookAndFeel();
        this.loadLangPack();
        this.loadGUI();
    }

    public Installer(File file) throws Exception {
        this.loadInstallData();
        this.loadXMLData(file);
        this.installdata.localeISO3 = this.installdata.xmlData.getAttribute("langpack");
        InputStream inputStream = this.getClass().getResourceAsStream("/langpacks/" + this.installdata.localeISO3 + ".xml");
        this.langpack = new LocaleDatabase(inputStream);
        InstallerFrame installerFrame = new InstallerFrame(this.langpack, this.installdata);
    }

    private static class MyOutputStream
    extends OutputStream {
        public void write(byte[] byArray, int n, int n2) {
        }

        public void write(int n) {
        }

        MyOutputStream() {
        }
    }

    class LanguageDialog
    extends JDialog
    implements ActionListener {
        private JComboBox comboBox;
        private JButton okButton;

        public Object getSelection() {
            return this.comboBox.getSelectedItem();
        }

        public void setSelection(Object object) {
            this.comboBox.setSelectedItem(object);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.dispose();
        }

        public LanguageDialog(Object[] objectArray) {
            JPanel jPanel = (JPanel)this.getContentPane();
            this.setTitle("Language selection");
            GridBagLayout gridBagLayout = new GridBagLayout();
            jPanel.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            JLabel jLabel = new JLabel("Please select your language (ISO3 code)", 0);
            JLabel jLabel2 = new JLabel("for install instructions:", 0);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)jLabel, "North");
            jPanel2.add((Component)jLabel2, "South");
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagLayout.addLayoutComponent(jPanel2, gridBagConstraints);
            jPanel.add(jPanel2);
            this.comboBox = new JComboBox<Object>(objectArray);
            Installer installer2 = Installer.this;
            if (installer2 == null) {
                throw null;
            }
            this.comboBox.setRenderer(installer2.new FlagRenderer());
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 1;
            gridBagLayout.addLayoutComponent(this.comboBox, gridBagConstraints);
            jPanel.add(this.comboBox);
            this.okButton = new JButton("Ok");
            this.okButton.addActionListener(this);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 10;
            gridBagLayout.addLayoutComponent(this.okButton, gridBagConstraints);
            jPanel.add(this.okButton);
            this.pack();
            Dimension dimension = this.getSize();
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)this).setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2 - 10);
            this.setResizable(true);
        }
    }

    class FlagRenderer
    extends JLabel
    implements ListCellRenderer {
        private TreeMap icons = new TreeMap();
        private TreeMap grayIcons = new TreeMap();

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (n == -1) {
                bl = true;
            }
            String string = (String)object;
            this.setText(string);
            if (bl) {
                this.setOpaque(true);
                this.setForeground(jList.getSelectionForeground());
                this.setBackground(jList.getSelectionBackground());
            } else {
                this.setOpaque(false);
            }
            if (!this.icons.containsKey(string)) {
                ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/res/flag." + string));
                this.icons.put(string, imageIcon);
                this.grayIcons.put(string, new ImageIcon(GrayFilter.createDisabledImage(imageIcon.getImage())));
            }
            if (bl) {
                this.setIcon((ImageIcon)this.icons.get(string));
            } else {
                this.setIcon((ImageIcon)this.grayIcons.get(string));
            }
            return this;
        }

        FlagRenderer() {
        }
    }
}

