


SHAR(1)             UNIX Programmer's Manual              SHAR(1)



NAME
     shar - create shell archive file for extraction by /bin/sh

SYNOPSIS
     shar [ -b ] [ -nseq_number ] [ -eseq_end ] [ -ooutput_file ]
     [ -tfinal_text ] files

DESCRIPTION
     Shar takes a list of files, and generates a /bin/sh script
     that, when executed, will re-create those files in a dif-
     ferent directory or on a different machine.  The resultant
     script will use wc(1) to do a mild error-check, and will
     warn about possibly-omitted control characters.

     Shar generates scripts that will make directories and plain
     files.  It will not try to generate intermediate filenames,
     however, so
          shar foo/bar/file
     will not work.  Do
          shar foo foo/bar foo/bar/file
     instead.

     The script is normally sent to standard output; the ``-o''
     option may be used to specify an output filename.  This is
     designed to prevent filling up the disk if
          shar * >SHAR
     command is done; do
          shar -o SHAR *
     instead.

     The ``-b'' option says that all leading directory names
     should be stripped from the file when they are packed into
     the archive.  For example,
          shar -b /etc/termcap
     creates an archive that, when executed, creates a file named
     ``termcap'' in the current directory, rather than overwrite
     the host system file.  Note, however, that the scripts gen-
     erated by shar refuse to overwrite pre-existing files; the
     ``-b'' option is for convenience, and may not strictly be
     necessary.

     Multi-part Archives
     Most larger software packages are usually sent out in two or
     more shell archives.  The ``-n,'' ``-e,'' and ``-t'' options
     are used to make an archive that is part of a series.  The
     individual archives are often called ``kits'' when this is
     done.  The ``-n'' option specifies the archive number; the
     ``-e'' option species the highest number in the series.
     When executed, the generated archives will then echo mes-
     sages like
          shar: End of archive 3 of 9.
     at their end.



Printed 2/21/88               LOCAL                             1






SHAR(1)             UNIX Programmer's Manual              SHAR(1)



     In addition, each shar will generate a file named
     arkXisdone.  Each script will contain a loop to check for
     the presence of these files, and indicate to the recipient
     which archives still need to be executed.  The ``-t'' option
     may be used to give starting instructions to the recipient.
     When the scripts determine that all the archives have been
     unpacked, the text specified with this flag is displayed.
     For example,
          shar -n1 -k9 -t "Now do 'sh ./Configure'" *.c >SHAR
     Adds commands to output the following when all the archives
     have been unpacked:
          You have run archive 1.
              .
              .
              .
          You have run archive 9.
          You have run all 9 archives.
          Now do 'sh ./Configure'

SEE ALSO
     echo(1), findsrc(1L), makekit(1L), mkdir(1), sh(1), test(1),
     unshar(1L), wc(1).

































Printed 2/21/88               LOCAL                             2



