/*
   letters.c - Letter handling for extended ASCII.

   Jason Hood, 19 November, 2002.

   The standard ctype functions will not recognise extended ASCII, but the LFN
   functions will. Create a set of tables to correctly handle case conversions.

   LFN will convert lowercase letters that have no uppercase equivalent to
   an underscore in the DOS name; these routines will leave it as is. This
   means that creating a file with an '' when in LFN, will NOT match a
   pattern containing an '' when in DOS.
*/


#include "letters.h"


// These tables are for CP437.

char _upper_char[256] = 	// Lower to Upper
{
  '\x00', '\x01', '\x02', '\x03', '\x04', '\x05', '\x06', '\x07',
  '\x08', '\x09', '\x0a', '\x0b', '\x0c', '\x0d', '\x0e', '\x0f',
  '\x10', '\x11', '\x12', '\x13', '\x14', '\x15', '\x16', '\x17',
  '\x18', '\x19', '\x1a', '\x1b', '\x1c', '\x1d', '\x1e', '\x1f',

  ' ','!','"','#', '$','%','&','\'', '(',')','*','+', ',','-','.','/',
  '0','1','2','3', '4','5','6','7',  '8','9',':',';', '<','=','>','?',
  '@','A','B','C', 'D','E','F','G',  'H','I','J','K', 'L','M','N','O',
  'P','Q','R','S', 'T','U','V','W',  'X','Y','Z','[','\\',']','^','_',
  '`','A','B','C', 'D','E','F','G',  'H','I','J','K', 'L','M','N','O',
  'P','Q','R','S', 'T','U','V','W',  'X','Y','Z','{', '|','}','~','',

  '','','','', '','','','',  '','','','', '','','','',
  '','','','', '','','','',  '','','','', '','','','',
  '','','','', '','','','',  '','','','', '','','','',
  '','','','', '','','','',  '','','','', '','','','',
  '','','','', '','','','',  '','','','', '','','','',
  '','','','', '','','','',  '','','','', '','','','',
  '','','','', '','','','',  '','','','', '','','','',
  '','','','', '','','','',  '','','','', '','','','',
};


char _lower_char[256] = 	// Upper to Lower
{
  '\x00', '\x01', '\x02', '\x03', '\x04', '\x05', '\x06', '\x07',
  '\x08', '\x09', '\x0a', '\x0b', '\x0c', '\x0d', '\x0e', '\x0f',
  '\x10', '\x11', '\x12', '\x13', '\x14', '\x15', '\x16', '\x17',
  '\x18', '\x19', '\x1a', '\x1b', '\x1c', '\x1d', '\x1e', '\x1f',

  ' ','!','"','#', '$','%','&','\'', '(',')','*','+', ',','-','.','/',
  '0','1','2','3', '4','5','6','7',  '8','9',':',';', '<','=','>','?',
  '@','a','b','c', 'd','e','f','g',  'h','i','j','k', 'l','m','n','o',
  'p','q','r','s', 't','u','v','w',  'x','y','z','[','\\',']','^','_',
  '`','a','b','c', 'd','e','f','g',  'h','i','j','k', 'l','m','n','o',
  'p','q','r','s', 't','u','v','w',  'x','y','z','{', '|','}','~','',

  '','','','', '','','','',  '','','','', '','','','',
  '','','','', '','','','',  '','','','', '','','','',
  '','','','', '','','','',  '','','','', '','','','',
  '','','','', '','','','',  '','','','', '','','','',
  '','','','', '','','','',  '','','','', '','','','',
  '','','','', '','','','',  '','','','', '','','','',
  '','','','', '','','','',  '','','','', '','','','',
  '','','','', '','','','',  '','','','', '','','','',
};


char* strupper( char* string )
{
  char* p;

  for (p = string; *p; ++p)
    *p = upper( *p );

  return string;
}


char* strlower( char* string )
{
  char* p;

  for (p = string; *p; ++p)
    *p = lower( *p );

  return string;
}


int strcomp( const char* str1, const char* str2 )
{
  int rc;

  while ((rc = upper( *str1 ) - upper( *str2 )) == 0 && *str1++)
    ++str2;

  return rc;
}
