{These are the routines to run the mini-editor}

PROCEDURE mini_ed; {restart:BOOLEAN}
(*****************************************************************************
input message text directly
-> note: lots of sub-subprocedures!
******************************************************************************)
CONST
    Ins_Mode : BOOLEAN = TRUE;          {editor mode: TRUE=Insert, FALSE=Overwrite}
    Tab_Col = 15;                       {tab column}
    Ln_Pg = 20;                         {maximum lines/pg in mini-editor}
VAR
    c             : CHAR;               {input character}
    done,anyc     : BOOLEAN;            {flow control}
    ln,cc,top_ln  : INTEGER;            {current line#, Col#, top screen line}
    tmpstr        : STRING;             {temp string}
    delstr,spaces : STRING[Max_Tty_Width]; {deleted, and blank line}
    i,j,k,err     : INTEGER;            {flow control}
    end_mfr_ln,msi,end_ed_msg : INTEGER;{count of last MFR line}
    ed_text : ARRAY [1..Max_Ed_Lines] OF STRING[Max_Tty_Width]; {editor buffer}
    last_ln : INTEGER;                  {what is last non-blank line of buffer}

{sub-subprocedures for the mini-editor}
(****************************************************)
PROCEDURE mini_editor;                  FORWARD;
PROCEDURE inp_ctrl;                     FORWARD;
PROCEDURE inp_extchr;                   FORWARD;
PROCEDURE inp_char;                     FORWARD;
PROCEDURE dr_frame;                     FORWARD;
PROCEDURE dr_page;                      FORWARD;
PROCEDURE dr_loc;                       FORWARD;
FUNCTION wrapper : BYTE;                FORWARD;
PROCEDURE ed_help;                      FORWARD;

{$i ed_file.pas}                        {file actions}
{$i ed_procs.pas}                       {char insert/del procedures}
{$i ed_curse.pas}                       {cursor movements}

PROCEDURE mini_editor;
(*****************************************************************************
input and edit message text
******************************************************************************)
BEGIN
    dr_loc;                             {mark cursor location}
    done:=FALSE;
    WHILE NOT done DO BEGIN
        c:=ReadKey;                     {get a keystroke}
        IF c <> #0 THEN
            IF ORD(c)<32 THEN
                inp_ctrl                {control keys}
            ELSE
                inp_char                {standard input}
            {end}
        ELSE BEGIN
            c:=ReadKey;                 {function keys}
            inp_extchr
        END;
        dr_loc                          {mark cursor location}
    END
END; {PROCEDURE mini_editor}

PROCEDURE inp_ctrl;
(*****************************************************************************
process control char
******************************************************************************)
var temp,i:INTEGER;
BEGIN
    CASE c OF                           {control & ASCII keys}
    ^M : ed_ent;                        {<ret> or <ent>}
    ^N : ed_insln;                      {insert blank line}
    ^I : ed_tab;                        {tab}
    ^H : ed_bs;                         {destructive backspace}
    ^U : ed_recall;                     {recall line}
    ^Y : ed_delln;                      {delete line}
    ^G : ed_del;                        {delete char}
    ^V : ed_ins;                        {insert mode toggle}
    ^E : ed_up;                         {cursor up}
    ^X : ed_down;                       {cursor down}
    ^S : ed_left;                       {cursor left}
    ^D : ed_right;                      {cursor right}
    ^F : ed_fwdwd;                      {forward a word}
    ^A : ed_bckwd;                      {back a word}
    ^R : ed_pgup;                       {page up}
    ^C : ed_pgdn;                       {page down}
    ^K : BEGIN                          {file ops}
             GOTOXY(30,1);
             WRITE('^K');
             c:=ReadKey;                {get a keystroke}
             CASE c OF
             'W','w',^W : savefile;     {write to file}
             'D','d',^D : done:=TRUE;   {save and exit}
             'R','r',^R : BEGIN
                              readfile(TRUE);    {request and read file}
                              dr_frame; dr_page  {redraw screen}
                          END;
             'Q','q',^Q : BEGIN
                              ed_abort; {quit - abort?}
                              dr_frame; dr_page;
                          END
             END; {case}
             GOTOXY(30,1);
             WRITE('  ');
         END;
    ^Q : BEGIN                          {quick ops}
             GOTOXY(30,1);
             WRITE('^Q');
             c:=ReadKey;                {get a keystroke}
             CASE c OF
             'R','r',^R : ed_tof;       {top of file}
             'C','c',^C : ed_eof;       {end of file}
             'E','e',^E : ed_home;      {top of screen}
             'X','x',^X : ed_end;       {end of screen}
             'D','d',^D : ed_eol;       {end of line}
             'S','s',^S : ed_bol;       {beginning of line}
             'F','f',^F : ed_find;      {find}
             'Y','y',^Y : ed_deleol;    {delete to eol}
             END; {case}
             GOTOXY(30,1);
             WRITE('  ');
         END;
    ^W : ed_scrldown;                   {scroll down}
    ^Z : ed_scrlup;                     {scroll up}
    ELSE
        beep;                           {undefined control char}
    END {case - ASCII chars}
END; {PROCEDURE inp_ctrl}

PROCEDURE inp_extchr;
(*****************************************************************************
extended editing chars
******************************************************************************)
VAR i:integer;
BEGIN
    CASE ORD(c) OF
    44 : ed_zap;                        {alt-Z - zap (clear) msg text}
    45 : BEGIN                          {alt-X - abort}
            ed_abort;
            dr_frame; dr_page;
         END;
    59 : ed_help;                       {F1-Editor Help}
{   60 :                                {F2-not used}
{   61 :                                {F3-not used}
{   62 :                                {F4-not used}
    63 : Savefile;                      {F5-save (write) file}
    64 : BEGIN
            readfile(TRUE);             {F6-request and read (insert) file}
            dr_frame; dr_page           {redraw screen}
         END;
    65 : ed_delln;                      {F7-delete line}
    66 : ed_insln;                      {F8-insert blank line}
    67 : ed_recall;                     {F9-recall deleted line}
    68 : done:=TRUE;                    {F10-done editing}
    71 : ed_home;                       {home}
    72 : ed_up;                         {up arrow}
    73 : ed_pgup;                       {pg Up}
    75 : ed_left;                       {left arrow}
    77 : ed_right;                      {right arrow}
    79 : ed_end;                        {end}
    80 : ed_down;                       {down arrow}
    81 : ed_pgdn;                       {Pg Down}
    82 : ed_ins;                        {insert}
    83 : ed_del;                        {del}
   115 : ed_bol;                        {ctrl-left arrow}
   116 : ed_eol;                        {ctrl-right arrow}
   117 : ed_end;                        {ctrl-end}
   118 : ed_eof;                        {ctrl-pgdn}
   119 : ed_tof;                        {ctrl-home}
   132 : ed_tof;                        {ctrl-Pgup}
    ELSE
         beep;                          {undefined extended character}
    END {case - extended chars}
END; {PROCEDURE inp_extchr}

PROCEDURE inp_char;
(*****************************************************************************
input one character (standard input)
******************************************************************************)
VAR i:INTEGER;
    pos:BYTE;
BEGIN
    c:=UpCase(c);     {force uppercase}
    IF Ins_Mode THEN BEGIN
        tmpstr:=copy(ed_text[ln],1,cc-1)+C+       {insert char into line}
            copy(ed_text[ln],cc,Max_Tty_Width);
        pos:=wrapper;                             {& wrap}
        IF pos>0 THEN BEGIN                       {it took two lines, so}
            IF cc>Max_Tty_Width-pos THEN BEGIN  {is cursor in wrap portion?}
                ln:=ln+1;                         {and put cursor in place}
                cc:=pos-(Max_Tty_Width-cc)-1;
                IF top_ln+Ln_Pg-1<ln THEN top_ln:=top_ln+1
            END;
            dr_page                               {redraw whole page}
        END ELSE BEGIN
            GOTOXY(2,3+ln-top_ln);                {redraw just this line}
            WRITE(ed_text[ln])
        END;
    END ELSE
        IF cc=Max_Tty_Width+1 THEN BEGIN
            tmpstr:=ed_text[ln]+C;                {tag the char on eol}
            pos:=wrapper;                         {& wrap}
            ln:=ln+1;
            cc:=pos-(Max_Tty_Width-cc)-1;       {and put cursor in place}
            IF top_ln+Ln_Pg-1<ln THEN top_ln:=top_ln+1;
            dr_page                               {redraw whole page}
        END ELSE BEGIN
            ed_text[ln][cc]:=c;                   {insert the character}
            WRITE(c)
        END;
    {end}
    ed_right;                                     {move cursor}
    IF last_ln<ln THEN last_ln:=ln;               {mark the last line}
END; {PROCEDURE inp_char}

PROCEDURE dr_frame;
(*****************************************************************************
displays editing screen
******************************************************************************)
VAR i:INTEGER;
BEGIN
    TextBackground(black); TextColor(Yellow); ClrScr;
    WRITE('TTY Print!  Mini Editor              ');
    TextColor(Cyan); WRITELN('Last Line:    Current Line:    Column:');
    TextColor(green);

    GOTOXY(1, 2); WRITE('Ŀ');
    FOR i:=3 TO 22 DO BEGIN
        GOTOXY( 1,i); WRITE('');
        GOTOXY(70,i); WRITE('');
    END;
    GOTOXY(1,23); WRITE('');

    GOTOXY(71, 3); TextColor(LightRed); WRITE('<F1> '); TextColor(Cyan); WRITE('for');
    GOTOXY(71, 4); WRITE('  Help');
    GOTOXY(71, 6); WRITE('Use Arrow');
    GOTOXY(71, 7); WRITE(' Keys to');
    GOTOXY(71, 8); WRITE('mov cursr');
    GOTOXY(71,10); TextColor(LightRed); WRITE('<INS>'); TextColor(Cyan); WRITE('Mode');
    GOTOXY(71,11); TextColor(LightRed); WRITE('<Tab>'); TextColor(Cyan); WRITE('Addr');
    GOTOXY(71,13); TextColor(LightRed); WRITE('<F5>'); TextColor(Cyan); WRITE('SavFn');
    GOTOXY(71,14); TextColor(LightRed); WRITE('<F6>'); TextColor(Cyan); WRITE('ReadF');
    GOTOXY(71,15); TextColor(LightRed); WRITE('<F7>'); TextColor(Cyan); WRITE('DelLn');
    GOTOXY(71,16); TextColor(LightRed); WRITE('<F8>'); TextColor(Cyan); WRITE('InsLn');
    GOTOXY(71,18); TextColor(LightRed); WRITE(' <Alt-X>');
    GOTOXY(71,19); TextColor(Cyan); WRITE(' to quit');
    GOTOXY(71,21); TextColor(LightRed);WRITE(' <F10> '); TextColor(Cyan); WRITE('to');
    GOTOXY(71,22); WRITE('Save/Exit');

    GOTOXY( 5,24); WRITE('Mode:');
    GOTOXY(11,24); TextColor(LightGray); TextBackGround(Blue);
    IF Ins_Mode THEN
        WRITE('Insert   ')
    ELSE
        WRITE('Overwrite');
END; {PROCEDURE dr_frame}

PROCEDURE dr_page;
(*****************************************************************************
fills in editing screen with lines to be edited
******************************************************************************)
VAR i:INTEGER;
BEGIN
    TextColor(LightGray); TextBackGround(Blue);
    FOR i:=1 TO Ln_Pg DO BEGIN
        GOTOXY(2,2+i);
        WRITE(ed_text[top_ln-1+i])
    END;
END; {PROCEDURE dr_page}

PROCEDURE dr_loc;
(*****************************************************************************
marks location of cursor on editing screen
******************************************************************************)
BEGIN
    TextColor(LightGray); TextBackGround(Blue);
    GOTOXY(48,1); WRITE(last_ln:3);
    GOTOXY(65,1); WRITE(ln:3);
    GOTOXY(78,1); WRITE(cc:2);
    GOTOXY(1+cc,3+ln-top_ln)
END; {PROCEDURE dr_loc}

FUNCTION wrapper; {: BYTE}
(*****************************************************************************
do an autowrap of the current line, if non-blank overflow insert to
next line.  Returns number of characters wrapped to second line
******************************************************************************)
VAR
    cln,non_sp,lst_sp,i,orgln:INTEGER;
    wrapstr:STRING[Max_Tty_Width];
    keychr:CHAR;     {first char of next line}
BEGIN
    orgln:=ln;              {store original line we started from}
    i:=length(tmpstr);
    WHILE (tmpstr[i]=' ') AND (i>Max_Tty_Width) DO i:=i-1;
    IF i<=Max_Tty_Width THEN BEGIN           {no added line is neccessary}
        ed_text[ln]:=COPY(tmpstr+spaces,1,Max_Tty_Width);
        wrapper:=0
    END ELSE BEGIN          {given input line requires two output lines}
        non_sp:=i;
        WHILE ((tmpstr[i]<>' ') OR (i>Max_Tty_Width)) AND (i>0) DO i:=i-1;
        IF i=0 THEN
            lst_sp:=Max_Tty_Width {no spaces in line, so break at last pos}
        ELSE
            lst_sp:=i;
        wrapstr:=COPY(tmpstr,lst_sp+1,non_sp-lst_sp);
        ed_text[ln]:=COPY(COPY(tmpstr,1,lst_sp)+spaces,1,Max_Tty_Width);
        keychr:=ed_text[ln+1][1];
        IF (keychr=' ') OR (keychr='!') OR                {if next line is blank}
            ((keychr>'1') AND (keychr<'9')) THEN BEGIN    {or starts a new paragraph}
            FOR i:=last_ln DOWNTO ln+1 DO  {bump every subsequent line down one}
                ed_text[i+1]:=ed_text[i];
            ed_text[ln+1]:=COPY(wrapstr+spaces,1,Max_Tty_Width); {overflow to next ln}
            last_ln:=last_ln+1;                {we added a line to msg}
        END ELSE BEGIN
            ln:=ln+1;                          {now on next line}
            tmpstr:=wrapstr+' '+ed_text[ln];   {add wrap string to next line}
            i:=wrapper;                        {recursive! throw away return value}
        END;
        ln:=orgln;                             {return value to original line}
        wrapper:=LENGTH(wrapstr);              {where cursor should be on next line}
    END
END; {FUNCTION wrapper : BYTE}

(************* main mini editor routine ***************)

BEGIN
    spaces:= '';                        {initialize to all spaces}
    FOR i:=1 TO Max_Tty_Width DO spaces:=spaces+' ';
    delstr:=spaces;                     {initialize delete line buffer}
    ln:=1; top_ln:=1;                   {setup}

    IF restart THEN BEGIN               {do this if restarting mini-ed}
        FOR i:=1 TO Tot_tty_lines DO    {copy message back into mini-ed buff}
            ed_text[i]:=COPY(tty[i]+spaces,1,Max_Tty_Width);
        IF tot_mfr_lines > 0 THEN BEGIN {any mfr?}
            tty[tot_tty_lines+1]:=COPY('!'+spaces,1,Max_Tty_Width);
            msi:=tot_tty_lines+2;
            FOR i:=1 TO Tot_mfr_lines DO BEGIN
                ed_text[msi]:=COPY(mfr[i]+spaces,1,Max_Tty_Width);
                msi:=msi+1
            END
        END;
        last_ln:=tot_tty_lines+1+tot_mfr_lines;
    END ELSE BEGIN                      {else do this first time only}
        FOR i:=1 TO Max_Ed_Lines DO ed_text[i]:=spaces;
        last_ln:=1;
        readfile(FALSE)                 {try to open and read autoload.msg file}
    END;
    dr_frame; dr_page;                  {draw screen}
    ed_tof;                             {start cursor at TOF}
    mini_editor;                        {call editor}
    savefile;                           {save file}
    msi:=1;
    i:=1;
    WHILE (ed_text[i][1] <> End_Mark) AND (i<=last_ln) DO BEGIN
        anyc:=FALSE;                    {copy ed_text to tty}
        FOR j:=1 TO Max_Tty_Width DO  {set flag if non-blank}
            IF ed_text[i][j] <> #32 THEN anyc:=TRUE;
        IF anyc THEN BEGIN
            tty[msi]:=ed_text[i];      {only copy non-blank lines}
            msi:=msi+1;
            IF msi>Max_TTY_Length THEN BEGIN
                TextBackGround(black); clrscr;
                beep; TextColor(LightMagenta+Blink);
                WRITELN('Message is longer than ',Max_Tty_Length,' lines.');
                TextColor(LightMagenta);
                WRITELN('i.e., Msg text in mini-editor exceeds ',Max_tty_Length/20:0,' TTY pages,');
                WRITELN;
                WRITELN('TTYPRT cannot handle a message that long.  Please split up and');
                WRITELN('send as two (or more) separate messages.');
                TextColor(Yellow);
                WRITELN;
                WRITELN('Strike any key to save file (if not done already)');
                WRITE('and then return to DOS ');
                c:=READKEY;
                savefile;
                halt
            END
        END;
        i:=i+1
    END;
    tot_tty_lines:=msi-1;                    {total lines in tty}

    msi:=1;                                  {init mfr line counter}
    IF ed_text[i][1] = End_Mark THEN BEGIN   {is there a mfr?}
        i:=i+1;                              {point to first line in mfr}
        WHILE (i <= last_ln) AND (msi>Max_MFR_Length) DO BEGIN
            mfr[msi]:=ed_text[i];
            msi:=msi+1;
            IF msi>Max_MFR_Length THEN BEGIN
                TextBackGround(black); clrscr;
                beep; TextColor(LightMagenta);
                WRITELN('MFR is longer than ',Max_MFR_Length,' lines.');
                WRITELN;
                WRITELN('TTYPRT cannot handle MFRs that long.');
                WRITELN('Additional text will be truncated.');
                TextColor(Yellow);
                WRITELN;
                WRITE('Strike any key to continue ');
                c:=READKEY
            END;
            i:=i+1
        END
    END;
    tot_mfr_lines:=msi-1;
END; {PROCEDURE mini_ed;}
