FUNCTION get_fn; {: BOOLEAN (c)}
(*****************************************************************************
gets a filename from user
******************************************************************************)
VAR
    i:INTEGER;
    temp:S35;
BEGIN
    TextBackGround(Blue); TextColor(LightGray);
    temp:=c;
    c:=READKEY;
    WHILE c<>^M DO BEGIN
        IF c=^H THEN BEGIN
            IF Length(temp) > 0 THEN BEGIN
                temp:=COPY(temp,1,LENGTH(temp)-1);
                WRITE(^H,' ',^H)
            END
        END ELSE BEGIN
            WRITE(c);
            temp:=temp+c
        END;
        c:=READKEY
    END;
    TextBackGround(Black); TextColor(Cyan); WRITELN;
    FOR i:=1 TO LENGTH(temp) DO temp[i]:=UpCase(temp[i]); {all uppercase}
    get_fn:=temp
END; {FUNCTION get_fn}

FUNCTION open_fn; {(fn:FILE_STR):BOOLEAN}
(*****************************************************************************
opens file given by argument, searches along path to do so; returns result
******************************************************************************)
VAR
    err:INTEGER;
    found:BOOLEAN;
    dospath,subdir:STRING[80];
    sigfn:S35;
    brk:INTEGER;
BEGIN
    found:=FALSE;
    ASSIGN(io_file,fn);                      {open file}
    {$I-} RESET(io_file); {$I+}
    err:=IORESULT;
    IF err = 0 THEN                          {was if successful?}
        found:=TRUE
    ELSE BEGIN                               {no, so look along path}
        dospath:=GetEnv('PATH');
        WHILE (err<>0) AND (LENGTH(dospath)>0) DO BEGIN
            brk:=POS(';',dospath);
            IF brk<>0 THEN BEGIN
               subdir:=COPY(dospath,1,brk-1);
               dospath:=COPY(dospath,brk+1,LENGTH(dospath))
            END ELSE BEGIN
               subdir:=dospath;
               dospath:=''
            END;
            IF (subdir[LENGTH(subdir)]=':') OR (subdir[LENGTH(subdir)]='\') THEN
               sigfn:=subdir+fn
            ELSE
               sigfn:=subdir+'\'+fn;
            ASSIGN(io_file,sigfn);                  {open sign block file}
            {$I-} RESET(io_file); {$I+}
            err:=IORESULT;
            IF err=0 THEN found:=TRUE
        END
    END;
    IF found THEN
        open_fn:=TRUE
    ELSE
        open_fn:=FALSE
    {end}
END; {FUNCTION open_ifn}

FUNCTION get_line;
(*****************************************************************************
reads a line of input from io_file, filters out garbage.
******************************************************************************)
VAR
    tmpstr:STRING;
    eol:BOOLEAN;
    cc:BYTE;
    c:CHAR;
BEGIN
    tmpstr:=''; eol:=FALSE;
    WHILE (NOT EOF(io_file)) AND (NOT eol) DO BEGIN
        READ(io_file,c);                     {get one character}
        WHILE ORD(c)=$1D DO BEGIN            {if $1D, it's the W* print header}
            READ(io_file,c);                 {discard chars till ending $1D}
            WHILE ORD(c) <> $1D DO READ(io_file,c);
            READ(io_file,c)                  {read next 'real' char}
        END;
        c:=CHR(ORD(c) AND 127);              {zero hi bit}
        c:=UpCase(c);                        {force uppercase}
        IF c < ' ' THEN BEGIN                {control char?}
            IF c=^M THEN eol:=TRUE           {return? discard all others!}
        END ELSE
            tmpstr:=tmpstr+c                 {add it on to string}
        {end}
    END;
    cc:=LENGTH(tmpstr);
    WHILE (tmpstr[cc]=' ') AND (cc>=1) DO cc:=cc-1;  {delete trailing <sp>'s}
    tmpstr[0]:=CHAR(cc);                     {adjust new length}
    get_line:=tmpstr                         {return w/line}
END;

PROCEDURE disp_dir;
(*****************************************************************************
shows a list of files in the current directory - 4 wide
******************************************************************************)
VAR DirInfo:SearchRec;
    i:INTEGER;
    dir:FILE_STR;
BEGIN
    GetDir(0,dir);
    TextBackground(Black); TextColor(LightCyan);
    WRITELN;
    WRITELN;
    WRITE('Directory of files in ');
    TextColor(lightGray); TextBackground(Blue); WRITE(dir);
    TextColor(lightCyan); TextBackground(Black); WRITELN(':');
    TextColor(Cyan);
    FindFirst('*.*',Archive,DirInfo);
    i:=1;
    WHILE DosError=0 DO BEGIN
        IF i<5 THEN BEGIN
            WRITE(COPY(DirInfo.name+'                 ',1,15));
            i:=i+1
        END ELSE BEGIN
            WRITELN(DirInfo.name);
            i:=1
        END;
        FINDNEXT(DirInfo)
    END;
    WRITELN
END; {PROCEDURE disp_dir}

PROCEDURE chg_dir;
(*****************************************************************************
changes current directory
******************************************************************************)
VAR
    dir,new_dir:FILE_STR;
    err:INTEGER;
    c:CHAR;
BEGIN
    GetDir(0,dir);
    TextBackground(Black); TextColor(LightCyan);
    WRITELN;
    WRITELN;
    WRITE('        Current directory is ',#26,' ');
    TextBackground(Blue); TextColor(LightGray); WRITE(dir);
    TextBackground(Black); TextColor(Yellow); WRITELN;
    WRITE(  'Enter directory to change to ',#26,' ');
    TextBackground(Blue); TextColor(LightGray);
    READLN(new_dir);
    TextBackground(Black); TextColor(Cyan); clreol;
    {$I-} ChDir(new_dir); {$I+}
    err:=IORESULT;
    IF err <> 0 THEN BEGIN
        TextColor(LightMagenta+Blink); WRITELN('That directory was not found!');
        beep; TextColor(Cyan);
    END;
    WRITELN
END; {PROCEDURE chg_dir}

PROCEDURE disp_msg;
(*****************************************************************************
displays text of message on screen, a page at a time
******************************************************************************)
VAR line_cnt,i:INTEGER;
    c:CHAR;
BEGIN
    TextBackGround(Black);
    cur_page:=1;
    WHILE cur_page<=tot_pages DO BEGIN
        Clrscr;
        TextColor(LightGreen);
        WRITELN('Page ',cur_page:2,' of ',tot_pages);
        WRITELN; TextColor(Cyan);
        line_cnt:=1;
        WHILE (line_cnt <= Max_Lines_Page) AND
             ((Max_Lines_Page * (cur_page-1)+line_cnt) <= Tot_tty_lines) DO BEGIN
             WRITELN(tty[Max_Lines_Page*(cur_page-1)+line_cnt]);
             line_cnt:=line_cnt+1
        END; {while}
        WRITELN;
        TextColor(Yellow);
        WRITE('Strike <esc> to return, any other key to continue ...');
        c:=READKEY;
        IF c=#27 THEN exit;
        cur_page:=cur_page+1;
    END; {while}
    IF tot_mfr_lines>0 THEN BEGIN
        Clrscr;
        TextColor(LightGreen);
        WRITELN('MFR:');
        WRITELN; TextColor(Cyan);
        FOR i:=1 TO tot_mfr_lines DO
            WRITELN(mfr[i]);
        WRITELN;
        TextColor(Yellow);
        WRITE('Strike any key to continue ...');
        c:=READKEY
    END
END; {PROCEDURE disp_msg}

PROCEDURE beep;
(*****************************************************************************
does just what it says!
******************************************************************************)
Begin
  sound(1000);
  delay(200);
  nosound
END; {PROCEDURE beep}

PROCEDURE help_msg; {(subj:S10)}
(*****************************************************************************
displays the help file on the argument subject
******************************************************************************)
VAR c:char;
   i:INTEGER;
   buff,tmp:STRING[80];
BEGIN
    TextBackGround(Black); clrscr;
    IF open_fn(hfn) THEN BEGIN
        tmp:=':'+subj;
        readln(io_file,buff);
        WHILE buff <> tmp DO readln(io_file,buff);     {find subject line}
        READLN(io_file,buff);                          {read header line}
        WHILE NOT EOF(io_file) AND (buff[1]<>':') DO BEGIN
            clrscr;
            TextColor(LightGreen); WRITELN(buff);  {help page title is highlighted}
            TextColor(Cyan);
            READLN(io_file,buff);
            i:=1;
            WHILE (i<23) AND (buff[1]<>':') DO BEGIN
                WRITELN(buff);
                READLN(io_file,buff);
                i:=i+1;
            END;
            GOTOXY(1,25); TextColor(Yellow);     {last line is highlighted}
            WRITE('Strike any key to continue ...');
            c:=READKEY; TextColor(Cyan); WRITELN;
            IF (c=#27) OR (buff[1]=':') THEN BEGIN
                clrscr;
                exit
            END;
            READLN(io_file,buff);                {read next header line}
        END
    END ELSE BEGIN
        TextColor(lightMagenta);
        WRITELN('Help file (',hfn,') not found.');
        WRITELN;
        TextColor(Cyan);
        WRITELN('Please refer to your documentation or the file TTYPRT3.DOC');
        WRITELN('for additional help.');
        WRITELN;
        TextColor(Yellow);                 {last line is highlighted}
        WRITE('Strike any key to continue ...');
        c:=READKEY; TextColor(Cyan)
    END;
    clrscr;
END; {PROCEDURE help_msg}

PROCEDURE load_font;
(*****************************************************************************
Copies external soft font file to LPT1 with appropriate control strings
Used in the HPLJ version only!
******************************************************************************)
VAR
    ans:STRING[30];  {answers to prompts}
    err:INTEGER;
    c:CHAR;
Begin
{$ifdef HPLJ}
    TextBackGround(Black); TextColor(LightGreen);
    clrscr;
    WRITELN('Softfont download to HP LaserJet or compatible printer');
    WRITELN; WRITELN; WRITELN; TextColor(cyan);
    WRITELN('(If unsure of the following questions - hit <enter> for defaults.)');
    WRITELN;
    TextColor(Yellow); WRITE('Enter OCR-A softfont filename or <enter> for ',ffn,' ',#26,' ');
    TextBackGround(Blue); TextColor(LightGray);
    READLN(ans); TextBackGround(Black);
    IF LENGTH(ans)>0 THEN ffn:=ans;
    WRITELN;
    TextColor(Yellow); WRITE('Enter softfont id number or <enter> for ',sfid:0,' ',#26,' ');
    TextBackGround(Blue); TextColor(LightGray);
    READLN(ans); TextBackGround(Black); TextColor(Cyan);
    IF LENGTH(ans)>0 THEN VAL(ans,sfid,err);
    IF sfid=0 THEN sfid:=1776;                {0 is not allowed, so reset}
    WRITELN;
    IF NOT open_fn(ffn) THEN BEGIN
        beep; TextColor(LightMagenta+Blink);
        WRITE('Font File not found, ');
    END ELSE BEGIN
        WRITE('Starting download, please wait ... ');
        WRITE(lst,#27,'E');                 {reset LaserJet}
        WRITE(lst,#27,'*c',sfid:0,'D');     {start softfont}
        WHILE NOT eof(io_file) DO BEGIN
            READ(io_file,c);
            WRITE(lst,c)
        END;
        WRITE(lst,#27,'*c5F');               {make it permament}
        CLOSE(io_file);
        WRITELN; WRITE('Soft font successfully downloaded, ');
    END;
    TextColor(Cyan);
    WRITELN('strike any key to continue ...');
    c:=READKEY
{$endif}
END; {PROCEDURE beep}
