\ This program maps the caps lock key to ctrl and right shift + caps lock
\   to caps lock.

\ This program is in the public domain

900 CONSTANT PSIZE \ make program load small in case of "LOADHI" command

100 MSDOS

INCLUDE INTS
INCLUDE FARMEM1

HEX
15  CONSTANT KBINT	\ keyboard interrupt vector number
4F  CONSTANT PROCESSKEY	\ code to process a key
3A  CONSTANT CAPSCODE	\ scan code for caps lock key
1D  CONSTANT CTRLCODE	\ scan code for ctrl key
80  CONSTANT RELEASE_INCREMENT

417 CONSTANT KB_FLAG1	\ keyboard flag location
1   CONSTANT RIGHT_SHIFT \ right shift key
2   CONSTANT LEFT_SHIFT

7E CONSTANT zero	\ A zero will go here
7D CONSTANT SAVECODE	\ was it a capslock or a ctrl??
80 CONSTANT newStart			\ target location of moved code
newStart CONSTANT newOriginalVector
HERE CONSTANT oldStart			\ source location of moved code
CREATE oldOriginalVector   4 ALLOT

80 4 + CONSTANT newProcessKey
L: processKey

	PROCESSKEY # AH CMP  =0 IF,  \ this is for us
		CAPSCODE # AL CMP =0 IF,  \ it is CAPS LOCK key
			ES PUSHSEG  CS: zero [] ES >SEG  \ load segment register
			RIGHT_SHIFT # ES: KB_FLAG1 [] BYTE TEST =0  IF,
				CTRLCODE # AL MOV  THEN,
			AL CS: SAVECODE [] MOV  ES POPSEG  STC
			CS: newOriginalVector JMPF
		THEN,
		CAPSCODE RELEASE_INCREMENT + # AL CMP =0 IF,  \ it is CAPS LOCK key release
			CS: SAVECODE [] AL MOV 
			RELEASE_INCREMENT # AL ADD  STC
			CS: newOriginalVector JMPF
		THEN,
	THEN,
	STC   CS: newOriginalVector JMPF
END-CODE

HERE oldStart - CONSTANT RESIDENTSIZE

0 0 IN/OUT
CODE tsr  ( terminate and stay resident )
	newStart RESIDENTSIZE + 10 /  1+ # DX MOV
	3100 # AX MOV
	21 INT
END-CODE
	
: MAIN  
	." CAPSLOCK -> CTRL,  RIGHTSHIFT + CAPSLOCK -> CAPSLOCK" CR
	." By Tom Almy" CR
	0 zero !
	KBINT get-handler  oldOriginalVector 2!
	oldStart newStart RESIDENTSIZE CMOVE	\ relocate code
	?CS: newProcessKey KBINT set-handler
	2C @ FREE	\ get rid of ENV block
	tsr
;

INCLUDE FARMEM2
INCLUDE FORTHLIB
END
