( ENSCREEN  PROGRAM, BY TOM ALMY.              21:33 08/14/85 )
\ THIS PROGRAM IS COPYRIGHT (C) 1985 BY TOM ALMY,
\ ALL RIGHTS RESERVED.
\  Users of ForthCMP are given permission to use or distribute this
\  program, as long as no charge is made and the credit message is maintained.



\ ALIGNDATA  I80186	\ For PC/AT, etc
100 MSDOS
8192 CONSTANT BUFSIZ	\ Use big buffers
SCONSTANT SDEFSTR 4TH"	\ Source Defaults to .4TH 
SCONSTANT DDEFSTR SCR"	\ Destination Defaults to .SCR 
INCLUDE VARS
INCLUDE FILTER

-1 CONSTANT TRUE  
0 CONSTANT FALSE
64 CONSTANT C/L
16 CONSTANT L/SCR

VARIABLE LINE#          \ line number on screen
VARIABLE NBLANKS        \ desirable number of blank lines
VARIABLE NEXTSCR?       \ Use --> at end of screens
VARIABLE TITLE?         \ Use first line to title all screens
VARIABLE TITLE  C/L ALLOT \ title for line
VARIABLE SKIPPER?       \ Skip first one or two screens
VARIABLE SMART?         \ Smart(?) packing of screens
VARIABLE ZERO-LINE?     \ set if last line was zero bytes

2 2 IN/OUT
: PAD-LINE ( addr len -- addr len' )
  \ pad a line to a multiple of 64 characters
  DUP 0= ZERO-LINE? !
  DUP C/L /  1+  C/L *  >R ( newlength )
  2DUP + R@ ROT - BL FILL ( padding )
  R> ( return new length ) ;


\ PROCESS INPUT LINE

VARIABLE LINEBUF  1024 ALLOT
VARIABLE LB2       128 ALLOT ( second line )
VARIABLE SPAN2
	VARIABLE WAS-SMART?

0 0 IN/OUT
: BE-SMART???  WAS-SMART? ON
  BEGIN
    SPAN @  ( current line length )
    LB2 128 EXPECT  ( get auxline )
    SPAN @ SPAN2 !  SPAN ! ( fix lengths )
    SPAN2 @ 0>  LB2 C@ BL = AND  ( continuing conditions )
     SPAN @ C/L / SPAN2 @ C/L / + 13 < AND  WHILE
    LINEBUF SPAN @ PAD-LINE  2DUP + LB2 SWAP SPAN2 @ CMOVE
    SPAN2 @ + SPAN ! DROP
  REPEAT  ;

0 2 IN/OUT
: GET-LINE ( -- addr length )
  WAS-SMART? @ IF SPAN2 @ 0> IF  LB2 LINEBUF SPAN2 @ CMOVE THEN
                  SPAN2 @ SPAN ! WAS-SMART? OFF
          ELSE  LINEBUF 256 EXPECT  THEN
  SPAN @ 0> IF
     SMART? @  LINEBUF C@ ASCII : = AND IF BE-SMART??? THEN
     LINEBUF SPAN @ 0
      DO COUNT CONTROL I = IF  DUP 1- BL C<- THEN LOOP  
     DROP THEN
     SPAN @ 0< NOT IF  LINEBUF SPAN @ PAD-LINE
                   ELSE  LINEBUF -1 THEN  ;

\ MESSAGES
0 0 IN/OUT 
: NOTICE  
	." FORTH ENSCREEN CONVERSION PROGRAM" CR
	." Copyright (C) 1985 by Thomas Almy" CR ;

0 0 IN/OUT 
: USAGE  
	CONSOLE CR
	." USAGE:  ENSCREEN  [-options] [FORFILE] [SCRFILE] " CR
	." where FORFILE is an ascii text file (default .4TH)" CR
	."   or standard input if absent or `-' specified" CR
	." SCRFILE is the new screen file (default .SCR)." CR
	." options include:" CR
	." <digit> -- optimal # blank lines at screen end," CR
	." N -- use `-->'," CR
	." T -- title from \ lines," CR
	." S -- Skip first screens," CR
	." I -- Smart(?) handling of colon defs." CR
	ABORT ;

0 0 IN/OUT
: GET-OPTIONS  \ read options from command line
 \  LINE# OFF   NEXTSCR? OFF
 \  SKIPPER? OFF  TITLE? OFF
 \  SMART? OFF  WAS-SMART? OFF    
   5 NBLANKS !
   OPTIONSTRING 2@ 0 ?DO
     COUNT DUP ASCII a >= OVER ASCII z <= AND IF BL - THEN  CASE
        ASCII - OF  ( ignore ) ENDOF
        ASCII N OF  NEXTSCR? ON ENDOF
        ASCII T OF  TITLE? ON  TITLE C/L BL FILL ENDOF
        ASCII S OF  SKIPPER? ON ENDOF
        ASCII I OF  SMART? ON ENDOF
        DUP ASCII 9 <= OVER ASCII 1 >= AND IF
           DUP ASCII 0 - NBLANKS !
           ELSE CONSOLE ." bad option--" DUP EMIT USAGE  THEN
      ENDCASE LOOP DROP ;     

0 0 IN/OUT
: ?SKIP-SCREENS
   SKIPPER? @ IF  NEXTSCR? @ IF C/L L/SCR * ELSE
                               C/L L/SCR * 2* THEN ( skip bytes)
                 SPACES  THEN  ;

0 0 IN/OUT
: FILL-SCREEN  ( fill screen to end with blanks )
   L/SCR LINE# @ -  C/L *
   NEXTSCR? @ IF ." -->"  3 ( len of "-->" ) - THEN
   SPACES
   LINE# OFF ;

2 2 IN/OUT
: ?SET-TITLE   ( addr len -- addr len )
      DUP 0> IF TITLE? @ IF  OVER C@ ASCII \ = IF
         DROP TITLE C/L CMOVE
         LINE# @ IF FILL-SCREEN ( force form-feed ) THEN
        GET-LINE THEN THEN THEN ;

0 0 IN/OUT
: ?PUT-TITLE    TITLE? @ IF  TITLE C/L TYPE  ELSE
                             C/L SPACES THEN
      1 LINE# ! ;

0 0 IN/OUT
: PROCESS-LINES
  BEGIN  GET-LINE  ?SET-TITLE
     DUP 0< NOT WHILE \ Leave if no line
     LINE#  @ 0= IF  ?PUT-TITLE  THEN
     L/SCR LINE# @ - NBLANKS @ = ZERO-LINE? @ AND NOT
     IF  ( not deleting blank line )
      DUP C/L /  DUP  L/SCR LINE# @ -  SWAP -
      NBLANKS @  < IF FILL-SCREEN ?PUT-TITLE THEN
     ( #lines ) LINE# +!
     TYPE     ELSE  2DROP THEN
  REPEAT  2DROP
;

: MAIN   
	SETBUFS ( allow I/O )
	NOTICE
	SETFILES IF USAGE THEN ( bad news? )
	GET-OPTIONS
	?SKIP-SCREENS
	PROCESS-LINES
	NEXTSCR? OFF  FILL-SCREEN
	BYE ;

INCLUDE DOS2
INCLUDE FORTHLIB

END

