

;              ciforth : a generic I86 ISO FORTH by HCC FIG

; $Id: ci86.gnr,v 4.15.2.1 2003/03/26 13:54:43 albert Exp $
; Copyright (2000): Albert van der Horst by GNU Public License
;
;HCC FIG Holland : Hobby Computer Club, Forth Interest Group  Holland
        ;  66,106
 ;   ciforth $Revision: 4.15.2.1 $
;
; For the generic system (to generate ciforth in an other configuration than this one):
;     http://home.hccnet.nl/a.w.m.van.der.horst/ci86gnr.html
;
; If this is a configured assembly file, it should be accompanied with configured
; documentation (texinfo, ps, html.)
; WITHOUT THE DOCUMENTATION: GIVE UP! GET THE REAL THING!
; You have a configured system, if there are NO curly brackets on the next line.
;                          
;
; Configuration of this particular version:
; 16-bits real mode  
; running under MSDOS
; with modern MSDOS I/O  
  
; Normally ciforth doesn't observe ISO >IN.
; Contains :
; (there may be no items here.)
;        Security words
;         Loadable words, i.e. all of ISO CORE, more than is needed
;           for a self contained kernel.
; A field in the header to point to source
;
 ;
; This is a NASM version of ciforth created by ``m4'' from the generic listing.
; It can be assembled using ``nasm'' obtainable via :
; Source: ftp://ftp.us.kernel.org/pub/software/devel/nasm/source/
; URL: http://www.cryogen.com/Nasm/

; This version can be assembled on a Linux system in behalf of a
; MS-DOS   version by
;   nasm -fbin ciforth.asm -o ciforth.com
; For assembling on other systems where nasm is available see the
; documentation of nasm.

%if 0
        A generic version of ISO FORTH for IBM type standard PC's by
                Albert van der Horst

                in cooperation with
                HCC Forth user group
                The Netherlands
                www.forth.hccnet.nl

              based on
              FIG-FORTH
   implemented by:  Charlie Krajewski
                    205 ( BIG ) Blue Rd.
                    Middletown, CT  06457

  The listing has been made possible by the
  prior work of:
               Thomas Newman, Hayward, Ca.

 : other_acknowledgements
         John_Cassidy
         Kim_Harris
         George_Flammer
         Robert_D._Villwock ;

 : for tools
         Richard M. Stallman
         Linus Torvalds

No one who programs with FORTH can afford to be without:
  "Starting Forth  by Leo Brodie" and "Thinking Forth by Leo Brodie".
   Both out of print.

This Forth is a descendant in the 300+ (RCS)- generations from fig-Forth.

For nostalgic reasons the following comment has never been removed:
   Although there is much to be said for typing in your own
   listing and getting it running, there is much to be said
   not typing in your own listing.  If you feel that 100+
   pages of plinking is nutty, contact me for availability
   of a disc with source & executable files.  Obtainable at
   a bargain basement price, prepare yourself for bargain
   basement support.

All publications of the FORTH Interest Group are public domain.
They may be further distributed by the inclusion of this
credit notice:
               This publication has been made available by:

               FORTH Interest Group
               P.O. Box 1105
               San Carlos, Ca.  94070
[I feel obliged to keep this last one in (AH). Note that although it is
based on fig-Forth no stone is left unturned.]
%endif
        ;
; ########################################################################################
;                       PREPARATION (no code)
; ########################################################################################
FIGREL  EQU     4       ; FIG RELEASE #
FIGREV  EQU     0       ; FIG REVISION #
USRVER  EQU     0      ; USER VERSION NUMBER, a digit now
;
;      VERY ELEMENTARY .
CW      EQU     2    ; Size of a cell in Forth, not in the bootcode.
ERRORSCREEN EQU     48    ; Screen where the error messages start.
;
;      MEMORY LAYOUT.
; Normally this is specified at the m4 configuration level.
; For a configured system these values can be changed at this single place. 
NBUF    EQU     8    ; No. of buffers, or screens 
KBBUF   EQU     1024      ; Data bytes per disk buffer
US      EQU     40H*CW  ; User variable space
EM      EQU     10000H     ; Where the memory ends w.r.t. ORIG.
EMP     EQU     (EM-1)/1000H+1 ; Number of pages.
RTS     EQU     0100H    ; Return stack & terminal input buffer
;

;
;      ASCII CHARACTER EQUIVALENTS
;
ABL     EQU     ' '     ; SPACE
ACR     EQU     0DH     ; CR
ASO     EQU     '['     ; SQUARE BRACKET OPEN 
ASC     EQU     ']'     ; SQUARE BRACKET CLOSE 
ADOT    EQU     '.'     ; PERIOD
ALF      EQU     0AH     ; LINE FEED, USED INTERNALLY AS
                        ; LINE ENDER
AFF      EQU     0CH     ; FORM FEED
BELL    EQU     07H     ; ^G
BSIN    EQU     08H     ; INPUT DELETE CHARACTER
BSOUT   EQU     08H     ; OUTPUT BACKSPACE ( ^H )
;
;      HEADER RELATED EQUATES
B_DUMMY   EQU     01H     ; dea is dummy, from vocabulary link
B_INVIS   EQU     02H     ; dea is invisible, "smudged".
B_IMMED   EQU     04H     ; dea is a immediate.
B_DENOT   EQU     08H     ; dea is a denotation.
C_HOFFSET EQU     0       ; Offsets of code field in cells, w.r.t. dea
D_HOFFSET EQU     1       ; Same for data field
F_HOFFSET EQU     2       ; Same for flag field
L_HOFFSET EQU     3       ; Same for link field
N_HOFFSET EQU     4       ; Same for name field
S_HOFFSET EQU     5       ; Same for source field
PH_OFFSET EQU     6   ; Past header field: Start of data area. 
BD_OFFSET EQU     6+1 ; Start of BODY for CREATEd word.
;


BUF1    EQU     EM-(KBBUF+2*2)*NBUF      ; FIRST DISK BUFFER
STRUSA  EQU     BUF1-US         ; User area
 ;  
; 

STRTIB  EQU     STRUSA-RTS      ; Start return stack area
                                ; Under this : data stack
INITR0  EQU     STRUSA         ; Grows down
INITS0  EQU     STRTIB          ; Grows down
 ;  

;

;

BPS     EQU     512             ;Bytes/sector, common to all of MSDOS
SPB     EQU     KBBUF/BPS
;
;

;
;

;
; 

; 

create  EQU     3C00H
open    EQU     3D00H
close   EQU     3E00H
read    EQU     3F00H
write   EQU     4000H
delete  EQU     4100H
lseek   EQU     4200H
; 

; 

; ########################################################################################
;                      BOOTCODE    (optional, always real mode)
; ########################################################################################

; All bootcode must be relocatable and its memory references absolute.
; Not for the sake of booting, but to allow MSDOS to start the program too. 

        ;    SEGMENT PARA PUBLIC 'CODE'
        ; CS:;,DS:;,SS:;,ES:;
    
    
ORG0:

; 

; 
; 
NOBOOT:         ; Skip till here if not booting.

; 
ENDBOOT:

; ########################################################################################
;                       ADJUST CODE SEGMENT REGISTER (still real mode)
; ########################################################################################
; Required start of .COM program.

           ORG     100H
ORIG:                         ; Accommodate also .exe files  
       MOV     BX, (EM-1)/10H+1
        MOV     AH,4Ah              ;Modify memory allocation
        INT     21h 
 
; ########################################################################################
;                       MOVE CODE TO ITS PLACE (still real mode)
; ########################################################################################
;
; ########################################################################################
;                       FILL GDT AND SWITCH TO PROTECTED MODE/32 BITS (optional)
; ########################################################################################
; 


        PUSH    DS
        MOV     AX,0
        MOV     DS,AX
        LEA     AX,[WARM_ENTRY]
        LEA     BX,[4*23H]
        MOV     [BX],AX         ;Jump to WARM_ENTRY on <CTRL-BREAK>
        INC     BX
        INC     BX
        MOV     AX,CS
        MOV      WORD[BX], AX
        POP     DS
ENDREADJUST:
 ;  
; 

; 
; ########################################################################################
;                       PREPARE FOR USING DPMI (OPTIONAL)
; ########################################################################################
;

        MOV     [LOADEXEC+4], DS
        MOV     [LOADEXEC+8], DS
        MOV     [LOADEXEC+12], DS

;Must be done before switching to protected mode.
        MOV     AX, [ES:2CH]
        MOV     [USINI+(CW*(31))],AX   ;Remember ENV pointer.
        MOV     [LOADEXEC], AX
 ; 

;

; 

; ########################################################################################
;                       FORTH GLUE CODE (optional, except for the jump)
; ########################################################################################

;

;
COLD_ENTRY:
        CLD                     ; DIR = INC

        MOV     AX,DS
        MOV     SS,AX           ;Atomic with next instruction.
        MOV     SP, WORD[USINI+(CW*(2))]    ;PARAM. STACK
        MOV     BP, WORD[USINI+(CW*(3))]    ;RETURN STACK
        MOV     SI, CLD1  ; (IP) <-
        JMP     NEXT
;
CLD1:   DW      COLD    ;  This is a piece of headerless high level code.
;
; ########################################################################################
;                       FORTH ITSELF (entry point : BOOTUP)
; ########################################################################################
;
%if 0
   FORTH REGISTERS
   The names under FORTH are used in the generic source.

   FORTH   8088     FORTH PRESERVATION RULES
   -----   ----     ----- ------------ -----
   HIP   SI      High level Interpreter Pointer.  Must be preserved
                    across FORTH words.

   WOR   BX      Working register.  When entering a word
                    via its code field the DEA is passed in WOR.

   SPO   SP      Parameter stack pointer.  Must be preserved
                    across FORTH words.

   RPO   BP      Return stack pointer.  Must be preserved across
                    FORTH words.

            AX      General register.  Used to pass data from
                    FORTH words, see label APUSH or macro _APUSH

            DX      General register.  Used to pass more data from
                    FORTH words, see label DPUSH or macro _DPUSH

            BX      General purpose register.

            CX      General purpose register.

            CS      Segment register. Must be preserved
                    across FORTH words.

            DS      ditto

            SS      ibid

            ES      Temporary segment register only used by
                    a few words. However it MUST remain equal to
                    DS, such that string primitives can be used
                    with impunity.

----------------------------------------------------------
%endif
        ;
%if 0
---------------------------------------------

   COMMENT CONVENTIONS
   ------- -----------

   =       IS EQUAL TO
   <-      ASSIGNMENT

  NAME        =  Address of name
  (NAME)      =  Contents of name

  CFA         =  CODE FIELD ADDRESS : a pointer to executable code
  DFA         =  DATA FIELD ADDRESS : a pointer to
                        data/high level code/ DOES> pointer
  FFA         =  FLAG FIELD ADDRESS: contains flags
  LFA         =  LINK FIELD ADDRESS: a pointer
  NFA         =  NAME FIELD ADDRESS: a pointer to a variable number of chars
  PHA         =  POST HEADER ADDRESS

  S1          =  Parameter stack - 1st cell
  S2          =  Parameter stack - 2nd cell
  R1          =  Return stack    - 1st cell
  R2          =  Return stack    - 2nd cell

  LSB         =  Least significant bit
  MSB         =  Most  significant bit
  LB          =  Low byte
  HB          =  High byte
  LW          =  Low  cell

------------------------------------------------------------
%endif
; 
        ;

; 
; 
;
; 
; In 32 bit versions there may be no jumps to NEXT at all 
; The label NEXT1 is rarely relevant (for _OLDDEBUG_) 
DPUSH:  PUSH    DX      ; Fall through.
APUSH:  PUSH    AX
NEXT:
;
        LODSW           ;AX <- (IP)
NEXT1:  MOV     BX,AX   ; (WOR) <- (IP)

        JMP      WORD[BX]    ; TO `CFA'
;
;       Dictionary starts here.

DP0:
; Vocabularies all end in a link to 0.
; Only the word FORTH links to the DENOTATION wordlist,
; that in turn links to 0.


;  *********
;  *   '   *
;  *********
;
N_TICK:   DW      1
        DB      "'"
TICK:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED + B_DENOT
        DW    0
        DW    N_TICK
    DW    0

        DW      ITICK
        DW      LITER
        DW      SEMIS
;

;  *********
;  *   &   *
;  *********
;
N_DCHAR:   DW      1
        DB      "&"
DCHAR:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED + B_DENOT
        DW    TICK-(CW*(C_HOFFSET))
        DW    N_DCHAR
    DW    0

        DW      INBRS
        DW      SWAP, DROP
        DW      LDUP, QBL
        DW      LIT, 10, QERR
        DW      LITER
        DW      QDELIM
        DW      SEMIS
;

;  *********
;  *   ^   *
;  *********
;
N_DCTL:   DW      1
        DB      "^"
DCTL:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED + B_DENOT
        DW    DCHAR-(CW*(C_HOFFSET))
        DW    N_DCTL
    DW    0

        DW      INBRS
        DW      SWAP, DROP
        DW      LDUP, QBL
        DW      LIT, 10, QERR
        DW      LIT, '@', LSUB
        DW      LITER
        DW      QDELIM
        DW      SEMIS
;

;  *********
;  *   0   *
;  *********
;
N_DEN0:   DW      1
        DB      "0"
DEN0:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DCTL-(CW*(C_HOFFSET))
        DW    N_DEN0
    DW    0

;  *********
;  *   1   *
;  *********
;
N_DEN1:   DW      1
        DB      "1"
DEN1:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DEN0-(CW*(C_HOFFSET))
        DW    N_DEN1
    DW    0

;  *********
;  *   2   *
;  *********
;
N_DEN2:   DW      1
        DB      "2"
DEN2:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DEN1-(CW*(C_HOFFSET))
        DW    N_DEN2
    DW    0

;  *********
;  *   3   *
;  *********
;
N_DEN3:   DW      1
        DB      "3"
DEN3:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DEN2-(CW*(C_HOFFSET))
        DW    N_DEN3
    DW    0

;  *********
;  *   4   *
;  *********
;
N_DEN4:   DW      1
        DB      "4"
DEN4:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DEN3-(CW*(C_HOFFSET))
        DW    N_DEN4
    DW    0

;  *********
;  *   5   *
;  *********
;
N_DEN5:   DW      1
        DB      "5"
DEN5:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DEN4-(CW*(C_HOFFSET))
        DW    N_DEN5
    DW    0

;  *********
;  *   6   *
;  *********
;
N_DEN6:   DW      1
        DB      "6"
DEN6:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DEN5-(CW*(C_HOFFSET))
        DW    N_DEN6
    DW    0

;  *********
;  *   7   *
;  *********
;
N_DEN7:   DW      1
        DB      "7"
DEN7:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DEN6-(CW*(C_HOFFSET))
        DW    N_DEN7
    DW    0

;  *********
;  *   8   *
;  *********
;
N_DEN8:   DW      1
        DB      "8"
DEN8:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DEN7-(CW*(C_HOFFSET))
        DW    N_DEN8
    DW    0

;  *********
;  *   9   *
;  *********
;
N_DEN9:   DW      1
        DB      "9"
DEN9:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DEN8-(CW*(C_HOFFSET))
        DW    N_DEN9
    DW    0

;  *********
;  *   A   *
;  *********
;
N_DENA:   DW      1
        DB      "A"
DENA:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DEN9-(CW*(C_HOFFSET))
        DW    N_DENA
    DW    0

;  *********
;  *   B   *
;  *********
;
N_DENB:   DW      1
        DB      "B"
DENB:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DENA-(CW*(C_HOFFSET))
        DW    N_DENB
    DW    0

;  *********
;  *   C   *
;  *********
;
N_DENC:   DW      1
        DB      "C"
DENC:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DENB-(CW*(C_HOFFSET))
        DW    N_DENC
    DW    0

;  *********
;  *   D   *
;  *********
;
N_DEND:   DW      1
        DB      "D"
DEND:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DENC-(CW*(C_HOFFSET))
        DW    N_DEND
    DW    0

;  *********
;  *   E   *
;  *********
;
N_DENE:   DW      1
        DB      "E"
DENE:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DEND-(CW*(C_HOFFSET))
        DW    N_DENE
    DW    0

;  *********
;  *   F   *
;  *********
;
N_DENF:   DW      1
        DB      "F"
DENF:        DW    DOCOL
        DW    LNUMB
        DW    B_IMMED + B_DENOT
        DW    DENE-(CW*(C_HOFFSET))
        DW    N_DENF
    DW    0

;

;  *********
;  *   -   *
;  *********
;
N_DENM:   DW      1
        DB      "-"
DENM:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED + B_DENOT
        DW    DENF-(CW*(C_HOFFSET))
        DW    N_DENM
    DW    0

        DW      PNUMB, DNEGA, SDLITE
        DW      SEMIS
;

;  *********
;  *   +   *
;  *********
;
N_DENP:   DW      1
        DB      "+"
DENP:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED + B_DENOT
        DW    DENM-(CW*(C_HOFFSET))
        DW    N_DENP
    DW    0

        DW      PNUMB, SDLITE
        DW      SEMIS
;

;  *********
;  *   "   *
;  *********
;
N_DENQ:   DW      1
        DB      '"'
DENQ:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED + B_DENOT
        DW    DENP-(CW*(C_HOFFSET))
        DW    N_DENQ
    DW    0

        DW      LIT, SKIP, COMMA        ;  'SKIP , HERE >R 0 ,
        DW      HERE, TOR, ZERO, COMMA
DENQ1:
        DW      LIT, '"', PPARS         ;           BEGIN &" (PARSE)
        DW      INBRS, LDUP, LIT, '"', EQUAL ;           IN[] DUP &" =
        DW      ZBRAN
        DW      DENQ2-$-CW                 ;           WHILE
        DW      TDROP, ONEP             ;           2DROP 1+ R@ $+!
        DW      LDUP, ALLOT, RR, SADD
        DW      BRAN
        DW      DENQ1-$-CW                  ;           REPEAT
DENQ2:
        DW      QBL, ZEQU
        DW      LIT, 10, QERR           ;           ?BLANK 0= 5 ?ERROR
        DW      DROP                    ;                DROP R@ $+!
        DW      LDUP, ALLOT, RR, SADD
        DW      FROMR, SFET, DLITE      ;           R> $@ POSTPONE DLITERAL ;
        DW      SEMIS
;

; The FORTH vocabulary is the only one not to link to zero.
; It links to the DENOTATION vocabulary.
;  *************
;  *   FORTH   *
;  *************
;
N_FORTH:   DW      5
        DB      "FORTH"
FORTH:        DW    DODOE
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    DENOTBODY 
        DW    N_FORTH
    DW    0

        DW      DOVOC
        DW      0       ; END OF VOCABULARY LIST

        DW    0H
        DW    0
        DW    B_DUMMY
        DW    TASK-(CW*(C_HOFFSET))
        DW    0
    DW    0

;
;

;  ************
;  *   CORE   *
;  ************
;
N_CORE:   DW      4
        DB      "CORE"
CORE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    0
        DW    N_CORE
    DW    0

        DW      ZERO    ; Not (fully) present.
        DW      SEMIS
;

;  ***********
;  *   CPU   *
;  ***********
;
N_LCPU:   DW      3
        DB      "CPU"
LCPU:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    CORE-(CW*(C_HOFFSET))
        DW    N_LCPU
    DW    0

; 

       DW      LIT, 0B328H, LIT, 5H      ; '8088'     
 
        DW      SEMIS
;

;  ***************
;  *   VERSION   *
;  ***************
;
N_LVERSION:   DW      7
        DB      "VERSION"
LVERSION:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LCPU-(CW*(C_HOFFSET))
        DW    N_LVERSION
    DW    0

%if 0
;       If this is there it is an official release
        DW      SKIP
        DW      22
IBMPC:  DB      'IBM-PC ciforth'
        DB      FIGREL+40H,ADOT,FIGREV+30H,ADOT,USRVER+30H
        DW      LIT, IBMPC, LIT, 22
%endif
;       If M4_VERSION exists and contains a . it is an official release
        DW      SKIP
         DW      5
SB0: DB      "4.0.2"
       
        DW      LIT, SB0
        DW      LIT, 5
        DW      SEMIS
;

;  ************
;  *   NAME   *
;  ************
;
N_LNAME:   DW      4
        DB      "NAME"
LNAME:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LVERSION-(CW*(C_HOFFSET))
        DW    N_LNAME
    DW    0

        DW      SKIP
         DW      7
SB1: DB      "ciforth"
       
        DW      LIT, SB1
        DW      LIT, 7
        DW      SEMIS
;

;  ****************
;  *   SUPPLIER   *
;  ****************
;
N_SUPPLIER:   DW      8
        DB      "SUPPLIER"
SUPPLIER:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LNAME-(CW*(C_HOFFSET))
        DW    N_SUPPLIER
    DW    0

        DW      SKIP
         DW      20
SB2: DB      "Albert van der Horst"
       
        DW      LIT, SB2
        DW      LIT, 20
        DW      SEMIS
;
;

;  ******************
;  *   DENOTATION   *
;  ******************
;
N_DENOT:   DW      10
        DB      "DENOTATION"
DENOT:        DW    DODOE
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    FORTH
        DW    N_DENOT
    DW    0

        DW      DOVOC
        DW      FORTH-(CW*(C_HOFFSET))     ; NEXT VOCABULARY 
DENOTBODY:

        DW    0H
        DW    0
        DW    B_DUMMY
        DW    DENQ-(CW*(C_HOFFSET))
        DW    0
    DW    0

;

;  *******************
;  *   ENVIRONMENT   *
;  *******************
;
N_ENV:   DW      11
        DB      "ENVIRONMENT"
ENV:        DW    DODOE
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    DENOT-(CW*(C_HOFFSET))
        DW    N_ENV
    DW    0

        DW      DOVOC
        DW      DENOT-(CW*(C_HOFFSET))       ; NEXT VOCABULARY 

        DW    0H
        DW    0
        DW    B_DUMMY
        DW    SUPPLIER-(CW*(C_HOFFSET))
        DW    0
    DW    0

;

;  ************
;  *   NOOP   *
;  ************
;
N_NOOP:   DW      4
        DB      "NOOP"
NOOP:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    ENV-(CW*(C_HOFFSET))
        DW    N_NOOP
    DW    0

       JMP     NEXT
;
; 
;

;  ***********
;  *   LIT   *
;  ***********
;
N_LIT:   DW      3
        DB      "LIT"
LIT:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    NOOP-(CW*(C_HOFFSET))
        DW    N_LIT
    DW    0

        LODSW           ; AX <- LITERAL
        JMP     APUSH          ; TO TOP OF STACK
;

;  ***************
;  *   EXECUTE   *
;  ***************
;
N_EXEC:   DW      7
        DB      "EXECUTE"
EXEC:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LIT-(CW*(C_HOFFSET))
        DW    N_EXEC
    DW    0

        POP     BX      ; GET XT
        JMP      WORD[BX + (CW*(C_HOFFSET))]  ;(IP) <- (PFA)
;


;  ***************
;  *   RECURSE   *
;  ***************
;
N_RECURSE:   DW      7
        DB      "RECURSE"
RECURSE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    EXEC-(CW*(C_HOFFSET))
        DW    N_RECURSE
    DW    0

        DW      LATEST, COMMA
        DW      SEMIS
;
;

;  **************
;  *   BRANCH   *
;  **************
;
N_BRAN:   DW      6
        DB      "BRANCH"
BRAN:        DW    (SKIP+(CW*(PH_OFFSET-C_HOFFSET)))
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    RECURSE-(CW*(C_HOFFSET))
        DW    N_BRAN
    DW    0

;

;  ************
;  *   SKIP   *
;  ************
;
N_SKIP:   DW      4
        DB      "SKIP"
SKIP:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    BRAN-(CW*(C_HOFFSET))
        DW    N_SKIP
    DW    0

BRAN1:  LODSW
        ADD     SI,AX
        JMP     NEXT
;

;  ***************
;  *   0BRANCH   *
;  ***************
;
N_ZBRAN:   DW      7
        DB      "0BRANCH"
ZBRAN:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SKIP-(CW*(C_HOFFSET))
        DW    N_ZBRAN
    DW    0

        POP     AX      ; GET STACK VALUE
        OR      AX,AX   ; ZERO?
        JZ      BRAN1   ; YES, BRANCH
        LEA     SI,[SI+(CW*(1))]
        JMP     NEXT
;
;

;  **************
;  *   (LOOP)   *
;  **************
;
N_XLOOP:   DW      6
        DB      "(LOOP)"
XLOOP:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    ZBRAN-(CW*(C_HOFFSET))
        DW    N_XLOOP
    DW    0

        MOV     BX,1    ; INCREMENT
XLOO1:  ADD     [BP],BX ; INDEX = INDEX + INCR
        MOV     AX,[BP] ; GET NEW INDEX
        SUB     AX,[BP+(CW*(1))]        ; COMPARE WITH LIMIT
        XOR     AX,BX   ; TEST SIGN
        JS      BRAN1   ; KEEP LOOPING
;
;  END OF `DO' LOOP
        LEA     BP,[BP+(CW*(3))]  ; ADJ RETURN STACK
        LEA     SI,[SI+(CW*(1))]       ; BYPASS BRANCH OFFSET
        JMP     NEXT
;

;  ***************
;  *   (+LOOP)   *
;  ***************
;
N_XPLOO:   DW      7
        DB      "(+LOOP)"
XPLOO:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    XLOOP-(CW*(C_HOFFSET))
        DW    N_XPLOO
    DW    0

        POP     BX      ; GET LOOP VALUE
        JMP SHORT     XLOO1
        JMP     NEXT           ;Helpfull for disassembly.
;

;  ************
;  *   (DO)   *
;  ************
;
N_XDO:   DW      4
        DB      "(DO)"
XDO:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    XPLOO-(CW*(C_HOFFSET))
        DW    N_XDO
    DW    0

        LODSW
        ADD     AX,SI  ;Make absolute
        POP     DX      ; INITIAL INDEX VALUE
        POP     BX      ; LIMIT VALUE
        XCHG    BP,SP   ; GET RETURN STACK
        PUSH    AX      ; Target location.
        PUSH    BX
        PUSH    DX
        XCHG    BP,SP   ; GET PARAMETER STACK
        JMP     NEXT
;

;  *************
;  *   (?DO)   *
;  *************
;
N_XQDO:   DW      5
        DB      "(?DO)"
XQDO:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    XDO-(CW*(C_HOFFSET))
        DW    N_XQDO
    DW    0

        LODSW
        ADD     AX,SI  ;Make absolute
        POP     DX      ; INITIAL INDEX VALUE
        POP     BX      ; LIMIT VALUE
        CMP     DX,BX
        JZ      QXDO1
        XCHG    BP,SP   ; GET RETURN STACK
        PUSH    AX      ; Target location.
        PUSH    BX
        PUSH    DX
        XCHG    BP,SP   ; GET PARAMETER STACK
        JMP     NEXT
QXDO1:  MOV     SI,AX
        JMP     NEXT
;

;  *********
;  *   I   *
;  *********
;
N_IDO:   DW      1
        DB      "I"
IDO:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    XQDO-(CW*(C_HOFFSET))
        DW    N_IDO
    DW    0

        MOV     AX,[BP] ; GET INDEX VALUE
        JMP     APUSH          ; TO PARAMETER STACK
;

;  *********
;  *   J   *
;  *********
;
N_JDO:   DW      1
        DB      "J"
JDO:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    IDO-(CW*(C_HOFFSET))
        DW    N_JDO
    DW    0

        MOV     AX,[BP+(CW*(3))] ; GET INDEX VALUE
        JMP     APUSH          ; TO PARAMETER STACK
;

;  **************
;  *   UNLOOP   *
;  **************
;
N_UNLOOP:   DW      6
        DB      "UNLOOP"
UNLOOP:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    JDO-(CW*(C_HOFFSET))
        DW    N_UNLOOP
    DW    0

        DW      LIT, RDROP, COMMA
        DW      LIT, RDROP, COMMA
        DW      LIT, RDROP, COMMA
        DW      SEMIS
;

;  ***************
;  *   +ORIGIN   *
;  ***************
;
N_PORIG:   DW      7
        DB      "+ORIGIN"
PORIG:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    UNLOOP-(CW*(C_HOFFSET))
        DW    N_PORIG
    DW    0

        DW      LIT
        DW      USINI
        DW      PLUS
        DW      SEMIS
;
;      Initialisation block for user variables through DOC-LINK
;       <<<<< must be in same order as user variables >>>>>
;
;        DW      WARM_ENTRY FIXME
;        DW      COLD_ENTRY
USINI:  DW      STRUSA  ; User area currently in use, cold value same as next.
        DW      STRUSA  ; INIT (U0) user area of the main task 1
        DW      INITS0  ; INIT (S0)         2
        DW      INITR0  ; INIT (R0)         3
        DW      STRTIB  ; INIT (TIB)        4
        DW      BSIN    ; RUBOUT: get rid of latest char 5
        DW      0       ; AVAILABLE         6
        DW      1       ; INIT (WARNING)     7
        DW      INITDP  ;      INIT (FENCE)  8
DPA:    DW      INITDP  ;      INIT (DP)     9
        DW      ENV-(CW*(C_HOFFSET)) ;       INIT (VOC-LINK) 10
;

        DW      0       ; INIT (OFFSET) 
;
;
;
;
;
        DW      0, 0            ; WHERE             12 13 
        DW      0, STRTIB       ;REMAINDER   14 15 
; 
        RESB    US-($ - USINI)        ; All user can be initialised.
;
;      <<<<< end of data used by cold start >>>>>

;  *************
;  *   DIGIT   *
;  *************
;
N_DIGIT:   DW      5
        DB      "DIGIT"
DIGIT:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PORIG-(CW*(C_HOFFSET))
        DW    N_DIGIT
    DW    0

        POP     DX      ;NUMBER BASE
        POP     AX      ;ASCII DIGIT
        SUB     AL,'0'
        JB      DIGI2   ;NUMBER ERROR
        CMP     AL,9
        JBE     DIGI1   ;NUMBER = 0 THRU 9
        SUB     AL,7
        CMP     AL,10   ;NUMBER 'A' THRU 'Z'?
        JB      DIGI2   ;NO
DIGI1:  CMP     AL,DL   ; COMPARE NUMBER TO BASE
        JAE     DIGI2   ;NUMBER ERROR
        SUB     DX,DX   ;ZERO
        MOV     DL,AL   ;NEW BINARY NUMBER
        MOV     AL,1    ;TRUE FLAG
        NEG     AX
        JMP     DPUSH          ;ADD TO STACK
;   NUMBER ERROR
DIGI2:  SUB     AX,AX   ;FALSE FLAG
        JMP     DPUSH
;

;  ***************
;  *   (MATCH)   *
;  ***************
;
N_PMATCH:   DW      7
        DB      "(MATCH)"
PMATCH:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    DIGIT-(CW*(C_HOFFSET))
        DW    N_PMATCH
    DW    0

        DW      TOR
        DW      RR, TFFA, FETCH
        DW      LIT, B_INVIS | B_DUMMY, LAND ;Get flags.
        DW      ZEQU
        DW      LDUP
        DW      ZBRAN
        DW      MATS2-$-CW
        DW      DROP
        DW      RR, TNFA, FETCH, FETCH
        DW      OVER, LSUB
;
; The following four lines take care of denotations.
        DW      LDUP, ZLESS  ;Ignorable length difference.
        DW      RR, TFFA, FETCH, LIT, B_DENOT, LAND ;Get flag.
        DW      LAND  ;Denotation applicable. 
        DW      ZEQU, LAND ;This AND is actually an OR.
;
        DW      ZEQU
        DW      LDUP
        DW      ZBRAN
        DW      MATS2-$-CW
        DW      DROP, OVER
        DW      RR, TNFA, FETCH, SFET
        DW      CORA, ZEQU  ; Compare equals.
MATS2:  DW      FROMR, SWAP
        DW      SEMIS
;

;  **************
;  *   ?BLANK   *
;  **************
;
N_QBL:   DW      6
        DB      "?BLANK"
QBL:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PMATCH-(CW*(C_HOFFSET))
        DW    N_QBL
    DW    0

        DW      LBL, ONEP, LESS
        DW      SEMIS
;

;  ************
;  *   IN[]   *
;  ************
;
N_INBRS:   DW      4
        DB      "IN[]"
INBRS:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    QBL-(CW*(C_HOFFSET))
        DW    N_INBRS
    DW    0

        DW      SRC, CELLP, TFET
        DW      OVER, EQUAL
        DW      ZBRAN
        DW      INBRS1-$-CW
        DW      ZERO
        DW      BRAN
        DW      INBRS2-$-CW
INBRS1:
        DW      LDUP
        
        DW      CFET
        DW      ONE, LIN, PSTORE
INBRS2:
        DW      SEMIS
;

;  **************
;  *   (WORD)   *
;  **************
;
N_LPWORD:   DW      6
        DB      "(WORD)"
LPWORD:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    INBRS-(CW*(C_HOFFSET))
        DW    N_LPWORD
    DW    0

        DW      X
PWORD0: DW      DROP
        DW      INBRS, QBL
        DW      OVER, SRC, CELLP, FETCH, LSUB ; At end?
        DW      LAND, ZEQU
        DW      ZBRAN
        DW      PWORD0-$-CW

        DW      X
PWORD1: DW      DROP
        DW      INBRS, QBL
        DW      ZBRAN
        DW      PWORD1-$-CW

        DW      OVER, LSUB
        
        DW      SEMIS
;

;  ***************
;  *   (PARSE)   *
;  ***************
;
N_PPARS:   DW      7
        DB      "(PARSE)"
PPARS:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LPWORD-(CW*(C_HOFFSET))
        DW    N_PPARS
    DW    0

        DW      SRC, CELLP, TFET
        DW      OVER, LSUB
        
        DW      ROT, SSPLIT, TSWAP
        DW      ZEQU
        DW      ZBRAN
        DW      PPARS8-$-CW
        DW      DROP, SRC, CELLP, FETCH
PPARS8: 
        DW      LIN, STORE
        DW SEMIS
;

;  ***********
;  *   SRC   *
;  ***********
;
N_SRC:   DW      3
        DB      "SRC"
SRC:        DW    DOUSE
        DW    (CW*(27))
        DW    0H
        DW    PPARS-(CW*(C_HOFFSET))
        DW    N_SRC
    DW    0
      ; And 28 and 29.
;


;  **************
;  *   SOURCE   *
;  **************
;
N_SOURCE:   DW      6
        DB      "SOURCE"
SOURCE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SRC-(CW*(C_HOFFSET))
        DW    N_SOURCE
    DW    0

        DW      SRC, FETCH
        DW      SRC, CELLP, FETCH
        DW      OVER, LSUB
        DW      SEMIS
;

;  ***********
;  *   >IN   *
;  ***********
;
N_IIN:   DW      3
        DB      ">IN"
IIN:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SOURCE-(CW*(C_HOFFSET))
        DW    N_IIN
    DW    0

        DW      LIN, FETCH
DW      SRC, FETCH, LSUB     
        DW      PIIN, STORE
        DW      PIIN
        DW      SEMIS
;
;

;  **********
;  *   CR   *
;  **********
;
N_CR:   DW      2
        DB      "CR"
CR:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    IIN-(CW*(C_HOFFSET))
        DW    N_CR
    DW    0

        DW      LIT,ALF
        DW      EMIT
        DW      ZERO, LOUT, STORE
        DW      SEMIS
;

;  *************
;  *   CMOVE   *
;  *************
;
N_LCMOVE:   DW      5
        DB      "CMOVE"
LCMOVE:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    CR-(CW*(C_HOFFSET))
        DW    N_LCMOVE
    DW    0

        CLD             ;direction
        MOV     BX,SI   ;save 
        POP     CX      ;count
        POP     DI      ;dest
        POP     SI      ;source
        REP     MOVSB
        MOV     SI,BX   ;get back 
        JMP     NEXT
;

;  ************
;  *   MOVE   *
;  ************
;
N_LMOVE:   DW      4
        DB      "MOVE"
LMOVE:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LCMOVE-(CW*(C_HOFFSET))
        DW    N_LMOVE
    DW    0

        MOV     BX,SI   ;SAVE 
        POP     CX      ;count
        POP     DI      ;dest
        POP     SI      ;source
        CMP     SI,DI
        JC    MOVE1
        CLD             ;INC DIRECTION
        JMP SHORT MOVE2
MOVE1:  STD
        ADD     DI,CX
        DEC     DI
        ADD     SI,CX
        DEC     SI
MOVE2:
        REP     MOVSB   ;THAT'S THE MOVE
        CLD             ;INC DIRECTION
        MOV     SI,BX   ;GET BACK 
        JMP     NEXT
;

;  ***************
;  *   FARMOVE   *
;  ***************
;
N_FMOVE:   DW      7
        DB      "FARMOVE"
FMOVE:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LMOVE-(CW*(C_HOFFSET))
        DW    N_FMOVE
    DW    0

        CLD             ;direction
        MOV     AX,SI   ;save 
        MOV     BX,DS    ;save 
        POP     CX      ;count
        POP     DI      ;dest
        POP     DX
        AND     DX,DX
        JZ      FARMV1
        MOV     ES,DX
FARMV1:
        POP     SI      ;source
        POP     DX
        PUSH    DS
        PUSH    BX      ;ES in fact.
        AND     DX,DX
        JZ      FARMV2
        MOV     DS,DX
FARMV2:
        REP     MOVSB
        MOV     SI,AX   ;restore 
        POP     ES
        POP     DS
        JMP     NEXT
;

;  ***********
;  *   UM*   *
;  ***********
;
N_USTAR:   DW      3
        DB      "UM*"
USTAR:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    FMOVE-(CW*(C_HOFFSET))
        DW    N_USTAR
    DW    0

        POP     AX
        POP     BX
        MUL     BX      ;UNSIGNED
        XCHG    AX,DX   ;AX NOW = MSW
        JMP     DPUSH          ;STORE DOUBLE CELL
;

;  **************
;  *   UM/MOD   *
;  **************
;
N_USLAS:   DW      6
        DB      "UM/MOD"
USLAS:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    USTAR-(CW*(C_HOFFSET))
        DW    N_USLAS
    DW    0

        POP     BX      ;DIVISOR
        POP     DX      ;MSW OF DIVIDEND
        POP     AX      ;LSW OF DIVIDEND
        DIV     BX      ;16 BIT DIVIDE
        JMP     DPUSH          ;STORE QUOT/REM
;

;  ***********
;  *   AND   *
;  ***********
;
N_LAND:   DW      3
        DB      "AND"
LAND:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    USLAS-(CW*(C_HOFFSET))
        DW    N_LAND
    DW    0

        POP     AX
        POP     BX
        AND     AX,BX
        JMP     APUSH
;

;  **********
;  *   OR   *
;  **********
;
N_LOR:   DW      2
        DB      "OR"
LOR:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LAND-(CW*(C_HOFFSET))
        DW    N_LOR
    DW    0

        POP     AX      ; (S1) <- (S1) OR (S2)
        POP     BX
        OR      AX,BX
        JMP     APUSH
;

;  ***********
;  *   XOR   *
;  ***********
;
N_LXOR:   DW      3
        DB      "XOR"
LXOR:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LOR-(CW*(C_HOFFSET))
        DW    N_LXOR
    DW    0

        POP     AX      ; (S1) <- (S1) XOR (S2)
        POP     BX
        XOR     AX,BX
        JMP     APUSH
;

;  **************
;  *   INVERT   *
;  **************
;
N_INVERT:   DW      6
        DB      "INVERT"
INVERT:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LXOR-(CW*(C_HOFFSET))
        DW    N_INVERT
    DW    0

        POP     AX      ; (S1) <- (S1) XOR (S2)
        NOT     AX
        JMP     APUSH
;

;  ************
;  *   DSP@   *
;  ************
;
N_SPFET:   DW      4
        DB      "DSP@"
SPFET:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    INVERT-(CW*(C_HOFFSET))
        DW    N_SPFET
    DW    0

        MOV     AX,SP   ; (S1) <- (SP)
        JMP     APUSH
;

;  ************
;  *   DSP!   *
;  ************
;
N_SPSTO:   DW      4
        DB      "DSP!"
SPSTO:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SPFET-(CW*(C_HOFFSET))
        DW    N_SPSTO
    DW    0

        POP     AX
        MOV     SP,AX        ;RESET PARAM STACK POINTER
        JMP     NEXT
;


;  *************
;  *   DEPTH   *
;  *************
;
N_DEPTH:   DW      5
        DB      "DEPTH"
DEPTH:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SPSTO-(CW*(C_HOFFSET))
        DW    N_DEPTH
    DW    0

        DW      SZERO, FETCH
        DW      SPFET
        DW      LSUB
        DW      LIT, CW, SLASH
        DW      ONEM
        DW      SEMIS
;
;

;  ************
;  *   RSP@   *
;  ************
;
N_RPFET:   DW      4
        DB      "RSP@"
RPFET:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    DEPTH-(CW*(C_HOFFSET))
        DW    N_RPFET
    DW    0
      ;(S1) <- (RP)
        PUSH    BP
        JMP     NEXT
;

;  ************
;  *   RSP!   *
;  ************
;
N_RPSTO:   DW      4
        DB      "RSP!"
RPSTO:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    RPFET-(CW*(C_HOFFSET))
        DW    N_RPSTO
    DW    0

        POP     BP
        JMP     NEXT
;

;  ************
;  *   EXIT   *
;  ************
;
N_EXIT:   DW      4
        DB      "EXIT"
EXIT:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    RPSTO-(CW*(C_HOFFSET))
        DW    N_EXIT
    DW    0

        MOV     SI,[BP] ;(IP) <- (R1)
        LEA     BP,[BP+(CW*(1))]
        JMP     NEXT
;

;  **********
;  *   CO   *
;  **********
;
N_CO:   DW      2
        DB      "CO"
CO:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    EXIT-(CW*(C_HOFFSET))
        DW    N_CO
    DW    0

        XCHG    SI,[BP]
        JMP     NEXT
;

;  ***********
;  *   (;)   *
;  ***********
;
N_SEMIS:   DW      3
        DB      "(;)"
SEMIS:        DW    (EXIT+(CW*(PH_OFFSET-C_HOFFSET)))
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    CO-(CW*(C_HOFFSET))
        DW    N_SEMIS
    DW    0

;

;  *************
;  *   LEAVE   *
;  *************
;
N_LLEAV:   DW      5
        DB      "LEAVE"
LLEAV:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SEMIS-(CW*(C_HOFFSET))
        DW    N_LLEAV
    DW    0
  ;LIMIT <- INDEX
        DW      RDROP, RDROP, RDROP
        DW      SEMIS
;

;  **********
;  *   >R   *
;  **********
;
N_TOR:   DW      2
        DB      ">R"
TOR:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LLEAV-(CW*(C_HOFFSET))
        DW    N_TOR
    DW    0
        ; (R1) <- (S1)
        POP     BX      ;GET STACK PARAMETER
        LEA     BP,[BP - (CW*(1))]    ;MOVE RETURN STACK DOWN
        MOV     [BP],BX ;ADD TO RETURN STACK
        JMP     NEXT
;

;  **********
;  *   R>   *
;  **********
;
N_FROMR:   DW      2
        DB      "R>"
FROMR:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    TOR-(CW*(C_HOFFSET))
        DW    N_FROMR
    DW    0
      ;(S1) <- (R1)
        MOV     AX,[BP] ; GET RETURN STACK VALUE
        LEA     BP,[BP + (CW*(1))]
        JMP     APUSH
;

;  *************
;  *   RDROP   *
;  *************
;
N_RDROP:   DW      5
        DB      "RDROP"
RDROP:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    FROMR-(CW*(C_HOFFSET))
        DW    N_RDROP
    DW    0
      ;(S1) <- (R1)
        LEA     BP,[BP+(CW*(1))]
        JMP     NEXT
;

;  **********
;  *   R@   *
;  **********
;
N_RR:   DW      2
        DB      "R@"
RR:        DW    (IDO+(CW*(PH_OFFSET-C_HOFFSET)))
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    RDROP-(CW*(C_HOFFSET))
        DW    N_RR
    DW    0

;

;  **********
;  *   0=   *
;  **********
;
N_ZEQU:   DW      2
        DB      "0="
ZEQU:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    RR-(CW*(C_HOFFSET))
        DW    N_ZEQU
    DW    0

        POP     AX
        NEG     AX
        CMC
        SBB     AX,AX
        JMP     APUSH
;

;  **********
;  *   0<   *
;  **********
;
N_ZLESS:   DW      2
        DB      "0<"
ZLESS:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    ZEQU-(CW*(C_HOFFSET))
        DW    N_ZLESS
    DW    0

        POP     AX
        OR      AX,AX   ;SET FLAGS
        MOV     AX,0    ;FALSE
        JNS     ZLESS1
        DEC     AX      ;TRUE
ZLESS1: JMP     APUSH
;

;  *********
;  *   +   *
;  *********
;
N_PLUS:   DW      1
        DB      "+"
PLUS:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    ZLESS-(CW*(C_HOFFSET))
        DW    N_PLUS
    DW    0

        POP     AX      ;(S1) <- (S1) + (S2)
        POP     BX
        ADD     AX,BX
        JMP     APUSH
;

;  **********
;  *   D+   *
;  **********
;
N_DPLUS:   DW      2
        DB      "D+"
DPLUS:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PLUS-(CW*(C_HOFFSET))
        DW    N_DPLUS
    DW    0

        POP     AX      ; YHW
        POP     DX      ; YLW
        POP     BX      ; XHW
        POP     CX      ; XLW
        ADD     DX,CX   ; SLW
        ADC     AX,BX   ; SHW
        JMP     DPUSH
;

;  **************
;  *   NEGATE   *
;  **************
;
N_NEGATE:   DW      6
        DB      "NEGATE"
NEGATE:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    DPLUS-(CW*(C_HOFFSET))
        DW    N_NEGATE
    DW    0

        POP     AX
        NEG     AX
        JMP     APUSH
;

;  ***************
;  *   DNEGATE   *
;  ***************
;
N_DNEGA:   DW      7
        DB      "DNEGATE"
DNEGA:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    NEGATE-(CW*(C_HOFFSET))
        DW    N_DNEGA
    DW    0

        POP     BX
        POP     CX
        SUB     AX,AX
        MOV     DX,AX
        SUB     DX,CX   ; MAKE 2'S COMPLEMENT
        SBB     AX,BX   ; HIGH CELL
        JMP     DPUSH
        ;
;

;  ************
;  *   OVER   *
;  ************
;
N_OVER:   DW      4
        DB      "OVER"
OVER:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    DNEGA-(CW*(C_HOFFSET))
        DW    N_OVER
    DW    0

        POP     DX
        POP     AX
        PUSH    AX
        JMP     DPUSH
;

;  ************
;  *   DROP   *
;  ************
;
N_DROP:   DW      4
        DB      "DROP"
DROP:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    OVER-(CW*(C_HOFFSET))
        DW    N_DROP
    DW    0

        POP     AX
        JMP     NEXT
;

;  *************
;  *   2DROP   *
;  *************
;
N_TDROP:   DW      5
        DB      "2DROP"
TDROP:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    DROP-(CW*(C_HOFFSET))
        DW    N_TDROP
    DW    0

        POP     AX
        POP     AX
        JMP     NEXT
;

;  ************
;  *   SWAP   *
;  ************
;
N_SWAP:   DW      4
        DB      "SWAP"
SWAP:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    TDROP-(CW*(C_HOFFSET))
        DW    N_SWAP
    DW    0

        POP     DX
        POP     AX
        JMP     DPUSH
;

;  ***********
;  *   DUP   *
;  ***********
;
N_LDUP:   DW      3
        DB      "DUP"
LDUP:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SWAP-(CW*(C_HOFFSET))
        DW    N_LDUP
    DW    0

        POP     AX
        PUSH    AX
        JMP     APUSH
;

;  ************
;  *   2DUP   *
;  ************
;
N_TDUP:   DW      4
        DB      "2DUP"
TDUP:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LDUP-(CW*(C_HOFFSET))
        DW    N_TDUP
    DW    0

        POP     AX
        POP     DX
        PUSH    DX
        PUSH    AX
        JMP     DPUSH
;

;  *************
;  *   2SWAP   *
;  *************
;
N_TSWAP:   DW      5
        DB      "2SWAP"
TSWAP:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    TDUP-(CW*(C_HOFFSET))
        DW    N_TSWAP
    DW    0

        POP     BX
        POP     CX
        POP     AX
        POP     DX
        PUSH     CX
        PUSH     BX
        JMP     DPUSH
;

;  *************
;  *   2OVER   *
;  *************
;
N_TOVER:   DW      5
        DB      "2OVER"
TOVER:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    TSWAP-(CW*(C_HOFFSET))
        DW    N_TOVER
    DW    0

        POP     BX
        POP     CX
        POP     AX
        POP     DX
        PUSH     DX
        PUSH     AX
        PUSH     CX
        PUSH     BX
        JMP     DPUSH
;

;  **********
;  *   +!   *
;  **********
;
N_PSTORE:   DW      2
        DB      "+!"
PSTORE:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    TOVER-(CW*(C_HOFFSET))
        DW    N_PSTORE
    DW    0

        POP     BX      ;ADDRESS
        POP     AX      ;INCREMENT
        ADD     [BX],AX
        JMP     NEXT
;

;  **************
;  *   TOGGLE   *
;  **************
;
N_TOGGL:   DW      6
        DB      "TOGGLE"
TOGGL:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PSTORE-(CW*(C_HOFFSET))
        DW    N_TOGGL
    DW    0

        POP     AX      ;BIT PATTERN
        POP     BX      ;ADDR
        XOR     [BX],AX ;
        JMP     NEXT
;

;  *********
;  *   @   *
;  *********
;
N_FETCH:   DW      1
        DB      "@"
FETCH:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    TOGGL-(CW*(C_HOFFSET))
        DW    N_FETCH
    DW    0

        POP     BX
        MOV     AX,[BX]
        JMP     APUSH
;

;  **********
;  *   C@   *
;  **********
;
N_CFET:   DW      2
        DB      "C@"
CFET:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    FETCH-(CW*(C_HOFFSET))
        DW    N_CFET
    DW    0

        POP     BX
        XOR     AX,AX
        MOV     AL,[BX]
        JMP     APUSH
;

;  **********
;  *   2@   *
;  **********
;
N_TFET:   DW      2
        DB      "2@"
TFET:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    CFET-(CW*(C_HOFFSET))
        DW    N_TFET
    DW    0

        POP     BX      ;ADDR
        MOV     AX,[BX] ;MSW
        MOV     DX,[BX+(CW*(1))]        ;LSW
        JMP     DPUSH
;

;  *********
;  *   !   *
;  *********
;
N_STORE:   DW      1
        DB      "!"
STORE:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    TFET-(CW*(C_HOFFSET))
        DW    N_STORE
    DW    0

        POP     BX      ;ADDR
        POP     AX      ;DATA
        MOV     [BX],AX
        JMP     NEXT
;

;  **********
;  *   C!   *
;  **********
;
N_CSTOR:   DW      2
        DB      "C!"
CSTOR:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    STORE-(CW*(C_HOFFSET))
        DW    N_CSTOR
    DW    0

        POP     BX      ;ADDR
        POP     AX      ;DATA
        MOV     [BX],AL
        JMP     NEXT
;

;  **********
;  *   2!   *
;  **********
;
N_TSTOR:   DW      2
        DB      "2!"
TSTOR:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    CSTOR-(CW*(C_HOFFSET))
        DW    N_TSTOR
    DW    0

        POP     BX      ;ADDR
        POP     AX      ;MSW
        MOV     [BX],AX
        POP     AX      ;LSW
        MOV     [BX+(CW*(1))],AX
        JMP     NEXT
;

;  **************
;  *   WITHIN   *
;  **************
;
N_WITHIN:   DW      6
        DB      "WITHIN"
WITHIN:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    TSTOR-(CW*(C_HOFFSET))
        DW    N_WITHIN
    DW    0

        DW      OVER, LSUB, TOR
        DW      LSUB, FROMR
        DW      ULESS
        DW      SEMIS
;


;  **********
;  *   L@   *
;  **********
;
N_LFET:   DW      2
        DB      "L@"
LFET:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    WITHIN-(CW*(C_HOFFSET))
        DW    N_LFET
    DW    0

        POP     BX      ;MEM LOC
        POP     CX      ;SEG REG VAL
        MOV     DX,DS   ; Leave this for real mode code.
        MOV     DS,CX
        MOV     BX,[BX]
        MOV     DS,DX
        PUSH    BX
        JMP     NEXT
;

;  **********
;  *   L!   *
;  **********
;
N_LSTORE:   DW      2
        DB      "L!"
LSTORE:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LFET-(CW*(C_HOFFSET))
        DW    N_LSTORE
    DW    0

        POP     BX
        POP     CX
        POP     DX
        MOV     AX,DS
        MOV     DS,CX
        MOV     [BX],DX
        MOV     DS,AX
        JMP     NEXT
;
;

;  *********
;  *   :   *
;  *********
;
N_COLON:   DW      1
        DB      ":"
COLON:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LSTORE-(CW*(C_HOFFSET))
        DW    N_COLON
    DW    0

        DW      SCSP
        DW      LPWORD
        DW      PCREAT
        DW      LATEST, HIDDEN
        DW      RBRAC
        DW      PSCOD
DOCOL:  LEA     BP,[BP - (CW*(1))]  ;Push HIP
        MOV     [BP],SI ;R1 <- (IP)
         MOV     SI,[BX+(CW*(D_HOFFSET - C_HOFFSET))]  ;(IP) <- (PFA)
;        CALL    DISPLAYSI
; 
        JMP     NEXT
;

;  *********
;  *   ;   *
;  *********
;
N_SEMI:   DW      1
        DB      ";"
SEMI:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    COLON-(CW*(C_HOFFSET))
        DW    N_SEMI
    DW    0

        DW      QCSP
        DW      LIT, SEMIS, COMMA
        DW      LATEST, HIDDEN
        DW      LBRAC
        DW      SEMIS
;

;  ****************
;  *   CONSTANT   *
;  ****************
;
N_LCONST:   DW      8
        DB      "CONSTANT"
LCONST:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SEMI-(CW*(C_HOFFSET))
        DW    N_LCONST
    DW    0

        DW      LPWORD
        DW      PCREAT
        DW      LATEST, TDFA, STORE
        DW      PSCOD
DOCON:  MOV     AX,[BX+(CW*((D_HOFFSET-C_HOFFSET)))] ;GET DATA FROM PFA
        JMP     APUSH
;

;  ****************
;  *   VARIABLE   *
;  ****************
;
N_VAR:   DW      8
        DB      "VARIABLE"
VAR:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LCONST-(CW*(C_HOFFSET))
        DW    N_VAR
    DW    0

        DW      LPWORD
        DW      PCREAT
        DW      ZERO, COMMA
        DW      PSCOD
DOVAR:  MOV     AX,[BX+(CW*((D_HOFFSET-C_HOFFSET)))] ;(AX) <- PFA
        JMP     APUSH
;

;  ************
;  *   USER   *
;  ************
;
N_USER:   DW      4
        DB      "USER"
USER:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    VAR-(CW*(C_HOFFSET))
        DW    N_USER
    DW    0

        DW      LCONST
        DW      PSCOD
DOUSE:  MOV     BX,[BX+(CW*((D_HOFFSET-C_HOFFSET)))] ;PFA  
        MOV     DI, WORD[USINI]
        LEA     AX,[BX+DI]      ;ADDR OF VARIABLE
        JMP     APUSH
;
;

;  *********
;  *   _   *
;  *********
;
N_X:   DW      1
        DB      "_"
X:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    USER-(CW*(C_HOFFSET))
        DW    N_X
    DW    0

        JMP     APUSH ;Whatever happens to be in AX, i.e. the dea of ``_''.
;

;  *********
;  *   0   *
;  *********
;
N_ZERO:   DW      1
        DB      "0"
ZERO:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    X-(CW*(C_HOFFSET))
        DW    N_ZERO
    DW    0

        XOR     AX,AX
        JMP     APUSH
;

;  *********
;  *   1   *
;  *********
;
N_ONE:   DW      1
        DB      "1"
ONE:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    ZERO-(CW*(C_HOFFSET))
        DW    N_ONE
    DW    0

        MOV     AX,1
        JMP     APUSH
;

;  *********
;  *   2   *
;  *********
;
N_TWO:   DW      1
        DB      "2"
TWO:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    ONE-(CW*(C_HOFFSET))
        DW    N_TWO
    DW    0

        MOV     AX,2
        JMP     APUSH
;

;  **********
;  *   BL   *
;  **********
;
N_LBL:   DW      2
        DB      "BL"
LBL:        DW    DOCON
        DW    ABL
        DW    0H
        DW    TWO-(CW*(C_HOFFSET))
        DW    N_LBL
    DW    0

;

;  **********
;  *   $@   *
;  **********
;
N_SFET:   DW      2
        DB      "$@"
SFET:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LBL-(CW*(C_HOFFSET))
        DW    N_SFET
    DW    0

        DW LDUP, CELLP, SWAP, FETCH
        DW SEMIS
;

;  **********
;  *   $!   *
;  **********
;
N_SSTOR:   DW      2
        DB      "$!"
SSTOR:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SFET-(CW*(C_HOFFSET))
        DW    N_SSTOR
    DW    0

        DW TDUP, STORE, CELLP, SWAP, LCMOVE
        DW SEMIS
;

;  *************
;  *   $!-BD   *
;  *************
;
N_SSTORBD:   DW      5
        DB      "$!-BD"
SSTORBD:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SSTOR-(CW*(C_HOFFSET))
        DW    N_SSTORBD
    DW    0

        DW TDUP, CSTOR, ONEP, SWAP, LCMOVE
        DW SEMIS
;

;  ***********
;  *   $+!   *
;  ***********
;
N_SADD:   DW      3
        DB      "$+!"
SADD:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SSTORBD-(CW*(C_HOFFSET))
        DW    N_SADD
    DW    0

        DW   LDUP, FETCH, TOR ; Remember old count.
        DW   TDUP, PSTORE
        DW   CELLP, FROMR, PLUS, SWAP, LCMOVE
        DW SEMIS
;

;  ***********
;  *   $C+   *
;  ***********
;
N_CHAPP:   DW      3
        DB      "$C+"
CHAPP:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SADD-(CW*(C_HOFFSET))
        DW    N_CHAPP
    DW    0

        DW   LDUP, TOR
        DW   LDUP, FETCH, PLUS, CELLP, CSTOR
        DW   ONE, FROMR, PSTORE
        DW SEMIS
;

;  **********
;  *   $,   *
;  **********
;
N_SCOMMA:   DW      2
        DB      "$,"
SCOMMA:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    CHAPP-(CW*(C_HOFFSET))
        DW    N_SCOMMA
    DW    0

        DW HERE, TOR
        DW LDUP, CELLP, ALLOT
        DW RR, SSTOR, FROMR
        DW SEMIS
;

;  ***********
;  *   C/L   *
;  ***********
;
N_CSLL:   DW      3
        DB      "C/L"
CSLL:        DW    DOCON
        DW    64
        DW    0H
        DW    SCOMMA-(CW*(C_HOFFSET))
        DW    N_CSLL
    DW    0

;


;  *************
;  *   FIRST   *
;  *************
;
N_FIRST:   DW      5
        DB      "FIRST"
FIRST:        DW    DOCON
        DW    BUF1
        DW    0H
        DW    CSLL-(CW*(C_HOFFSET))
        DW    N_FIRST
    DW    0

 ;  
;
; 
;

;  *************
;  *   LIMIT   *
;  *************
;
N_LIMIT:   DW      5
        DB      "LIMIT"
LIMIT:        DW    DOCON
        DW    BUF1+(KBBUF+2*CW)*NBUF
        DW    0H
        DW    FIRST-(CW*(C_HOFFSET))
        DW    N_LIMIT
    DW    0

; THE END  OF THE MEMORY 

;  **********
;  *   EM   *
;  **********
;
N_LEM:   DW      2
        DB      "EM"
LEM:        DW    DOCON
        DW    ACTUAL_EM
        DW    0H
        DW    LIMIT-(CW*(C_HOFFSET))
        DW    N_LEM
    DW    0

;

;  **********
;  *   BM   *
;  **********
;
N_LBM:   DW      2
        DB      "BM"
LBM:        DW    DOCON
        DW    ORG0
        DW    0H
        DW    LEM-(CW*(C_HOFFSET))
        DW    N_LBM
    DW    0

;

;  *************
;  *   B/BUF   *
;  *************
;
N_BBUF:   DW      5
        DB      "B/BUF"
BBUF:        DW    DOCON
        DW    KBBUF
        DW    0H
        DW    LBM-(CW*(C_HOFFSET))
        DW    N_BBUF
    DW    0

;
; All user variables are initialised 
; with the values from USINI.
; The implementation relies on the initialisation of 
; those with numbers (1..11), so change in concord with USINI.

;  **********
;  *   U0   *
;  **********
;
N_UZERO:   DW      2
        DB      "U0"
UZERO:        DW    DOUSE
        DW    (CW*(1))
        DW    0H
        DW    BBUF-(CW*(C_HOFFSET))
        DW    N_UZERO
    DW    0

;

;  **********
;  *   S0   *
;  **********
;
N_SZERO:   DW      2
        DB      "S0"
SZERO:        DW    DOUSE
        DW    (CW*(2))
        DW    0H
        DW    UZERO-(CW*(C_HOFFSET))
        DW    N_SZERO
    DW    0

;

;  **********
;  *   R0   *
;  **********
;
N_RZERO:   DW      2
        DB      "R0"
RZERO:        DW    DOUSE
        DW    (CW*(3))
        DW    0H
        DW    SZERO-(CW*(C_HOFFSET))
        DW    N_RZERO
    DW    0

;

;  ***********
;  *   TIB   *
;  ***********
;
N_TIB:   DW      3
        DB      "TIB"
TIB:        DW    DOUSE
        DW    (CW*(4))
        DW    0H
        DW    RZERO-(CW*(C_HOFFSET))
        DW    N_TIB
    DW    0

;

;  **************
;  *   RUBOUT   *
;  **************
;
N_RUBOUT:   DW      6
        DB      "RUBOUT"
RUBOUT:        DW    DOUSE
        DW    (CW*(5))
        DW    0H
        DW    TIB-(CW*(C_HOFFSET))
        DW    N_RUBOUT
    DW    0

;

;  ***************
;  *   WARNING   *
;  ***************
;
N_LWARN:   DW      7
        DB      "WARNING"
LWARN:        DW    DOUSE
        DW    (CW*(7))
        DW    0H
        DW    RUBOUT-(CW*(C_HOFFSET))
        DW    N_LWARN
    DW    0

;

;  *************
;  *   FENCE   *
;  *************
;
N_FENCE:   DW      5
        DB      "FENCE"
FENCE:        DW    DOUSE
        DW    (CW*(8))
        DW    0H
        DW    LWARN-(CW*(C_HOFFSET))
        DW    N_FENCE
    DW    0

;

;  **********
;  *   DP   *
;  **********
;
N_LDP:   DW      2
        DB      "DP"
LDP:        DW    DOUSE
        DW    (CW*(9))
        DW    0H
        DW    FENCE-(CW*(C_HOFFSET))
        DW    N_LDP
    DW    0

;

;  ****************
;  *   VOC-LINK   *
;  ****************
;
N_VOCL:   DW      8
        DB      "VOC-LINK"
VOCL:        DW    DOUSE
        DW    (CW*(10))
        DW    0H
        DW    LDP-(CW*(C_HOFFSET))
        DW    N_VOCL
    DW    0

;

;  **************
;  *   OFFSET   *
;  **************
;
N_LOFFSET:   DW      6
        DB      "OFFSET"
LOFFSET:        DW    DOUSE
        DW    (CW*(11))
        DW    0H
        DW    VOCL-(CW*(C_HOFFSET))
        DW    N_LOFFSET
    DW    0

;
; End of user variables with fixed place.
;
;

;  *************
;  *   WHERE   *
;  *************
;
N_LWHERE:   DW      5
        DB      "WHERE"
LWHERE:        DW    DOUSE
        DW    (CW*(12))
        DW    0H
        DW    LOFFSET-(CW*(C_HOFFSET))
        DW    N_LWHERE
    DW    0
    ;  Occupies two CELLS! 
;

;  ***********
;  *   SCR   *
;  ***********
;
N_SCR:   DW      3
        DB      "SCR"
SCR:        DW    DOUSE
        DW    (CW*(33))
        DW    0H
        DW    LWHERE-(CW*(C_HOFFSET))
        DW    N_SCR
    DW    0

;

;  *************
;  *   STATE   *
;  *************
;
N_STATE:   DW      5
        DB      "STATE"
STATE:        DW    DOUSE
        DW    (CW*(18))
        DW    0H
        DW    SCR-(CW*(C_HOFFSET))
        DW    N_STATE
    DW    0

;

;  ************
;  *   BASE   *
;  ************
;
N_BASE:   DW      4
        DB      "BASE"
BASE:        DW    DOUSE
        DW    (CW*(19))
        DW    0H
        DW    STATE-(CW*(C_HOFFSET))
        DW    N_BASE
    DW    0

;

;  ***********
;  *   DPL   *
;  ***********
;
N_DPL:   DW      3
        DB      "DPL"
DPL:        DW    DOUSE
        DW    (CW*(20))
        DW    0H
        DW    BASE-(CW*(C_HOFFSET))
        DW    N_DPL
    DW    0

;

;  ***********
;  *   FLD   *
;  ***********
;
N_LFLD:   DW      3
        DB      "FLD"
LFLD:        DW    DOUSE
        DW    (CW*(21))
        DW    0H
        DW    DPL-(CW*(C_HOFFSET))
        DW    N_LFLD
    DW    0

;


;  ***********
;  *   CSP   *
;  ***********
;
N_LCSP:   DW      3
        DB      "CSP"
LCSP:        DW    DOUSE
        DW    (CW*(22))
        DW    0H
        DW    LFLD-(CW*(C_HOFFSET))
        DW    N_LCSP
    DW    0

;
;

;  **********
;  *   R#   *
;  **********
;
N_RNUM:   DW      2
        DB      "R#"
RNUM:        DW    DOUSE
        DW    (CW*(23))
        DW    0H
        DW    LCSP-(CW*(C_HOFFSET))
        DW    N_RNUM
    DW    0

;

;  ***********
;  *   HLD   *
;  ***********
;
N_HLD:   DW      3
        DB      "HLD"
HLD:        DW    DOUSE
        DW    (CW*(24))
        DW    0H
        DW    RNUM-(CW*(C_HOFFSET))
        DW    N_HLD
    DW    0

;

;  ***********
;  *   OUT   *
;  ***********
;
N_LOUT:   DW      3
        DB      "OUT"
LOUT:        DW    DOUSE
        DW    (CW*(25))
        DW    0H
        DW    HLD-(CW*(C_HOFFSET))
        DW    N_LOUT
    DW    0

;

;  *************
;  *   (BLK)   *
;  *************
;
N_PBLK:   DW      5
        DB      "(BLK)"
PBLK:        DW    DOUSE
        DW    (CW*(26))
        DW    0H
        DW    LOUT-(CW*(C_HOFFSET))
        DW    N_PBLK
    DW    0

;

;  **********
;  *   IN   *
;  **********
;
N_LIN:   DW      2
        DB      "IN"
LIN:        DW    DOUSE
        DW    (CW*(29))
        DW    0H
        DW    PBLK-(CW*(C_HOFFSET))
        DW    N_LIN
    DW    0

;


;  *************
;  *   (>IN)   *
;  *************
;
N_PIIN:   DW      5
        DB      "(>IN)"
PIIN:        DW    DOUSE
        DW    (CW*(30))
        DW    0H
        DW    LIN-(CW*(C_HOFFSET))
        DW    N_PIIN
    DW    0

;
;

;  ************
;  *   ARGS   *
;  ************
;
N_ARGS:   DW      4
        DB      "ARGS"
ARGS:        DW    DOUSE
        DW    (CW*(31))
        DW    0H
        DW    PIIN-(CW*(C_HOFFSET))
        DW    N_ARGS
    DW    0

;

;  ***************
;  *   HANDLER   *
;  ***************
;
N_HANDLER:   DW      7
        DB      "HANDLER"
HANDLER:        DW    DOUSE
        DW    (CW*(32))
        DW    0H
        DW    ARGS-(CW*(C_HOFFSET))
        DW    N_HANDLER
    DW    0

;

;  ***************
;  *   CURRENT   *
;  ***************
;
N_CURR:   DW      7
        DB      "CURRENT"
CURR:        DW    DOUSE
        DW    (CW*(34))
        DW    0H
        DW    HANDLER-(CW*(C_HOFFSET))
        DW    N_CURR
    DW    0

;

;  *****************
;  *   REMAINDER   *
;  *****************
;
N_REMAIND:   DW      9
        DB      "REMAINDER"
REMAIND:        DW    DOUSE
        DW    (CW*(14))
        DW    0H
        DW    CURR-(CW*(C_HOFFSET))
        DW    N_REMAIND
    DW    0

;      IMPORTANT
; REQUIRES ONE MORE CELL!
;

;  ********************
;  *   SEARCH-ORDER   *
;  ********************
;
N_SEARCH:   DW      12
        DB      "SEARCH-ORDER"
SEARCH:        DW    DOUSE
        DW    (CW*(37))
        DW    0H
        DW    REMAIND-(CW*(C_HOFFSET))
        DW    N_SEARCH
    DW    0
 ; Up to  37+8
;      IMPORTANT
;     8 USER SPACE CELLS MUST BE KEPT FREE
;     IN ADDITION TO THE ONE FOR SEARCH
;
;========== END USER VARIABLES =============;
;

;  **********
;  *   1+   *
;  **********
;
N_ONEP:   DW      2
        DB      "1+"
ONEP:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SEARCH-(CW*(C_HOFFSET))
        DW    N_ONEP
    DW    0

        DW      ONE
        DW      PLUS
        DW      SEMIS
;

;  *************
;  *   CELL+   *
;  *************
;
N_CELLP:   DW      5
        DB      "CELL+"
CELLP:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    ONEP-(CW*(C_HOFFSET))
        DW    N_CELLP
    DW    0

        DW      LIT, CW
        DW      PLUS
        DW      SEMIS
;

;
;  *************
;  *   CELLS   *
;  *************
;
N_LCELLS:   DW      5
        DB      "CELLS"
LCELLS:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    CELLP-(CW*(C_HOFFSET))
        DW    N_LCELLS
    DW    0

        DW      ONE 
        DW      LSHIFT
        DW      SEMIS
;

;  *************
;  *   CHAR+   *
;  *************
;
N_CHARP:   DW      5
        DB      "CHAR+"
CHARP:        DW    DOCOL
        DW    (ONEP+(CW*(PH_OFFSET-C_HOFFSET)))
        DW    0H
        DW    LCELLS-(CW*(C_HOFFSET))
        DW    N_CHARP
    DW    0

;

;  *************
;  *   CHARS   *
;  *************
;
N_CHARS:   DW      5
        DB      "CHARS"
CHARS:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    CHARP-(CW*(C_HOFFSET))
        DW    N_CHARS
    DW    0

        DW      SEMIS
;

;  *************
;  *   ALIGN   *
;  *************
;
N_LALIGN:   DW      5
        DB      "ALIGN"
LALIGN:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    CHARS-(CW*(C_HOFFSET))
        DW    N_LALIGN
    DW    0

        DW      SEMIS
;

;  ***************
;  *   ALIGNED   *
;  ***************
;
N_ALIGNED:   DW      7
        DB      "ALIGNED"
ALIGNED:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LALIGN-(CW*(C_HOFFSET))
        DW    N_ALIGNED
    DW    0

        JMP     NEXT
;

;  ************
;  *   HERE   *
;  ************
;
N_HERE:   DW      4
        DB      "HERE"
HERE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    ALIGNED-(CW*(C_HOFFSET))
        DW    N_HERE
    DW    0

        DW      LDP
        DW      FETCH
        DW      SEMIS
;

;  *************
;  *   ALLOT   *
;  *************
;
N_ALLOT:   DW      5
        DB      "ALLOT"
ALLOT:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    HERE-(CW*(C_HOFFSET))
        DW    N_ALLOT
    DW    0

        DW      LDP
        DW      PSTORE
        DW      SEMIS
;

;  *********
;  *   ,   *
;  *********
;
N_COMMA:   DW      1
        DB      ","
COMMA:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    ALLOT-(CW*(C_HOFFSET))
        DW    N_COMMA
    DW    0

        DW      HERE
        DW      STORE
        DW      TWO
        DW      ALLOT
        DW      SEMIS
;

;  **********
;  *   C,   *
;  **********
;
N_CCOMM:   DW      2
        DB      "C,"
CCOMM:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    COMMA-(CW*(C_HOFFSET))
        DW    N_CCOMM
    DW    0

        DW      HERE
        DW      CSTOR
        DW      ONE
        DW      ALLOT
        DW      SEMIS
;

;  *********
;  *   -   *
;  *********
;
N_LSUB:   DW      1
        DB      "-"
LSUB:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    CCOMM-(CW*(C_HOFFSET))
        DW    N_LSUB
    DW    0

        POP     DX      ;S1
        POP     AX
        SUB     AX,DX
        JMP     APUSH   ;S1 = S2 - S1
;

;  *********
;  *   =   *
;  *********
;
N_EQUAL:   DW      1
        DB      "="
EQUAL:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LSUB-(CW*(C_HOFFSET))
        DW    N_EQUAL
    DW    0

        DW      LSUB
        DW      ZEQU
        DW      SEMIS
;

;  *********
;  *   <   *
;  *********
;
N_LESS:   DW      1
        DB      "<"
LESS:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    EQUAL-(CW*(C_HOFFSET))
        DW    N_LESS
    DW    0

        POP     DX      ;S1
        POP     BX      ;S2
        XOR     AX,AX   ;0 default RESULT
        CMP     BX,DX
        JNL     LES1
        DEC     AX
LES1:   JMP     APUSH
;

;  **********
;  *   U<   *
;  **********
;
N_ULESS:   DW      2
        DB      "U<"
ULESS:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LESS-(CW*(C_HOFFSET))
        DW    N_ULESS
    DW    0

        POP     AX
        POP     DX
        SUB     DX,AX
        SBB     AX,AX
        JMP     APUSH
;

;  *********
;  *   >   *
;  *********
;
N_GREAT:   DW      1
        DB      ">"
GREAT:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    ULESS-(CW*(C_HOFFSET))
        DW    N_GREAT
    DW    0

        DW      SWAP
        DW      LESS
        DW      SEMIS
;

;  **********
;  *   <>   *
;  **********
;
N_UNEQ:   DW      2
        DB      "<>"
UNEQ:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    GREAT-(CW*(C_HOFFSET))
        DW    N_UNEQ
    DW    0

        DW      LSUB
        DW      ZEQU
        DW      ZEQU
        DW      SEMIS
;

;  ***********
;  *   ROT   *
;  ***********
;
N_ROT:   DW      3
        DB      "ROT"
ROT:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    UNEQ-(CW*(C_HOFFSET))
        DW    N_ROT
    DW    0

        POP     DX      ;S1
        POP     BX      ;S2
        POP     AX      ;S3
        PUSH    BX
        JMP     DPUSH
;

;  *************
;  *   SPACE   *
;  *************
;
N_SPACE:   DW      5
        DB      "SPACE"
SPACE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    ROT-(CW*(C_HOFFSET))
        DW    N_SPACE
    DW    0

        DW      LBL
        DW      EMIT
        DW      SEMIS
;

;  ************
;  *   ?DUP   *
;  ************
;
N_QDUP:   DW      4
        DB      "?DUP"
QDUP:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SPACE-(CW*(C_HOFFSET))
        DW    N_QDUP
    DW    0

        DW      LDUP
        DW      ZBRAN
        DW      QDUP1-$-CW ; IF
        DW      LDUP    ;THEN
QDUP1:  DW      SEMIS
;

;  **************
;  *   LATEST   *
;  **************
;
N_LATEST:   DW      6
        DB      "LATEST"
LATEST:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    QDUP-(CW*(C_HOFFSET))
        DW    N_LATEST
    DW    0

        DW      CURR
        DW      FETCH
        DW      TLFA
        DW      FETCH
        DW      SEMIS
;

;  ************
;  *   >CFA   *
;  ************
;
N_TCFA:   DW      4
        DB      ">CFA"
TCFA:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LATEST-(CW*(C_HOFFSET))
        DW    N_TCFA
    DW    0

        DW      LIT, (CW*(C_HOFFSET))
        DW      PLUS
        DW      SEMIS
;

;  ************
;  *   >DFA   *
;  ************
;
N_TDFA:   DW      4
        DB      ">DFA"
TDFA:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    TCFA-(CW*(C_HOFFSET))
        DW    N_TDFA
    DW    0

        DW      LIT, (CW*(D_HOFFSET))
        DW      PLUS
        DW      SEMIS
;

;  ************
;  *   >FFA   *
;  ************
;
N_TFFA:   DW      4
        DB      ">FFA"
TFFA:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    TDFA-(CW*(C_HOFFSET))
        DW    N_TFFA
    DW    0

        DW      LIT, (CW*(F_HOFFSET))
        DW      PLUS
        DW      SEMIS
;

;  ************
;  *   >LFA   *
;  ************
;
N_TLFA:   DW      4
        DB      ">LFA"
TLFA:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    TFFA-(CW*(C_HOFFSET))
        DW    N_TLFA
    DW    0

        DW      LIT, (CW*(L_HOFFSET))
        DW      PLUS
        DW      SEMIS
;

;  ************
;  *   >NFA   *
;  ************
;
N_TNFA:   DW      4
        DB      ">NFA"
TNFA:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    TLFA-(CW*(C_HOFFSET))
        DW    N_TNFA
    DW    0

        DW      LIT,(CW*(N_HOFFSET))
        DW      PLUS
        DW      SEMIS
;


;
;  ************
;  *   >SFA   *
;  ************
;
N_TSFA:   DW      4
        DB      ">SFA"
TSFA:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    TNFA-(CW*(C_HOFFSET))
        DW    N_TSFA
    DW    0

        DW      LIT,(CW*(S_HOFFSET))
        DW      PLUS
        DW      SEMIS
;
;

;  ************
;  *   >PHA   *
;  ************
;
N_TPHA:   DW      4
        DB      ">PHA"
TPHA:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    TSFA-(CW*(C_HOFFSET))
        DW    N_TPHA
    DW    0

        DW      LIT,(CW*(PH_OFFSET))
        DW      PLUS
        DW      SEMIS
;

;  *************
;  *   >BODY   *
;  *************
;
N_TOBODY:   DW      5
        DB      ">BODY"
TOBODY:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    TPHA-(CW*(C_HOFFSET))
        DW    N_TOBODY
    DW    0

        DW      CTOD
        DW      TDFA, FETCH
        DW      CELLP           ; Skip DOES> pointer.
        DW      SEMIS
;

;  *************
;  *   BODY>   *
;  *************
;
N_BODYF:   DW      5
        DB      "BODY>"
BODYF:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    TOBODY-(CW*(C_HOFFSET))
        DW    N_BODYF
    DW    0

        DW      LIT,(CW*(BD_OFFSET))
        DW      LSUB
        DW      SEMIS
;

;  ************
;  *   CFA>   *
;  ************
;
N_CTOD:   DW      4
        DB      "CFA>"
CTOD:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    BODYF-(CW*(C_HOFFSET))
        DW    N_CTOD
    DW    0

        DW      LIT,(CW*(C_HOFFSET))
        DW      LSUB
        DW      SEMIS
;

;  ************
;  *   >WID   *
;  ************
;
N_TWID:   DW      4
        DB      ">WID"
TWID:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    CTOD-(CW*(C_HOFFSET))
        DW    N_TWID
    DW    0

        DW      TOBODY
        DW      CELLP ; Skip vfa link.
        DW      SEMIS
;

;  ************
;  *   >VFA   *
;  ************
;
N_TVFA:   DW      4
        DB      ">VFA"
TVFA:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    TWID-(CW*(C_HOFFSET))
        DW    N_TVFA
    DW    0

        DW      TOBODY
        DW      SEMIS
;


;  ************
;  *   !CSP   *
;  ************
;
N_SCSP:   DW      4
        DB      "!CSP"
SCSP:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    TVFA-(CW*(C_HOFFSET))
        DW    N_SCSP
    DW    0

        DW      SPFET
        DW      LCSP
        DW      STORE
        DW      SEMIS
;
;

;  **************
;  *   ?ERROR   *
;  **************
;
N_QERR:   DW      6
        DB      "?ERROR"
QERR:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SCSP-(CW*(C_HOFFSET))
        DW    N_QERR
    DW    0

        DW      SWAP
        DW      ZBRAN
        DW      QERR1-$-CW ;IF
        DW      LIN, FETCH
        DW      SRC, FETCH
        DW      LWHERE, TSTOR
        DW      THROW
        DW      BRAN
        DW      QERR2-$-CW  ;ELSE
QERR1:  DW      DROP    ;THEN
QERR2:  DW      SEMIS
;

;  **************
;  *   ?ERRUR   *
;  **************
;
N_QERRUR:   DW      6
        DB      "?ERRUR"
QERRUR:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    QERR-(CW*(C_HOFFSET))
        DW    N_QERRUR
    DW    0

        DW      ZERO, MIN, LDUP, QERR
        DW      SEMIS
;


;  **************
;  *   ?DELIM   *
;  **************
;
N_QDELIM:   DW      6
        DB      "?DELIM"
QDELIM:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    QERRUR-(CW*(C_HOFFSET))
        DW    N_QDELIM
    DW    0

        DW      INBRS
        DW      QBL
        DW      ZEQU
        DW      LIT, 10, QERR
        DW      DROP
        DW      SEMIS
;

;  ************
;  *   ?CSP   *
;  ************
;
N_QCSP:   DW      4
        DB      "?CSP"
QCSP:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    QDELIM-(CW*(C_HOFFSET))
        DW    N_QCSP
    DW    0

        DW      SPFET
        DW      LCSP
        DW      FETCH
        DW      LSUB
        DW      LIT, 20, QERR
        DW      SEMIS
;

;  *************
;  *   ?COMP   *
;  *************
;
N_QCOMP:   DW      5
        DB      "?COMP"
QCOMP:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    QCSP-(CW*(C_HOFFSET))
        DW    N_QCOMP
    DW    0

        DW      STATE
        DW      FETCH
        DW      ZEQU
        DW      LIT, 17, QERR
        DW      SEMIS
;

;  *************
;  *   ?EXEC   *
;  *************
;
N_QEXEC:   DW      5
        DB      "?EXEC"
QEXEC:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    QCOMP-(CW*(C_HOFFSET))
        DW    N_QEXEC
    DW    0

        DW      STATE
        DW      FETCH
        DW      LIT, 18, QERR
        DW      SEMIS
;

;  **************
;  *   ?PAIRS   *
;  **************
;
N_QPAIR:   DW      6
        DB      "?PAIRS"
QPAIR:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    QEXEC-(CW*(C_HOFFSET))
        DW    N_QPAIR
    DW    0

        DW      LSUB
        DW      LIT, 19, QERR
        DW      SEMIS
;


;  ****************
;  *   ?LOADING   *
;  ****************
;
N_QLOAD:   DW      8
        DB      "?LOADING"
QLOAD:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    QPAIR-(CW*(C_HOFFSET))
        DW    N_QLOAD
    DW    0

        DW      BLK
        DW      FETCH
        DW      ZEQU
        DW      LIT, 22, QERR
        DW      SEMIS
;
;
;
;

;  *********
;  *   [   *
;  *********
;
N_LBRAC:   DW      1
        DB      "["
LBRAC:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    QLOAD-(CW*(C_HOFFSET))
        DW    N_LBRAC
    DW    0

        DW      ZERO
        DW      STATE
        DW      STORE
        DW      SEMIS
;

;  *********
;  *   ]   *
;  *********
;
N_RBRAC:   DW      1
        DB      "]"
RBRAC:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LBRAC-(CW*(C_HOFFSET))
        DW    N_RBRAC
    DW    0

        DW      ONE
        DW      STATE
        DW      STORE
        DW      SEMIS
;

;  **************
;  *   HIDDEN   *
;  **************
;
N_HIDDEN:   DW      6
        DB      "HIDDEN"
HIDDEN:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    RBRAC-(CW*(C_HOFFSET))
        DW    N_HIDDEN
    DW    0

        DW      TFFA
        DW      LIT,B_INVIS
        DW      TOGGL
        DW      SEMIS
;

;  ***********
;  *   HEX   *
;  ***********
;
N_HEX:   DW      3
        DB      "HEX"
HEX:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    HIDDEN-(CW*(C_HOFFSET))
        DW    N_HEX
    DW    0

        DW      LIT,16
        DW      BASE
        DW      STORE
        DW      SEMIS
;

;  ***************
;  *   DECIMAL   *
;  ***************
;
N_DECA:   DW      7
        DB      "DECIMAL"
DECA:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    HEX-(CW*(C_HOFFSET))
        DW    N_DECA
    DW    0

        DW      LIT,10
        DW      BASE
        DW      STORE
        DW      SEMIS
;

;  ***************
;  *   (;CODE)   *
;  ***************
;
N_PSCOD:   DW      7
        DB      "(;CODE)"
PSCOD:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    DECA-(CW*(C_HOFFSET))
        DW    N_PSCOD
    DW    0

        DW      FROMR
        DW      LATEST
        DW      TCFA
        DW      STORE
        DW      SEMIS
;

;

;  **************
;  *   CREATE   *
;  **************
;
N_CREATE:   DW      6
        DB      "CREATE"
CREATE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PSCOD-(CW*(C_HOFFSET))
        DW    N_CREATE
    DW    0

        DW      LPWORD
        DW      PCREAT
        DW      LIT, HLNOOP, COMMA
        DW      PSCOD
DODOE:  LEA     BP,[BP - (CW*(1))] ;Push HIP.
        MOV     [BP],SI
        MOV     SI,[BX+(CW*((D_HOFFSET-C_HOFFSET)))] ;NEW IP 
        LEA     AX,[SI+(CW*(1))]
        MOV     SI,[SI]
        JMP     APUSH
HLNOOP: DW      SEMIS
;

;  *************
;  *   DOES>   *
;  *************
;
N_DOES:   DW      5
        DB      "DOES>"
DOES:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    CREATE-(CW*(C_HOFFSET))
        DW    N_DOES
    DW    0

        DW      FROMR
        DW      LATEST
        DW      TDFA
        DW      FETCH
        DW      STORE
        DW      SEMIS
;

;  *************
;  *   COUNT   *
;  *************
;
N_COUNT:   DW      5
        DB      "COUNT"
COUNT:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    DOES-(CW*(C_HOFFSET))
        DW    N_COUNT
    DW    0

        DW      LDUP
        DW      ONEP
        DW      SWAP
        DW      CFET
        DW      SEMIS
;

;  *****************
;  *   -TRAILING   *
;  *****************
;
N_DTRAI:   DW      9
        DB      "-TRAILING"
DTRAI:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    COUNT-(CW*(C_HOFFSET))
        DW    N_DTRAI
    DW    0

        DW      LDUP
        DW      ZERO
        DW     XQDO
        DW      DTRA4-$-CW
DTRA1:  DW      OVER
        DW      OVER
        DW      PLUS
        DW      ONE
        DW      LSUB
        DW      CFET
        DW      QBL
        DW      ZEQU
        DW      ZBRAN
        DW      DTRA2-$-CW ;IF
        DW      LLEAV
DTRA2:  DW      ONE
        DW      LSUB    ; THEN
        DW     XLOOP
        DW      DTRA1-$-CW    ; LOOP
DTRA4:
        DW      SEMIS
;


;  **********
;  *   S"   *
;  **********
;
N_SQUOT:   DW      2
        DB      'S"'
SQUOT:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    DTRAI-(CW*(C_HOFFSET))
        DW    N_SQUOT
    DW    0

        DW      DENQ
        DW      SEMIS
;
;

;  **********
;  *   ."   *
;  **********
;
N_DOTQ:   DW      2
        DB      '."'
DOTQ:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    SQUOT-(CW*(C_HOFFSET))
        DW    N_DOTQ
    DW    0

        DW      DENQ
        DW      STATE
        DW      FETCH
        DW      ZBRAN
        DW      DOTQ1-$-CW ; IF
        DW      LIT, LTYPE, COMMA
        DW      BRAN
        DW      DOTQ2-$-CW
DOTQ1:
        DW      LTYPE
DOTQ2:
        DW      SEMIS   ; THEN
;

;  **********
;  *   .(   *
;  **********
;
N_DOTP:   DW      2
        DB      ".("
DOTP:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    DOTQ-(CW*(C_HOFFSET))
        DW    N_DOTP
    DW    0

        DW      LIT, ')'
        DW      PPARS
        DW      LTYPE
        DW      SEMIS
;

;  ***************
;  *   SET-SRC   *
;  ***************
;
N_SETSRC:   DW      7
        DB      "SET-SRC"
SETSRC:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    DOTP-(CW*(C_HOFFSET))
        DW    N_SETSRC
    DW    0

        DW      OVER, PLUS
        DW      SWAP, SRC, TSTOR
        DW      SRC, FETCH
        DW      LIN, STORE ;  IN

;       DW      DOTS
        DW      SEMIS
;

;  ****************
;  *   EVALUATE   *
;  ****************
;
N_EVALUATE:   DW      8
        DB      "EVALUATE"
EVALUATE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SETSRC-(CW*(C_HOFFSET))
        DW    N_EVALUATE
    DW    0

        DW      SAVE
        DW      SETSRC
        DW      LIT, INTER, CATCH
        DW      RESTO
        DW      THROW
        DW      SEMIS
;

;  ************
;  *   FILL   *
;  ************
;
N_FILL:   DW      4
        DB      "FILL"
FILL:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    EVALUATE-(CW*(C_HOFFSET))
        DW    N_FILL
    DW    0

        POP     AX      ; FILL CHAR
        POP     CX      ; FILL COUNT
        POP     DI      ; BEGIN ADDR
;       MOV    BX,DS
;       MOV    ES,BX   ; ES <- DS
        CLD             ; INC DIRECTION
        REP     STOSB   ;STORE BYTE
        JMP     NEXT
;

;  ************
;  *   CORA   *
;  ************
;
N_CORA:   DW      4
        DB      "CORA"
CORA:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    FILL-(CW*(C_HOFFSET))
        DW    N_CORA
    DW    0

;       MOV    ES,BX   ; ES <- DS
;       MOV    BX,DS
        MOV     DX,SI   ;SAVE
        XOR     AX,AX   ; Result
        POP     CX      ; count
        POP     DI      ; addr2
        POP     SI      ; addr1
        CLD             ; INC DIRECTION
        REP     CMPSB   ; Compare BYTE
        JZ      CORA3
        MOV     AL,1    ;Remainder is already 0
        JNC     CORA3
        NEG     AX
CORA3:
        MOV     SI,DX  ;Restore
        JMP     APUSH
;

;  **********
;  *   $I   *
;  **********
;
N_SINDEX:   DW      2
        DB      "$I"
SINDEX:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    CORA-(CW*(C_HOFFSET))
        DW    N_SINDEX
    DW    0

;       MOV    ES,BX   ; ES <- DS
;       MOV    BX,DS
        POP     AX      ; char
        POP     CX      ; count
        POP     DI      ; addr
        OR      DI,DI   ;Clear zero flag.
        CLD             ; INC DIRECTION
        REPNZ     SCASB   ; Compare BYTE
        JZ      SINDEX1
        XOR     DI,DI    ;Not found: 0
        INC     DI
SINDEX1:
        DEC     DI
        PUSH    DI
        JMP     NEXT
;

;  **********
;  *   $S   *
;  **********
;
N_SSPLIT:   DW      2
        DB      "$S"
SSPLIT:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SINDEX-(CW*(C_HOFFSET))
        DW    N_SSPLIT
    DW    0

;       MOV    ES,BX   ; ES <- DS
;       MOV    BX,DS
        POP     AX      ; char
        POP     CX      ; count
        MOV     BX,CX
        POP     DI      ; addr
        OR      DI,DI   ;Clear zero flag.
        MOV     DX,DI   ; Copy
        CLD             ; INC DIRECTION
        REPNZ     SCASB   ; Compare BYTE
        JZ      SSPLIT1
; Not present.
        PUSH    CX   ; Nil pointer.
        JMP SSPLIT2
SSPLIT1:
        PUSH    DI
        SUB     BX,CX
        DEC     BX      ;Delimiter is not part of first string.
SSPLIT2:
        PUSH    CX   ;Remaining length
        PUSH    DX   ;Start of first string.
        PUSH    BX   ;Skipped length.
        JMP     NEXT
;

;  *************
;  *   ERASE   *
;  *************
;
N_LERASE:   DW      5
        DB      "ERASE"
LERASE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SSPLIT-(CW*(C_HOFFSET))
        DW    N_LERASE
    DW    0

        DW      ZERO
        DW      FILL
        DW      SEMIS
;


;  *************
;  *   BLANK   *
;  *************
;
N_BLANK:   DW      5
        DB      "BLANK"
BLANK:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LERASE-(CW*(C_HOFFSET))
        DW    N_BLANK
    DW    0

        DW      LBL
        DW      FILL
        DW      SEMIS
;
;

;  ************
;  *   HOLD   *
;  ************
;
N_HOLD:   DW      4
        DB      "HOLD"
HOLD:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    BLANK-(CW*(C_HOFFSET))
        DW    N_HOLD
    DW    0

        DW      LIT,-1
        DW      HLD
        DW      PSTORE
        DW      HLD
        DW      FETCH
        DW      CSTOR
        DW      SEMIS
;

;  ***********
;  *   PAD   *
;  ***********
;
N_PAD:   DW      3
        DB      "PAD"
PAD:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    HOLD-(CW*(C_HOFFSET))
        DW    N_PAD
    DW    0

        DW      HERE
; Allow for a one line name, a double binary number and some hold char's
        DW      LIT,84+128+64
        DW      PLUS
        DW      SEMIS
;


;  ************
;  *   WORD   *
;  ************
;
N_IWORD:   DW      4
        DB      "WORD"
IWORD:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PAD-(CW*(C_HOFFSET))
        DW    N_IWORD
    DW    0

        DW      LDUP, LBL, EQUAL
        DW      ZBRAN
        DW      IWORD1-$-CW
         DW      DROP
         DW      LPWORD
        DW      BRAN
        DW      IWORD2-$-CW
IWORD1: DW      TOR
IWORD3:  DW      INBRS, RR, EQUAL
        DW      ZBRAN
        DW      IWORD4-$-CW
        DW      DROP
        DW      BRAN
        DW      IWORD3-$-CW
IWORD4:
        DW      DROP
        DW      LIT, -1, LIN, PSTORE ; Backtrace to first non-delimiter.
        DW      FROMR, PPARS
;        DW      DOTS
IWORD2:
        DW      HERE
        DW      LIT,22H
        DW      BLANK
        DW      HERE
        DW      SSTORBD     ; FIXME
        DW      HERE
;        DW      DOTS
        DW      SEMIS
;
;

;  ************
;  *   CHAR   *
;  ************
;
N_LCHAR:   DW      4
        DB      "CHAR"
LCHAR:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    IWORD-(CW*(C_HOFFSET))
        DW    N_LCHAR
    DW    0

        DW      LPWORD, DROP, CFET
        DW      SEMIS
;

;  **************
;  *   [CHAR]   *
;  **************
;
N_BCHAR:   DW      6
        DB      "[CHAR]"
BCHAR:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    LCHAR-(CW*(C_HOFFSET))
        DW    N_BCHAR
    DW    0

        DW      LCHAR, LITER
        DW      SEMIS
;

;  ****************
;  *   (NUMBER)   *
;  ****************
;
N_PNUMB:   DW      8
        DB      "(NUMBER)"
PNUMB:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    BCHAR-(CW*(C_HOFFSET))
        DW    N_PNUMB
    DW    0

        DW      ZERO, ZERO
        DW      ZERO, DPL, STORE
NPNUM1:  DW      INBRS   ; BEGIN
        DW      LDUP, LIT, ADOT, EQUAL
        DW      ZBRAN
        DW      NPNUM2A-$-CW ; IF
        DW      DROP, DPL, STORE, ZERO
        DW      BRAN
        DW      NPNUM3-$-CW ; ELSE
NPNUM2A:
        DW      LDUP, LIT, ',', EQUAL
        DW      ZBRAN
        DW      NPNUM2-$-CW ; IF
        DW      TDROP, ZERO
        DW      BRAN
        DW      NPNUM3-$-CW ; ELSE
NPNUM2:
        DW      LDUP, QBL
        DW      ZBRAN
        DW      NPNUM4-$-CW ; IF
        DW      DROP, DROP, ONE
        DW      BRAN
        DW      NPNUM3-$-CW ; ELSE
NPNUM4:
        DW      SWAP, DROP
        DW      BASE, FETCH, DIGIT
        DW      ZEQU
        DW      LIT, 10, QERR

        DW      SWAP
        DW      BASE
        DW      FETCH
        DW      USTAR
        DW      DROP
        DW      ROT
        DW      BASE
        DW      FETCH
        DW      USTAR
        DW      DPLUS
        DW      ZERO
NPNUM3:                 ; THEN THEN
        DW      ZBRAN
        DW      NPNUM1-$-CW
        DW      SEMIS
;

;  **************
;  *   NUMBER   *
;  **************
;
N_NUMB:   DW      6
        DB      "NUMBER"
NUMB:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PNUMB-(CW*(C_HOFFSET))
        DW    N_NUMB
    DW    0

LNUMB:
        DW      LIT, -1, LIN, PSTORE
        DW      PNUMB, SDLITE
        DW      SEMIS
;


;  ***************
;  *   >NUMBER   *
;  ***************
;
N_TONUMB:   DW      7
        DB      ">NUMBER"
TONUMB:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    NUMB-(CW*(C_HOFFSET))
        DW    N_TONUMB
    DW    0

        DW      TDUP, PLUS, TOR     ; End available on return stack.
        DW      ZERO
        DW     XQDO
        DW      TONUM9-$-CW
TONUM1:
        DW      LDUP, CFET, BASE, FETCH, DIGIT
        DW      ZEQU
        DW      ZBRAN
        DW      TONUM4-$-CW ; IF
        DW      DROP
        DW      LLEAV
TONUM4:
        DW      SWAP, TOR ; Address out of the way.
        DW      SWAP
        DW      BASE
        DW      FETCH
        DW      USTAR
        DW      DROP
        DW      ROT
        DW      BASE
        DW      FETCH
        DW      USTAR
        DW      DPLUS
        DW      FROMR, ONEP     ; Address back.
        DW     XLOOP
        DW      TONUM1-$-CW
TONUM9:
        DW      FROMR
        DW      OVER, LSUB
        DW      SEMIS
;
;

;  *************
;  *   FOUND   *
;  *************
;
N_FOUND:   DW      5
        DB      "FOUND"
FOUND:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    TONUMB-(CW*(C_HOFFSET))
        DW    N_FOUND
    DW    0

        DW      SEARCH, TOR
FOUND1: DW      RR, FETCH
;        DW      DOTS
        DW      PFIND, LDUP, ZEQU
        DW      ZBRAN
        DW      FOUND3-$-CW
        DW      DROP
        DW      RR, FETCH, LIT, FORTH, LSUB ;Was this ONLY?
        DW      ZBRAN
        DW      FOUND2-$-CW
        DW      FROMR, CELLP, TOR
        DW      BRAN
        DW      FOUND1-$-CW
FOUND2: DW      ZERO
FOUND3: DW      RDROP
        DW      SWAP,DROP,SWAP,DROP
        DW      SEMIS
;

;  ***************
;  *   PRESENT   *
;  ***************
;
N_PRESENT:   DW      7
        DB      "PRESENT"
PRESENT:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    FOUND-(CW*(C_HOFFSET))
        DW    N_PRESENT
    DW    0

        DW      LDUP, TOR
        DW      FOUND
        DW      LDUP
        DW      ZBRAN
        DW      PRES1-$-CW
        DW      LDUP
        DW      TNFA, FETCH, FETCH ;  Get precise length.
        DW      RR, EQUAL
        DW      LAND
PRES1:
        DW      RDROP
        DW      SEMIS
;


;  ************
;  *   FIND   *
;  ************
;
N_FIND:   DW      4
        DB      "FIND"
FIND:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PRESENT-(CW*(C_HOFFSET))
        DW    N_FIND
    DW    0

        DW      LDUP, COUNT, PRESENT
        DW      LDUP
        DW      ZBRAN
        DW      FIND1-$-CW ;IF
        DW      SWAP, DROP ; The address.
        ; Fine point, get xt by TCFA. Even if a NOOP.
        DW      LDUP, TCFA, SWAP
        DW      TFFA, FETCH
        DW      LIT, B_IMMED, LAND
        DW      LIT, -1, SWAP
        DW      ZBRAN
        DW      FIND1-$-CW ;IF
        DW      NEGATE
FIND1:               ;THEN THEN
        DW      SEMIS
;

;  **************
;  *   (FIND)   *
;  **************
;
N_PFIND:   DW      6
        DB      "(FIND)"
PFIND:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    FIND-(CW*(C_HOFFSET))
        DW    N_PFIND
    DW    0

PFIND0:
        DW      LDUP
        DW      ZBRAN
        DW      PFIND1-$-CW
        DW      PMATCH, ZEQU
        DW      ZBRAN
        DW      PFIND1-$-CW
        DW     TLFA, FETCH
        DW      BRAN
        DW      PFIND0-$-CW
PFIND1:
        DW      SEMIS
;

;  *************
;  *   ERROR   *
;  *************
;
N_ERROR:   DW      5
        DB      "ERROR"
ERROR:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PFIND-(CW*(C_HOFFSET))
        DW    N_ERROR
    DW    0

        DW      LWHERE, TFET
        DW      OVER, LIT, 20, LSUB
        DW      MAX
        DW      SWAP,OVER, LSUB
        DW      LTYPE
        DW      SKIP
         DW      18
SB3: DB      "? ciforth ERROR # "
       
        DW      LIT, SB3
        DW      LIT, 18
        DW      LTYPE
        DW      BASE, FETCH
        DW      DECA
        DW      OVER
        DW      STOD, ZERO, PDDOTR      ;This is about (.) 
        DW      LTYPE
        DW      BASE, STORE
        DW      MESS
        DW      SEMIS
;

;  *************
;  *   CATCH   *
;  *************
;
N_CATCH:   DW      5
        DB      "CATCH"
CATCH:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    ERROR-(CW*(C_HOFFSET))
        DW    N_CATCH
    DW    0

        DW      SPFET, CELLP, TOR
        DW      HANDLER, FETCH, TOR
        DW      RPFET, HANDLER, STORE
        DW      EXEC
        DW      FROMR, HANDLER, STORE
        DW      RDROP, ZERO
        DW      SEMIS
;

;  *************
;  *   THROW   *
;  *************
;
N_THROW:   DW      5
        DB      "THROW"
THROW:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    CATCH-(CW*(C_HOFFSET))
        DW    N_THROW
    DW    0

        DW      LDUP
        DW      ZBRAN
        DW      THROW1-$-CW
        DW      HANDLER, FETCH, ZEQU
        DW      ZBRAN
        DW      THROW2-$-CW
        DW      ERROR
        DW      MTBUF  ; A (too) crude way to remove locks
        DW      SZERO, FETCH, SPSTO
        DW      QUIT
THROW2:
        DW      HANDLER, FETCH, RPSTO
        DW      FROMR, HANDLER, STORE
        DW      FROMR, SWAP, TOR
        DW      SPSTO
        DW      FROMR
        DW      X
THROW1:
        DW      DROP
        DW      SEMIS
;


;  ****************
;  *   (ABORT")   *
;  ****************
;
N_PABORTQ:   DW      8
        DB      '(ABORT")'
PABORTQ:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    THROW-(CW*(C_HOFFSET))
        DW    N_PABORTQ
    DW    0

        DW      ROT
        DW      ZBRAN
        DW      PABQ1-$-CW ;IF
        DW      LTYPE
        DW      SIGNON, ABORT
        DW      BRAN
        DW      PABQ2-$-CW ;ELSE
PABQ1:  DW       TDROP
PABQ2:   DW      SEMIS
;

;  **************
;  *   ABORT"   *
;  **************
;
N_ABORTQ:   DW      6
        DB      'ABORT"'
ABORTQ:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    PABORTQ-(CW*(C_HOFFSET))
        DW    N_ABORTQ
    DW    0

        DW      QCOMP
        DW      DENQ
        DW      LIT, PABORTQ, COMMA
        DW      SEMIS
;
;

;  ***********
;  *   ID.   *
;  ***********
;
N_IDDOT:   DW      3
        DB      "ID."
IDDOT:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    ABORTQ-(CW*(C_HOFFSET))
        DW    N_IDDOT
    DW    0

        DW      LDUP, TFFA
        DW      FETCH, LIT, B_DUMMY, LXOR
        DW      ZBRAN
        DW      IDDOT1-$-CW
        DW      TNFA
        DW      FETCH
        DW      SFET
        DW      LTYPE
        DW      SPACE
        DW      SPACE
        DW      SPACE
        DW      BRAN
        DW      IDDOT2-$-CW
IDDOT1:
        DW      DROP
IDDOT2:
        DW      SEMIS
;

;  ****************
;  *   (CREATE)   *
;  ****************
;
N_PCREAT:   DW      8
        DB      "(CREATE)"
PCREAT:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    IDDOT-(CW*(C_HOFFSET))
        DW    N_PCREAT
    DW    0

        DW      LDUP
        DW      ZEQU
        DW      LIT, 5, QERR
        DW      TDUP
        DW      PRESENT
        DW      LDUP
        DW      ZBRAN
        DW      CREA1-$-CW ;IF
        DW      TNFA, FETCH, SFET
        DW      LTYPE
        DW      LIT,4
        DW      MESS
        DW      X       ;THEN
CREA1:  DW      DROP
        DW      SCOMMA
        DW      HERE,TOR

        DW      RR, TPHA, COMMA         ; Code field.

        DW      RR, TPHA, COMMA         ; Data field.

        DW      ZERO, COMMA ; Flag field.

        DW      CURR, FETCH, TLFA
        DW      LDUP, FETCH, COMMA   ; Link field.
        DW      RR, SWAP, STORE

        DW      COMMA   ; Name field.


        DW      BLK, FETCH, LDUP, ZEQU
        DW      ZBRAN
        DW      CREA2-$-CW
        DW      DROP, LIN, FETCH
CREA2:  DW      COMMA  ; Source field.

        DW      RDROP
        DW      SEMIS
;

;  *****************
;  *   [COMPILE]   *
;  *****************
;
N_BCOMP:   DW      9
        DB      "[COMPILE]"
BCOMP:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    PCREAT-(CW*(C_HOFFSET))
        DW    N_BCOMP
    DW    0

        DW      LPWORD
        DW      PRESENT
        DW      LDUP
        DW      ZEQU
        DW      LIT, 16, QERR
        DW      TCFA
        DW      COMMA
        DW      SEMIS
;

;  ****************
;  *   POSTPONE   *
;  ****************
;
N_POSTP:   DW      8
        DB      "POSTPONE"
POSTP:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    BCOMP-(CW*(C_HOFFSET))
        DW    N_POSTP
    DW    0

        DW      LPWORD
        DW      PRESENT
        DW      LDUP
        DW      ZEQU
        DW      LIT, 15, QERR
        DW      LDUP, TFFA, FETCH
        DW      LIT, B_IMMED, LAND, ZEQU
        DW      ZBRAN
        DW      POSTP1-$-CW
         DW      LIT, LIT, COMMA
         DW      COMMA
         DW      LIT, COMMA, COMMA
        DW      BRAN
        DW      POSTP2-$-CW
POSTP1:
         DW      COMMA
POSTP2:
        DW      SEMIS
;

;  ***************
;  *   LITERAL   *
;  ***************
;
N_LITER:   DW      7
        DB      "LITERAL"
LITER:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    POSTP-(CW*(C_HOFFSET))
        DW    N_LITER
    DW    0

        DW      STATE
        DW      FETCH
        DW      ZBRAN
        DW      LITE1-$-CW ;IF
        DW      LIT, LIT, COMMA
        DW      COMMA   ;THEN
LITE1:  DW      SEMIS
;

;  ****************
;  *   DLITERAL   *
;  ****************
;
N_DLITE:   DW      8
        DB      "DLITERAL"
DLITE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    LITER-(CW*(C_HOFFSET))
        DW    N_DLITE
    DW    0

        DW      STATE
        DW      FETCH
        DW      ZBRAN
        DW      DLIT1-$-CW ; IF
        DW      SWAP
        DW      LITER
        DW      LITER   ; THEN
DLIT1:  DW      SEMIS
;
;

;  *****************
;  *   SDLITERAL   *
;  *****************
;
N_SDLITE:   DW      9
        DB      "SDLITERAL"
SDLITE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    DLITE-(CW*(C_HOFFSET))
        DW    N_SDLITE
    DW    0

        DW      DPL
        DW      FETCH
        DW      ZBRAN
        DW      SDLIT1-$-CW ; IF
        DW      DLITE
        DW      BRAN
        DW      SDLIT2-$-CW ; IF
SDLIT1:
        DW      DROP, LITER
SDLIT2:
        DW      SEMIS
;


;  **************
;  *   ?STACK   *
;  **************
;
N_QSTAC:   DW      6
        DB      "?STACK"
QSTAC:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SDLITE-(CW*(C_HOFFSET))
        DW    N_QSTAC
    DW    0

        DW      SPFET
        DW      SZERO
        DW      FETCH
        DW      SWAP
        DW      ULESS
        DW      ONE, QERR
        DW      SPFET
        DW      HERE
        DW      LIT,80H
        DW      PLUS
        DW      ULESS
        DW      LIT, 7, QERR
        DW      SEMIS
        ;
;
;

;  *****************
;  *   INTERPRET   *
;  *****************
;
N_INTER:   DW      9
        DB      "INTERPRET"
INTER:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    QSTAC-(CW*(C_HOFFSET))
        DW    N_INTER
    DW    0

INTE1:
        DW      LPWORD
        DW      LDUP      ; Zero length.
        DW      ZBRAN
        DW      INTE8-$-CW ;WHILE
;       DW      DOTS
;       DW      TDUP, LTYPE
        DW      OVER, TOR       ; Save old parse pointer.
        DW      FOUND
        DW      LDUP, ZEQU
        DW      LIT, 12, QERR
        DW      LDUP, TFFA, FETCH
        DW      LDUP, LIT, B_DENOT, LAND ;Retain copy of flags.
        DW      ZBRAN
        DW      INTE3B-$-CW ;IF
        DW      OVER, TNFA, FETCH, FETCH
        DW      RR, PLUS, LIN, STORE  ;Skip over prefix.
INTE3B:                  ;THEN 
        DW      RDROP           ; Drop old parse pointer.
        DW      LIT, B_IMMED, LAND
        DW      STATE, FETCH, ZEQU, LOR
        DW      ZBRAN
        DW      INTE3-$-CW ;IF
        DW      EXEC
        DW      BRAN
        DW      INTE4-$-CW ;IF
INTE3:
        DW      COMMA
                        ;THEN
INTE4:
        DW      QSTAC
        DW      BRAN
        DW      INTE1-$-CW  ;AGAIN
INTE8:  DW      DROP, DROP
        DW      SEMIS
;

;  *****************
;  *   IMMEDIATE   *
;  *****************
;
N_IMMED:   DW      9
        DB      "IMMEDIATE"
IMMED:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    INTER-(CW*(C_HOFFSET))
        DW    N_IMMED
    DW    0

        DW      LATEST
        DW      TFFA
        DW      LIT, B_IMMED
        DW      TOGGL
        DW      SEMIS
;

;  ******************
;  *   VOCABULARY   *
;  ******************
;
N_VOCAB:   DW      10
        DB      "VOCABULARY"
VOCAB:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    IMMED-(CW*(C_HOFFSET))
        DW    N_VOCAB
    DW    0

        DW      CREATE
        DW      LATEST   ; Link this DEA into VOC-LINK chain.
        DW      VOCL
        DW      FETCH
        DW      COMMA
        DW      VOCL
        DW      STORE
        DW      ZERO, COMMA   ; Dummy code field
        DW      ZERO, COMMA   ; Dummy data field
        DW      LIT, B_DUMMY, COMMA ; Dummy flag field
        DW      ZERO, COMMA ;Links to the word FORTH

        DW      DOES
DOVOC:
        DW      ALSO
        DW      CELLP   ; Make it a WID. 
        DW      SEARCH
        DW      STORE
        DW      SEMIS
        ;
;
;   The link to task is a cold start value only.
;   It is updated each time a definition is
;   appended to the 'FORTH' vocabulary.
;

;

;  *******************
;  *   DEFINITIONS   *
;  *******************
;
N_DEFIN:   DW      11
        DB      "DEFINITIONS"
DEFIN:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    VOCAB-(CW*(C_HOFFSET))
        DW    N_DEFIN
    DW    0

        DW      SEARCH
        DW      FETCH
        DW      CURR
        DW      STORE
        DW      SEMIS
;

;  ************
;  *   ALSO   *
;  ************
;
N_ALSO:   DW      4
        DB      "ALSO"
ALSO:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    DEFIN-(CW*(C_HOFFSET))
        DW    N_ALSO
    DW    0

        DW      SEARCH, LDUP, CELLP
        DW      LIT, (CW*(8-1))
        DW      LMOVE
        DW      LIT, FORTH  ;End sentinel for array of word lists.
        DW      SEARCH, LIT, (CW*(8)), PLUS
        DW      STORE ;Trim sets of wordset.
        DW      SEMIS
;

;  ****************
;  *   PREVIOUS   *
;  ****************
;
N_PREVI:   DW      8
        DB      "PREVIOUS"
PREVI:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    ALSO-(CW*(C_HOFFSET))
        DW    N_PREVI
    DW    0

        DW      SEARCH, LDUP, CELLP, SWAP
        DW      LIT, (CW*(8))
        DW      LMOVE
        DW      SEMIS
;

;  ************
;  *   ONLY   *
;  ************
;
N_ONLY:   DW      4
        DB      "ONLY"
ONLY:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PREVI-(CW*(C_HOFFSET))
        DW    N_ONLY
    DW    0

        DW      LIT, FORTH, SEARCH, STORE
        DW      SEARCH, LDUP, CELLP
        DW      LIT, (CW*(8-1))
        DW      LCMOVE
        DW      SEMIS
;

;  *********
;  *   (   *
;  *********
;
N_PAREN:   DW      1
        DB      "("
PAREN:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    ONLY-(CW*(C_HOFFSET))
        DW    N_PAREN
    DW    0

        DW      LIT,')'
        DW      PPARS
        DW      TDROP
        DW      SEMIS
;
;

;  *********
;  *   \   *
;  *********
;
N_BACKS:   DW      1
        DB      "\"
BACKS:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    PAREN-(CW*(C_HOFFSET))
        DW    N_BACKS
    DW    0

        DW      LIT,ALF
        DW      PPARS
        DW      TDROP
        DW      SEMIS
;

;  ************
;  *   QUIT   *
;  ************
;
N_QUIT:   DW      4
        DB      "QUIT"
QUIT:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    BACKS-(CW*(C_HOFFSET))
        DW    N_QUIT
    DW    0

        DW      LBRAC
QUIT1:                  ;BEGIN
        DW      RZERO
        DW      FETCH
        DW      RPSTO
        
        DW      PACCEP
;
        DW       SETSRC
        DW      INTER
        DW      OK
        DW      BRAN
        DW      QUIT1-$-CW  ;AGAIN
        DW      SEMIS   ;Unnecessary, but helpful for decompilation.
;

;  **********
;  *   OK   *
;  **********
;
N_OK:   DW      2
        DB      "OK"
OK:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    QUIT-(CW*(C_HOFFSET))
        DW    N_OK
    DW    0

        DW      STATE
        DW      FETCH
        DW      ZEQU
        DW      ZBRAN
        DW      OK2-$-CW ;IF
        DW      SKIP
         DW      3
SB4: DB      " OK"
       
        DW      LIT, SB4
        DW      LIT, 3
        DW      LTYPE
        DW      CR
OK2:
        DW      SEMIS
;

;  *************
;  *   ABORT   *
;  *************
;
N_ABORT:   DW      5
        DB      "ABORT"
ABORT:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    OK-(CW*(C_HOFFSET))
        DW    N_ABORT
    DW    0

        DW      SZERO, FETCH, SPSTO
        DW      ZERO, HANDLER, STORE
        DW      DECA
        DW      ONLY
        DW      FORTH
        DW      DEFIN
        DW      QUIT
        DW      SEMIS   ;Unnecessary, but helpful for decompilation.
;
;      WARM START VECTOR COMES HERE
;      For booting code we enter here, real mode and using the switchsegment.
;      BY control BREAK.
WARM_ENTRY:
; 
        
        MOV     SI, WRM1
        JMP     NEXT                   ;Hope stacks are still okay.
;
WRM1:   DW      WARM
;

;  ************
;  *   WARM   *
;  ************
;
N_WARM:   DW      4
        DB      "WARM"
WARM:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    ABORT-(CW*(C_HOFFSET))
        DW    N_WARM
    DW    0

        DW      MTBUF
        DW      SIGNON
        DW      ABORT
        DW      SEMIS   ;Unnecessary, but helpful for decompilation.
;


;  ***************
;  *   OPTIONS   *
;  ***************
;
N_OPTIONS:   DW      7
        DB      "OPTIONS"
OPTIONS:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    WARM-(CW*(C_HOFFSET))
        DW    N_OPTIONS
    DW    0

;       Execute option.

        DW      LIT, 81H
OPT1:
        DW      LDUP, CFET, LBL, EQUAL
        DW      ZBRAN
        DW      OPT2-$-CW            ; Skip blanks.
        DW      ONEP
        DW      BRAN
        DW      OPT1-$-CW
OPT2:   DW      LDUP, CFET, LIT, ACR, UNEQ
        DW      ZBRAN
        DW      OPT4-$-CW ; No options  
        DW      FETCH
        DW      LDUP
        DW      LIT, 0FDH  , LAND
        DW      LIT, '-', UNEQ
        DW      ZBRAN
        DW      OPT3-$-CW
        DW      LIT, 3, LDUP, ERROR
        DW      XCODE, STORE, BYE
OPT3:
        DW      LIT, 8, RSHIFT
        DW      LIT, 1FH, LAND
        DW      LOAD
        DW      ZERO, SWAP ; Sign on suppressed.
OPT4:
        DW      DROP
        DW      SEMIS   ;Unnecessary, but helpful for decompilation.
;


;  ************
;  *   COLD   *
;  ************
;
N_COLD:   DW      4
        DB      "COLD"
COLD:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    OPTIONS-(CW*(C_HOFFSET))
        DW    N_COLD
    DW    0

        DW      ZERO, HANDLER, STORE
        DW      MTBUF
        DW      FIRST
        DW      STALEST,STORE
        DW      FIRST
        DW      PREV,STORE
; Fill user area for single task.
        DW      LIT, USINI
        DW      LIT, USINI+(CW*(1)), FETCH
        DW      LIT, US
        DW      LCMOVE

        DW      LIT, 0, BLINI  ;Default, don't write in the library file!
;
        DW      DECA    ; FIXME has to go done by ABORT anyway.
        DW      ONLY    ; FIXME has to go done by ABORT anyway.
        DW      FORTH   ; FIXME has to go done by ABORT anyway.
        DW      DEFIN   ; FIXME has to go done by ABORT anyway.
        DW      ONE            ; Sign on wanted.
;
        DW      OPTIONS
        DW      ZBRAN
        DW      COLD5-$-CW
        DW      SIGNON    ; Suppressed for scripting! Or any options.
COLD5:
        DW      ABORT
        DW      BYE     ; In case of turnkey programs.
        DW      SEMIS   ; Unnecessary, but helpful for decompilation.
;

;  ***********
;  *   S>D   *
;  ***********
;
N_STOD:   DW      3
        DB      "S>D"
STOD:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    COLD-(CW*(C_HOFFSET))
        DW    N_STOD
    DW    0

        POP     DX      ;S1
        SUB     AX,AX
        OR      DX,DX
        JNS     STOD1   ;POS
        DEC     AX      ;NEG
STOD1:  JMP     DPUSH
;

;  ***********
;  *   ABS   *
;  ***********
;
N_LABS:   DW      3
        DB      "ABS"
LABS:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    STOD-(CW*(C_HOFFSET))
        DW    N_LABS
    DW    0

        DW      LDUP
        DW      ZLESS
        DW      ZBRAN
        DW      PM1-$-CW   ;IF
        DW      NEGATE   ;THEN
PM1:
        DW      SEMIS
;

;  ************
;  *   DABS   *
;  ************
;
N_DABS:   DW      4
        DB      "DABS"
DABS:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LABS-(CW*(C_HOFFSET))
        DW    N_DABS
    DW    0

        DW      LDUP
        DW      ZLESS
        DW      ZBRAN
        DW      DPM1-$-CW  ;IF
        DW      DNEGA   ;THEN
DPM1:
        DW      SEMIS
;

;  ***********
;  *   MIN   *
;  ***********
;
N_MIN:   DW      3
        DB      "MIN"
MIN:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    DABS-(CW*(C_HOFFSET))
        DW    N_MIN
    DW    0

        DW      TDUP
        DW      GREAT
        DW      ZBRAN
        DW      MIN1-$-CW  ;IF
        DW      SWAP    ;THEN
MIN1:   DW      DROP
        DW      SEMIS
;

;  ***********
;  *   MAX   *
;  ***********
;
N_MAX:   DW      3
        DB      "MAX"
MAX:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    MIN-(CW*(C_HOFFSET))
        DW    N_MAX
    DW    0

        DW      TDUP
        DW      LESS
        DW      ZBRAN
        DW      MAX1-$-CW  ;IF
        DW      SWAP    ;THEN
MAX1:   DW      DROP
        DW      SEMIS
;

;  **************
;  *   LSHIFT   *
;  **************
;
N_LSHIFT:   DW      6
        DB      "LSHIFT"
LSHIFT:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    MAX-(CW*(C_HOFFSET))
        DW    N_LSHIFT
    DW    0

        POP     CX
        POP     AX
        SHL     AX,CL
        JMP     APUSH
;

;  **************
;  *   RSHIFT   *
;  **************
;
N_RSHIFT:   DW      6
        DB      "RSHIFT"
RSHIFT:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LSHIFT-(CW*(C_HOFFSET))
        DW    N_RSHIFT
    DW    0

        POP     CX
        POP     AX
        SHR     AX,CL
        JMP     APUSH
;

;  **********
;  *   M*   *
;  **********
;
N_MSTAR:   DW      2
        DB      "M*"
MSTAR:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    RSHIFT-(CW*(C_HOFFSET))
        DW    N_MSTAR
    DW    0

        POP     AX
        POP     BX
        IMUL     BX      ;SIGNED
        XCHG    AX,DX   ;AX NOW = MSW
        JMP     DPUSH          ;STORE DOUBLE CELL
;

;  **************
;  *   SM/REM   *
;  **************
;
N_MSLAS:   DW      6
        DB      "SM/REM"
MSLAS:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    MSTAR-(CW*(C_HOFFSET))
        DW    N_MSLAS
    DW    0

        POP     BX      ;DIVISOR
        POP     DX      ;MSW OF DIVIDEND
        POP     AX      ;LSW OF DIVIDEND
        IDIV     BX      ;16 BIT DIVIDE
        JMP     DPUSH          ;STORE QUOT/REM
;


;  **********
;  *   2/   *
;  **********
;
N_TWOSL:   DW      2
        DB      "2/"
TWOSL:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    MSLAS-(CW*(C_HOFFSET))
        DW    N_TWOSL
    DW    0

        DW      STOD, TWO, FMSLAS
        DW      SWAP, DROP
        DW      SEMIS
;

;  **********
;  *   2*   *
;  **********
;
N_TWOST:   DW      2
        DB      "2*"
TWOST:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    TWOSL-(CW*(C_HOFFSET))
        DW    N_TWOST
    DW    0

        DW      TWO, STAR
        DW      SEMIS
;

;  **********
;  *   1-   *
;  **********
;
N_ONEM:   DW      2
        DB      "1-"
ONEM:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    TWOST-(CW*(C_HOFFSET))
        DW    N_ONEM
    DW    0

        DW      ONE, LSUB
        DW      SEMIS
;
;

;  **************
;  *   FM/MOD   *
;  **************
;
N_FMSLAS:   DW      6
        DB      "FM/MOD"
FMSLAS:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    ONEM-(CW*(C_HOFFSET))
        DW    N_FMSLAS
    DW    0

        DW      LDUP, TOR
        DW      TDUP, LXOR, TOR
        DW      MSLAS
        DW      FROMR, ZLESS
        DW      ZBRAN
        DW      FMMOD1-$-CW
        DW      OVER
        DW      ZBRAN
        DW      FMMOD1-$-CW
        DW      ONE, LSUB
        DW      SWAP, FROMR, PLUS, SWAP
        DW      BRAN
        DW      FMMOD2-$-CW
FMMOD1:
        DW      RDROP
FMMOD2:
        DW      SEMIS
;

;  *********
;  *   *   *
;  *********
;
N_STAR:   DW      1
        DB      "*"
STAR:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    FMSLAS-(CW*(C_HOFFSET))
        DW    N_STAR
    DW    0

        DW      MSTAR
        DW      DROP
        DW      SEMIS
;

;  ************
;  *   /MOD   *
;  ************
;
N_SLMOD:   DW      4
        DB      "/MOD"
SLMOD:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    STAR-(CW*(C_HOFFSET))
        DW    N_SLMOD
    DW    0

        DW      TOR
        DW      STOD
        DW      FROMR
        DW      MSLAS
        DW      SEMIS
;

;  *********
;  *   /   *
;  *********
;
N_SLASH:   DW      1
        DB      "/"
SLASH:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SLMOD-(CW*(C_HOFFSET))
        DW    N_SLASH
    DW    0

        DW      SLMOD
        DW      SWAP
        DW      DROP
        DW      SEMIS
;

;  ***********
;  *   MOD   *
;  ***********
;
N_LMOD:   DW      3
        DB      "MOD"
LMOD:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SLASH-(CW*(C_HOFFSET))
        DW    N_LMOD
    DW    0

        DW      SLMOD
        DW      DROP
        DW      SEMIS
;

;  *************
;  *   */MOD   *
;  *************
;
N_SSMOD:   DW      5
        DB      "*/MOD"
SSMOD:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LMOD-(CW*(C_HOFFSET))
        DW    N_SSMOD
    DW    0

        DW      TOR
        DW      MSTAR
        DW      FROMR
        DW      MSLAS
        DW      SEMIS
;

;  **********
;  *   */   *
;  **********
;
N_SSLA:   DW      2
        DB      "*/"
SSLA:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SSMOD-(CW*(C_HOFFSET))
        DW    N_SSLA
    DW    0

        DW      SSMOD
        DW      SWAP
        DW      DROP
        DW      SEMIS
;

;  *************
;  *   M/MOD   *
;  *************
;
N_MSMOD:   DW      5
        DB      "M/MOD"
MSMOD:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SSLA-(CW*(C_HOFFSET))
        DW    N_MSMOD
    DW    0

        DW      TOR
        DW      ZERO
        DW      RR
        DW      USLAS
        DW      FROMR
        DW      SWAP
        DW      TOR
        DW      USLAS
        DW      FROMR
        DW      SEMIS
;

;  **************
;  *   (LINE)   *
;  **************
;
N_PLINE:   DW      6
        DB      "(LINE)"
PLINE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    MSMOD-(CW*(C_HOFFSET))
        DW    N_PLINE
    DW    0

        DW      TOR
        DW      LIT,64
        DW      MSTAR
        DW      BBUF
        DW      FMSLAS
        DW      FROMR ; This blocks, so is screens.
        DW      PLUS
        DW      BLOCK
        DW      PLUS
        DW      LIT,63
        DW      SEMIS
;

;  **************
;  *   ERRSCR   *
;  **************
;
N_ERRSCR:   DW      6
        DB      "ERRSCR"
ERRSCR:        DW    DOVAR
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PLINE-(CW*(C_HOFFSET))
        DW    N_ERRSCR
    DW    0

        DW ERRORSCREEN
;

;  ***************
;  *   MESSAGE   *
;  ***************
;
N_MESS:   DW      7
        DB      "MESSAGE"
MESS:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    ERRSCR-(CW*(C_HOFFSET))
        DW    N_MESS
    DW    0

        DW      LWARN
        DW      FETCH
        DW      ZBRAN
        DW      MESS1-$-CW ;IF
        DW      ERRSCR, FETCH
        DW      PLINE, ONEP     ; Also print the '\n' !
        DW      LTYPE
        DW      X
MESS1:                  ;THEN
        DW      DROP
        DW      SEMIS
;

;  ***********
;  *   PC@   *
;  ***********
;
N_PCFET:   DW      3
        DB      "PC@"
PCFET:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    MESS-(CW*(C_HOFFSET))
        DW    N_PCFET
    DW    0

; FETCH CHARACTER (BYTE) FROM PORT
        POP     DX      ; PORT ADDR
        XOR     AX,AX
        IN      AL,DX  ; BYTE INPUT
        JMP     APUSH
;

;  ***********
;  *   PC!   *
;  ***********
;
N_PCSTO:   DW      3
        DB      "PC!"
PCSTO:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PCFET-(CW*(C_HOFFSET))
        DW    N_PCSTO
    DW    0

        POP     DX      ;PORT ADDR
        POP     AX      ;DATA
        OUT     DX,AL   ; BYTE OUTPUT
        JMP     NEXT
;

;  **********
;  *   P@   *
;  **********
;
N_PFET:   DW      2
        DB      "P@"
PFET:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PCSTO-(CW*(C_HOFFSET))
        DW    N_PFET
    DW    0

        POP     DX      ;PORT ADDR
        IN      AX,DX  ;WORD INPUT
        JMP     APUSH
;

;  **********
;  *   P!   *
;  **********
;
N_PSTO:   DW      2
        DB      "P!"
PSTO:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PFET-(CW*(C_HOFFSET))
        DW    N_PSTO
    DW    0

        POP     DX      ;PORT ADDR
        POP     AX      ;DATA
        OUT     DX,AX   ;WORD OUTPUT
        JMP     NEXT
;

;  ***************
;  *   STALEST   *
;  ***************
;
N_STALEST:   DW      7
        DB      "STALEST"
STALEST:        DW    DOVAR
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PSTO-(CW*(C_HOFFSET))
        DW    N_STALEST
    DW    0

        DW BUF1
;

;  ************
;  *   PREV   *
;  ************
;
N_PREV:   DW      4
        DB      "PREV"
PREV:        DW    DOVAR
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    STALEST-(CW*(C_HOFFSET))
        DW    N_PREV
    DW    0

        DW      BUF1
;

;  *************
;  *   #BUFF   *
;  *************
;
N_NOBUF:   DW      5
        DB      "#BUFF"
NOBUF:        DW    DOCON
        DW    NBUF
        DW    0H
        DW    PREV-(CW*(C_HOFFSET))
        DW    N_NOBUF
    DW    0

;

;  ************
;  *   +BUF   *
;  ************
;
N_PBUF:   DW      4
        DB      "+BUF"
PBUF:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    NOBUF-(CW*(C_HOFFSET))
        DW    N_PBUF
    DW    0

        DW      LIT,(KBBUF+2*CW)
        DW      PLUS,LDUP
        DW      LIMIT,EQUAL
        DW      ZBRAN
        DW      PBUF1-$-CW
        DW      DROP,FIRST
PBUF1:  DW      LDUP, PREV, FETCH, LSUB
        DW      SEMIS
;

;  **************
;  *   UPDATE   *
;  **************
;
N_UPDAT:   DW      6
        DB      "UPDATE"
UPDAT:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PBUF-(CW*(C_HOFFSET))
        DW    N_UPDAT
    DW    0

        DW      PREV, FETCH
        DW      LDUP, CELLP,CELLP
        DW      SWAP, FETCH
        DW      LOFFSET,  FETCH, PLUS
        DW      ZERO
        DW      RSLW
        DW      SEMIS
;

;  *********************
;  *   EMPTY-BUFFERS   *
;  *********************
;
N_MTBUF:   DW      13
        DB      "EMPTY-BUFFERS"
MTBUF:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    UPDAT-(CW*(C_HOFFSET))
        DW    N_MTBUF
    DW    0

        DW      FIRST
        DW      LIMIT,OVER
        DW      LSUB,LERASE
        DW      SEMIS
        ;
;

;  ****************
;  *   (BUFFER)   *
;  ****************
;
N_BUFFER:   DW      8
        DB      "(BUFFER)"
BUFFER:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    MTBUF-(CW*(C_HOFFSET))
        DW    N_BUFFER
    DW    0

; Find the buffer, if it is already here.
    DW      PREV, FETCH
BUFFER1:
    DW          TOR, RR, FETCH, OVER, EQUAL
    DW      ZBRAN
        DW      BUFFER3-$-CW
    DW        DROP, FROMR, EXIT
BUFFER3:
    DW          FROMR
    DW      PBUF, ZEQU
    DW      ZBRAN
        DW      BUFFER1-$-CW
    DW       DROP
; Just allocate the stalest buffer.
    DW       STALEST,   FETCH, TOR
; Remember the next stalest buffer. 
    DW       RR
BUFFER2:
    DW       PBUF, OVER, CELLP, FETCH,
    DW       LIT, -1, GREAT, LAND
    DW      ZBRAN
        DW      BUFFER2-$-CW
    DW       STALEST, STORE
; Fill in the house keeping.
    DW       RR, STORE
    DW       ZERO, RR, CELLP, STORE
    DW       RR, PREV, STORE
    DW       FROMR
    DW  SEMIS
;


;  *************
;  *   BLOCK   *
;  *************
;
N_BLOCK:   DW      5
        DB      "BLOCK"
BLOCK:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    BUFFER-(CW*(C_HOFFSET))
        DW    N_BLOCK
    DW    0


        DW      BUFFER
        DW      LDUP, CELLP, FETCH, ZEQU
        DW      ZBRAN
        DW      BLOCK1-$-CW
        DW      LDUP, CELLP, CELLP
        DW      OVER, FETCH
        DW      LOFFSET,  FETCH, PLUS
        DW      ONE
        DW      RSLW
        DW      ONE, OVER, CELLP, STORE
BLOCK1:
        DW      LDUP, PREV, STORE
        DW      CELLP, CELLP
        DW      SEMIS
;

;  *************
;  *   FLUSH   *
;  *************
;
N_FLUSH:   DW      5
        DB      "FLUSH"
FLUSH:        DW    DOCOL
        DW    (MTBUF+(CW*(PH_OFFSET-C_HOFFSET)))
        DW    0H
        DW    BLOCK-(CW*(C_HOFFSET))
        DW    N_FLUSH
    DW    0


; Unlock all buffers
        DW      LIMIT
        DW      FIRST, CELLP
        DW     XDO
        DW      FLUS2-$-CW
FLUS1:  DW      ZERO, IDO, STORE
        DW      LIT,(KBBUF+2*CW)
        DW      PLOOP
        DW      (FLUS1-$)
FLUS2:
        DW      SEMIS
;

;  ************
;  *   SAVE   *
;  ************
;
N_SAVE:   DW      4
        DB      "SAVE"
SAVE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    FLUSH-(CW*(C_HOFFSET))
        DW    N_SAVE
    DW    0

        DW      FROMR
        DW      SRC, TFET
        DW      LIN, FETCH
        DW      TOR, TOR, TOR
        DW      TOR
        DW SEMIS
;

;  ***************
;  *   RESTORE   *
;  ***************
;
N_RESTO:   DW      7
        DB      "RESTORE"
RESTO:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SAVE-(CW*(C_HOFFSET))
        DW    N_RESTO
    DW    0

        DW      FROMR
        DW      FROMR, FROMR, FROMR
        DW      LIN, STORE
        DW      SRC, TSTOR
        DW      TOR
        DW SEMIS
;


;  ******************
;  *   SAVE-INPUT   *
;  ******************
;
N_SAVEI:   DW      10
        DB      "SAVE-INPUT"
SAVEI:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    RESTO-(CW*(C_HOFFSET))
        DW    N_SAVEI
    DW    0

        DW      SRC, TFET
        DW      LIN, FETCH
        DW      LIT, 3
        DW SEMIS
;

;  *********************
;  *   RESTORE-INPUT   *
;  *********************
;
N_RESTOI:   DW      13
        DB      "RESTORE-INPUT"
RESTOI:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SAVEI-(CW*(C_HOFFSET))
        DW    N_RESTOI
    DW    0

        DW      DROP
        DW      LIN, STORE
        DW      SRC, TSTOR
        DW      LIT, -1
        DW SEMIS
;
;

;  ************
;  *   LOCK   *
;  ************
;
N_LLOCK:   DW      4
        DB      "LOCK"
LLOCK:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    RESTOI-(CW*(C_HOFFSET))
        DW    N_LLOCK
    DW    0

        DW      BLOCK
        DW      LIT, CW, LSUB
        DW      LIT, -2, SWAP, PSTORE
        DW      SEMIS
;

;  **************
;  *   UNLOCK   *
;  **************
;
N_LUNLOCK:   DW      6
        DB      "UNLOCK"
LUNLOCK:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LLOCK-(CW*(C_HOFFSET))
        DW    N_LUNLOCK
    DW    0

        DW      BLOCK
        DW      LIT, CW, LSUB
        DW      TWO, SWAP, PSTORE
        DW      SEMIS
;

;  ************
;  *   LOAD   *
;  ************
;
N_LOAD:   DW      4
        DB      "LOAD"
LOAD:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LUNLOCK-(CW*(C_HOFFSET))
        DW    N_LOAD
    DW    0

        DW      LDUP, THRU
        DW      SEMIS
;

;  ************
;  *   THRU   *
;  ************
;
N_THRU:   DW      4
        DB      "THRU"
THRU:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LOAD-(CW*(C_HOFFSET))
        DW    N_THRU
    DW    0

        DW      SAVE
        DW      ONEP, SWAP
        DW     XDO
        DW      THRU2-$-CW
THRU1:
        DW      IDO, LLOCK
        DW      IDO, BLOCK
        DW      LIT, KBBUF
        DW      SETSRC
        DW      LIT, INTER, CATCH
        DW      IDO, LUNLOCK
        DW      QDUP
        DW      ZBRAN
        DW      THRU3-$-CW
        DW      RDROP, RDROP, RDROP; UNLOOP.
        DW      RESTO
        DW      THROW
THRU3:
        DW     XLOOP
        DW      THRU1-$-CW
THRU2:
        DW      RESTO
        DW      SEMIS
;

;

;  ***********
;  *   BLK   *
;  ***********
;
N_BLK:   DW      3
        DB      "BLK"
BLK:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    THRU-(CW*(C_HOFFSET))
        DW    N_BLK
    DW    0

        DW      LIN, FETCH
        DW      FIRST, LIMIT, WITHIN
        DW      SRC, TFET, LSUB
        DW      LIT, 1024, EQUAL, LAND
        DW      ZBRAN
        DW      BLK1-$-CW
        DW      SRC, FETCH, TWO, LCELLS, LSUB, FETCH
        DW      BRAN
        DW      BLK2-$-CW
BLK1:
        DW      ZERO
BLK2:
        DW      PBLK, STORE
        DW      PBLK
        DW      SEMIS
;

;  ***********
;  *   -->   *
;  ***********
;
N_ARROW:   DW      3
        DB      "-->"
ARROW:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    BLK-(CW*(C_HOFFSET))
        DW    N_ARROW
    DW    0

        DW      QLOAD
        DW      BLK, FETCH
        DW      LDUP, LUNLOCK
        DW      ONEP
        DW      LDUP, LLOCK
        DW      LDUP, BLK, STORE
        DW      BLOCK
        DW      LIT, KBBUF
        DW      SETSRC
        DW      SEMIS
        ;
;
;

; Generic call on BIOS. A boon for experimenters.


; Because there is no such thing as a variable interrupt:
; THIS IS SELF MODIFYING CODE! NOT REENTRANT! DO NOT PUT IN ROM!
; BEWARE OF THE SOFTWARE POLICE!
;  *************
;  *   BIOSO   *
;  *************
;
N_BIOSO:   DW      5
        DB      "BIOSO"
BIOSO:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    ARROW-(CW*(C_HOFFSET))
        DW    N_BIOSO
    DW    0

        POP     AX      ; Function code
        ; Once we are more acknowledgeable, put segment overwrite here.
        MOV     BYTE [RQBIOS+1],AL ; Patch the code.
        POP     DX
        POP     CX
        POP     BX
        POP     AX
        PUSH     SI      ; Save Forth registers. NEEDED? 
        PUSH     BP
        XCHG    SI,AX   ; Save AX in (already free) SI
        
        XCHG    SI,AX
RQBIOS:  INT(0)          ; Request number to be overwritten.
        PUSHF      ; Save status into DI 
        POP     DI
        XCHG    SI,AX ; Save AX in (still free) SI     
        
        XCHG    SI,AX
        POP     BP      ; Restore Forth registers. NEEDED? 
        POP     SI
        PUSH     AX
        PUSH     BX
        PUSH     CX
        PUSH     DX
        PUSH     DI     ; i.e. flags 
        JMP     NEXT

; SELF MODIFYING CODE ENDS HERE! YOU HAVE BEEN WARNED!
;
;
; Generic call on BIOS. A boon for experimenters.



; Because there is no such thing as a variable interrupt:
; THIS IS SELF MODIFYING CODE! NOT REENTRANT! DO NOT PUT IN ROM!
; BEWARE OF THE SOFTWARE POLICE!
;  *************
;  *   BIOSN   *
;  *************
;
N_BIOSN:   DW      5
        DB      "BIOSN"
BIOSN:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    BIOSO-(CW*(C_HOFFSET))
        DW    N_BIOSN
    DW    0

        POP     AX      ; Function code
        ; Once we are more acknowledgeable, put segment overwrite here.
        MOV     BYTE [RQBIOSN+1],AL ; Patch the code.
        POP     AX
        POP     BX
        POP     CX
        POP     DX
        PUSH     SI      ; Save Forth registers. NEEDED? 
        PUSH     BP
        XCHG    SI,AX   ; Save AX in (already free) SI
        
        XCHG    SI,AX
RQBIOSN:  INT(0)          ; Request number to be overwritten.
        PUSHF      ; Save status into DI 
        POP     DI
        XCHG    SI,AX ; Save AX in (still free) SI     
        
        XCHG    SI,AX
        POP     BP      ; Restore Forth registers. NEEDED? 
        POP     SI
        PUSH     AX
        PUSH     DI     ; i.e. flags 
        JMP     NEXT
; SELF MODIFYING CODE ENDS HERE! YOU HAVE BEEN WARNED!
;
;


;  *************
;  *   BDOSO   *
;  *************
;
N_BDOSO:   DW      5
        DB      "BDOSO"
BDOSO:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    BIOSN-(CW*(C_HOFFSET))
        DW    N_BDOSO
    DW    0

        POP     DX
        POP     CX
        POP     BX
        POP     AX
        PUSH     SI      ; Save Forth registers. NEEDED? 
        PUSH     BP
        XCHG    SI,AX   ; Save AX in (already free) SI
        
        XCHG    SI,AX
        INT     21H
        PUSHF      ; Save status into DI 
        POP     DI; Not EDI! 
        XCHG    SI,AX  ; Save AX in (still free) SI     
        
        XCHG    SI,AX
        POP     BP      ; Restore Forth registers. NEEDED? 
        POP     SI
        PUSH     AX
        PUSH     BX
        PUSH     CX
        PUSH     DX
        PUSH     DI     ; i.e. flags 
        JMP     NEXT
;
;
; 
; 
        ;
;------------------------------------
;       SYSTEM DEPENDANT CHAR I/O
;------------------------------------


;  ************
;  *   EMIT   *
;  ************
;
N_EMIT:   DW      4
        DB      "EMIT"
EMIT:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    BDOSO-(CW*(C_HOFFSET))
        DW    N_EMIT
    DW    0

        DW      LDUP,LIT,ALF,EQUAL
        DW      ZBRAN
        DW      EMIT1-$-CW
        DW      LIT,ACR,EMIT
        DW      ZERO,LOUT,STORE
EMIT1:
        DW      SPFET, ONE, LTYPE
        DW      DROP
        DW      SEMIS
;

;  ***********
;  *   KEY   *
;  ***********
;
N_KEY:   DW      3
        DB      "KEY"
KEY:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    EMIT-(CW*(C_HOFFSET))
        DW    N_KEY
    DW    0

        DW      X, X, X, LIT, 1000H
        DW      LIT, 0016H, BIOSN
        DW      DROP
        DW      LIT, 00FFH, LAND, SEMIS
;

;  ************
;  *   KEY?   *
;  ************
;
N_KEYQ:   DW      4
        DB      "KEY?"
KEYQ:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    KEY-(CW*(C_HOFFSET))
        DW    N_KEYQ
    DW    0

        DW      X, X, X, LIT, 0B00H
        DW      BDOSN, DROP ; ignore error 
        DW      LIT, 01H, LAND  ;Dubious!! FIXME!!
        DW      SEMIS
;

;  ************
;  *   TYPE   *
;  ************
;
N_LTYPE:   DW      4
        DB      "TYPE"
LTYPE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    KEYQ-(CW*(C_HOFFSET))
        DW    N_LTYPE
    DW    0

        DW      LDUP, LOUT, PSTORE
        DW      ONE, WFILE, DROP
        DW      SEMIS
;

;  ****************
;  *   (ACCEPT)   *
;  ****************
;
N_PACCEP:   DW      8
        DB      "(ACCEPT)"
PACCEP:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LTYPE-(CW*(C_HOFFSET))
        DW    N_PACCEP
    DW    0

PACCEP2:
        DW      REMAIND
        DW      TFET
        DW      LIT, ALF, SINDEX
        DW      ZEQU
        DW      ZBRAN
        DW      PACCEP1-$-CW
        DW      REMAIND, TFET
        DW      TIB, FETCH
        DW      SWAP, LMOVE
        DW      TIB, FETCH
        DW      REMAIND, CELLP, STORE
        DW      REFTIB
        DW      BRAN
        DW      PACCEP2-$-CW
PACCEP1:
        DW      REMAIND, TFET
        DW      LIT, ALF, SSPLIT
        DW      TSWAP, REMAIND, TSTOR
        DW ONEM
        DW      SEMIS
;

;  *************
;  *   BDOSN   *
;  *************
;
N_BDOSN:   DW      5
        DB      "BDOSN"
BDOSN:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PACCEP-(CW*(C_HOFFSET))
        DW    N_BDOSN
    DW    0

        DW      LIT, 21H, BIOSN
        DW      ONE, LAND
        DW      LDUP
        DW      ZBRAN
        DW      BDOSN1-$-CW
        DW      SWAP
        DW      NEGATE
        DW      SWAP
BDOSN1:
        DW      SEMIS
;
 ; 


; 


;  *************
;  *   RWBUF   *
;  *************
;
N_RWBUF:   DW      5
        DB      "RWBUF"
RWBUF:        DW    DOVAR
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    BDOSN-(CW*(C_HOFFSET))
        DW    N_RWBUF
    DW    0

        RESB    200H
 ;  
; 
;

; 

;  ***********
;  *   ZEN   *
;  ***********
;
N_ZEN:   DW      3
        DB      "ZEN"
ZEN:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    RWBUF-(CW*(C_HOFFSET))
        DW    N_ZEN
    DW    0

        DW      RWBUF, SSTOR
        DW      ZERO, RWBUF, CHAPP
        DW      RWBUF, CELLP
         
        DW      SEMIS
 ;  
; 
;

;

;  *****************
;  *   OPEN-FILE   *
;  *****************
;
N_OFILE:   DW      9
        DB      "OPEN-FILE"
OFILE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    ZEN-(CW*(C_HOFFSET))
        DW    N_OFILE
    DW    0

        DW      TOR, ZEN, X, X
        DW      LIT, open, FROMR, PLUS, BDOSN
        DW      ZBRAN
        DW      OFILE1-$-CW
        DW      LDUP
        DW      BRAN
        DW      OFILE2-$-CW
OFILE1:
        DW      ZERO
OFILE2:
        DW      SEMIS
 ; 
;

;

;  ******************
;  *   CLOSE-FILE   *
;  ******************
;
N_CFILE:   DW      10
        DB      "CLOSE-FILE"
CFILE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    OFILE-(CW*(C_HOFFSET))
        DW    N_CFILE
    DW    0

        DW      TOR, X, X, FROMR
        DW      LIT, close, BDOSN
        DW      ZBRAN
        DW      CFILE1-$-CW
        DW      BRAN
        DW      CFILE2-$-CW
CFILE1:
        DW      DROP, ZERO
CFILE2:
        DW      SEMIS
 ; 
;

;

;  *******************
;  *   CREATE-FILE   *
;  *******************
;
N_CREATEF:   DW      11
        DB      "CREATE-FILE"
CREATEF:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    CFILE-(CW*(C_HOFFSET))
        DW    N_CREATEF
    DW    0

        DW      TOR, ZEN, FROMR, X
        DW      LIT, create, BDOSN
        DW      ZBRAN
        DW      CRFILE1-$-CW
        DW      LDUP
        DW      BRAN
        DW      CRFILE2-$-CW
CRFILE1:
        DW      ZERO
CRFILE2:
        DW      SEMIS
 ; 
;

;

;  *******************
;  *   DELETE-FILE   *
;  *******************
;
N_DFILE:   DW      11
        DB      "DELETE-FILE"
DFILE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    CREATEF-(CW*(C_HOFFSET))
        DW    N_DFILE
    DW    0

        DW      ZEN, X, X
        DW      LIT, delete, BDOSN
        DW      ZEQU
        DW      ZBRAN
        DW      DFILE1-$-CW
        DW      DROP, ZERO
DFILE1:
        DW      SEMIS
 ; 
;

; 

;  *****************
;  *   READ-FILE   *
;  *****************
;
N_RFILE:   DW      9
        DB      "READ-FILE"
RFILE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    DFILE-(CW*(C_HOFFSET))
        DW    N_RFILE
    DW    0

        DW      LIT, read, BDOSN
        DW      ZBRAN
        DW      RFILE1-$-CW
        DW      ZERO, SWAP
        DW      BRAN
        DW      RFILE2-$-CW
RFILE1:
        DW      ZERO
RFILE2:
        DW      SEMIS
 ;  
; 
;

;

;  ***********************
;  *   REPOSITION-FILE   *
;  ***********************
;
N_PFILE:   DW      15
        DB      "REPOSITION-FILE"
PFILE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    RFILE-(CW*(C_HOFFSET))
        DW    N_PFILE
    DW    0

        
        DW      LIT, lseek, BDOSN
        DW      ZEQU
        DW      ZBRAN
        DW      PFILE1-$-CW
        DW      DROP, ZERO
PFILE1:
        DW      SEMIS
 ; 
;

; 

;  ******************
;  *   WRITE-FILE   *
;  ******************
;
N_WFILE:   DW      10
        DB      "WRITE-FILE"
WFILE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PFILE-(CW*(C_HOFFSET))
        DW    N_WFILE
    DW    0

        DW      LIT, write, BDOSN
        DW      ZEQU
        DW      ZBRAN
        DW      WFILE1-$-CW
        DW      DROP, ZERO
WFILE1:
        DW      SEMIS
 ;  
; 
;
; 

;  ****************
;  *   GET-FILE   *
;  ****************
;
N_GETFILE:   DW      8
        DB      "GET-FILE"
GETFILE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    WFILE-(CW*(C_HOFFSET))
        DW    N_GETFILE
    DW    0

        DW      TDUP, SCOMMA, DROP
        DW      LIT, 'F'+(100H*('i'+100H*('L'+100H*'e'))), COMMA ;Magic number.
        DW      ZERO, OFILE, THROW, TOR
        DW      HERE, LDUP
        DW      LEM, LIT, 6, SLASH, LDUP, ALLOT
        DW      LIT, 1000, LSUB
        DW      RR, RFILE, THROW
        DW      FROMR, CFILE, THROW
        DW      TDUP, PLUS, LDP, STORE        ; No allocation if it fails.
        DW      SEMIS
;

;  ****************
;  *   PUT-FILE   *
;  ****************
;
N_PUTFILE:   DW      8
        DB      "PUT-FILE"
PUTFILE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    GETFILE-(CW*(C_HOFFSET))
        DW    N_PUTFILE
    DW    0

        DW      ZERO
        DW      CREATEF, THROW
        DW      LDUP, TOR
        DW      WFILE, THROW
        DW      FROMR, CFILE, THROW
        DW      SEMIS
;

;  ****************
;  *   INCLUDED   *
;  ****************
;
N_INCLUD:   DW      8
        DB      "INCLUDED"
INCLUD:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PUTFILE-(CW*(C_HOFFSET))
        DW    N_INCLUD
    DW    0

        DW      HERE, TOR
        DW      LIT, GETFILE, CATCH
        DW      LDUP
        DW      ZBRAN
        DW      INCLUD1-$-CW
        DW      FROMR, LDP, STORE
        DW      THROW
        DW      BRAN
        DW      INCLUD2-$-CW
INCLUD1:
        DW      RDROP, DROP
INCLUD2:
        DW      EVALUATE
        DW      SEMIS
;

;  ******************
;  *   REFILL-TIB   *
;  ******************
;
N_REFTIB:   DW      10
        DB      "REFILL-TIB"
REFTIB:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    INCLUD-(CW*(C_HOFFSET))
        DW    N_REFTIB
    DW    0

        DW      REMAIND, FETCH, TOR
        DW      TIB, FETCH, RR, PLUS
        DW      LIT, RTS/2, RR, LSUB
        DW      ZERO, RFILE
        DW      QERRUR
        DW      LDUP, ZEQU, LIT, -32, LAND ; Presumably end of pipe.
        DW      QERRUR
        DW      TIB, FETCH, SWAP, FROMR, PLUS
        DW      REMAIND, TSTOR
        DW      SEMIS
;
;

; _SUPPRESSED_  ; 
;
;
;
;


;  **************
;  *   ACCEPT   *
;  **************
;
N_ACCEP:   DW      6
        DB      "ACCEPT"
ACCEP:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    REFTIB-(CW*(C_HOFFSET))
        DW    N_ACCEP
    DW    0

        DW      PACCEP
        DW      TSWAP, ROT, MIN
        DW      LDUP, TOR, LMOVE, FROMR
        DW      SEMIS
;
;
;
;
;

        ;
;------------------------------------
;       SYSTEM DEPENDANT DISK I/O
;------------------------------------


;  ******************
;  *   DISK-ERROR   *
;  ******************
;
N_DERR:   DW      10
        DB      "DISK-ERROR"
DERR:        DW    DOVAR
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    ACCEP-(CW*(C_HOFFSET))
        DW    N_DERR
    DW    0

        DW      -1
;


;  ******************
;  *   BLOCK-FILE   *
;  ******************
;
N_BLFL:   DW      10
        DB      "BLOCK-FILE"
BLFL:        DW    DOVAR
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    DERR-(CW*(C_HOFFSET))
        DW    N_BLFL
    DW    0

        DW      9
        DB      "forth.lab"
        RESB    30-9               ; Allow for some path

;  ********************
;  *   BLOCK-HANDLE   *
;  ********************
;
N_BHAN:   DW      12
        DB      "BLOCK-HANDLE"
BHAN:        DW    DOVAR
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    BLFL-(CW*(C_HOFFSET))
        DW    N_BHAN
    DW    0

        DW      -1
;

;  *******************
;  *   ?DISK-ERROR   *
;  *******************
;
N_QDSKER:   DW      11
        DB      "?DISK-ERROR"
QDSKER:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    BHAN-(CW*(C_HOFFSET))
        DW    N_QDSKER
    DW    0

        DW      LIT, 8, QERR
        DW      SEMIS
;
;


;  ******************
;  *   BLOCK-INIT   *
;  ******************
;
N_BLINI:   DW      10
        DB      "BLOCK-INIT"
BLINI:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    QDSKER-(CW*(C_HOFFSET))
        DW    N_BLINI
    DW    0

        DW      BLFL, SFET
        DW      ROT
        DW      OFILE
        DW      ZEQU, NEGATE  ; 0 if disk problems, 1 if not.
        DW      LWARN, FETCH, MIN ; AND but WARNING is 0/1.
        DW      LWARN, STORE
        DW      BHAN, STORE
        DW      SEMIS
;

;  ******************
;  *   BLOCK-EXIT   *
;  ******************
;
N_BLEXI:   DW      10
        DB      "BLOCK-EXIT"
BLEXI:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    BLINI-(CW*(C_HOFFSET))
        DW    N_BLEXI
    DW    0

        DW      FLUSH
        DW      BHAN, FETCH
        DW      CFILE
        DW      ZERO, LWARN, STORE
        DW      LIT, -1, BHAN, STORE    ;Regardless of close errors.
        DW      QDSKER
        DW      SEMIS
;

;  ************
;  *   SEEK   *
;  ************
;
N_SEEK:   DW      4
        DB      "SEEK"
SEEK:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    BLEXI-(CW*(C_HOFFSET))
        DW    N_SEEK
    DW    0

        DW      BBUF
        DW      USTAR
        DW      BHAN, FETCH
        DW      PFILE           ; Disk position.
        DW      QDSKER
        DW      SEMIS
;

;  ***********
;  *   R\W   *
;  ***********
;
N_RSLW:   DW      3
        DB      "R\W"
RSLW:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SEEK-(CW*(C_HOFFSET))
        DW    N_RSLW
    DW    0

        DW      TOR ; blk on top
        DW      SEEK ; That's done
        DW      BBUF
        DW      BHAN, FETCH
        DW      FROMR
        DW      ZBRAN
        DW      RSLW1-$-CW
        DW      RFILE           ; Disk read 
        DW      SWAP, DROP
        DW      BRAN
        DW      RSLW2-$-CW
RSLW1:  DW      WFILE           ; Disk write
RSLW2:
        DW      QDSKER
        DW      SEMIS
;
;

;  *************
;  *   SHELL   *
;  *************
;
N_SHELL:   DW      5
        DB      "SHELL"
SHELL:        DW    DOVAR
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    RSLW-(CW*(C_HOFFSET))
        DW    N_SHELL
    DW    0

         
                DW      14
        DB      "C:\COMMAND.COM"
        RESB    30-9               ; Allow for some path
;

;

;  **************
;  *   SYSTEM   *
;  **************
;
N_SYSTEM:   DW      6
        DB      "SYSTEM"
SYSTEM:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SHELL-(CW*(C_HOFFSET))
        DW    N_SYSTEM
    DW    0

        DW      LIT, COMBUF, TOR
        DW      ZERO, SHELL, CHAPP, LIT, -1, SHELL, PSTORE
        DW      SKIP
         DW      5
SB5: DB      "X /c "
       
        DW      LIT, SB5
        DW      LIT, 5
        DW      RR, SSTOR
        DW      RR, SADD, LIT, ACR, RR, CHAPP
        DW      FROMR, SFET, ONEM, SWAP, CSTOR ;Fill in (BD) count at X.
 
        DW      SHELL, CELLP, X, LIT, LOADEXEC
        DW      LIT, 4B00H, BDOSN
        DW      SWAP, QERR
        DW      SEMIS
LOADEXEC:   DW  0       ; The 0 are filled in at boot with DS.
        DW      COMBUF + CW  ;Allow it to be a counted string.
        DW      0
        DW      6CH
        DW      0
        DW      7CH
        DW      0
COMBUF:  RESB    CW+256  ;One cell for high level string manipulation.
 ; 
;
; 
;
;
;
; 
; 
;


;  *********
;  *   '   *
;  *********
;
N_ITICK:   DW      1
        DB      "'"
ITICK:        DW    DOCOL 
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SYSTEM-(CW*(C_HOFFSET))
        DW    N_ITICK
    DW    0

        DW      LPWORD, PRESENT
        DW      LDUP, ZEQU
        DW      LIT, 11, QERR
        DW      SEMIS
;

;  ***********
;  *   [']   *
;  ***********
;
N_BTICK:   DW      3
        DB      "[']"
BTICK:        DW    DOCOL
        DW    (TICK+(CW*(PH_OFFSET-C_HOFFSET)))
        DW    B_IMMED
        DW    ITICK-(CW*(C_HOFFSET))
        DW    N_BTICK
    DW    0

;
;

;  ******************
;  *   FORGET-VOC   *
;  ******************
;
N_FORGV:   DW      10
        DB      "FORGET-VOC"
FORGV:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    BTICK-(CW*(C_HOFFSET))
        DW    N_FORGV
    DW    0

        DW      TDUP
        DW      SWAP
        DW      ULESS
        DW      ZBRAN
        DW      FORGV1-$-CW
;  Forget part of contents.
        DW      SWAP
        DW      TOR
        DW      TWID
        DW      LDUP
FORGV3:
        DW      TLFA,FETCH    ; Next voc
        DW      LDUP
        DW      RR
        DW      ULESS
        DW      ZBRAN
        DW      FORGV3-$-CW
        DW      SWAP
        DW      TLFA
        DW      STORE
        DW      FROMR
        DW      BRAN
        DW      FORGV2-$-CW
FORGV1:
;        Vocabulary itself is also forgotten.
        DW      TVFA
        DW      FETCH     ; Unlink by linking next vocabulary.
        DW      VOCL
        DW      STORE
        DW      ONLY, FORTH
        DW      DEFIN
FORGV2: DW      SEMIS
;

;  **************
;  *   FORGET   *
;  **************
;
N_FORG:   DW      6
        DB      "FORGET"
FORG:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    FORGV-(CW*(C_HOFFSET))
        DW    N_FORG
    DW    0

        DW      TICK
        DW      LDUP
        DW      FENCE
        DW      FETCH
        DW      LESS
        DW      LIT, 21, QERR
        DW      LIT,FORGV
        DW      FORV
        DW      TNFA, FETCH, LDP, STORE
        DW      SEMIS
;

;  *************
;  *   (BACK   *
;  *************
;
N_PBACK:   DW      5
        DB      "(BACK"
PBACK:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    FORG-(CW*(C_HOFFSET))
        DW    N_PBACK
    DW    0

        DW      HERE
        DW      SEMIS
;

;  *************
;  *   BACK)   *
;  *************
;
N_BACKP:   DW      5
        DB      "BACK)"
BACKP:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PBACK-(CW*(C_HOFFSET))
        DW    N_BACKP
    DW    0

        DW      HERE
        DW      CELLP
        DW      LSUB
        DW      COMMA
        DW      SEMIS
;

;  ****************
;  *   (FORWARD   *
;  ****************
;
N_PFORWARD:   DW      8
        DB      "(FORWARD"
PFORWARD:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    BACKP-(CW*(C_HOFFSET))
        DW    N_PFORWARD
    DW    0

        DW      HERE
        DW      X
        DW      COMMA
        DW      SEMIS
;

;  ****************
;  *   FORWARD)   *
;  ****************
;
N_FORWARDP:   DW      8
        DB      "FORWARD)"
FORWARDP:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PFORWARD-(CW*(C_HOFFSET))
        DW    N_FORWARDP
    DW    0

        DW      HERE
        DW      OVER
        DW      CELLP
        DW      LSUB
        DW      SWAP
        DW      STORE
        DW      SEMIS
;

;  *************
;  *   BEGIN   *
;  *************
;
N_BEGIN:   DW      5
        DB      "BEGIN"
BEGIN:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    FORWARDP-(CW*(C_HOFFSET))
        DW    N_BEGIN
    DW    0

        DW      PBACK
        DW      QCOMP, ONE
        DW      SEMIS
;

;  ************
;  *   THEN   *
;  ************
;
N_THEN:   DW      4
        DB      "THEN"
THEN:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    BEGIN-(CW*(C_HOFFSET))
        DW    N_THEN
    DW    0

        DW      QCOMP, TWO, QPAIR
        DW      FORWARDP
        DW      SEMIS
;

;  **********
;  *   DO   *
;  **********
;
N_DO:   DW      2
        DB      "DO"
DO:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    THEN-(CW*(C_HOFFSET))
        DW    N_DO
    DW    0

         DW      LIT, XDO, COMMA, PFORWARD, PBACK
        DW      LIT,3    ; Magic number
        DW      SEMIS
;

;  ***********
;  *   ?DO   *
;  ***********
;
N_QDO:   DW      3
        DB      "?DO"
QDO:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    DO-(CW*(C_HOFFSET))
        DW    N_QDO
    DW    0

         DW      LIT, XQDO, COMMA, PFORWARD, PBACK
        DW      LIT,3    ; Magic number
        DW      SEMIS
;

;  ************
;  *   LOOP   *
;  ************
;
N_LLOOP:   DW      4
        DB      "LOOP"
LLOOP:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    QDO-(CW*(C_HOFFSET))
        DW    N_LLOOP
    DW    0

        DW      LIT, 3, QPAIR
        DW      LIT, XLOOP, COMMA, BACKP
        DW      FORWARDP ; For DO to push the leave address.
        DW      SEMIS
;

;  *************
;  *   +LOOP   *
;  *************
;
N_PLOOP:   DW      5
        DB      "+LOOP"
PLOOP:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    LLOOP-(CW*(C_HOFFSET))
        DW    N_PLOOP
    DW    0

        DW      LIT, 3, QPAIR
        DW      LIT, XPLOO, COMMA, BACKP
        DW      FORWARDP ; For DO to push the leave address.
        DW      SEMIS
;

;  *************
;  *   UNTIL   *
;  *************
;
N_UNTIL:   DW      5
        DB      "UNTIL"
UNTIL:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    PLOOP-(CW*(C_HOFFSET))
        DW    N_UNTIL
    DW    0

        DW      ONE, QPAIR
        DW      LIT, ZBRAN, COMMA, BACKP
        DW      SEMIS
;

;  *************
;  *   AGAIN   *
;  *************
;
N_AGAIN:   DW      5
        DB      "AGAIN"
AGAIN:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    UNTIL-(CW*(C_HOFFSET))
        DW    N_AGAIN
    DW    0

        DW      ONE, QPAIR
        DW      LIT, BRAN, COMMA, BACKP
        DW      SEMIS
;

;  **************
;  *   REPEAT   *
;  **************
;
N_REPEA:   DW      6
        DB      "REPEAT"
REPEA:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    AGAIN-(CW*(C_HOFFSET))
        DW    N_REPEA
    DW    0

        DW      ONE, QPAIR   ; Matches BEGIN ?
        DW      LIT, BRAN, COMMA, BACKP
        DW      QCOMP, LIT, 4, QPAIR ; Matches WHILE ?
        DW      FORWARDP ; WHILE target. 
        DW      SEMIS
;

;  **********
;  *   IF   *
;  **********
;
N_LIF:   DW      2
        DB      "IF"
LIF:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    REPEA-(CW*(C_HOFFSET))
        DW    N_LIF
    DW    0

        DW      LIT, ZBRAN, COMMA, PFORWARD
        DW      TWO     ; Magic number
        DW      SEMIS
;

;  ************
;  *   ELSE   *
;  ************
;
N_LELSE:   DW      4
        DB      "ELSE"
LELSE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    LIF-(CW*(C_HOFFSET))
        DW    N_LELSE
    DW    0

        DW      QCOMP, TWO, QPAIR
        DW      LIT, BRAN, COMMA, PFORWARD
        DW      SWAP
        DW      FORWARDP
        DW      TWO     ; Magic number
        DW      SEMIS
;

;  *************
;  *   WHILE   *
;  *************
;
N_LWHILE:   DW      5
        DB      "WHILE"
LWHILE:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    B_IMMED
        DW    LELSE-(CW*(C_HOFFSET))
        DW    N_LWHILE
    DW    0

        DW      TOR    ;  Save backward target. 
        DW      TOR
        DW      LIT, ZBRAN, COMMA, PFORWARD
        DW      LIT, 4 ; Magic number
        DW      FROMR
        DW      FROMR
        DW      SEMIS
;

;  **************
;  *   SPACES   *
;  **************
;
N_SPACES:   DW      6
        DB      "SPACES"
SPACES:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LWHILE-(CW*(C_HOFFSET))
        DW    N_SPACES
    DW    0

        DW      ZERO
        DW      MAX
        DW      ZERO
        DW     XQDO
        DW      SPAX1-$-CW
SPAX2:  DW      SPACE
        DW     XLOOP
        DW      SPAX2-$-CW    ;LOOP
SPAX1:
        DW      SEMIS
;

;  **********
;  *   <#   *
;  **********
;
N_BDIGS:   DW      2
        DB      "<#"
BDIGS:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SPACES-(CW*(C_HOFFSET))
        DW    N_BDIGS
    DW    0

        DW      PAD
        DW      HLD
        DW      STORE
        DW      SEMIS
;

;  **********
;  *   #>   *
;  **********
;
N_EDIGS:   DW      2
        DB      "#>"
EDIGS:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    BDIGS-(CW*(C_HOFFSET))
        DW    N_EDIGS
    DW    0

        DW      DROP
        DW      DROP
        DW      HLD
        DW      FETCH
        DW      PAD
        DW      OVER
        DW      LSUB
        DW      SEMIS
;

;  ************
;  *   SIGN   *
;  ************
;
N_SIGN:   DW      4
        DB      "SIGN"
SIGN:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    EDIGS-(CW*(C_HOFFSET))
        DW    N_SIGN
    DW    0

        DW      ZLESS
        DW      ZBRAN
        DW      SIGN1-$-CW ;IF
        DW      LIT,2DH
        DW      HOLD    ;THEN
SIGN1:  DW      SEMIS
;

;  *********
;  *   #   *
;  *********
;
N_DIG:   DW      1
        DB      "#"
DIG:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    SIGN-(CW*(C_HOFFSET))
        DW    N_DIG
    DW    0

        DW      BASE
        DW      FETCH
        DW      MSMOD
        DW      ROT
        DW      LIT,9
        DW      OVER
        DW      LESS
        DW      ZBRAN
        DW      DIG1-$-CW  ;IF
        DW      LIT,7
        DW      PLUS    ;THEN
DIG1:   DW      LIT,30H
        DW      PLUS
        DW      HOLD
        DW      SEMIS
;

;  **********
;  *   #S   *
;  **********
;
N_DIGS:   DW      2
        DB      "#S"
DIGS:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    DIG-(CW*(C_HOFFSET))
        DW    N_DIGS
    DW    0

DIGS1:  DW      DIG     ;BEGIN
        DW      OVER
        DW      OVER
        DW      LOR
        DW      ZEQU
        DW      ZBRAN
        DW      DIGS1-$-CW ;UNTIL
        DW      SEMIS
;

;  *************
;  *   (D.R)   *
;  *************
;
N_PDDOTR:   DW      5
        DB      "(D.R)"
PDDOTR:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    DIGS-(CW*(C_HOFFSET))
        DW    N_PDDOTR
    DW    0

        DW      TOR
        DW      SWAP
        DW      OVER
        DW      DABS
        DW      BDIGS
        DW      DIGS
        DW      ROT
        DW      SIGN
        DW      EDIGS
        DW      FROMR
        DW      OVER
        DW      LSUB
        DW      SPACES
        DW      SEMIS
;

;  ***********
;  *   D.R   *
;  ***********
;
N_DDOTR:   DW      3
        DB      "D.R"
DDOTR:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    PDDOTR-(CW*(C_HOFFSET))
        DW    N_DDOTR
    DW    0

        DW      PDDOTR
        DW      LTYPE
        DW      SEMIS
;

;  **********
;  *   .R   *
;  **********
;
N_DOTR:   DW      2
        DB      ".R"
DOTR:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    DDOTR-(CW*(C_HOFFSET))
        DW    N_DOTR
    DW    0

        DW      TOR
        DW      STOD
        DW      FROMR
        DW      DDOTR
        DW      SEMIS
;

;  **********
;  *   D.   *
;  **********
;
N_DDOT:   DW      2
        DB      "D."
DDOT:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    DOTR-(CW*(C_HOFFSET))
        DW    N_DDOT
    DW    0

        DW      ZERO
        DW      DDOTR
        DW      SPACE
        DW      SEMIS
;

;  *********
;  *   .   *
;  *********
;
N_DOT:   DW      1
        DB      "."
DOT:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    DDOT-(CW*(C_HOFFSET))
        DW    N_DOT
    DW    0

        DW      STOD
        DW      DDOT
        DW      SEMIS
;

;  *********
;  *   ?   *
;  *********
;
N_QUES:   DW      1
        DB      "?"
QUES:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    DOT-(CW*(C_HOFFSET))
        DW    N_QUES
    DW    0

        DW      FETCH
        DW      DOT
        DW      SEMIS
;

;  **********
;  *   U.   *
;  **********
;
N_UDOT:   DW      2
        DB      "U."
UDOT:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    QUES-(CW*(C_HOFFSET))
        DW    N_UDOT
    DW    0

        DW      ZERO
        DW      DDOT
        DW      SEMIS
;

;  *****************
;  *   FOR-WORDS   *
;  *****************
;
N_FORW:   DW      9
        DB      "FOR-WORDS"
FORW:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    UDOT-(CW*(C_HOFFSET))
        DW    N_FORW
    DW    0

        DW      SWAP
        DW      TOR
        DW      TOR
FORW1:  DW      FROMR
        DW      RR
        DW      OVER
        DW      TLFA
        DW      FETCH
        DW      TOR
        DW      EXEC
        DW      RR
        DW      ZEQU
        DW      ZBRAN
        DW      FORW1-$-CW
        DW      RDROP
        DW      RDROP
        DW      SEMIS
;

;  ****************
;  *   FOR-VOCS   *
;  ****************
;
N_FORV:   DW      8
        DB      "FOR-VOCS"
FORV:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    FORW-(CW*(C_HOFFSET))
        DW    N_FORV
    DW    0

        DW      TOR
        DW      VOCL
        DW      FETCH
        DW      TOR
FORV1:  DW      FROMR
        DW      RR
        DW      OVER
        DW      TVFA
        DW      FETCH
        DW      TOR
        DW      EXEC
        DW      RR
        DW      ZEQU
        DW      ZBRAN
        DW      FORV1-$-CW
        DW      RDROP
        DW      RDROP
        DW      SEMIS
;

;  *************
;  *   WORDS   *
;  *************
;
N_WORDS:   DW      5
        DB      "WORDS"
WORDS:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    FORV-(CW*(C_HOFFSET))
        DW    N_WORDS
    DW    0

        DW      CSLL
        DW      LOUT
        DW      STORE
        DW      LIT, IDDOT
        DW      SEARCH
        DW      FETCH
        DW      FORW
        DW      SEMIS
;


;  ***********
;  *   BYE   *
;  ***********
;
N_BYE:   DW      3
        DB      "BYE"
BYE:        DW    $+(CW*(PH_OFFSET-C_HOFFSET))
        DW    $+(CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    WORDS-(CW*(C_HOFFSET))
        DW    N_BYE
    DW    0

        MOV     AL,[(XCODE+(CW*(PH_OFFSET-C_HOFFSET)))]
        MOV     AH,4CH
        INT     21H
; EXIT TO PC-DOS
; 
; 

;  *****************
;  *   EXIT-CODE   *
;  *****************
;
N_XCODE:   DW      9
        DB      "EXIT-CODE"
XCODE:        DW    DOVAR
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    BYE-(CW*(C_HOFFSET))
        DW    N_XCODE
    DW    0

        DW      0
;
; 
;

;  ************
;  *   LIST   *
;  ************
;
N_LLIST:   DW      4
        DB      "LIST"
LLIST:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    XCODE-(CW*(C_HOFFSET))
        DW    N_LLIST
    DW    0

        DW      SCR,STORE
        DW      SKIP
         DW      6
SB6: DB      "SCR # "
       
        DW      LIT, SB6
        DW      LIT, 6
        DW      LTYPE
        DW      BASE, FETCH
        DW      DECA
        DW      SCR, FETCH, DOT
        DW      BASE, STORE
        DW      SCR, FETCH, BLOCK
        DW      LIT,1024
LLIST1: DW      LIT, ALF, SSPLIT
        DW      CR, LTYPE
        DW      OVER,ZEQU ;DUP would not show a last empty line!
        DW      ZBRAN
        DW      LLIST1-$-CW
        DW      TDROP
        DW      SEMIS
;

;  *************
;  *   INDEX   *
;  *************
;
N_INDEX:   DW      5
        DB      "INDEX"
INDEX:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LLIST-(CW*(C_HOFFSET))
        DW    N_INDEX
    DW    0

        DW      LIT,AFF
        DW      EMIT,CR
        DW      ONEP,SWAP
        DW     XDO
        DW      INDE9-$-CW
INDE1:  DW      CR,IDO
        DW      LIT,3
        DW      DOTR,SPACE
        DW      ZERO,IDO
        DW      PLINE, LTYPE, KEYQ
        DW      ZBRAN
        DW      INDE2-$-CW
        DW      LLEAV
INDE2:  DW     XLOOP
        DW      INDE1-$-CW
INDE9:
        DW      SEMIS
;

;  **********
;  *   .S   *
;  **********
;
N_DOTS:   DW      2
        DB      ".S"
DOTS:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    INDEX-(CW*(C_HOFFSET))
        DW    N_DOTS
    DW    0

        DW      CR
        DW      LIT, 'S', EMIT
        DW      LIT, ASO, EMIT
        DW      SPACE
        DW      SPFET, SZERO, FETCH
DOC2:   DW      OVER, OVER,  EQUAL, ZEQU
        DW      ZBRAN
        DW      DOC1-$-CW
        DW      ZERO, CELLP, LSUB, LDUP, FETCH, DOT
        DW      BRAN
        DW      DOC2-$-CW
DOC1:    DW DROP, DROP
        DW      LIT, ASC, EMIT
        DW SEMIS
;

;  ********************
;  *   ENVIRONMENT?   *
;  ********************
;
N_ENVQ:   DW      12
        DB      "ENVIRONMENT?"
ENVQ:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    DOTS-(CW*(C_HOFFSET))
        DW    N_ENVQ
    DW    0

        DW      LIT, ENV, TWID, PFIND
        DW      TOR, TDROP, FROMR
        DW      LDUP
        DW      ZBRAN
        DW      ENVQ1-$-CW
        DW      EXEC
        DW      LIT, -1
ENVQ1:
        DW      SEMIS
;


;  *************
;  *   TRIAD   *
;  *************
;
N_TRIAD:   DW      5
        DB      "TRIAD"
TRIAD:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    ENVQ-(CW*(C_HOFFSET))
        DW    N_TRIAD
    DW    0

        DW      LIT,AFF
        DW      EMIT
        DW      LIT,3
        DW      SLASH
        DW      LIT,3
        DW      STAR
        DW      LIT,3
        DW      OVER,PLUS
        DW      SWAP
        DW     XDO
        DW      TRIA9-$-CW
TRIA1:  DW      CR,IDO
        DW      LLIST
        DW      KEYQ
        DW      ZBRAN
        DW      TRIA2-$-CW
        DW      LLEAV   ;LEAVE
TRIA2:  DW     XLOOP
        DW      TRIA1-$-CW    ;THEN
TRIA9:
        DW      CR
        DW      ZERO, MESS
        DW      SEMIS
;
;
; This word is not even fig!

;  ***************
;  *   .SIGNON   *
;  ***************
;
N_SIGNON:   DW      7
        DB      ".SIGNON"
SIGNON:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    TRIAD-(CW*(C_HOFFSET))
        DW    N_SIGNON
    DW    0

; PRINT CPU TYPE (8088)
        DW      CR
        DW      BASE,FETCH
        DW      LIT,36, BASE,STORE
        DW      LCPU, DDOT
        DW      BASE,STORE
;
        DW      LNAME, LTYPE, SPACE
        DW      LVERSION, LTYPE, SPACE
        DW      CR
        DW      SEMIS
;

;

;  **************
;  *   LOW-DP   *
;  **************
;
N_LOWDP:   DW      6
        DB      "LOW-DP"
LOWDP:        DW    DOUSE
        DW    (CW*(16))
        DW    0H
        DW    SIGNON-(CW*(C_HOFFSET))
        DW    N_LOWDP
    DW    0

;

;  **************
;  *   LOW-EM   *
;  **************
;
N_LOWEM:   DW      6
        DB      "LOW-EM"
LOWEM:        DW    DOUSE
        DW    (CW*(17))
        DW    0H
        DW    LOWDP-(CW*(C_HOFFSET))
        DW    N_LOWEM
    DW    0

;
; 
;
;**** LAST DICTIONARY WORD ****

;  ************
;  *   TASK   *
;  ************
;
N_TASK:   DW      4
        DB      "TASK"
TASK:        DW    DOCOL
        DW    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DW    0H
        DW    LOWEM-(CW*(C_HOFFSET))
        DW    N_TASK
    DW    0

        DW      SEMIS
;

TEXTEND  EQU     $       ; Show end of dictionary.
INITDP   EQU     TEXTEND ;Where we want new words.
ACTUAL_EM EQU    EM  ; Different for relocatable code only.
 ;  

%if 0

The remaining memory ( up to 'EM' ) is
used for:

        1. EXTENSION DICTIONARY
        2. PARAMETER STACK
        3. TERMINAL INPUT BUFFER
        4. RETURN STACK
        5. USER VARIABLE AREA
        6. DISK BUFFERS (UNLESS REQUIRED <1 MBYTE)


%endif

; 
;

 ;    ENDS
        ;
%if 0

  MISC. NOTES AND SCATTERED THOUGHTS

- Remember that all the FORTH words in this version are
  upper case letters.  Use <CAPS LOCK> when in FORTH.


- This source will assemble on all platforms where NASM is
  available.

  On MSDOS the command line is:
  nasm -fbin ci86.asm -o ci86.com
  (There may be exceptions for special configurations.)
  The result will run on MSDOS systems only, or stand alone
  an an IBM-compatible computer

- In a MODERN version <ctrl> P  will echo all output to the
  printer. This is not programmed here, but a feature of the MSDOS.
  The operating system may make available a command history too.

- Changing variable EM will allow you to create a larger
  dictionary space.  However I suggest you develop and
  DEBUG with EM set to 4000H.  Setting it to a larger value
  will result in a larger FORTH.EXE file, and you may
  need to run EXE2BIN ( Chap 10, DOS 2.0 ) to get enough
  disk space.  Once you are satisfied with what you have,
  then by all means take that extra memory.

- <Ctrl-Break> will vector to WARM start ( Label WARM_ENTRY: )
 ;  

- Subscribe to FORTH Dimensions.  It is a valuable source
  of system and application ideas.  Talking with fellow
  FORTH programmers is sure to stir up some exciting ideas.
  Consider joining a FIG chapter.  See the back of FORTH
  Dimensions for more info.

%endif

; Define the entry point, not valid for auto booting.
        ;     ORIG

























;




