      SUBROUTINE PCTIDY (DOUSER,CFILNM)
C  Version 7.01
C    by Ajit J. Thakkar, Chemistry Dept., U. of New Brunswick
C  Lahey F77L file definitions for Tidy
      INCLUDE 'TIDY.INC'
      INCLUDE 'UNITS.INC'
      COMMON/TDYVER/VERNUM
      CHARACTER*30 VERNUM
      CHARACTER*64 FILNM1, FILNM2, CFILNM
      CHARACTER*65 CLNAME
      INTEGER IDot
      LOGICAL DOUSER, FORFIL

C  Display version number on console
      WRITE (STDERR,'(1x,A)') VERNUM

C  Find and open user control file.
      INQUIRE (FILE='tidy.ini',EXIST=douser)
      IF (DOUSER) THEN
        CFILNM='tidy.ini'
        OPEN(USRFIL,FILE=CFILNM,STATUS='OLD',POSITION='REWIND')
      END IF

C  Find and open source file
      CALL GetCL(CLNAME)
      FILNM1=CLNAME(2:64)
      Idot=INDEX(FILNM1,'.')
      IF (Idot.eq.0) THEN
        IDOT=INDEX(FILNM1,' ')
        FILNM1=FILNM1(1:Idot-1)//'.for'
        INQUIRE (FILE=FILNM1,EXIST=forfil)
        IF (.NOT.FORFIL) THEN
          FILNM1=FILNM1(1:Idot-1)//'.f  '
          INQUIRE (FILE=FILNM1,EXIST=forfil)
          IF (.NOT.FORFIL) THEN
            WRITE (STDERR,'(A)') ' Source file does not exist'
            STOP
          END IF
        END IF
      END IF
      OPEN(INFILE,FILE=FILNM1,STATUS='OLD',POSITION='REWIND')

C  Open listing and "punched output" files.
C  formatted, sequential, overwrite old files if they exist
      FILNM1=FILNM1(1:Idot)//'lis'
      OPEN(OUTFIL,FILE=FILNM1,POSITION='REWIND',
     &     CARRIAGE CONTROL='FORTRAN')

      FILNM1=FILNM1(1:Idot)//'tid'
      OPEN(PUNFIL,FILE=FILNM1,POSITION='REWIND',CARRIAGE CONTROL='LIST')

C  Open scratch files
C  unformatted, sequential, overwrite old files if they exist
      FILNM1='SCFIL1.TDY'
      FILNM2='SCFIL2.TDY'
      OPEN(SCFIL1,FILE=FILNM1,POSITION='REWIND',FORM='UNFORMATTED')
      OPEN(SCFIL2,FILE=FILNM2,POSITION='REWIND',FORM='UNFORMATTED')

      RETURN
      END
