/*
	scr_ci - translate extended key codes to single numbers
*/

#include "scr_ci.h"

#ifdef __TURBOC__
#define ci getch
#endif

/*	these are extended codes returned by getchar(), after a zero */

#define home_code		71
#define up_code			72
#define pgup_code		73
#define left_code		75
#define right_code		77
#define end_code		79
#define down_code		80
#define pgdn_code		81
#define ins_code		82
#define del_code		83
#define ctrl_home_code	0x77
#define ctrl_end_code	0x75
#define ctrl_left_code	115
#define ctrl_right_code	116

#define F1_code			59
#define F2_code			60
#define F3_code			61
#define F4_code			62
#define F5_code			63
#define F6_code			64
#define F7_code			65
#define F8_code			66
#define F9_code			67
#define F10_code		68
#define F11_code		0xd9
#define F12_code		0xda

#define ctrl_F1_code	94
#define ctrl_F2_code	95
#define ctrl_F3_code	96
#define ctrl_F4_code	97
#define ctrl_F5_code	98
#define ctrl_F6_code	99
#define ctrl_F7_code	100
#define ctrl_F8_code	101
#define ctrl_F9_code	102
#define ctrl_F10_code	103
#define ctrl_F11_code	103
#define ctrl_F12_code	103

#define alt_F1_code		104
#define alt_F2_code		105
#define alt_F3_code		106
#define alt_F4_code		107
#define alt_F5_code		108
#define alt_F6_code		109
#define alt_F7_code		110
#define alt_F8_code		111
#define alt_F9_code		112
#define alt_F10_code	113
#define alt_F11_code	113
#define alt_F12_code	113

char translation_table[] = {
		up_code,			up_char,
		down_code,			down_char,
		left_code,			left_char,
		right_code,			right_char,
		home_code,			home_char,
		end_code,			end_char, 
		pgup_code,			pgup_char,
		pgdn_code,			pgdn_char, 
		ctrl_home_code,		ctrl_home_char,
		ctrl_end_code,		ctrl_end_char,
		ins_code,			ins_char,
		del_code,			del_char,
		ctrl_left_code,		ctrl_left_char,
		ctrl_right_code,	ctrl_right_char,
		F1_code,			F1_char,
		F2_code,			F2_char,
		F3_code,			F3_char,
		F4_code,			F4_char,
		F5_code,			F5_char,
		F6_code,			F6_char,
		F7_code,			F7_char,
		F8_code,			F8_char,
		F9_code,			F9_char,
		F10_code,			F10_char,
		F11_code,			F11_char,
		F12_code,			F12_char,

		ctrl_F1_code,		ctrl_F1_char,
		ctrl_F2_code,		ctrl_F2_char,
		ctrl_F3_code,		ctrl_F3_char,
		ctrl_F4_code,		ctrl_F4_char,
		ctrl_F5_code,		ctrl_F5_char,
		ctrl_F6_code,		ctrl_F6_char,
		ctrl_F7_code,		ctrl_F7_char,
		ctrl_F8_code,		ctrl_F8_char,
		ctrl_F9_code,		ctrl_F9_char,
		ctrl_F10_code,		ctrl_F10_char,
		ctrl_F11_code,		ctrl_F11_char,
		ctrl_F12_code,		ctrl_F12_char,

		alt_F1_code,		alt_F1_char,
		alt_F2_code,		alt_F2_char,
		alt_F3_code,		alt_F3_char,
		alt_F4_code,		alt_F4_char,
		alt_F5_code,		alt_F5_char,
		alt_F6_code,		alt_F6_char,
		alt_F7_code,		alt_F7_char,
		alt_F8_code,		alt_F8_char,
		alt_F9_code,		alt_F9_char,
		alt_F10_code,		alt_F10_char,
		alt_F11_code,		alt_F11_char,
		alt_F12_code,		alt_F12_char,

		0, 					255
		};
int scan_code;

scr_ci()
{
	int ch;
	char *s;

	ch = ci();
	if(ch == 0)
		{scan_code = ci();
		for (s = translation_table; *s; s += 2)
			if(*s == scan_code)
				break;
		return s[1];
		}
	return ch;
}

#ifdef MAIN

#include <stdio.h>

main()
{
	int ch;
	FILE *ofile;
	ofile = fopen("keys", "a");


	do
		{
		printf("type a key: ");
		ch = scr_ci();
		printf("   ch = %3d = %02x or '%c', scan code = %3d = %02x \n", 
							ch, ch, isprint(ch)?ch:'.', scan_code, scan_code);
		if(isalpha(ch) || isdigit(ch) || isspace(ch)) 
			fprintf(ofile, "%c", ch);
		else
			fprintf(ofile, "   ch = %3d = %02x or '%c', scan code %3d = %02x \n", 
							ch, ch, isprint(ch)?ch:'.', scan_code, scan_code);
		} while(ch != 'q');
	fclose(ofile);

}
#endif MAIN
