{ Triadic Koch Curve }

uses SVGA256;

var Order,S,Angle,X,Y,Xold,Yold,Color:integer;

{  InitGr  }
procedure InitGr(Order1,S1,Angle1,X1,Y1,Color1:integer);
begin
  Order:=Order1;
  S:=S1;
  Angle:=Angle1;
  X:=X1; Y:=Y1;
  Xold:=X; Yold:=Y;
  Color:=Color1;
end;
{  Turn  }
procedure Turn(Degree:integer);
begin
  Angle:=Angle+Degree;
  while Angle>360 do Angle:=Angle-360;
  while Angle<0 do Angle:=Angle+360;
end;
{  Forward  }
procedure Forward(S:integer);
begin
  X:=X+Round(2*Cos(Angle*Pi/180));
  Y:=Y+Round(2*Sin(Angle*Pi/180));
  Line(Xold,Yold,X,Y,Color div 8);
  Xold:=X; Yold:=Y;
  Color:=Color+1;
  if Color>104*8 then Color:=32*8;
end;
{  Triadic  }
procedure Triadic(I:integer);
begin
  if I>1 then begin
    Triadic(I-1);
    Turn(-60);
    Triadic(I-1);
    Turn(120);
    Triadic(I-1);
    Turn(-60);
    Triadic(I-1);
  end else Forward(S);
end;

var I:integer;
begin
  SetMode(3);
  Write('Triadic Koch Curve');
  InitGr(5,2,0,240,180,32*8);
  for I:=0 to 2 do
    begin Triadic(Order); Angle:=Angle+120; end;
  Readln;
  SetMode(0);
end.
