/** 3DGPL *************************************************\
 *  (X11, 8bit deep bitmaps, 32bit mashine)               *
 *  Header for hardware specific stuff.                   *
 *                                                        *
 *  Defines:                                              *
 *    HW_open_screen         opening output surface;      *
 *    HW_blit                colourmap onto the screen;   *
 *    HW_close_screen        closing output;              *
 *                                                        *
 *    HW_run_event_loop      runiing for events;          *
 *    HW_quit_event_loop     quiting running.             *
 *                                                        *
 *  (6/1995) By Sergei Savhenko. (savs@cs.mcgill.ca).     *
 *  Copyright (c) 1995 Sergei Savchenko.                  *
 *  THIS SOURCE CODE CAN'T BE USED FOR COMERCIAL PURPOSES *
 *  WITHOUT AUTHORISATION                                 *
\**********************************************************/

#include <X11/Xlib.h>                       /* all X stuff */
#include "../hardware/hardware.h"           /* harware dependent stuff */

Display *HW_display;                        /* x server connection */
Visual *HW_visual;                          /* display's visual */
int HW_screen;                              /* deafualt screen */
Colormap HW_cmap;                           /* window's colourmap */
GC HW_gc;                                   /* default graphical conext */
Window HW_window;                           /* window being created */
Window HW_rootw;                            /* the very root window */
XColor HW_rgb[256];                         /* pixels rgb values */
unsigned long HW_cells[256];                /* colour numbers */ 
XImage *HW_image;                           /* the thing containing bitmap */
int HW_running;                             /* event loop still running */

/**********************************************************\
 *  Implementations for fast memory operations.           *
\**********************************************************/
				  
void HW_set_int(int *d,long l,int v) {long i; for(i=0;i<l;i++) *d++=v; }

/**********************************************************\
 * Creating a window.                                     *
 * RETURNS:  0 on display opening error;                  *
 * --------  1 on success.                                *
\**********************************************************/

int HW_open_screen(char *display_name,char *screen_name,
		   struct HW_colour palette[256],unsigned char *colourmap
		  )
{
 int i;

 if((HW_display=XOpenDisplay(display_name))==NULL) return(0);
 HW_screen=DefaultScreen(HW_display);
 HW_visual=DefaultVisual(HW_display,HW_screen);
 HW_rootw=RootWindow(HW_display,HW_screen);
 HW_gc=DefaultGC(HW_display,HW_screen);

 HW_window=XCreateSimpleWindow(HW_display,HW_rootw,0,0,
			       HW_SCREEN_X_SIZE,HW_SCREEN_Y_SIZE,
			       CopyFromParent,CopyFromParent,CopyFromParent
			      );

 HW_cmap=XCreateColormap(HW_display,HW_rootw,HW_visual,AllocNone);
 for(i=0;i<256;i++)
  if(!XAllocColorCells(HW_display,HW_cmap,0,0,0,HW_cells+i,1))
   return(0);
  else
  {
   HW_rgb[i].flags= DoRed|DoGreen|DoBlue;
   HW_rgb[i].red=palette[i].hw_r;
   HW_rgb[i].green=palette[i].hw_g;
   HW_rgb[i].blue=palette[i].hw_b;
   HW_rgb[i].pixel=HW_cells[i];
  }
 XStoreColors(HW_display,HW_cmap,HW_rgb,256); 

 HW_image=XCreateImage(HW_display,HW_visual,8,ZPixmap,0,
		       colourmap,HW_SCREEN_X_SIZE,HW_SCREEN_Y_SIZE,
		       8,HW_SCREEN_X_SIZE); 

 XSetWindowColormap(HW_display,HW_window,HW_cmap); 
 XMapWindow(HW_display,HW_window);
 XSync(HW_display,False);                       
 XSelectInput(HW_display,HW_window,KeyPressMask); 

 return(1);
}

/**********************************************************\
 * blitting a bitmap into the allocated window.           *
\**********************************************************/

void HW_blit(void)
{
 XPutImage(HW_display,HW_window,HW_gc,
	   HW_image,0,0,0,0,HW_SCREEN_X_SIZE,HW_SCREEN_Y_SIZE);
}

/**********************************************************\
 * Deallocating a window.                                 *
\**********************************************************/

void HW_close_screen(void)
{
 XCloseDisplay(HW_display);
}

/**********************************************************\
 *  The main event loop.                                  *
\**********************************************************/

void HW_run_event_loop(void (*application_main)(void),
		       void (*application_key_handler)(int key_code)
		      )
{
 XEvent report;                             /* beware putting XKeyEvent here */ 

 HW_running=1;
 while(HW_running==1)
 {
  if(XCheckWindowEvent(HW_display,HW_window,KeyPressMask,&report)==1)
   application_key_handler(((XKeyEvent*)&report)->keycode);
  application_main();    
 }
}

/**********************************************************\
 *  quiting the event loop.                               *
\**********************************************************/

void HW_quit_event_loop(void)
{
 HW_running=0;
}

/**********************************************************/
