/* Mouse Library */

#include <dos.h>

int mouse_init(void)
{
	union REGS iReg, oReg;
	void (interrupt far *int_handler)();
	long vector;
	unsigned char first_byte;

	int_handler = _dos_getvect(0x33);
	first_byte = *(unsigned char far *) int_handler;
	vector = (long) int_handler;

	if(( vector == 0) || (first_byte == 0xCF))
		return 0;

	iReg.x.ax = 0;
	_int86(0x33,&iReg,&oReg);

	if( oReg.x.ax == 0xFFFF )
		return 1;
	else
		return 0;
}

void mouse_call(int *m1, int *m2, int *m3, int *m4)
{
	union REGS iReg, oReg;

	iReg.x.ax = *m1;
	iReg.x.bx = *m2;
	iReg.x.cx = *m3;
	iReg.x.dx = *m4;

	_int86(0x33,&iReg,&oReg);

	*m1 = oReg.x.ax;
	*m2 = oReg.x.bx;
	*m3 = oReg.x.cx;
	*m4 = oReg.x.dx;
}
