/***************************************************************************/
/*           Cube.Hpp : The class encapsulating everything 'bout           */
/*                      the cube, from displaying to updating.             */
/*                                                                         */
/*           By : Nikhil V.                      Dt. : 9/23/1997.          */
/***************************************************************************/
#ifndef CUBE
#define CUBE

#include "face.hpp"

class Cube {
	Face *faces;                         // The array of the faces.
	int numface, count;                  // numface is just for flexibility
	public:
		Cube(int nfaces) {
			numface = nfaces;
			count = 0;                 // counts initialized elements of
								  // the array.
			faces = new Face[numface]; // Initialize the data structure.
			}
		Cube operator <<(Face &arg) {   // Put the face into the array.
			faces[count] = arg;
			count++;
			return *this;
			}
		void show();
		void update(double XMatrix[3][3]);
		void erase();
		void changeAng(int angl, int tilt);
		void resetPts();
		void chDist(int dist);
	};

void Cube::show() {                    // Use method of face object.
	for(int i = 0; i < numface; i++) faces[i].show();
	}

void Cube::update(double XMatrix[3][3]) {
	for(int i = 0; i < numface; i++) {
		faces[i].XForm(XMatrix);     // transform.
		}
	}

void Cube::erase() {
	for(int i = 0; i < numface; i++) {    // Draw the cube in BLACK color.
		faces[i].erase();
		}
	}

void Cube::changeAng(int angl, int tilt) {
	for(int i = 0; i < numface; i++) {
		faces[i].changeAng(angl, tilt);  // Change viewing parameters of
		}                                // all points in the cube.
	}

void Cube::resetPts() {
	for(int i = 0; i < numface; i++) {
		faces[i].reset();            // Use face's Reset method.
		}
	}

void Cube::chDist(int dist) {
	for(int i = 0; i < numface; i++) {
		faces[i].chDist(dist);       // Change the distance of the viewer
		}                            // for all the faces in the cube.
	}

#endif
/***************************************************************************/
