/* Set up the basic primitives for Layer control */

#include <stdio.h>
#include <string.h>
#include "\usr\include\intr_lib.h"
#include "program.h"
#include "eelayer.h"


#define MAX_LAYERS 44
#define LAYER_OFF 0
#define LAYER_ON  1
#define LAYER_ENABLED 2
#define LAYER_UNUSED  4

#define BLACK		0
#define RED		4
#define GREEN		2
#define BLUE		1
#define YELLOW		14
#define CYAN		3
#define MAGENTA		5
#define WHITE		15


static char *UsedLayers[] ={
	"Wire",
	"Bus",
	"Gate",
	"IEEE",
	"PinFun",
	"PinNum",
	"PinNam",
	"RefDes",
	"Attr",
	"Device",
	"Notes",
	"NetNam",
	"Pin",
	"END"
};
static int LayerInfo[] ={
	 WHITE,0x8200,
	 YELLOW,0x0100,
	 CYAN,0x0100,
	 RED,0x0100, 
	 BLUE,0x0100, 
	 YELLOW,0x0100, 
	 BLUE,0x0100, 
	 YELLOW,0x0100, 
	 YELLOW,0x0100, 
	 CYAN,0x0100, 
	 BLUE,0x0100, 
	 RED,0x0100,
	 WHITE,0x0100
};

LayerStruct *Layer; 	/* define basic layer data pointer */

void SeedLayers()

{
	int pt;
	
	Layer = (LayerStruct *) MyMalloc(sizeof(LayerStruct));
	
	
	pt=0;
	Layer->CurrentWidth = 1;
/* seed Up the Layer Strings and colours, set all user layers off */
	while((strcmp(UsedLayers[pt],"END"))!=0){
		/* set layer name up */
	 
		strcpy(Layer->LayerNames[pt],UsedLayers[pt]);
		Layer->LayerStatus[pt]=
			 (LayerInfo[(pt * 2) +1] & 0x0f00)/0x100;

		Layer->LayerColor[pt] = LayerInfo[(pt * 2)];

		if(LayerInfo[(pt * 2) +1] & 0x8200)
			Layer->CurrentLayer=pt;
	 
		pt++;
	}
	 
	Layer->NumberOfLayers=pt-1;
	while(pt!=MAX_LAYERS){
		sprintf(Layer->LayerNames[pt],"User%d",pt);

		
		Layer->LayerStatus[pt] = LAYER_UNUSED;
							/* layers clear */
							/* and Off */
		Layer->LayerColor[pt] = INTR_COLOR_BLACK;
		/* Colours Black */ 
		pt++;
	}
	

	 
}
int ReturnCurrentWidth()
{
	return(Layer -> CurrentWidth);
}
void SetCurrentWidth(int Width)
{
	Layer -> CurrentWidth = Width;
}
int ReturnCurrentLayer()
{
	return(Layer -> CurrentLayer);
}
void SetCurrentLayer(int layer)
{
	Layer->CurrentLayer = layer;
}
char *ReturnLayerName(layer)
int layer;
{
	return(Layer->LayerNames[layer]);
}
void SetLayerName(layer,Name)
int layer;
char *Name;
{
	strcpy(Layer->LayerNames[layer],Name);
}
int ReturnLayerMode(layer)
int layer;
{
	return(Layer->LayerStatus[layer]);
}
void SetLayerMode(layer,Mode)
int layer,Mode;
{
	Layer->LayerStatus[layer]=Mode;
}

int ReturnLayerColor(layer)
int layer;
{
	return(Layer->LayerColor[layer]);
	 
}
void SetLayerColor(layer,Color)
int layer,Color;
{
	Layer->LayerColor[layer]=Color;
}
int ReturnLayerNumber()
{
	return(Layer->NumberOfLayers);
}
void SetLayerNumber(Number)
int Number;
{
	Layer->NumberOfLayers=Number;
}
void LoadLayers(f)
FILE *f;	/* Load the Layer Structuer from a file */
{
	int cnt,Number;
	char Line[LINE_LEN];
	int Mode,Color,layer;
	char Name[0x10];

	fgets(Line,LINE_LEN-1,f);	/* read line */
	sscanf(Line,"%s %d %d",Name,&Number,&Layer->CurrentLayer);
	if((strcmp(Name,"EELAYER"))!=0){
		/* Error! */
	} else
		SetLayerNumber(Number);
	cnt=0;
	while(cnt!=Number+1){
		fgets(Line,LINE_LEN-1,f);	/* read line */
		sscanf(Line,"%s %d %d %d",Name,&Color,&Mode,&layer);
		SetLayerName(layer,Name);
		SetLayerColor(layer,Color);
		SetLayerMode(layer,Mode);
		cnt++;
	}
	fgets(Line,LINE_LEN-1,f);	/* read trailing Line */

}
