/*****************************************************************************
* Definitions for the EED printer driver program:			     *
*****************************************************************************/

#ifndef PROGRAM_H
#define PROGRAM_H


#define EEDRAW_VERSION "Version 1.3"

#ifndef __MSDOS__

#ifdef mips					/* SGI R2000/R3000 machines. */
#define NO_VOID_PTR
#define SYSV
#endif /* mips */

char *malloc(unsigned int size);

#define searchpath(name) name

#ifndef M_PI
#define M_PI 3.1415927
#endif /* M_PI */

#endif /* __MSDOS__ */

#include "virtrstr.h"

typedef int		BooleanType;
typedef unsigned char	ByteType;
typedef double		RealType;

#ifdef VoidPtr
#undef VoidPtr
#endif /* VoidPtr */

#ifdef NO_VOID_PTR
#define VoidPtr		char *
#else
#define VoidPtr		void *
#endif /* NO_VOID_PTR */

#ifndef	NULL
#define	NULL	0
#endif

#ifndef	TRUE
#define	TRUE	1
#define	FALSE	0
#endif

#ifndef LINE_LEN
#define LINE_LEN	255
#define LINE_LEN_SHORT	81
#define FULL_PATH_LEN	81
#define FILE_NAME_LEN	14
#define MAX_PIN_INFO	10
#endif

#define SIGN(x)		((x) > 0 ? 1 : ((x) < 0 ? -1 : 0))
#define ABS(y)		((y) > 0 ? (y) : (-(y)))
#define SQR(y)		((y) * (y))
#define SGN(x)		((x) > 0 ? 1 : ((x) == 0 ? 0 : -1))
#define MIN(x, y)	((x) > (y) ? (y) : (x))
#define MAX(x, y)	((x) > (y) ? (x) : (y))
#define BOUND(x, Min, Max) (MIN(MAX((x), (Min)), (Max)))
#define GEN_COPY(Dest, Src, Size)       memcpy(Dest, Src, Size)

#define INFINITY	1e6
#define EPSILON		1e-6

#define DEG2RAD(Deg)	((Deg) * M_PI / 180.0)
#define RAD2DEG(Rad)	((Rad) * 180.0 / M_PI)

#define BSPACE	8
#define TAB	9
#define LF	10
#define CR	13
#define ESC	27

#define PAGE_SCALER	1000		/* Mapping from page size in inches. */
#define PAGE_A4_XSIZE	10.0			       /* Regular page size. */
#define PAGE_A4_YSIZE	7.5

/* Note the snap distance is also the scaler for libraries loaded in. */
#define DEFAULT_SNAP_DISTANCE	16		/* Distance to snap a point. */

typedef enum {
    DRAW_POLYLINE_STRUCT_TYPE,
    DRAW_CONNECTION_STRUCT_TYPE,
    DRAW_TEXT_STRUCT_TYPE,
    DRAW_LIB_ITEM_STRUCT_TYPE,
    DRAW_PICK_ITEM_STRUCT_TYPE
} DrawStructType;

typedef struct DrawGenericStruct {
    DrawStructType StructType;
    struct DrawGenericStruct *Pnext;
    struct LayerStruct *Layer;
} DrawGenericStruct;

typedef struct DrawPolylineStruct {
    DrawStructType StructType;
    struct DrawGenericStruct *Pnext;
    char Layer;
    TextWidthType Width;
    int NumOfPoints;		      /* Number of XY pairs in Points array. */
    int *Points;			/* XY pairs that forms the polyline. */
} DrawPolylineStruct;

typedef struct DrawConnectionStruct {
    DrawStructType StructType;
    struct DrawGenericStruct *Pnext;
    char Layer;
    int PosX, PosY;			    /* XY coordinates of connection. */
} DrawConnectionStruct;

typedef struct DrawTextStruct {
    DrawStructType StructType;
    struct DrawGenericStruct *Pnext;
    char Layer;
    int PosX, PosY, Scale;		    /* XY coordinates of connection. */
    TextOrientationType Orient;
    char *Text;
} DrawTextStruct;

typedef struct DrawLibItemStruct {
    DrawStructType StructType;
    struct DrawGenericStruct *Pnext;
    TextOrientationType PartNameOrient, ChipNameOrient;
    char *PartName;      /* Name of part, i.e. "Op. Amp. 21". Not Chip Name. */
    char *ChipName;	   /* Key to look for in the library, i.e. "74LS00". */
    int PartNameX, PartNameY;		    /* Where PartName should be put. */
    int ChipNameX, ChipNameY;		    /* Where ChipName should be put. */
    int Multi;			 /* In multi unit chip - which unit to draw. */
    int Transform[2][2];       /* The rotation/mirror transformation matrix. */
    int PosX, PosY;				  /* Exact position of part. */
    int BBoxMinX, BBoxMaxX, BBoxMinY, BBoxMaxY;     /* BBox around the part. */
} DrawLibItemStruct;


typedef struct LayerStruct {
	char LayerNames[45][8];
	int  LayerColor[45];
	char LayerStatus[45];
	int  NumberOfLayers;
	int CurrentLayer;
	int CurrentWidth;
}LayerStruct;


typedef struct DrawPickedStruct { /* Holds structures picked by pick events. */
    DrawStructType StructType;
    struct DrawPickedStruct *Pnext;
    DrawGenericStruct *PickedStruct;
} DrawPickedStruct;

extern int EEPageSizeX, EEPageSizeY; /* Clipping boundaries of current page. */
extern DrawGenericStruct *EEDrawList;         /* All objects are saved here. */
extern char *EEPSFontName;			     /* EED-PS PS font name. */
extern char *EEDataFileName;		      /* EED-PS EED input file name. */
extern LayerStruct *Layer;

VoidPtr MyMalloc(unsigned size);
void MyFree(VoidPtr p);
void MyExit(int ExitCode);
void FatalError(char *ErrMsg);

#endif PROGRAM_H
