#include <stdio.h>
#include "eelib.h"
#include "EElibdat.h"

#define VER "EELib, Library Manager,	Version 1.0"
#define DEL_FILE "del"		/* Deleted file extension */
#define SCRATCH_FILE "eelib.del"


main(argc,argv)
int argc;
char *argv[];
{
	if(argc==1){	/* no command line arg's givern */
		Command_Screen();
	} else {	/* Parrs the commandline */
		printf("%s\n",VER);
		if(argc!=3 & argc!=4){
			usage();
		} else {

		    if(argv[1][0]=='-' || argv[1][0]=='\/'){

			switch (argv[1][1]){
				case 'a' :
				case 'A' :
					if(argc!=4)
						usage();
					lib_cmd=1;
					sprintf(file_in,"%s.lib",argv[2]);
					sprintf(file_out,"%s",argv[3]);
					break;
				case 'c' :
				case 'C' :
					if(argc!=3)
						usage();
					lib_cmd=2;
					sprintf(file_in,"%s.lib",argv[2]);
					break;
				case 'd' :
				case 'D' :
					if(argc!=4)
						usage();
					lib_cmd=3;
					sprintf(file_in,"%s.lib",argv[2]);
					sprintf(file_out,"%s",argv[3]);
					break;
				case 'e' :
				case 'E' :
					if(argc!=4)
						usage();
					lib_cmd=4;
					sprintf(file_in,"%s.lib",argv[2]);
					sprintf(file_out,"%s",argv[3]);
					break;
				case 'l' :
				case 'L' :
					if(argc!=4)
						usage();
					lib_cmd=5;
					sprintf(file_in,"%s.lib",argv[2]);
					sprintf(file_out,"%s.lst",argv[3]);
					break;
				case 'm' :
				case 'M' :
					if(argc!=4)
						usage();
					lib_cmd=7; 
					sprintf(file_in,"%s.lib",argv[2]);
					sprintf(file_out,"%s.map",argv[3]);
					break;
				case 's' :
				case 'S' :
					if(argc!=3)
						usage();
					lib_cmd=6;
					sprintf(file_in,"%s.lib",argv[2]);
					break;
				default :
					usage();
				}
			command();
		   } else {
			usage();
		   }
		}
	}
	return(0);
}
void usage(void)
{
	printf("EELib <Switch> <File1> <File2>\n");
	exit(-1);
}
void Command_Screen(void)
{
	printf("No Command Screen Code Yet\n");
	usage();
}
void command(void)
{
	switch(lib_cmd){
		case 1 :
			add_lib();
			break;
		case 4 :
			extract_lib();
			break;
		case 2 :
			create_lib();
			break;
		case 3 :
			delete_lib();
			break;
		case 5 :
			list_lib();
			break;
		case 6 :
			show_lib();
			break;
		case 7 :
			map_lib();
			break;
	}
}
void add_lib(void)
{
	char make_name[0x100];

	int found_error = 0;

	if((fin=fopen(file_in,"r"))==NULL){
		fprintf(stderr,"Can't open library file %s\n",file_in);
		exit(-2);
	}
	while((c=getc(fin))!=EOF){
		ungetc(c,fin);
		fgets(buf,0x100,fin);
		sscanf(buf,"%s %s %s %d %d %d %d %d",cmd,name,leadin,
			&pins,&textinside,&drawnum,&units,&pinsperunit);
		if((strcmp("DEF",cmd))==0){

/* see if we can find the part in the library */

			if((strcmp(name,file_out))==0){
				found_error=1;
			}
		}
	}	/* checked the whole file, see if an error is called for */
	fclose(fin);
	if(found_error != 0){
		fprintf(stderr,"%s exists in the library already\n",file_out);
		fprintf(stderr,"Remove old part before installing new\n");
		exit(-3);
	}
	sprintf(make_name,"%s.bit",file_out);
	if((fin=fopen(file_in,"a"))==NULL){
		fprintf(stderr,"Can't open library file %s\n",file_in);
		exit(-2);
	}
	if((fout=fopen(make_name,"r"))==NULL){
		fprintf(stderr,"Can't open part file %s\n",make_name);
		exit(-2);
	}

	printf("About to add %s to library %s\n",make_name,file_in);

	 
/* opened the library file at the end, and about to copy */
/* new data to the end of library file */

	while((c=getc(fout))!=EOF)
		putc(c,fin);
	
/* close all the files */
	fclose(fin);
	fclose(fout);
}
void extract_lib(void)
{
	char output[0x20];

	if((fin=fopen(file_in,"r"))==NULL){
		fprintf(stderr,"Can't open %s for reading\n",file_in);
		exit(-2);
	}
	while((c=getc(fin))!=EOF){
		ungetc(c,fin);
		fgets(buf,0x100,fin);
		sscanf(buf,"%s %s %s %d %d %d %d %d",cmd,name,leadin,
			&pins,&textinside,&drawnum,&units,&pinsperunit);
		if((strcmp("DEF",cmd))==0){

/* find the part in the library */

			if((strcmp(name,file_out))==0){
				printf("%s found in %s, Unpacking to %s.bit\n",
					file_out,file_in,file_out);
				sprintf(output,"%s.bit",file_out);
				if((fout=fopen(output,"w"))==NULL){
					fprintf(stderr,"Cant open %s\n",
						output);
					exit(-2);
				}
				copy_to_file();
				fclose(fout);
			}
		}
	}
}
int copy_to_file(void)
{
	int flag = 1;
	fprintf(fout,"%s",buf);
	while(flag){
		fgets(buf,0x100,fin);
		sscanf(buf,"%s",name);
		if((strcmp(name,"ENDDEF"))==0){
			fprintf(fout,"%s",buf);
			return(1);
		} else {
			fprintf(fout,"%s",buf);
		}
	}
	return(0);	/* never reached */
}
	
void create_lib(void)
{
	char answer;

	if((fout=fopen(file_in,"r"))==NULL){
		create();
	} else {
		fclose(fout);
		/* Should we create ?? */
		printf("File Exist's, Overwrite (Y/N)? ");
		answer=getch();
		if(answer=='Y' | answer=='y')
			create();
	}
}
void create(void)
{
	if((fout=fopen(file_in,"w"))==NULL){
		fprintf(stderr,"Can't write to %s\n",file_in);
		exit(-2);
	}
	fprintf(fout,"EEDRAW-LIB Version 1\n#\n#\n# ");
	fprintf(fout,"Created by EELib\n#\n#\n#\n\n"); 
	fprintf(fout,"# Standard Layer Descriptions Follow\n#\n#\n");
	fprintf(fout,"#\t0) Wire\t\tWire Layer\n");
	fprintf(fout,"#\t1) Bus\t\tBus Layer\n");
	fprintf(fout,"#\t2) Gate\t\tGate Outline Layer\n");
	fprintf(fout,"#\t3) IEEE\t\tIEEE Outline Layer\n");
	fprintf(fout,"#\t4) PinFun\tin function Layer\n");
	fprintf(fout,"#\t5) PinNum\tPin Number Layer\n");
	fprintf(fout,"#\t6) PinNam\tPin Name Layer\n");
	fprintf(fout,"#\t7) RefDes\tReference Designator Layer\n");
	fprintf(fout,"#\t8) Attr\t\tAttribute Layer\n");
	fprintf(fout,"#\t9) Device\tDevice Name Layer\n");
	fprintf(fout,"#\t10) Notes\tUser Notes Layer\n");
	fprintf(fout,"#\t11) NetNam\tNetwork Name Layer\n");
	fprintf(fout,"#\t12) Pin\t\tDevice Pin Layer\n");
	fprintf(fout,"#\n#\n#\n");
	fclose(fout);

}
void delete_lib(void)
{
	char fn[0x100];
	int found = 0;
	printf("About to delete %s from library %s\n",file_out,file_in);
	if((fin=fopen(file_in,"r"))==NULL){
		fprintf(stderr,"Can't open file %s\n",file_in);
		exit(-2);
	}
	if((ftmp=fopen(SCRATCH_FILE,"w"))==NULL){
		fprintf(stderr,"Can't open scratch file\n");
		exit(-2);
	}
	while((c=getc(fin))!=EOF){
		ungetc(c,fin); 
		fgets(buf,0x100,fin);
		sscanf(buf,"%s %s %s %d %d %d %d %d",cmd,name,leadin,
			&pins,&textinside,&drawnum,&units,&pinsperunit);
		if((strcmp(name,file_out))==0){
			found=1;
			sprintf(fn,"%s.%s",file_out,DEL_FILE);
			if((fout=fopen(fn,"a"))==NULL){
				fprintf(stderr,"Can't open delete file %s\n",
					fn);
				exit(-2);
			}
			copy_to_file(); 
			fclose(fout);
		} else 
			fprintf(ftmp,"%s",buf);
	} /* file copyed to the scratch file, now copy back to library */
	fclose(ftmp);
	fclose(fin);
	replace_file(SCRATCH_FILE,file_in);
	if(found==0){
		fprintf(stderr,"%s Not found in library %s\n",file_out,file_in);
	}
	unlink(SCRATCH_FILE);	/* Clear the tempary file */
}
void replace_file(char *file1, char *file2)
{
	if((fin=fopen(file1,"r"))==NULL){
		fprintf(stderr,"Can't open %s for reading\n",
			SCRATCH_FILE);
		exit(-2);
	}
	if((fout=fopen(file2,"w"))==NULL){
		fprintf(stderr,"Can't open file %s for writting\n",file_in);
		exit(-2);
	}
	while((c=getc(fin))!=EOF)
		putc(c,fout);
	fclose(fin);
	fclose(fout);

}
void show_lib(void)
{
	int cnt;
	cnt=0;

	if((fin=fopen(file_in,"r"))==NULL){
		fprintf(stderr,"Can't open %s for reading\n",file_in);
		exit(-2);
	}
	while((c=getc(fin))!=EOF){
		ungetc(c,fin);
		fgets(buf,0x100,fin);
		sscanf(buf,"%s %s %s %d %d %d %d %d",cmd,name,leadin,
			&pins,&textinside,&drawnum,&units,&pinsperunit);
		if((strcmp("DEF",cmd))==0){
			if(cnt==0){
				printf("%s:\t%s",file_in,name);
				cnt++;
			} else {
				printf("\t%s",name);
				cnt++;
				if(cnt==4){
					printf("\n");
					cnt=0;
				}
			}
		}
	}
	printf("\n");
	fclose(fin);
}
void list_lib(void)
{
	if((fin=fopen(file_in,"r"))==NULL){
		fprintf(stderr,"Can't open %s for reading\n",file_in);
		exit(-2);
	}
	if((fout=fopen(file_out,"w"))==NULL){
		fprintf(stderr,"Can't open %s for writting\n",file_out);
		exit(-2);
	}
	fprintf(fout,"Library List From %s\n",file_in);
	while((c=getc(fin))!=EOF){
		ungetc(c,fin);
		fgets(buf,0x100,fin);
		sscanf(buf,"%s %s %s %d %d %d %d %d",cmd,name,leadin,
			&pins,&textinside,&drawnum,&units,&pinsperunit);
		if((strcmp("DEF",cmd))==0){
			fprintf(fout,"%s\n",name);
		}
	}
}
void map_lib(void)
{
	if((fin=fopen(file_in,"r"))==NULL){
		fprintf(stderr,"Can't open %s for reading\n",file_in);
		exit(-2);
	}
	if((fout=fopen(file_out,"a"))==NULL){
		fprintf(stderr,"Can't open %s for writting\n",file_out);
		exit(-2);
	}
	printf("Forming Best Guess Map List From Library %s\n",
		file_in);
	fprintf(fout,"#\n# Component -> Part Mapping File\n#\n");
	fprintf(fout,"# Units\tComponent\tPart\n#\n\n");
	while((c=getc(fin))!=EOF){
		ungetc(c,fin);
		fgets(buf,0x100,fin);
		sscanf(buf,"%s %s %s %d %d %d %d %d",cmd,name,leadin,
			&pins,&textinside,&drawnum,&units,&pinsperunit);
		if((strcmp("DEF",cmd))==0){
			if(units==0)
				units=1;
			 fprintf(fout,"%d\t%s\tcomp%03d\n",units,name,pins);
		}
	}
	fclose(fin);
	fclose(fout);
}

