/*
        Mouse methods
*/

typedef struct {
	int row,col,buttons;
	} mouse_state;

#define MOUSE_LEFT 1
#define MOUSE_RIGHT 2

int mouse_reset(void);
void mouse_on(void);             /* enables the mouse cursor */
void mouse_off(void);            /* disables the mouse cursor */
int mouse_get(mouse_state *m);           /* get mouse position and button status */
void mouse_put(mouse_state *m);          /* put mouse at position */
int mouse_click(mouse_state *m); /* mouse wait until click */
int mouse_click_grat(mouse_state *m);   /* mouse wait until click */
extern int (*mouse_idle_job)(void);         /* the mouse idle task */
int mouse_idle(void);                           /* idle mouse job */
int mouse_press(mouse_state *m);
extern int mouse_is;                    /* set to non-zero if mouse exists */
extern int use_grat;                    /* nonzero if graticule positioning */

