;
; some DPMI functions for C/C++ by P.Ulaszewski (September 2000)
;

global _DPMI_DOSmalloc			; function 100h
global _DPMI_DOSfree			; function 101h
global _DPMI_GetRMVector		; function 200h
global _DPMI_SetRMVector		; function 201h
global _DPMI_GetPMVector		; function 204h
global _DPMI_SetPMVector		; function 205h
global _DPMI_malloc			; function 501h
global _DPMI_free			; function 502h

segment _TEXT public align=16 class=CODE use32

; int DPMI_DOSmalloc (long size, short segment, short selector)
_DPMI_DOSmalloc:
	push ebx
	push edx
	mov eax,0100h
	mov ebx,[esp+4+8]		; size in bytes
	add ebx,0fh
	shr ebx,4			; convert to para
	int 31h
	jnc .malloc_ok
	xor eax,eax
	jmp short .exit
.malloc_ok:
	mov [esp+8+8],ax		; segment of allocated block
	mov [esp+12+8],dx		; selector of allocated block
	mov eax,1
.exit:
	pop edx
	pop ebx
	ret
	

; void DPMI_DOSfree (short selector);
_DPMI_DOSfree:
	push eax
	push edx
	mov eax,0101h
	mov dx,[esp+4+8]
	int 31h
	pop edx
	pop eax


; void DPMI_GetRMVector (int IntNum, short segment, short offset);
_DPMI_GetRMVector:
	push ebp
	mov ebp,esp
	push eax
	push ebx
	push ecx
	push edx
	mov eax,0200h
	mov bl,[ebp+8]			; IntNum
	int 31h
	mov [ebp+12],cx			; segment
	mov [ebp+16],dx			; offset
	pop edx
	pop ecx
	pop ebx
	pop eax
	ret


; void DPMI_SetRMVector (int IntNum, short segment, short offset);
_DPMI_SetRMVector:
	push ebp
	mov ebp,esp
	push eax
	push ebx
	push ecx
	push edx
	mov eax,0201h
	mov bl,[ebp+8]			; IntNum
	mov cx,[ebp+12]			; segment
	mov dx,[ebp+16]			; offset
	int 31h
	pop edx
	pop ecx
	pop ebx
	pop eax
	ret


; void DPMI_GetPMVector (int IntNum, short selector, long offset);
_DPMI_GetPMVector:
	push ebp
	mov ebp,esp
	push eax
	push ebx
	push ecx
	push edx
	mov eax,0204h
	mov bl,[ebp+8]			; IntNum
	int 31h
	mov [ebp+12],cx			; selector
	mov [ebp+16],edx		; offset
	pop edx
	pop ecx
	pop ebx
	pop eax
	ret


; void DPMI_SetPMVector (int IntNum, short selector, long offset);
_DPMI_SetPMVector:
	push ebp
	mov ebp,esp
	push eax
	push ebx
	push ecx
	push edx
	mov eax,0205h
	mov bl,[ebp+8]			; IntNum
	mov cx,[ebp+12]			; selector
	mov edx,[ebp+16]		; offset
	int 31h
	pop edx
	pop ecx
	pop ebx
	pop eax
	ret


; void *DPMI_malloc (long size, long handle)
_DPMI_malloc:
	push ebp
	mov ebp,esp
	push ebx
	push ecx
	push edx
	push esi
	push edi

	mov eax,501h
	mov ebx,[ebp+8]			; size
	shr ebx,16
	mov ecx,[ebp+8]			; size
	and ecx,0ffffh			; BX:CX = size
	int 31h
	jnc .malloc_ok
	xor eax,eax
	jmp short .exit
.malloc_ok:
	shl esi,16
	mov si,di
	mov [ebp+12],esi		; handle
	shl ebx,16
	mov bx,cx
	mov eax,ebx
.exit:
	pop edi
	pop esi
	pop edx
	pop ecx
	pop ebx
	pop ebp
	ret


; void DPMI_free (long handle)
_DPMI_free:
	push eax
	push esi
	push edi
	mov eax,502h
	mov esi,[esp+4+12]
	mov di,si
	shr esi,16
	int 31h
	pop edi
	pop esi
	pop eax
	ret
	

