
;
; Extra functions for 32bit Windows based compilers.
; This code is for programs running in 32bit DPMI.
; by Piotr Ulaszewski
;
; Note: if you have a DPMI 32bit capable compiler do not use this functions.
;


global _print
global _SetVGAMode
global _int386
global _outport
global _outpw
global _outportb
global _outp
global _inport
global _inpw
global _inportb
global _inp
global _delay
global _exit
global _fsize
global _loadfile


segment _TEXT public align=16 class=CODE use32


; void print (char *)
_print:
	push eax
	push edx
	mov edx,[esp+4+8]
	mov ah,9
	int 21h
	pop edx
	pop eax
	ret

	
; void SetVGAMode (int )
_SetVGAMode:
	push eax
	mov al,[esp+4+4]
	xor ah,ah
	int 10h
	pop eax
	ret
	

; void int386 (int , union REGS *, union REGS *)
_int386:
	push ebp
	mov ebp,esp
	pushad

	mov al,[ebp+8]			; int vector
	mov [ss:int_number],al
	mov esi,[ebp+12]		; inregs pointer
	push dword [esi]		; eax
	push dword [esi+4]		; ebx
	push dword [esi+8]		; ecx
	push dword [esi+12]		; edx
	push dword [esi+16]		; esi
	push dword [esi+20]		; edi
;	push dword [esi+24]		; cflag
;	push dword [esi+28]		; eflags
;	popfd
;	pop eax
;	bt eax,1
	pop edi
	pop esi
	pop edx
	pop ecx
	pop ebx
	pop eax
	db 0cdh
	int_number db 0
	push eax
	push ebx
	push ecx
	push edx
	push esi
	push edi
	setc al
	push eax
	pushfd
	mov esi,[ebp+16]		; outregs pointer
	pop dword [esi+28]		; eflags
	pop eax
	movzx eax,al
	mov [esi+24],eax		; cflag
	pop dword [esi+20]		; edi
	pop dword [esi+16]		; esi
	pop dword [esi+12]		; edx
	pop dword [esi+8]		; ecx
	pop dword [esi+4]		; ebx
	pop dword [esi]			; eax

	popad
	pop ebp
	ret


; void outport (short port, short value)
_outport:
_outpw:
	push eax
	push edx
	mov edx,[esp+4+8]		; port nr
	mov eax,[esp+8+8]		; value
	out dx,ax
	pop edx
	pop eax
	ret


; void outportb (short port, unsigned char value)
_outportb:
_outp:
	push eax
	push edx
	mov edx,[esp+4+8]		; port nr
	mov eax,[esp+8+8]		; value
	out dx,al
	pop edx
	pop eax
	ret


; int inport (short port)
_inport:
_inpw:
	push edx
	mov edx,[esp+4+4]		; port nr
	xor eax,eax
	in ax,dx
	pop edx
	ret


; int inportb (short port)
_inportb:
_inp:
	push edx
	mov edx,[esp+4+4]		; port nr
	xor eax,eax
	in al,dx
	ret
	

; void delay (int miliseconds)
_delay:
	push eax
	push ecx
	push edx
	mov edx,[esp+4+12]		; miliseconds
	shl edx,10			; multiply by 1024
	shld ecx,edx,16			; extend EDX to CX:DX
	mov ah,86h
	int 15h
	pop edx
	pop ecx
	pop eax
	ret


; void exit (int returncode)
_exit:
	mov al,[esp+4]
	mov ah,4ch
	int 21h


; long fsize (char *filename)
_fsize:
	push ebp
	mov ebp,esp
	sub esp,byte 8			; 2 dwords
	push ebx
	push ecx
	push edx
	mov edx,[ebp+8]			; filename
	mov eax,3d02h			; open file for read/write
	int 21h
	jnc .open_ok
	xor eax,eax
	jmp short .exit
.open_ok:
	mov [ebp-4],eax			; file handle
	mov ebx,eax
	mov eax,4202h			; lseek
	xor edx,edx
	xor ecx,ecx
	int 21h
	shl edx,16
	mov dx,ax
	mov [ebp-8],edx			; file size
	mov eax,4200h
	mov ebx,[ebp-4]			; file handle
	xor edx,edx
	xor ecx,ecx
	int 21h
	mov eax,3e00h			; close file
	mov ebx,[ebp-4]			; file handle
	int 21h
	mov eax,[ebp-8]			; file size
.exit:
	pop edx
	pop ecx
	pop ebx
	add esp,byte 8
	pop ebp
	ret


; int loadfile (char *filename, void *fileposition, void *destination, long size)
_loadfile:
	push ebp
	mov ebp,esp
	sub esp,byte 4
	push ebx
	push ecx
	push edx
	mov edx,[ebp+8]			; filename
	mov eax,3d02h			; open file for read/write
	int 21h
	jnc .open_ok
	xor eax,eax
	jmp short .exit
.open_ok:
	mov [ebp-4],eax			; file handle
	mov ebx,eax
	mov eax,4200h			; set file position
	mov edx,[ebp+12]		; file position
	shld ecx,edx,16			; CX:DX - file position
	int 21h
	jnc .fpos_ok
	xor eax,eax
	jmp short .exit_and_close
.fpos_ok:
	mov eax,3f00h			; read file
	mov ebx,[ebp-4]			; file handle
	mov ecx,[ebp+20]		; size to read
	mov edx,[ebp+16]		; destination pointer
	jnc .fread_ok
	xor eax,eax
	jmp short .exit_and_close
.fread_ok:
	mov eax,1
.exit_and_close:
	push eax
	mov eax,3e00h
	mov ebx,[ebp-4]			; file handle
	int 21h
	pop eax
.exit:
	pop edx
	pop ecx
	pop ebx
	add esp,byte 4
	pop ebp
	ret


