/*

 Mini Run Time library for DPMI.

 If you have a DPMI 32bit capable compiler do not use this header.
 This header is only for 32bit Windows based compilers,
 in order to provide basic console functions for DOS Extended
 applications.
 1998-2000 Piotr Ulaszewski

*/


#ifdef __cplusplus
extern "C" {
#endif


extern void cdecl print(char *text);
extern void cdecl SetVGAMode(int mode);

typedef union{
   struct {
      dword ax;
      dword bx;
      dword cx;
      dword dx;
      dword si;
      dword di;
      dword cflag;
      dword flags;
   } x;
   struct {
      byte al;
      byte ah;
      word upper_ax;
      byte bl;
      byte bh;
      word upper_bx;
      byte cl;
      byte ch;
      word upper_cx;
      byte dl;
      byte dh;
      word upper_dx;
   } h;
} REGS;

extern void cdecl int386(int IntNr, union REGS *inregs, union REGS *outregs);
extern void cdecl outport(short port, short value);
extern void cdecl outpw(short port, short value);
extern void cdecl outportb(short port, unsigned char value);
extern void cdecl outp(short port, unsigned char value);
extern int cdecl inport(short port);
extern int cdecl inpw(short port);
extern int cdecl inportb(short port);
extern int cdecl inp(short port);
extern void cdecl delay(int miliseconds);
extern void cdecl exit(int );

extern long cdecl fsize(char *filename);
extern int cdecl loadfile(char *filename, void *fileposition, void *destination, long size);

#ifdef __cplusplus
}
#endif

