/*******************************************************************
 *
 *  ttkern.h                                                     1.0
 *
 *    Kerning support interface.            
 *
 *  Copyright 1996, 1997 by
 *  David Turner, Robert Wilhelm, and Werner Lemberg.
 *
 *  This file is part of the FreeType project, and may only be used
 *  modified and distributed under the terms of the FreeType project
 *  license, LICENSE.TXT. By continuing to use, modify or distribute
 *  this file you indicate that you have read the license and
 *  understand and accept it fully.
 *
 *
 *  The kerning support is currently part of the engine extensions.
 *  This file is included by 'apiext.h', the API extender included
 *  by user applications. As a consequence, it should _not_ depend
 *  on engine internal types. It's implementation can however..
 *
 ******************************************************************/

#ifndef TTKERN_H
#define TTKERN_H

#include "ttcommon.h"
#include "ftxkern.h"

  #ifdef __cplusplus
  extern "C" {
  #endif
  
  /* included by 'kern.c' and 'extend.c' */

  /* the following functions are called by the extensions constructor */
  /* and destructor.                                                  */

  /* Create the kerning default data. This should load the kerning */
  /* tables directory, but leave the table themselves on the disk. */
  /* They will be loaded on demand..                               */
  TT_Error  Kerning_Create( PFace        face,
                            TT_Kerning*  kern );

  /* Destroy _all_ kerning information */
  TT_Error  Kerning_Destroy( TT_Kerning*  kern );

  #ifdef __cplusplus
  }
  #endif
  
#endif /* TTKERN_H */
