/*******************************************************************
 *
 *  tttables.h                                                  1.1
 *
 *    TrueType Tables structures and handling (specification).
 *
 *  Copyright 1996, 1997 by
 *  David Turner, Robert Wilhelm, and Werner Lemberg.
 *
 *  This file is part of the FreeType project, and may only be used
 *  modified and distributed under the terms of the FreeType project
 *  license, LICENSE.TXT. By continuing to use, modify or distribute
 *  this file you indicate that you have read the license and
 *  understand and accept it fully.
 *
 ******************************************************************/

#ifndef TTTABLES_H
#define TTTABLES_H

#include "tttypes.h"

  #ifdef __cplusplus
  extern "C" {
  #endif

  /***********************************************************************/
  /*                                                                     */
  /*                      TrueType Table Types                           */
  /*                                                                     */
  /***********************************************************************/

  /* TrueType Collection Header */

  typedef struct  _TTTCHeader
  {
    Long      Tag;
    TT_Fixed  version;
    ULong     DirCount;
    PULong    TableDirectory;
  } TTTCHeader;

  typedef TTTCHeader*  PTTCHeader;

  /* TrueType Table Directory type */

  typedef struct  _TTableDir
  {
    TT_Fixed  version;      /* should be 0x10000 */
    UShort    numTables;    /* number of tables  */

    UShort  searchRange;    /* These parameters are only used  */
    UShort  entrySelector;  /* for a dichotomy search in the   */
    UShort  rangeShift;     /* directory. We ignore them.      */
  } TTableDir;

  typedef TTableDir*  PTableDir;

  /* The 'TableDir' is followed by 'numTables' TableDirEntries */

  typedef struct  _TTableDirEntry
  {
    Long  Tag;        /*        table type */
    Long  CheckSum;   /*    table checksum */
    Long  Offset;     /* table file offset */
    Long  Length;     /*      table length */
  } TTableDirEntry;

  typedef TTableDirEntry*  PTableDirEntry;

  /* 'cmap' tables */

  typedef struct  _TCMapDir
  {
    UShort  tableVersionNumber;
    UShort  numCMaps;
  } TCMapDir;

  typedef TCMapDir*  PCMapDir;

  typedef struct  _TCMapDirEntry
  {
    UShort  platformID;
    UShort  platformEncodingID;
    Long    offset;
  } TCMapDirEntry;

  typedef TCMapDirEntry*  PCMapDirEntries;


  /* 'maxp' Maximum Profiles table */

  typedef struct  _TMaxProfile
  {
    TT_Fixed  version;
    UShort    numGlyphs,
              maxPoints,
              maxContours,
              maxCompositePoints,
              maxCompositeContours,
              maxZones,
              maxTwilightPoints,
              maxStorage,
              maxFunctionDefs,
              maxInstructionDefs,
              maxStackElements,
              maxSizeOfInstructions,
              maxComponentElements,
              maxComponentDepth;
  } TMaxProfile;

  typedef TMaxProfile*  PMaxProfile;


  /* table "gasp" */

  #define GASP_GRIDFIT  0x01
  #define GASP_DOGRAY   0x02

  typedef struct  _GaspRange
  {
    UShort  maxPPEM;
    UShort  gaspFlag;
  } GaspRange;

  typedef struct  _TGasp
  {
    UShort      version;
    UShort      numRanges;
    GaspRange*  gaspRanges;
  } TGasp;


  /* table "head" - now defined in freetype.h */

  /*
  typedef struct  _TLongDateTime
  {
    Long  l1;
    Long  l2;
  } TLongDateTime;

  typedef struct  _THeader
  {
    TT_Fixed  Table_Version;
    TT_Fixed  Font_Revision;

    Long      CheckSum_Adjust;
    Long      Magic_Number;

    UShort    Flags;
    UShort    Units_Per_EM;

    TLongDateTime  Created, Modified;

    Short     xMin;
    Short     yMin;
    Short     xMax;
    Short     yMax;

    UShort    Mac_Style;
    UShort    Lowest_Rec_PPEM;

    Short     Font_Direction;
    Short     Index_To_Loc_Format;
    Short     Glyph_Data_Format;
  } THeader;
  */

  /* table "hhea" - now defined in freetype.h */

  /*
  typedef struct _THorizontalHeader
  {
    Fixed   Version;
    Short   Ascender;
    Short   Descender;
    Short   Line_Gap;

    UShort  advance_Width_Max;

    Short   min_Left_Side_Bearing;
    Short   min_Right_Side_Bearing;
    Short   xMax_Extent;
    Short   caret_Slope_Rise;
    Short   caret_Slope_Run;

    Short   Reserved[5];

    Short   metric_Data_Format;
    UShort  number_Of_HMetrics;
  } THorizontalHeader;
  */

  /* table "HMTX" */

  typedef struct  _TLongHorMetric
  {
    UShort  advance_Width;
    Short   lsb;
  } TLongHorMetric;

  typedef TLongHorMetric*  PTableHorMetrics;


  /* 'OS/2' table - now defined in freetype.h */

  /*
  typedef struct _TOS2_Table
  {
    UShort  version;               
    Short   xAvgCharWidth;
    UShort  usWeightClass;
    UShort  usWidthClass;
    Short   fsType;
    Short   ySubscriptXSize;
    Short   ySubscriptYSize;
    Short   ySubscriptXOffset;
    Short   ySubscriptYOffset;
    Short   ySuperscriptXSize;
    Short   ySuperscriptYSize;
    Short   ySuperscriptXOffset;
    Short   ySuperscriptYOffset;
    Short   yStrikeoutSize;
    Short   yStrikeoutPosition;
    Short   sFamilyClass;
    Byte    panose[10];
    ULong   ulUnicodeRange1;       
    ULong   ulUnicodeRange2;       
    ULong   ulUnicodeRange3;       
    ULong   ulUnicodeRange4;       
    Byte    achVendID[4];
    UShort  fsSelection;
    UShort  usFirstCharIndex;
    UShort  usLastCharIndex;
    UShort  sTypoAscender;
    UShort  sTypoDescender;
    UShort  sTypoLineGap;
    UShort  usWinAscent;
    UShort  usWinDescent;

    ULong   ulCodePageRange1;      
    ULong   ulCodePageRange2;      
  } TOS2_Table;

  typedef TOS2_Table *  POS2_Table;
  */

  /* "post" table - now defined in freetype.h */

  /*
  typedef struct _TPostscript
  {
    TT_Fixed  FormatType;
    TT_Fixed  italicAngle;
    Short     underlinePosition;
    Short     underlineThickness;
    ULong     isFixedPitch;
    ULong     minMemType42;
    ULong     maxMemType42;
    ULong     minMemType1;
    ULong     maxMemType1;
  } TPostscript;

  typedef TPostscript  *PPostscript;
  */

  /* 'loca' location table type */

  typedef struct _TLoca
  {
    UShort    Size;
    PStorage  Table;
  } TLoca;

  /* table "name" */

  typedef struct  _TNameRec
  {
    UShort  platformID;
    UShort  encodingID;
    UShort  languageID;
    UShort  nameID;
    UShort  stringLength;
    UShort  stringOffset;

    /* this last field is not defined in the spec */
    /* but used by the FreeType engine            */

    PByte   string;
  } TNameRec;

  typedef struct  _TName_Table
  {
    UShort     format;
    UShort     numNameRecords;
    UShort     storageOffset;
    TNameRec*  names;
    PByte      storage;
  } TName_Table;


  #ifdef __cplusplus
  }
  #endif

#endif /* TTTABLES_H */

/* End */
