.\"
.\" $Id: ttf2bdf.man,v 1.2 1997/10/01 18:24:55 mleisher Exp $
.\"
.TH TTF2BDF 1 "01 October 1997" "X Version 11"
.SH NAME 
ttf2bdf \- TrueType to BDF font converter

.SH SYNOPSIS
.B ttf2bdf
[\fIoptions\fP] [\fIfont.ttf\fP]

.SH DESCRIPTION
.I ttf2bdf
will convert a TrueType font to a BDF font using the FreeType renderer.

.SH OPTIONS
.I ttf2bdf
accepts the following command line arguments:

.PP
.TP 8
.I -v
print warning messages when the font is converted.
.PP
.TP 8
.I -c c
set the character spacing.  This should be one of `P' for proportional,
`M' for monospace, or `C' for character cell.  By default, the spacing
of a font will be automatically determined to be either `M' or `P'
according to values provided in the font.
.PP
.TP 8
.I -t name
set the typeface name used in the XLFD name.  By default,
.I ttf2bdf
will attempt to get a name from the font first and then it will use the
name supplied with this command line option, and if all else fails, it
will use the name `Unknown'.
.PP
.TP 8
.I -w name
set the weight name used in the XLFD name.  If this value is not
supplied, the default value is assumed to be `Medium'.  Some common
values for this are `Thin', `Delicate', `ExtraLight', `Light', `Normal',
`Medium', `SemiCondensed', `Condensed', `SemiBold', `Bold', `Heavy',
`ExtraBold', and `ExtraHeavy'.
.PP
.TP 8
.I -s name
set the slant name used in the XLFD name.  If this value is not
supplied, the default value is assumed to be `R', for Roman.  Some common
values for this are `R' for Roman, `I' for Italic, `O' for Oblique, `RI'
for Reverse Italic, and `RO' for Reverse Oblique.
.PP
.TP 8
.I -pid id
set the platform id for selecting the character map (see default value by
running the program with the -h option).
.PP
.TP 8
.I -eid id
set the encoding id for selecting the character map (see default value by
running the program with the -h option).
.PP
.TP 8
.I -p n
set the desired point size (see default value by running the program with the
-h option).
.PP
.TP 8
.I -r n
set both the horizontal and the vertical resolution (see default value by
running the program with the -h option).
.PP
.TP 8
.I -rh n
set the horizontal resolution (see default value by running the program with
the -h option).
.PP
.TP 8
.I -rv n
set the vertical resolution (see default value by running the program with
the -h option).
.PP
.TP 8
.I -o outfile

.SH "SEE ALSO"
xmbdfed(1), xfed(1), bdftopcf(1), bdftosnf(1)
.br
\fIGlyph Bitmap Distribution Format (BDF) Specification\fP, Application
Note 5005, Adobe System Inc, 1993

.SH ACKNOWLEDGMENTS

The FreeType project for providing the renderer!
.br
Robert Wilhelm <robert@physiol.med.tu-muenchen.de> for pointing out a
crucial problem with the pre-1.0 code.
.br
Lho Li-Da <ollie@ms1.hinet.net> for problem reports.
.br
Adrian Havill <havill@threeweb.ad.jp> for unintentionally pointing out a
missing feature.
.br
Richard Verhoeven <rcb5@win.tue.nl> for problem reports and patches.
.br
Choi Jun Ho <junker@jazz.snu.ac.kr> whose implementation provided some
nice new features.
.SH AUTHOR
Mark Leisher
.br
Computing Research Lab
.br
New Mexico State University
.br
Email: mleisher@crl.nmsu.edu
