/* ------------------------------------------------------------------------ */
/* IconDraw.C (C) CopyLeft Bill Buckels 1991-1999                           */
/* All Rights Reversed.                                                     */
/*                                                                          */
/* Licence Agreement                                                        */
/* -----------------                                                        */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* If you don't agree, remove this source code from your computer now.      */
/*                                                                          */
/* Written by   : Bill Buckels                                              */
/*                589 Oxford Street                                         */
/*                Winnipeg, Manitoba, Canada R3M 3J2                        */
/*                                                                          */
/* Email: bbuckels@escape.ca                                                */
/* WebSite: http://www.escape.ca/~bbuckels                                  */
/*                                                                          */
/* Purpose      : Image Editor for Old Printshop and Printmaster            */
/* Revision     : 2.0 Last Release                                          */
/* ------------------------------------------------------------------------ */
/* Written in Large Model Microsoft C Version 6.00a                         */
/* ------------------------------------------------------------------------ */

/* not done to any great degree of excellence */
/* just basically cleaned-up for the final release */
/* some of this is really butt-ugly code */
/* especially where we make the mouse act like a keyboard and */
/* the parts where we make the keyboard act like a mouse */

#include <graph.h>
#include <conio.h>
#include <stdio.h>
#include <fcntl.h>
#include <dos.h>
#include <bios.h>
#include <io.h>
#include <malloc.h>
#include <string.h>

#define TRUE  1
#define FALSE 0

#define ENTERKEY   '\x0d' /* character generated by the Enter Key          */
#define ESCKEY     '\x1b' /* character generated by the Esc key            */
#define SPACEBAR   '\x20'
#define FUNCKEY    '\x00' /* first character generated by function keys    */
#define UPARROW    'H'    /* second character generated by up-arrow key    */
#define DOWNARROW  'P'    /* second character generated by down-arrow key  */
#define LTARROW    'K'    /* second character generated by left-arrow key  */
#define RTARROW    'M'    /* second character generated by right-arrow key */
#define PGUP       'I'    /* second character generated by page up key     */
#define PGDOWN     'Q'    /* second character generated by page down key   */
#define HOMEKEY    'G'    /* second character generated by home key        */
#define ENDKEY     'O'    /* second character generated by end key         */


#define PSHOP_BUFSIZE   572
#define PMASTER_BUFSIZE 577

#define DAT 0
#define SHP 1
#define POG 2

char poghead[8]={
    0x00,0x00,0x00,0x01,
    0x00,0x00,0x00,0x00};

unsigned pchangetarget;

char shphead[4]={0x0b,0x34,0x58,0x00};

char shptail[1]={0x00};

int bMickey    = FALSE;
int bCursorOn  = FALSE;

void cursoroff(),
     cursoron();

/* Character Array of .PCX format Run Length Full Screen CGA Graphics */
/* The BYTE COUNT Descriptor Integer precedes the Character Array. */

extern int DIRECTOR_SIZE;
extern unsigned char far DIRECTOR[];
extern int DRAWMENU_SIZE;
extern unsigned char far DRAWMENU[];
extern int ICONTIT_SIZE;
extern unsigned char far ICONTIT[];
extern int ISORRY_SIZE;
extern unsigned char far ISORRY[];
extern int ICONBYE_SIZE;
extern unsigned char far ICONBYE[];


/* eat keystrokes */
void EatKeys()
{
  if (kbhit()) {
    while(kbhit()) {
      if (getch() == 0)
        getch();
    }
  }
}

int drawcolor=3;
unsigned char far *screenbuffer,*showbuffer;

/* type conversion functions */
unsigned int byteword(unsigned char a, unsigned char b){
  return b << 8 | a;
}
unsigned char lsb(unsigned int word){
  return word &0xff;
}
unsigned char msb(unsigned int word){
  return word >> 8;
}
unsigned char pcxheader[128];

int pccheader(int bytewidth, int rasterheight)
{
  /* makes a standard header for a 1-bit .PCC or .PCX */
  int i;
  unsigned char zsoft = 10,version = 3,codetype = 1,pixbits = 1;
  unsigned int  xmin = 0, ymin = 0;
  unsigned int  xmax = (bytewidth*8) - 1, ymax = rasterheight - 1;
  unsigned int  hres = bytewidth*8, vres = rasterheight;
  unsigned char no_planes = 1;
  unsigned int  bytesperline = bytewidth;
  
  for(i = 0;i != 128;i++)pcxheader[i] = 0;
  /* pad the header with nulls */
  
  pcxheader[0] = zsoft;
  pcxheader[1] = version;
  pcxheader[2] = codetype;
  pcxheader[3] = pixbits;
  pcxheader[4] = lsb(xmin);
  pcxheader[5] = msb(xmin);
  pcxheader[6] = lsb(ymin);
  pcxheader[7] = msb(ymin);
  pcxheader[8] = lsb(xmax);
  pcxheader[9] = msb(xmax);
  pcxheader[10] = lsb(ymax);
  pcxheader[11] = msb(ymax);
  pcxheader[12] = lsb(hres);
  pcxheader[13] = msb(hres);
  pcxheader[14] = lsb(vres);
  pcxheader[15] = msb(vres);
  pcxheader[65] = no_planes;
  pcxheader[66] = lsb(bytesperline);
  pcxheader[67] = msb(bytesperline);
  return 0;
  
}


FILE *pccfile;
int makepcc(char *name, int rasterheight, int bytewidth)
{
  unsigned char crtbuf[80];
  unsigned int  offset = 0;
  int i,y;
  
  if((pccfile = fopen(name, "wb")) == NULL)return - 1;
  pccheader(bytewidth, rasterheight);
  
  for(i = 0;i != 128;i++)fputc(pcxheader[i], pccfile);
  /* write the header */
  
  for(y = 0;y < rasterheight;y++) {
    memcpy(crtbuf, &screenbuffer[offset], bytewidth);
    encline(crtbuf, bytewidth);
    offset += bytewidth;
  }
  fclose(pccfile);
  return (0);
  
}

/* a microsoft compatible bsaved memory image format descriptor */
unsigned char BSAVED_header[7]={

    '\xfd',          /* ID Flag = file descriptor identifier bsaved file */

    /* BASIC will use original segment and offset information */
    /* to reload a memory image unless "DEF SEG" has been used */
    /* and then an explicit offset is used as the second arg */
    /* of the bload command.  If an offset is specified without*/
    /* first calling DEF SEG, The image will then be loaded to */
    /* the offset specified in the last segment pointed to */
    /* by the last call to DEF SEG. DEF SEG without args returns */
    /* to DGROUP (the default data segment) */

    /* we would normally implement using an array in memory and */
    /* VARSEG and VARPTR to obtain the window for the array's */
    /* memory location, i.e. override the defaults by windowing */
    /* to the array base using DEF SEG = VARSEG(arrayname(0)) then to */
    /* fill the array we would use BLOAD arrayname, VARPTR(arrayname(0)) */
    /* using VARPTR to point to the offset from the memory base segment */

    '\x00', '\xb8',  /* base address     = LSB | MSB original segment */
    '\x00', '\x00',  /* offset from base = LSB | MSB original offset */

    '\x00', '\x40'   /* file size = LSB | MSB of bytes to be loaded + */
                     /* size of descriptors in bytes (8) */
    };
/* we have used the CGA frame buffer as the base */
/* if someone fails to initialize the array and bloads */
/* the file without args it will ruin the display but */
/* will not crash the program... no point making this too drastic */

unsigned char BSAVED_tailer[1]={
    '\x1A'                      /* traditionally used by BASIC */
    };                          /* as a terminator */


/* raw binary info in either a BASIC PUT or a C putimage file format */
/* assume MED res screen mode if we are not saving to PCC or PCX */

int BSAVE(char *name, int rasterheight, int bytewidth, char language)
{
  int fh;
  int target = bytewidth*rasterheight;
  unsigned int blength = target + 4;
  unsigned char arrayheader[4];
  int bitsperbyte = 8;
  int bitwidth = bytewidth*bitsperbyte;
  
  /* since the array info is recorded in bit width */
  /* we calculate the width by multiplying by 8 */
  /* the rasters break on even byte boundaries */
  
  
  #define S_IWRITE    0000200          /* write permission, owner */
    
    if((fh = open(name, O_CREAT | O_TRUNC | O_WRONLY | O_BINARY, S_IWRITE)) == - 1)
    return - 1;
  
  if(language != 'C') {
    write(fh, BSAVED_header, 5);
    write(fh, (char *)&blength, 2);
  }
  
  write(fh, (char *)&bitwidth, 2);
  write(fh, (char *)&rasterheight, 2);
  
  write(fh, (char *)&screenbuffer[0], target);
  if(language != 'C')write(fh, BSAVED_tailer, 1);
  close(fh);
  return (0);
  
}


/* save or append to current libary */
/* this is actually pretty robust with the exceptions that we don't allow */
/* a delete and we don't allow a create... */
int PSSAVE(char *szNam, char *szNam2, char *szCaption, int filetype, int ctr)
{
  FILE *fp;
  int target, i = 0;
  long pos;
  char *ptr;
  unsigned char c, temp, szBuf[PMASTER_BUFSIZE];
  int iAppend = FALSE;
  
  switch(filetype) {
    case SHP:
    target = PMASTER_BUFSIZE;
    break;
    default:
    target = PSHOP_BUFSIZE;
    break;
  }
  
  /* open for update or append */
  if(ctr)
    ptr = (char *)"rb+w";
  else { 
    ptr = (char *)"ab";
    iAppend = TRUE;
  }
  
  if(NULL != (fp = fopen(szNam, ptr))) { 
    if(ctr) { 
      ctr--;                           /* seek to start of image */
      pos = (long)(ctr * target);
      if(filetype == POG)
        pos = pos + 10;
      fseek(fp, pos, SEEK_SET);
    }
    
    /* if a printmaster file, wrap image in header and footer */
    if(filetype == SHP)
      fwrite(shphead, 1, sizeof(shphead), fp);
    
    /* reduce to a pure monochrome */
    ptr = (unsigned char *)&screenbuffer[0];
    i = 0;
    while(i < PSHOP_BUFSIZE) {
      c = 0;
      
      temp = *ptr;
      *ptr++;
      if((temp&192) >> 6)c |= 1;  c <<= 1;
      if((temp&48) >> 4) c |= 1;  c <<= 1;
      if((temp&12) >> 2) c |= 1;  c <<= 1;
      if(temp&3)c |= 1;         c <<= 1;
      
      temp = *ptr;
      *ptr++;
      if((temp&192) >> 6)c |= 1;  c <<= 1;
      if((temp&48) >> 4) c |= 1;  c <<= 1;
      if((temp&12) >> 2) c |= 1;  c <<= 1;
      if(temp&3)c |= 1;
      
      szBuf[i] = (c^0xff);
      i++;
    }
    fwrite(szBuf, 1, PSHOP_BUFSIZE, fp);
    if(filetype == SHP)
      fwrite(shptail, 1, sizeof(shptail), fp);
    fclose(fp);
    szCaption[15]=0;
    if(iAppend) { 
      if(NULL != (fp = fopen(szNam2, "ab"))) { 
        fwrite(szCaption, 1, 16, fp);
        if(filetype == POG)
          pchangetarget = (unsigned )(filelength(fileno(fp)) / 16);
        fclose(fp);
        /* POG files contain an image count */
        /* if we are appending we need to adjust this */
        if (filetype == POG) {
          if(NULL != (fp = fopen(szNam, "rb+w"))) {
             pos = 8L;
             fseek(fp, pos, SEEK_SET);
             fwrite(&pchangetarget, 1, 2, fp);
             fclose(fp);
          }
        }
      }
    }
    else {
      if(NULL != (fp = fopen(szNam2, "rb+w"))) {
        /* seek to start of caption */
        pos = (long)(ctr * 16);
        fseek(fp, pos, SEEK_SET);
        fwrite(szCaption, 1, 16, fp);
        fclose(fp);
      }

    }
    return (0);
  }
  return(1);
  
}

// a microsoft compatible bsaved memory image format descriptor
unsigned char BSV_header[7]={

    '\xfd',          // ID Flag = file descriptor identifier bsaved file

    '\x00', '\xb8',  // base address     = LSB | MSB original segment
    '\x00', '\x00',  // offset from base = LSB | MSB original offset

    '\xA0', '\x0F'   // file size = LSB | MSB of bytes to be loaded +
                     // size of descriptors in bytes (8)
    };

char toponly=223;
char botonly=220;
char both=   219;
char blank=  32;

#define TBLUE '\x1f';
int textpixel(unsigned one, unsigned two,FILE *fp)
{
    unsigned attribute=TBLUE;

    // if both pixels are on
    if(one && two)
    {
      fputc(blank,fp);
      fputc(attribute,fp);
      return 0;
     }

    // if neither pixel is on we draw a white block
    if(one==0 && two == 0)
    {
        fputc(both,fp);
        fputc(attribute,fp);
        return 0;
    }

    if(one==0)
    {
        fputc(toponly,fp);

    }
    if(two==0)
    {
        fputc(botonly,fp);

    }
    fputc(attribute,fp);

return 0;
}


int textsave(char *outfile)
{
    unsigned topbyte, botbyte;
    FILE *fp;
    unsigned i,x,y;
    unsigned toff,boff;

   if((fp=fopen(outfile,"wb"))==NULL)return -1;

   for(i=0;i!=7;i++)fputc(BSV_header[i],fp);


    for(y=0;y<25;y++)
    {
      toff = (y*44)+22;
      boff = toff+22;

      //ignore the first 4 + last 4 pixels
      for(x=1;x<21;x++)
      {
         topbyte=screenbuffer[toff+x];
         botbyte=screenbuffer[boff+x];

         textpixel((topbyte>>6),
                   (botbyte>>6),
                   fp);
         textpixel((topbyte>>4)&3,
                   (botbyte>>4)&3,
                   fp);
         textpixel((topbyte>>2)&3,
                   (botbyte>>2)&3,
                   fp);
         textpixel(topbyte&3,
                   botbyte&3,
                   fp);
       }

    }
    fputc(BSAVED_tailer[0],fp);
    fclose(fp);
    return 0;

}



void putdot(col, row, color)
unsigned int col,row;
unsigned char color;
{
  unsigned char *crtdot =
    (unsigned char *)0xB8000000l + (0x2000 * (row % 2)) + (80 * (row / 2)) + col / 4;
  unsigned int mask,temp;
  
  mask = 0xc0 >> ((col % 4)*2);
  temp = *crtdot;
  
  *crtdot = temp & ~mask;
  mask = (color & 0x03) << (6 - (col % 4)*2);
  temp = *crtdot;
  *crtdot = temp | mask;
}



/* large letters */
void pcromfont(unsigned char *str, int xorigin, int yorigin, int scale)
{
  /* uses the rom font as a template for a bitmap font */
  int scanline,YREG = yorigin,XREG = xorigin,byte,character,nibble;
  int x,y;
  
  unsigned char *romfont = (unsigned char *) 0xffa6000el;
  
  /* flags etcetera */
  
  int target = strlen(str);            /* string length */
  
  for(scanline = 0;scanline < 8;scanline++) {
  /* finish the current scanline  */
    /* before advancing to the next */
    for(byte = 0;byte < target;byte++) {
    /* run the scanline */
      character = romfont[(str[byte]&0x7f)*8 + scanline];
      /* get the bitmap */
      for(nibble = 0;nibble < 8;nibble++) {
        XREG += scale;
        if(character & 0x80 >> nibble)
          for(x = 0;x != scale;x++)
          for(y = 0;y != scale;y++)
          putdot(XREG + x, YREG + y, drawcolor);
      }
    }
    YREG += scale;
    XREG = xorigin;
  }
  
}


void pcmidfont(unsigned char *str, int xmiddle, int yorigin, int scale)
{
  /* centre justified string */
  pcromfont(str, (xmiddle - (4*(strlen(str))*scale)), yorigin, scale);
}

/* note: the arrow array corresponds to the pixel map and the number */
/* corresponds to the desired pixel attribute. we use the 2-d array to */
/* construct a visual map of the cursor and call makemickey() to */
/* produce the binary values. we can visually design any cursor mask */
/* by overtyping this example. */

short arrow[16][8]={   /* the cursor template */
2,0,0,0,0,0,0,0,
2,2,0,0,0,0,0,0,
2,2,2,0,0,0,0,0,
2,2,2,2,0,0,0,0,       /* this type of array is usually referred */
2,2,2,2,2,0,0,0,       /* to as a sprite */
2,2,2,2,2,2,0,0,
2,2,2,2,2,2,2,0,
2,2,2,2,2,2,2,2,
2,2,2,0,0,0,0,0,
2,2,0,0,0,0,0,0,
2,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0};

short zorro[16][8]={   /* the screen mask */
0,3,3,3,3,3,3,3,
0,0,3,3,3,3,3,3,
0,0,0,3,3,3,3,3,
0,0,0,0,3,3,3,3,
0,0,0,0,0,3,3,3,
0,0,0,0,0,0,3,3,
0,0,0,0,0,0,0,3,
0,0,0,0,0,0,0,0,
0,0,0,3,3,3,3,3,
0,0,3,3,3,3,3,3,
0,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3};

/* the outline of the shape defined by arrow */
/* is made invisible by anding with 3. */
/* the shape is anded with 0 to remain visible. */

static int cursor[32]={ /* some dummy values */
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
int *cptr=cursor;

void makemickey(int cursortype)
{
  /* usage:  load a new cursor into the cursor buffer */
  /* or   :  switch between different cursor shapes */
  /* accumulate color value and position to cursor array */
  /* each pixel value in the CGA MED RES is stored in 2 bits */
  /* and the mouse cursor mask is stored in a word value */
  /* the pixel map is defined by a left shift of the pixel */
  /* attribute to the appropriate position in the mask. */
  
  
  int shifter,i,j,k = 16;
  
  for(i = 0;i < 16;i++) {
    for(j = 0;j < 8;j++) {
      switch(j) {
        case 0: shifter = 14;break;
        case 1: shifter = 12;break;
        case 2: shifter = 10;break;
        case 3: shifter = 8;break;
        case 4: shifter = 6;break;
        case 5: shifter = 4;break;
        case 6: shifter = 2;break;
        case 7: shifter = 0;break;
      }
      /* reference to additional sprites can be added here */
      switch(cursortype) {
        default:
        
        cursor[k] = (cursor[k] | arrow[i][j] << shifter);
        cursor[i] = (cursor[i] | zorro[i][j] << shifter);
      }
    }
    k++;
  }
  
}


int hi_mickey()
{
  union REGS inregs, outregs;
  struct SREGS segregs;
  long address;
  unsigned char first_byte;
  
  makemickey(1);
  
  bMickey = FALSE;
  
  /* check for microsoft compatible mouse driver */
  inregs.x.ax = 0x3533;
  intdosx(&inregs, &outregs, &segregs);
  address = (((long) segregs.es) << 16) + (long) outregs.x.bx;
  first_byte = * (long far *) address;
  if((address == 0) || (first_byte == 0xcf)) return bMickey;
  
  /* check to see if the mouse is responding */
  inregs.x.ax = 0;
  int86(0x33, &inregs, &outregs);
  if(outregs.x.ax == 0)return bMickey;
  
  /* load the cursor */
  segread(&segregs);
  segregs.es = segregs.ds;
  inregs.x.ax = 9;
  inregs.x.bx = 0;
  inregs.x.cx = 0;
  inregs.x.dx = *((unsigned int*)&cptr);
  int86x(0x33, &inregs, &outregs, &segregs);
  
  bMickey = TRUE;
  return bMickey;
}


/* this is the command array for the "Graphics Editor" screen */
/* these coordinates are dependent on the image layout        */
/* and must change if the image layout changes...             */
/* no plans to do so though:) */

int commandbox[9][5]=
{

    /*  x1   y1  x2   y2   keystroke value */

    0,   159,  170,  168,  (int) 'A',
    0,   169,  170,  178,  (int) 'B',
    0,   179,  170,  188,  (int) 'C',

    171,   159,  319, 168,  (int) 'S',
    171,   169,  319, 178,  (int) 'P',
    171,   179,  319, 188,  (int) 'X',

    0,   189, 99,  199,  ESCKEY,
    100, 189, 207, 199,  (int) 'T',
    208, 189, 319, 199,  ENTERKEY

};

unsigned char CheckCommand(int x, int y)
{
  /* this function checks each of the hot zones in the commands */
  /* listing and returns a keystroke for the current choice     */
  /* the pagedown key is returned as an ENTERKEY stroke         */
  int i;
  
  for(i = 0;i < 9;i++) {
    /* if its in range return the hot box number */
    if(x >= commandbox[i][0] && y >= commandbox[i][1] &&
        x <= commandbox[i][2] && y <= commandbox[i][3])
          return (unsigned char)commandbox[i][4];
  }
  
  /* if we haven't hit a hot spot yet then we're not in range */
  return (unsigned char)FUNCKEY;
}



int filebox[22][7]=
    {

/*  x1   y1  x2   y2   row  col  record # */
    0,   0,  79,  23,  2,   2,   0,
    80,  0,  159, 23,  2,   12,  0,
    160, 0,  239, 23,  2,   22,  0,
    240, 0,  319, 23,  2,   32,  0,

    0,   24, 79,  47,  5,   2,   0,
    80,  24, 159, 47,  5,   12,  0,
    160, 24, 239, 47,  5,   22,  0,
    240, 24, 319, 47,  5,   32,  0,

    0,   48, 79,  71,  8,   2,   0,
    80,  48, 159, 71,  8,   12,  0,
    160, 48, 239, 71,  8,   22,  0,
    240, 48, 319, 71,  8,   32,  0,

    0,   72, 79,  95,  11,  2,   0,
    80,  72, 159, 95,  11,  12,  0,
    160, 72, 239, 95,  11,  22,  0,
    240, 72, 319, 95,  11,  32,  0,

    0,   96, 79,  119, 14,  2,   0,
    80,  96, 159, 119, 14,  12,  0,
    160, 96, 239, 119, 14,  22,  0,
    240, 96, 319, 119, 14,  32,  0,

    0,  120, 159, 199, 80,  150,   0, /* turn the page */
    160,120, 319, 199, 240, 150,   0  /* return to previous screen */

};

#define SCREENSIZE 16385
unsigned char far *crtptr    =(unsigned char *) 0xB8000000l;
unsigned char far *inleafptr =(unsigned char *)0xB8000000l+0x2000;
unsigned char far *menubuffer;
unsigned char far *directorbuffer;

#define   CGALINE    80

int memoryload(unsigned char far *in, unsigned char far *out, int sz)
{
  unsigned int byteoff = 0,packet,width = 0;
  unsigned char byte,bytecount;
  int wordcount = 0;
  
  
  
  do {
    bytecount = 1;                     /* start with a seed count */
    byte = in[wordcount];
    wordcount++;
    /* check to see if its raw */
    if(0xC0 == (0xC0 &byte)) {
      /* if its not, run encoded */
      bytecount = 0x3f &byte;
      byte = in[wordcount];
      wordcount++;
    }
    for(packet = 0;packet < bytecount;packet++) {
      out[byteoff] = byte;
      byteoff++;
    }
  }while(wordcount < sz);
  return(0);
}

int cload(unsigned char far *array)
{
  unsigned int y,inset = 0, offset = 0;
  
  for(y = 0;y < 200;) {
    memcpy(crtptr + inset, array + offset, CGALINE);
    offset += CGALINE;
    y++;
    memcpy(inleafptr + inset, array + offset, CGALINE);
    offset += CGALINE;
    inset += CGALINE;
    y++;
  }
  return(0);
  
}

/* get a series of files of a certain type.. in this case, type .DAT */
int wildcounter=0;
char wildfiles[200][15];
int fileindex =0;


void initpix()
{
  directorbuffer = _fmalloc(SCREENSIZE);
  menubuffer = _fmalloc(SCREENSIZE);
  
  
  memset(wildfiles, 0, sizeof(wildfiles));
  memoryload(DIRECTOR, directorbuffer, DIRECTOR_SIZE);
  memoryload(DRAWMENU, menubuffer, DRAWMENU_SIZE);
}

void freepix()
{
  _ffree(directorbuffer);
  _ffree(menubuffer);
}

int getfiles(char *filetype)
{
  int i;
  char buffer[15];
  struct find_t wild_card;
  
  sprintf(buffer, "*.%s", filetype);
  
  if(_dos_findfirst(buffer, _A_NORMAL, &wild_card) == 0) {
    strcpy(wildfiles[wildcounter], wild_card.name);
    wildcounter++;
    
    while(_dos_findnext(&wild_card) == 0) {
      strcpy(wildfiles[wildcounter], wild_card.name);
      wildcounter++;
    }
  }
  
  return wildcounter;
}



int mousex, mousey;


int CheckFile(int x, int y)
{
  /* this function checks each of the hot zones in the files */
  /* listing and returns the number of the current choice */
  
  int currentchoice = - 1;
  int i;
  
  /* check the flip zone and the quit without selection zone */
  if(x >= filebox[20][0] && y >= filebox[20][1] &&
      x <= filebox[20][2] && y <= filebox[20][3])
    return 20;
  if(x >= filebox[21][0] && y >= filebox[21][1] &&
      x <= filebox[21][2] && y <= filebox[21][3])
    return 21;
  
  for(i = 0;i != 20;i++) {
    /* if its in range return the hot box number */
    if(x >= filebox[i][0] && y >= filebox[i][1] &&
        x <= filebox[i][2] && y <= filebox[i][3])return i;
  }
  
  /* if we haven't hit a hot spot yet then we're not in range */
  return currentchoice;
}


int drawscreen(int screentype)
{
  int x, x1, y1, len;
  char scratchbuf[15];
  char *wordptr;
  union REGS inregs,outregs;
  int idx;
  
  
  switch(screentype) {
    /* falls through here the first time */
    case 0:
      getfiles("DAT");
      getfiles("SHP");
      getfiles("POG");
      return wildcounter;
    
    case 1:    cload(directorbuffer);
    
    case 2:
    
    
    
    for(x = 0;x != 20;x++) {
      filebox[x][6] = fileindex;
      /* set the index pointer to the wildfiles */
      
      _setcolor(0);
      _rectangle(_GFILLINTERIOR, filebox[x][0] + 1, filebox[x][1] + 1,
        filebox[x][2] - 1, filebox[x][3] - 1);

      strcpy(scratchbuf, wildfiles[fileindex]);
      wordptr = (char *)&scratchbuf[0];
      for (idx = 0; wordptr[idx] != 0; idx++) {
        if (wordptr[idx] == '.') {
          wordptr[idx] = 0;
          break;
        }
      }
      // first character of extension
      wordptr[idx+2] = 0;

      drawcolor = 3;
      x1 = filebox[x][0] + 2;
      y1 = filebox[x][1] + ((filebox[x][3] - filebox[x][1]) / 2) - 4;
      pcromfont(wordptr, x1, y1, 1);

      drawcolor = 2;  // red letter day..:)
      x1 = filebox[x][2] - 10;
      pcromfont(&wordptr[idx+1], x1, y1, 1);

      _setcolor(1);
      _rectangle(_GBORDER, filebox[x][0], filebox[x][1],
        filebox[x][2], filebox[x][3]);
      fileindex++;
      /* wrap around if we are at the end */
      if(fileindex == wildcounter)fileindex = 0;
    }
    
    /* pause while a button is released */
    
    do {
      inregs.x.ax = 3;
      int86(0x33, &inregs, &outregs);
    }
    while(outregs.x.bx != 0);
    break;

   case 3:
   case 4:
   case 5:
    if (screentype == 3)
      memoryload(ICONTIT, directorbuffer, ICONTIT_SIZE);
    if (screentype == 4)
      memoryload(ISORRY, directorbuffer, ISORRY_SIZE);
    if (screentype == 5)
      memoryload(ICONBYE, directorbuffer, ICONBYE_SIZE);

    /* just use the file menu screen buffer for the title */
    cload(directorbuffer);
    memoryload(DIRECTOR, directorbuffer, DIRECTOR_SIZE);

    do {
      inregs.x.ax = 3;
      int86(0x33, &inregs, &outregs);
    }
    while(outregs.x.bx != 0);
    EatKeys();  /* eat keystrokes etc. */
    for(;;) {
      if (kbhit()) {
        if (getch()==0) getch();
        break;
      }
      if (GetButtonStatus(&idx, &idx))
        break;
    }
    break;
  }
  GetButtonStatus(&idx, &idx);
  EatKeys();
  
  
}


void cursoron(void)
{
  union REGS inregs, outregs;
  /* */
  /*  set mouse cursor location, then turn on cursor */
  /* */
  cursoroff();
  
  if(bCursorOn == FALSE) { 
    inregs.x.ax = 4;
    inregs.x.cx = mousex*2;
    inregs.x.dx = mousey;
    int86(0x33, &inregs, &outregs);
    
    inregs.x.ax = 1;
    int86(0x33, &inregs, &outregs);
    bCursorOn = TRUE;
  }
}

void cursoroff(void)
{
  union REGS inregs, outregs;
  
  if(bCursorOn == TRUE) { 
    inregs.x.ax = 2;
    int86(0x33, &inregs, &outregs);
    bCursorOn = FALSE;
  }
}

void ShowMickey(int mousex, int mousey)
{
  union REGS inregs, outregs;
  
  cursoroff();
  
  if(bCursorOn == FALSE) { 
    inregs.x.ax = 4;
    inregs.x.cx = mousex*2;
    inregs.x.dx = mousey;
    int86(0x33, &inregs, &outregs);    /* start */
    
    inregs.x.ax = 1;
    int86(0x33, &inregs, &outregs);    /* show  cursor*/
    bCursorOn = TRUE;
  }
}

void HideMickey(int *mousex, int *mousey)
{
  union REGS inregs, outregs;
  
  if(bCursorOn == TRUE) {
    inregs.x.ax = 3;
    int86(0x33, &inregs, &outregs);
    mousex[0] = outregs.x.cx / 2;
    mousey[0] = outregs.x.dx;
    
    inregs.x.ax = 2;
    int86(0x33, &inregs, &outregs);
    bCursorOn = FALSE;
  }
}

int GetButtonStatus(int *mousex, int *mousey)
{
  union REGS inregs, outregs;
  int iRet = 0;
  
  if(bMickey == TRUE) {
    inregs.x.ax = 3;
    int86(0x33, &inregs, &outregs);
    mousex[0] = outregs.x.cx / 2;
    mousey[0] = outregs.x.dx;
    if(outregs.x.bx) {
      if(outregs.x.bx == 2)
        iRet = 27;
      else
        iRet = 13;
      
      while(outregs.x.bx)int86(0x33, &inregs, &outregs);
    }
  }
  return iRet;
}

int GetMousePosition(int *mousex, int *mousey)
{
  union REGS inregs, outregs;
  int iRet = 0;
  
  if(bMickey == TRUE) {
    inregs.x.ax = 3;
    int86(0x33, &inregs, &outregs);
    mousex[0] = outregs.x.cx / 2;
    mousey[0] = outregs.x.dx;
  }
  return iRet;
}

char namebuf[40];
char savebuf[40];

int getpixname(char *ptr, char *ptr2)
{
  int idx;
  int x = 104;
  int y = 139;
  int ctr = 0;
  char c,d;
  
  drawcolor = 0;
  pcromfont(namebuf, x, y, 1);
  
  x = 24;
  drawcolor = 2;
  pcromfont("Picname ? ", x, y, 1);
  x = 104;
  
  memset(namebuf, 0, sizeof(namebuf));
  if (NULL == ptr) {
    if (NULL != ptr2) {
      strcpy(namebuf, ptr2);
      for (idx = 8; idx < sizeof(namebuf); idx++)
        namebuf[idx] = 0;
      for (idx = 0; namebuf[idx]!=0; idx++) {
        /* substitute all non-alphanumeric with underscores */
        d = toupper(namebuf[idx]);
        if(d >= 'A' && d <= 'Z' || d >= '0' && d <= '9')
          continue;
        namebuf[idx] = '_';
      }
    }
  }
  else
    strcpy(namebuf, ptr);

  ctr = strlen(namebuf);
  drawcolor = 3;
  pcromfont(namebuf, x, y, 1);

  EatKeys();
  GetButtonStatus(&idx, &idx);
  c = 0;
  while(c != 13) {

    for (;;) {
      if (kbhit()) {
        c = getch();
        break;
      }
      else {
        if (GetButtonStatus(&idx, &idx)) {
          c = 13;
          break;
        }
      }
    }

    if(c == 0)c = getch();
    else {
      if (c == ESCKEY) {
        drawcolor = 0;
        pcromfont(namebuf, x, y, 1);
        memset(namebuf, 0, sizeof(namebuf));
        break;
      }
      d = toupper(c);
      if(d >= 'A' && d <= 'Z' || (d=='\x20' && NULL!=ptr) ||
         d >= '0' && d <= '9' || d == '_') {
        namebuf[ctr] = c;
        ctr++;
        namebuf[ctr] = 0;
        pcromfont(namebuf, x, y, 1);
      }
      if(d == 8) {
        drawcolor = 0;
        pcromfont(namebuf, x, y, 1);
        drawcolor = 3;
        ctr--;
        if(ctr < 0)ctr = 0;
        namebuf[ctr] = 0;
        pcromfont(namebuf, x, y, 1);
      }
      
      if((ctr > 7 && NULL == ptr) || (ctr > 15)) {
        drawcolor = 0;
        pcromfont(namebuf, x, y, 1);
        x = 24;
        pcromfont("Picname ? ", x, y, 1);
        return 8;
      }
    }
  }
  
  drawcolor = 0;
  pcromfont(namebuf, x, y, 1);
  x = 24;
  pcromfont("Picname ? ", x, y, 1);
  return(strlen(namebuf));
  
}


int trim(char *ptr, int idx)
{
  int len, jdx;

  len = strlen(ptr);

  for (jdx = len; jdx < idx; jdx++)
    ptr[jdx] = 0;                   /* clear trailing garbage */

  len = strlen(ptr) - 1;
  while (len > -1) {
    if (ptr[len]!=' ' && ptr[len] != 0)    /* clear trailing whitespace */
      break;
    ptr[len] = 0;
    len--;
  }

}


int pixstuff(int pixbits)
{
  int bufpacket = 22;
  int inset = (40 - (11*2));
  int offset = inset + (80*12);
  int i = 0, j = 0;
  
  int target = 104 / pixbits;
  int x;
  unsigned char *ptr,*bptr, ch;
  
  i = 0;
  memset((char *)&screenbuffer[0], 0, 0X4000);
  ptr = (unsigned char *)&screenbuffer[0];
  
  pixbits--;
  while(i < target) {
    /* double-up the scanlines if saving to PCX */
    /* it looks better... */
    
    for(j = pixbits; j < 2; j++) {
      /* shift from double byte to single byte */
      bptr = (unsigned char *)0xb8000000l + offset;
      x = 0;
      while(x < bufpacket) {
        if(*bptr >> 4)*ptr |= 3;       /* high nibble */
        *ptr <<= 2;
        if(*bptr&15)*ptr |= 3;         /* low nibble */
        *ptr <<= 2;
        *bptr++;
        
        if(*bptr >> 4)*ptr |= 3;       /* 2nd byte */
        *ptr <<= 2;
        if(*bptr&15)*ptr |= 3;
        *bptr++;
        
        *ptr++;
        x++;
      }
      i++;
    }
    offset += 80;
  }
  
}

int InRange()
{
  if(mousey > 23 && mousey < (24 + 104)
     && mousex > 71 && mousex < (319 - 71))
  return TRUE;
  return FALSE;

}

int InWindow()
{
  if(mousey > 23 && mousey < 199
     && mousex > 0 && mousex < 319)
  return TRUE;
  return FALSE;

}



char szSpot[40] = "";

#define SPOTX 256
#define SPOTY 6

int PlotSpot(int *plotx, int *ploty, int mx, int my, int bCursor)
{

  if (mx == -1 && my == -1) {  /* reset requested */
     drawcolor = 3;
     pcromfont(szSpot, SPOTX, SPOTY, 1);
     szSpot[0] = plotx[0] = ploty[0] = 0;
  }
  else {

    if (InRange()) {
       if (plotx[0] != mx || ploty[0] != my) {
         plotx[0] = mx;
         ploty[0] = my;
         drawcolor = 3;
         pcromfont(szSpot, SPOTX, SPOTY, 1);
         drawcolor = 0;
         sprintf(szSpot, "%003d,%003d", (mx-72)/2, (my-24)/2);
         pcromfont(szSpot, SPOTX, SPOTY, 1);
       }
    }
    else {
       if (plotx[0] != 0 || ploty[0] != 0) {
         drawcolor = 3;
         pcromfont(szSpot, SPOTX, SPOTY, 1);
         szSpot[0] = plotx[0] = ploty[0] = 0;
       }
    }
  }
  return 0;
}


int pixload(char *fname)
{
  union REGS inregs, outregs;
  
  int m2;
  
  int fh,fh2;
  int offset;
  int inleaf;
  int iPictureCounter = 0;
  int iSaving = FALSE;
  int savemousex = mousex, savemousey = mousey, mousefirst = 0;
  int oldmousex, oldmousey;
  int iValidKey = FALSE;
  int keymousex, keymousey, plotx = -1, ploty = -1;

  int packet = 11,bufpacket = 22,bigpacket = 44;
  int inset = (40 - (11*2));
  int i = 0, idx;
  int iClipType = DAT;
  
  int target = 52;
  char buf[PMASTER_BUFSIZE];
  char oldname[17];
  char cbuf[11];
  int x,y, nibble;
  unsigned temp;
  char *ptr, *cptr,*bptr;
  
  char name[66],name2[66],scratch[66];
  unsigned char c, dh;
  
  strcpy(scratch, fname);
  if(NULL != strstr(scratch, ".DAT"))
    iClipType = DAT;
  strcpy(scratch, fname);
  if(NULL != strstr(scratch, ".SHP"))
    iClipType = SHP;
  strcpy(scratch, fname);
  if(NULL != strstr(scratch, ".POG"))
    iClipType = POG;
  
  ptr = strtok(scratch, ".");
  switch(iClipType) { 
    case POG:
    sprintf(name, "%s.POG", scratch);
    sprintf(name2, "%s.PNM", scratch);
    puts("its a pog");
    break;
    case SHP:
    sprintf(name, "%s.SHP", scratch);
    sprintf(name2, "%s.SDR", scratch);
    break;
    case DAT:
    default:
    sprintf(name, "%s.DAT", scratch);
    sprintf(name2, "%s.NAM", scratch);
    break;
  }
  
  screenbuffer = _fmalloc(0x4000);
  showbuffer = _fmalloc(0x4000);

  memset(namebuf, 0, sizeof(namebuf));
  oldname[16] = 0;
  
  /* display the titleblock */
  
  cload(menubuffer);
  EatKeys();  /* eat keystrokes etc. */
  /* clear the keyboard if any characters */
  
  ENTRY:;
  
  
  if((fh = open(name, O_RDONLY | O_BINARY)) == - 1) {
    _ffree(screenbuffer);
    _ffree(showbuffer);
    return - 1;
  }
  
  if((fh2 = open(name2, O_RDONLY | O_BINARY)) == - 1) {
    close(fh);
    _ffree(screenbuffer);
    _ffree(showbuffer);
    return - 1;
  }
  
  /* if it's a pog file we blow away the header */
  if(iClipType == POG)
    read(fh, cbuf, 10);
  
  TOP:;
  
  drawcolor = 0;
  pcromfont(oldname, 104, 139, 1);
  pcromfont(namebuf, 104, 139, 1);
  if(!read(fh2, oldname, 16))goto ENDER;
  oldname[15] = 0;
  trim(oldname, 16);
  drawcolor = 2;
  pcromfont(oldname, 104, 139, 1);
  iSaving = FALSE;
  
  /* if it's a printmaster file then we read the image specs */
  if(iClipType == SHP) {
    if(!read(fh, cbuf, 4))goto ENDER;
    packet = cbuf[0];                  /* width in bytes */
    inset = 40 - (packet*2);
    target = cbuf[1];                  /* height in rasters */
    bufpacket = cbuf[2] / 4;           /* width in pixels */
    bigpacket = bufpacket*2;
    /* first and last image bytes are NULL PADDING */
    
  }
  inleaf = 8192 + inset + (80*12);
  
  offset = inset + (80*12);
  
  i = 0;
  memset((char *)&screenbuffer[0], 0, target*bufpacket);
  memset((char *)&showbuffer[0], 0, target*bigpacket);
  
  bptr = (char *)&showbuffer[0];
  while(i < target) {
    /* read into a buffer and shift out to 2 bits per pixel */
    /* and to 4 bits per pixel for fatbits */
    
    
    if(!read(fh, cbuf, packet))goto ENDER;
    
    x = 0;
    cptr = (char *)&cbuf[0];
    
    while(x < packet) {
      nibble = 0;
      while(nibble < 8) {
        if(*cptr & 0x80 >> nibble)*bptr |= 15;
        nibble++;
        if(nibble != 2 && nibble != 4 && nibble != 6 && nibble != 8)*bptr <<= 4;
        else {
          *bptr^= 0xff;
          *bptr++;
        }
      }
      *cptr++;
      x++;
    }
    
    memcpy((char *)0xb8000000l + inleaf, 
      &showbuffer[i*bigpacket], bigpacket);
    inleaf += 80;
    memcpy((char *)0xb8000000l + offset, 
      &showbuffer[i*bigpacket], bigpacket);
    offset += 80;
    i++;
  }
  
  /* first and last image bytes are NULL PADDING */
  if(iClipType == SHP)if(!read(fh, cbuf, 1))goto ENDER;
  
  iPictureCounter++;                   /* increment picture counter */
  
  MOUSEAGAIN:;
  
  if(mousefirst)
    GetMousePosition(&mousex, &mousey);
  else { 
    mousefirst = 1;
    mousex = 160;
    mousey = 160;
  }
  if(bCursorOn == FALSE)
    cursoron();
  
  
  /* this is the drawing loop */
  /* we allow keyboard and mouse navigation in this loop */

  EatKeys();
  GetButtonStatus(&m2, &m2);  /* clear keystrokes and button status */
  iValidKey = FALSE;

  plotspot(&plotx, &ploty, -1, -1, TRUE);

  while(iValidKey == FALSE) {
    c = dh = m2 = 0;
    if (kbhit()) {
       c = toupper(getch());
       switch(c) {
         case ENTERKEY:
         case SPACEBAR:
           if (c == ENTERKEY) {
             m2 = 1;  /* left button down = black pixels */
           }
           else {
             m2 = 2; /* right button down = white pixels */
           }
           c = CheckCommand(mousex, mousey);
           if (c!= FUNCKEY) {
             iValidKey = TRUE;
             if (c == ENTERKEY) {
               c = FUNCKEY;
               dh = PGDOWN;
              }
           }
           break;
         case ESCKEY:
         case 'A':
         case 'B':
         case 'C':
         case 'S':
         case 'P':
         case 'X':
         case 'T':
           iValidKey = TRUE;
           break;
         case FUNCKEY:
           keymousex = mousex;
           keymousey = mousey;
           dh = getch();
           switch(dh)
           {
             case PGUP:
             case PGDOWN:
               iValidKey = TRUE;
               break;
             case UPARROW:
               if (InWindow()) {
                 mousey -=2;
                 if (InWindow() == FALSE)
                   mousey+=2;
               }
               break;
             case DOWNARROW:
               if (InWindow()) {
                 mousey +=2;
                 if (InWindow() == FALSE)
                   mousey-=2;
               }
               break;
             case LTARROW:
               if (InWindow()) {
                 mousex -=2;
                 if (InWindow() == FALSE)
                   mousex+=2;
               }
               break;
             case RTARROW:
               if (InWindow()) {
                 mousex +=2;
                 if (InWindow() == FALSE)
                   mousex-=2;
               }
               break;
             default:
               dh = 0;
               break;
           }
           /* if any mouse motion, be sure to move it */
           if (keymousex != mousex || keymousey!= mousey){
             cursoroff();
             plotspot(&plotx, &ploty, mousex, mousey, FALSE);
             cursoron();
           }
           break;
       }
       EatKeys();
    }
    else {
      inregs.x.ax = 3;
      int86(0x33, &inregs, &outregs);
      m2 = outregs.x.bx   ;
      mousex = outregs.x.cx / 2 ;
      mousey = outregs.x.dx   ;
      if (m2 == 1 || m2 == 2) {
         /* simulate Key Strokes with the Mouse */
         c = CheckCommand(mousex, mousey);
         if (c!= FUNCKEY) {
           iValidKey = TRUE;
           if (c == ENTERKEY) {
             c = FUNCKEY;
             dh = PGDOWN;
           }
         }

      }
    }

    if(mousey != oldmousey && mousex != oldmousex && iSaving == TRUE) {
       cursoroff();
       drawcolor = 0;
       pcromfont(oldname, 104, 139, 1);
       pcromfont(namebuf, 104, 139, 1);
       drawcolor = 2;
       pcromfont(oldname, 104, 139, 1);
       plotspot(&plotx, &ploty, mousex, mousey, FALSE);
       cursoron();
       iSaving = FALSE;
    }

    if(m2 == 1 || m2 == 2) {
      if(InRange()) {
        if(m2 == 1)drawcolor = 0;
        else drawcolor = 3;
        y = (mousey / 2)*2;
        x = (mousex / 2)*2;
        cursoroff();
        putdot(x, y, drawcolor);
        putdot(x + 1, y, drawcolor);
        putdot(x, y + 1, drawcolor);
        putdot(x + 1, y + 1, drawcolor);
        plotspot(&plotx, &ploty, mousex, mousey, FALSE);
        cursoron();
      }
      else {
        plotspot(&plotx, &ploty, mousex, mousey, TRUE);
      }
    }
    else {
      plotspot(&plotx, &ploty, mousex, mousey, TRUE);
    }
  }

  plotspot(&plotx, &ploty, -1, -1, TRUE);
  

  while(c!= ESCKEY) {
    switch(c) {
      case 'T':
      cursoroff();
      drawcolor = 0;
      pcromfont(namebuf, 104, 139, 1);
      pcromfont(oldname, 104, 139, 1);
      if(!getpixname(NULL, oldname)) {
        drawcolor = 2;
        pcromfont(oldname, 104, 139, 1);
        break;
      }
      pixstuff(2);
      strcpy(scratch, namebuf);

      memset(namebuf, 0, sizeof(namebuf));
      memset(savebuf, 0, sizeof(savebuf));

      scratch[8] = 0;
      cptr = strtok(scratch, ". *");
      sprintf(savebuf, "%s.BSV", scratch);
      textsave(savebuf);
      sprintf(namebuf, "%s SAVED", savebuf);
      drawcolor = 2;
      pcromfont(namebuf, 104, 139, 1);
      printf("%c", 7);
      GetMousePosition(&oldmousex, &oldmousey);
      iSaving = TRUE;
      break;

      case 'A':
      case 'S':
      cursoroff();
      drawcolor = 0;
      pcromfont(namebuf, 104, 139, 1);
      pcromfont(oldname, 104, 139, 1);
      if(c == 'A') { 
        if(!getpixname("New Name", NULL)) {
          drawcolor = 2;
          pcromfont(oldname, 104, 139, 1);
          break;
        }
        namebuf[15] = 0;
        strcpy(oldname, namebuf);
        idx = 0;
      }
      else  {
        idx = iPictureCounter;
        if(!getpixname(oldname, NULL)) {
          drawcolor = 2;
          pcromfont(oldname, 104, 139, 1);
          break;
        }
        namebuf[15] = 0;
        strcpy(oldname, namebuf);
      }
      pixstuff(2);
      PSSAVE(name, name2, namebuf, iClipType, idx);

      memset(namebuf, 0, sizeof(namebuf));

      sprintf(namebuf, "%s SAVED", name);
      drawcolor = 2;
      pcromfont(namebuf, 104, 139, 1);
      printf("%c", 7);
      /* if in append-mode, setup at the end of the file */
      /* in case more editing and saving is to be done   */
      if (c=='A') {
        while(read(fh2, oldname, 16)) {
          if (iClipType == SHP)
            idx = PMASTER_BUFSIZE;
          else
            idx = PSHOP_BUFSIZE;
          if(!read(fh, buf, idx))
            break;
          iPictureCounter++;
        }
      }
      GetMousePosition(&oldmousex, &oldmousey);
      iSaving = TRUE;
      break;
      
      case 'B':
      case 'C':
      cursoroff();
      drawcolor = 0;
      pcromfont(namebuf, 104, 139, 1);
      pcromfont(oldname, 104, 139, 1);
      if(!getpixname(NULL, oldname)) {
        drawcolor = 2;
        pcromfont(oldname, 104, 139, 1);
        break;
      }
      pixstuff(2);
      strcpy(scratch, namebuf);

      memset(namebuf, 0, sizeof(namebuf));
      memset(savebuf, 0, sizeof(savebuf));

      scratch[8] = 0;
      cptr = strtok(scratch, ". *");
      sprintf(savebuf, "%s.PIC", scratch);
      BSAVE(savebuf, target, bufpacket, c);
      sprintf(namebuf, "%s SAVED", savebuf);
      drawcolor = 2;
      pcromfont(namebuf, 104, 139, 1);
      printf("%c", 7);
      GetMousePosition(&oldmousex, &oldmousey);
      iSaving = TRUE;
      break;
      
      case 'P':
      case 'X':
      cursoroff();
      drawcolor = 0;
      pcromfont(oldname, 104, 139, 1);
      pcromfont(namebuf, 104, 139, 1);
      if(!getpixname(NULL, oldname)) {
        drawcolor = 2;
        pcromfont(oldname, 104, 139, 1);
        break;
      }

      strcpy(scratch, namebuf);

      memset(namebuf, 0, sizeof(namebuf));
      memset(savebuf, 0, sizeof(savebuf));

      scratch[8] = 0;
      cptr = strtok(scratch, ". *");
      if(c == 'X') { 
        pixstuff(1);
        sprintf(savebuf, "%s.PCX", scratch);
        makepcc(savebuf, target*2, bufpacket);
      }
      else { 
        pixstuff(2);
        sprintf(savebuf, "%s.PCC", scratch);
        makepcc(savebuf, target, bufpacket);
      }
      sprintf(namebuf, "%s SAVED", savebuf);
      drawcolor = 2;
      pcromfont(namebuf, 104, 139, 1);
      printf("%c", 7);
      GetMousePosition(&oldmousex, &oldmousey);
      iSaving = TRUE;
      break;

      default :
      if(c == FUNCKEY) {   /* next image */
        switch(dh) {
          case PGUP:
          case PGDOWN:
            cursoroff();
            EatKeys();  /* eat keystrokes etc. */
            goto TOP;
        }
      }
    }
    EatKeys();  /* eat keystrokes etc. */
    goto MOUSEAGAIN;
  }
  
  close(fh);
  close(fh2);
  _ffree(screenbuffer);
  _ffree(showbuffer);
  cursoroff();

  /* clear any keys or mouse presses leftover */
  EatKeys();
  GetButtonStatus(&m2, &m2);
  mousex = savemousex;
  mousey = savemousey;
  return 0;
  
  ENDER:;
  
  close(fh);
  close(fh2);
  iPictureCounter = 0;
  goto ENTRY;
  
}


main(int argc, char **argv)
{
  int x,y,m2;
  char c, ch, dh;
  char far *imagebuf;
  
  int newchoice, oldchoice,filechoice, tempchoice;
  
  union REGS inregs, outregs;
  struct SREGS segregs;
  long address;
  unsigned char first_byte;
  
  /* */
  /*  check for CGA compatible video adapter on initial video mode.*/
  /* */
  
  int86(0x11, &inregs, &outregs);      /* get equipment list from the bios */
  /* get display type (bits 4 and 5 of ax) */
  
  if((outregs.x.ax & 0x30) == 0x30) {
    printf("Sorry... CGA or Compatible Video Adapter Required.\n");
    exit(0);
  }
  
  /* */
  /*  check to see if the mouse is responding */
  /* */
  hi_mickey();
  if(bMickey != TRUE) {
    printf("Sorry... Microsoft Compatible Mouse not found!\n");
    exit(0);
  }
  
  imagebuf = _fmalloc(2048);
  initpix();
  
  /* */
  /* set the video mode */
  /* */
  _setvideomode(_MRESNOCOLOR);
  hi_mickey();  /* need to initialize the custom cursor now that */
                /* we are in graphics mode */
  
  /* */
  /*  set mouse sensitivity */
  /* */
  inregs.x.ax = 15;
  inregs.x.cx = 16;
  inregs.x.dx = 32;
  int86(0x33, &inregs, &outregs);
  
  drawscreen(3);
  if(!drawscreen(0)) {
    drawscreen(4);
  }
  else {
    drawscreen(1);


    /* */
    /*  set mouse cursor location, then turn on cursor */
    /* */

    mousex = 160;
    mousey = 160;

    /* */
    /*  m a i n    l o o p */
    /* */
    oldchoice = - 1;
    newchoice = - 1;

    NEXTPAGE:;
    /* short jump back to here if only a page flip */
    EatKeys();
    GetButtonStatus(&m2, &m2);

    /* turn on the cursor */

    cursoron();
    filechoice = - 1;

    while(filechoice == - 1) {
      m2 = 0;
      /* wait here for a button press */
      while(!(m2)) {


        /* simulate mouse selection with keyboard keys */
        if (kbhit()) {
          tempchoice = -1;
          ch = getch();
          if (ch == FUNCKEY) {
            dh = getch();
            if (oldchoice > -1 && oldchoice < 22)
              tempchoice = oldchoice;
            switch(dh) {
               case DOWNARROW:
                  if (tempchoice == 21)
                    tempchoice = 19;
                  if (tempchoice == 20)
                    tempchoice = 16;
                  tempchoice+=4;
                  if (tempchoice > 19)
                    tempchoice -= 20;
                  break;
               case UPARROW:
                  if (tempchoice == 21 || tempchoice == 20) {
                    if (tempchoice == 21)
                      tempchoice = 19;
                    if (tempchoice == 20)
                      tempchoice = 16;
                  }
                  else {
                    tempchoice-=4;
                    if (tempchoice < 0)
                      tempchoice += 20;
                  }
                  break;
               case LTARROW:
                  tempchoice--;
                  if (tempchoice < 0)
                    tempchoice = 21;
                  break;
               case RTARROW:
                  tempchoice++;
                  if (tempchoice > 21)
                    tempchoice = 0;
                  break;
               case PGDOWN:
               case PGUP:
                  m2 = 1;
                  tempchoice = 20;
                  break;
               default:
                  tempchoice = -1;
                  break;

            }
          }
          else {
            /* common key strokes - ESCape to quit */
            /* ENTER to simulate a Button Press    */
            switch (ch) {
              case ESCKEY:
                tempchoice = 21;
              case ENTERKEY:
              case SPACEBAR:
                m2 = 1;
            }

          }
          if (tempchoice!= -1) {
            /* simulate mouse movement */
            /* put the cursor in the middle */
            x = filebox[tempchoice][0] +
                ((filebox[tempchoice][2] - filebox[tempchoice][0])/2) - 8;
            y = filebox[tempchoice][1] +
                ((filebox[tempchoice][3] - filebox[tempchoice][1])/2) - 8;
          }
          EatKeys();

        }
        else {
          inregs.x.ax = 3;
          int86(0x33, &inregs, &outregs);
          m2 = outregs.x.bx   ;
          x = outregs.x.cx / 2 ;
          y = outregs.x.dx   ;
        }

        /* get mouse location and button status */
        newchoice = CheckFile(x, y);


        if(newchoice != oldchoice) {
          /* turn off cursor */
          cursoroff();
          if(oldchoice > - 1 && oldchoice < 20) {
            _putimage(filebox[oldchoice][0] + 1,
              filebox[oldchoice][1] + 1, imagebuf, _GPSET);
          }
          if(newchoice > - 1 && newchoice < 20) {
            _getimage(filebox[newchoice][0] + 1,
              filebox[newchoice][1] + 1,
              filebox[newchoice][2] - 1,
              filebox[newchoice][3] - 1, imagebuf);
            _putimage(filebox[newchoice][0] + 1,
              filebox[newchoice][1] + 1, imagebuf, _GPRESET);

          }
          /* turn on the cursor */
          ShowMickey(x, y);
        }
        oldchoice = newchoice;
      }

      filechoice = CheckFile(x, y);
    }

    mousex = x;
    mousey = y;
    cursoroff();
    /* turn off cursor */
    /* draw the screen */

    if(filechoice == 20) {
      drawscreen(2);
      oldchoice = -1;
      goto NEXTPAGE;                     /* short jump to flip the page */
    }

    if(filechoice < 20) {
      pixload(wildfiles[filebox[filechoice][6]]);
      drawscreen(1);
      oldchoice = -1;
      goto NEXTPAGE;
    }

  }
  cursoroff();
  drawscreen(5);
  freepix();
  _ffree(imagebuf);
  _setvideomode(3);                    /* reset video mode and exit */
  puts(" Have A Nice Dos! ");
  exit(0);
  
}

encline(inbuff, inlen)  /* encodes a raw line and writes it out to disk */
unsigned char *inbuff;
int inlen;
{
  unsigned char this,last;
  int srcindex,i;
  register int total;
  register unsigned char runcount;
  total = 0;
  last = *(inbuff); runcount = 1;
  
  for(srcindex = 1;srcindex != inlen;srcindex++) {
    this = *(++inbuff);
    if(this == last) {
      runcount++;
      if(runcount == 63) {
        if(!(i = encput(last, runcount)))
          return(0);
        total += i;
        runcount = 0;
      }
    }
    else {
      if(runcount) {
        if(!(i = encput(last, runcount)))
          return(0);
        total += i;
      }
      last = this;
      runcount = 1;
    }
  }
  
  if(runcount) {
    if(!(i = encput(last, runcount)))
      return(0);
    return(total + i);
  }
  return (total);
  
}


encput(byt, cnt)       /* the writer for the encline function */
unsigned char byt,cnt;
{
  if(cnt) {
    if((cnt == 1) && (0xc0 != (0xc0 &byt))) {
      if(EOF == fputc((int)byt, pccfile))
        return(0);
      return(1);
    }
    else {
      if(EOF == fputc((int)0xc0 | cnt, pccfile))
        return(0);
      if(EOF == fputc((int)byt, pccfile))
        return(0);
      return(2);
    }
  }
  return(0);
  
}
