/* ------------------------------------------------------------------------ */
/* Shp2Dat.c (C) CopyLeft Bill Buckels 1991-1999                            */
/* All Rights Reversed.                                                     */
/*                                                                          */
/* Licence Agreement                                                        */
/* -----------------                                                        */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* If you don't agree, remove this source code from your computer now.      */
/*                                                                          */
/* Written by   : Bill Buckels                                              */
/*                589 Oxford Street                                         */
/*                Winnipeg, Manitoba, Canada R3M 3J2                        */
/*                                                                          */
/* Email: bbuckels@escape.ca                                                */
/* WebSite: http://www.escape.ca/~bbuckels                                  */
/*                                                                          */
/* Purpose      : Converts from "Old PrintMaster" to "Old PrintShop"        */
/* Revision     : 2.0 Last Release                                          */
/* ------------------------------------------------------------------------ */
/* Written in Large Model Microsoft C Version 6.00a                         */
/* ------------------------------------------------------------------------ */

char shphead[4]={0x0b,0x34,0x58,0x00};
char shptail[1]={0x00};

#include <fcntl.h>
#include <stdio.h>
#include <malloc.h>
#include <io.h>
#include <stdlib.h>
#include <string.h>

unsigned char far *buffer;

unsigned csize = 572;
unsigned dsize = 577;

int SHP2DAT(char *shpname, char *datname)
{
  int fh,fh2;
  
#define S_IWRITE    0000200          /* write permission, owner   */
    
    if((fh2 = open(shpname, O_RDONLY | O_BINARY)) == - 1) {
    perror(shpname);
    return - 1;
  }
  
  
  if((fh = open(datname, O_CREAT | O_TRUNC | O_WRONLY | O_BINARY, S_IWRITE)) == - 1) {
    perror(datname);
    close(fh2);
    return - 1;
  }
  
  
  buffer = _fmalloc(dsize);
  
  printf("INPUT FILE  : %s\n", shpname);
  printf("OUTPUT FILE : %s\n", datname);
  
  while(read(fh2, buffer, dsize) == dsize)
    write(fh, (char *)&buffer[4], csize);
  
  close(fh);
  close(fh2);
  free(buffer);
  
  printf("Done !");
  return (0);
  
}

int DAT2SHP(char *datname, char *shpname)
{
  int fh,fh2;
  
#define S_IWRITE    0000200          /* write permission, owner   */
    
    if((fh2 = open(datname, O_RDONLY | O_BINARY)) == - 1) {
    perror(datname);
    return - 1;
  }
  
  
  if((fh = open(shpname, O_CREAT | O_TRUNC | O_WRONLY | O_BINARY, S_IWRITE)) == - 1) {
    perror(shpname);
    close(fh2);
    return - 1;
  }
  
  
  buffer = _fmalloc(csize);
  
  printf("INPUT FILE  : %s\n", datname);
  printf("OUTPUT FILE : %s\n", shpname);
  
  while(read(fh2, buffer, csize) == csize) {
    write(fh, shphead, 4);
    write(fh, buffer, csize);
    write(fh, shptail, 1);
  }
  close(fh);
  close(fh2);
  free(buffer);
  
  printf("Done !");
  return (0);
  
}



main(int argc, char **argv)
{
  int fh,fh2;
  FILE *fp;
  char *bptr;
  char c,d;
  
  char shopbuf1[66],shopbuf2[66],masterbuf1[66],masterbuf2[66];
  char tempbuf[66];
  
  puts("SHP2DAT(C) v2.0 CopyLeft by Bill Buckels 1991-1999");
  puts("All Rights Reversed.");
  
  
  /* check for correct usage */
  switch(argc) {
    case 2 : break;
    
    case 3 : if(strcmpi(argv[2], "REVERSE") == 0)break;
    default:
    
    puts("USAGE  is \"SHP2DAT <filnam.shp>\"");
    puts("OPTION is \"SHP2DAT <filnam.shp> REVERSE\"");
    puts("CONVERTS SHP files to DAT files -or-");
    puts("REVERSE OPTION CONVERTS DAT FILES TO SHP FILES");
    exit(0);
    
  }
  
  /* make file names */
  
  strcpy(tempbuf, argv[1]);
  bptr = strtok(tempbuf, " .\\:*");
  sprintf(masterbuf1, "%s.SHP", tempbuf);
  sprintf(masterbuf2, "%s.SDR", tempbuf);
  
  c = toupper(tempbuf[0]);
  d = toupper(tempbuf[1]);
  
  if(c == 'G' && d == 'R') {
    sprintf(shopbuf1, "%s.DAT", tempbuf);
    sprintf(shopbuf2, "%s.NAM", tempbuf);
  }
  else {
    tempbuf[6] = 0;
    sprintf(shopbuf1, "GR%s.DAT", tempbuf);
    sprintf(shopbuf2, "GR%s.NAM", tempbuf);
  }
  
  switch(argc) {
    /* convert from printmaster to printshop */
    case 2   :
    if((fp = fopen(shopbuf1, "rb")) != NULL) {
      fclose(fp);
      printf("%s already exists... cannot overwrite files\n", 
        shopbuf1);
      exit(0);
    }
    
    sprintf(tempbuf, "COPY %s %s", masterbuf2, shopbuf2);
    system(tempbuf);
    
    SHP2DAT(masterbuf1, shopbuf1);
    break;
    
    
    /* convert from printshop to printmaster */
    default : if((fp = fopen(masterbuf1, "rb")) != NULL) {
    fclose(fp);
    printf("%s already exists... cannot overwrite files\n", 
      masterbuf1);
    exit(0);
  }
    sprintf(tempbuf, "COPY %s %s", shopbuf2, masterbuf2);
    system(tempbuf);
    
    DAT2SHP(shopbuf1, masterbuf1);
    
  }
  
  exit(0);
  
}
