global_settings {
 ambient_light color <1.2,1.8,2>
}

#include "sides.inc"

light_source { 100 color rgb <1.3,1.15,1>
  looks_like {
    sphere {0,20
      pigment  { granite
        color_map {
          [0 color rgb <.6,.8,1>]
          [.5 color rgb 1]
          [1 color rgb 1]
        }
        sine_wave 
        scale 5
      }
      finish { ambient 1 }
    }
  }
}

// Create an infinite sphere around scene and allow any texture on it
sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1]}
    scale 1.3
    translate -.2
  }
}

fog {
  fog_type   1
  distance   10
  color      rgbt <1,1,1,.25>
  fog_offset .3
  fog_alt    0.01
  turbulence 0.8
}


height_field
{
  tga               
  "hillhf.tga"     
  smooth
  
  pigment { color rgb 1}
  finish {reflection 0 ambient .3}
  
  scale <20,6,20>
  translate <-10,-4,-10>
}
