/* constants and structures for graphix.c graphics function library */
/* this header file should be used in the main program or in the file where
the function g_init () is called.  All others should use graph.h .  Use
hpgraph.h only to compile graphix.c */

/* copyright 1988 - 1992 Robert C. Becker, Lantern Systems */

#ifndef DSP_FN_DEFT

enum DFNON__OFF { DFN_OFF, DFN_ON };	/* definition for display fn's ON/OFF */

#define DSP_FN_DEFT
#endif

#define	Graphix_hdr_deft		/* graphix headers do not need to be defined */

#include "graph.h"	/* function prototypes */

#ifndef VID_PARAM_DEFT

#define		IBMPACKED	1	/* video bios # for CGA, MCGA, and VGA 256 color mode, ATT6300, Herc HGC & HCG+ */
#define		IBMPLANES	2	/* video bios # for EGA & VGA */
#define		VESABIOS	3	/* video bios # for VESA devices using BIOS I/O */

struct _vid_x_parm_		/* graphix init parameters */
	{
	unsigned max_xdot;	/* horizontal screens pixels - 1 */
	unsigned max_ydot;	/* vertical screen pixels - 1 */
	int max_pen;		/* # colors for this mode - 1 */
	unsigned char mode;	/* BIOS mode # for this mode */
	unsigned video_bios;	/* 0 -> using bios writes, != 0 -> not using bios for pixel writes */
	unsigned base_adr;	/* segment adr for video RAM */
	unsigned block_size;		/* # bytes in one block of video RAM */
	unsigned block_per_page;	/* # blocks needed to make one graphics screen */
	unsigned bytes_per_pixel;	/* =1 unless more than 8 bits/pixel */
	unsigned bits_per_pixel;	/* # bits used for a single pixel */
	unsigned pixels_per_byte;	/* # pixels/byte  (=1 if > 8 bits/pixel) */

	};
#define 	VID_PARAM_DEFT	/* video param structure defined */
#endif

#ifndef CHAR_STR_DEFT

struct char___deft
	{
	char *fontname;
	double ascender;
	double descender;
	double width;
	double base;
	double center;
	double top;
	double x_inc;
	double y_inc;
	};

#define		CHAR_STR_DEFT	/* char description struct defined */
#endif

struct _vid_x_parm_ hpc_320_200_hp = { 319, 199, 3, 0x04, IBMPACKED, 0xb800, 0x2000, 2, 1, 2, 4 };
	/* BIOS CGA 320x200 color */
struct _vid_x_parm_ hpc_640_200_hp = { 639, 199, 1, 0x06, IBMPACKED, 0xb800, 0x2000, 2, 1, 1, 8 };
	/* BIOS CGA 640x200 BW */
struct _vid_x_parm_ hpa_640_400_hp = { 639, 399, 1, 0x48, IBMPACKED, 0xb800, 0x2000, 4, 1, 1, 8 };
	/* AT&T 640x400 mode, tiny type */
struct _vid_x_parm_ hpad_640_400_hp = { 639, 399, 15, 0x48, IBMPACKED, 0xb800, 0x2000, 4, 1, 1, 8 };
	/* AT&T 640x400 BW, tiny type, 16 colors */
struct _vid_x_parm_ hph_720_348_hp = { 719, 347, 1, 0x00, IBMPACKED, 0xb000, 0x2000, 4, 1, 1, 8 };
	/* Hercules 720x348 mode (HGC and HGC+) */
struct _vid_x_parm_ hpe_320_200_hp = { 319, 199, 15, 0x0d, IBMPLANES, 0xa000, 0, 1, 1, 1, 8 };
	/* IBM EGA med-res mode (320x200) */
struct _vid_x_parm_ hpe_640_200_hp = { 639, 199, 15, 0x0e, IBMPLANES, 0xa000, 0, 1, 1, 1, 8 };
	/* IBM EGA med-res mode (640x200) */
struct _vid_x_parm_ hpem_640_350_hp = { 639, 349, 2, 0x0f, IBMPLANES, 0xa000, 0, 1, 1, 1, 8 };
	/* IBM EGA high-res BW mode (640x350) */
struct _vid_x_parm_ hpe_640_350_hp = { 639, 349, 15, 0x10, IBMPLANES, 0xa000, 0, 1, 1, 1, 8 };
	/* IBM EGA high-res mode (640x350) */
struct _vid_x_parm_ hpv_640_480_hp = { 639, 479, 15, 0x12, IBMPLANES, 0xa000, 0, 1, 1, 1, 8 };
	/* IBM VGA high-res mode (640x480) */
struct _vid_x_parm_ hpv_320_200_hp = { 319, 199, 255, 0x13, IBMPACKED, 0xa000,0, 1, 1, 1, 8 };
	/* IBM VGA lo-res mode (320x200) */
struct _vid_x_parm_ hpm_640_480_hp = { 639, 479, 2, 0x11, IBMPACKED, 0xa000, 0, 1, 1, 1, 8  };
	/* IBM MCGA 640x480 BW (highest resolution) */

extern double X_mm = 220.0, Y_mm = 160.0;	/* screen size in mm */
