/* gstructs.h */

/* definitions of external structures for use in compiling portions of
graphix.c library outside of main body of graphix.c */

/* copyright 1988 - 1992, Robert C. Becker, Lantern Systems */

#ifndef STRCTS_DEFT	/* check for existance of previous definitions */

struct hp_position	/* public structures for external routines */
	{
	double xpos, ypos, rpos_x, rpos_y;
	};

struct hp_scaling
	{
	double x_factor, x_offset, y_factor, y_offset, xmax, ymax;
	double scr_xmin, scr_ymin;
	};

struct hp_misc
	{
	unsigned max_x_dot, max_y_dot;
	double x_ppm, y_ppm, gdu;
	int pendown, g_input, mouse_status, degree;
	unsigned wht_color;
	};

struct w_params		/* struct for viewport, limit, & clip params */
	{
	double xmin, xmax, ymin, ymax;
	};

#define STRCTS_DEFT
#endif

extern struct hp_position  __x_y_rfs_;	/* position info */
extern struct hp_scaling  __x_y_sfs_;	/* scale factors & offsets */
extern struct hp_misc  __gr_msc__;	/* miscellaneous */
