/*                        Sprite & Scrolling Engine                         */
/*        Copyright (c) Genesoft 1995-1996.  All rights reserved.           */

#include<stdio.h>
#include<stdlib.h>

#include<sse.h>
#include"mapmaker.h"


char * Buffer, * CP, * TP;
int left, original;

int SetupBuffer( int Size )
{
   /* Set up a buffer for our data */
   if( ( Buffer = (char*) malloc( Size ) ) == NULL ) return 1;
   
   left = original = Size;
   CP = Buffer;
   TP = Buffer + Size;
   return 0;
}

int BufferLeft()
{
   return left;
}

void * Alloc( int Amount )
{
   void * ret;
   ret = TempAlloc( Amount );
   left -= Amount;
   CP += Amount;
   return ret;
}

void * TempAlloc( int Amount )
{
   if( Amount > left )
   {
      sseRestoreVideoMode();
      printf("Out of buffer space!\n" );
      printf("  Solution: Increase MAPMAKER \"BUFFER_SIZE\" value.\n\n" );
      exit( EXIT_FAILURE );
   }
   return CP;
}

void FreeFrom( void * Pos )
{
   if( Pos > CP || Pos < Buffer )
   {
      sseRestoreVideoMode();
      printf("FreeFrom position out of range!\n" );
      exit( EXIT_FAILURE );
   }
   left += CP - Pos;
   CP = Pos;
}

void * AllocTop( int Amount )
{
   TempAlloc( Amount ); // Check if there is enough space
   TP -= Amount;
   left -= Amount;
   return TP;
}

void FreeTop( void )
{
   TP = Buffer + original;
}


