/* Compute and print out various engineering handbook tables
 */

#define fabs(x) ( (x) < 0 ? -(x) : (x) )

extern double MACHEP, MAXNUM;
extern double Kn, Kp, P, kl;
double sqrt(), log(), pow(), sin(), cos(), atan();
double ellpe(), ellpk(), chbevl();
double rsol(), lyle(), dwighta(), dwightb(), butterw();
double lyle2(), spielrein(), nagaoka();



main()
{
double a, b, c, N, L, q;
long i;
int j;

N = 1.0;

/* Print Nagaoka's table */
printf( "Values of Nagaoka's Constant K for Circular Solenoidal Current Sheet\n" );
printf( " L = 2e-9 pi^2 (2a/b) N^2 a K  henrys\n" );
printf( " a = radius, b = length\n\n" );
printf( "2a/b   K\n\n" );
b = 2.0;
a = 0.0;
i = 0.0;
while( i <= 40000L )
	{
	a = 0.01 * i;
	L = nagaoka( a, b, N );
	printf( "%4.2lf %7.5lf\n", a, Kn );
	if( i >= 10000L )
		{
		i += 10000L;
		continue;
		}
	if( i >= 4000 )
		{
		i += 1000;
		continue;
		}
	if( i >= 2000 )
		{
		i += 200;
		continue;
		}
	if( i >= 500 )
		{
		i += 50;
		continue;
		}
	if( i >= 200 )
		{
		i += 10;
		continue;
		}
	if( i >= 100 )
		{
		i += 5;
		continue;
		}
	i += 1;
	}

printf( "\n\n\n" );
printf( "Grover's Table of K\' for Circular Coils of Rectangular Cross Section\n" );
printf( " a = mean radius, b = length, c = winding thickness\n" );
printf( " L = 2e-9 pi^2 (2a/b) N^2 a K\'  henrys\n\n" );
a = 0.5;
c = 0.025;
i = 25;
while( c < 1.0 )
while( i <= 1000 )
{
c = 0.001 * i;
printf( "       c/2a = %.3lf\n", c );
printf( "b/c = 0, .1, .2, ..., 1.0\n" );
for( j=0; j<=10; j++ )
	{
	q = 0.1 * j;
	b = q * c;
	L = rsol( a, b, c, N );
	printf( "%6.4lf ", Kp );
	}
printf( "\n" );
printf( "c/b = 0, .1, .2, ..., 1.0\n" );
for( j=0; j<=10; j++ )
	{  /* c/b = q */
	q = 0.1 * j;
	if( q == 0.0 )
		b = 9.9e5*c;
	else
		b = c/q;
	L = rsol( a, b, c, N );
	printf( "%6.4lf ", Kp );
	}
printf( "\n" );
if( i == 25 )
	{
	i = 50;
	}
else
	{
	if( i == 50 )
		i = 100;
	else
		i += 100;
	}
}

printf( "\n\n\n" );
printf( "Grover's Table of P for Flat Disk Coils\n" );
printf( " L = 1e-9 N^2 a P  henrys\n\n" );
printf( "  c/2a   P\n" );
a = 0.5;
b = 0.0;
i = 1;
N = 1.0;
while( i <= 100L )
	{
	c = 0.01 * i;
	L = rsol( a, b, c, N );
	printf( "%4.2lf %7.3lf\n", c, P );
	i += 1;
	}


printf( "\n\n\n" );
printf( "Grover's Table of P for Circular Coils of Square Cross Section\n" );
printf( " b = c\n" );
printf( " L = 1e-9 N^2 a P  henrys\n\n" );
printf( "  c/2a   P\n" );
a = 0.5;
i = 1;
N = 1.0;
while( i <= 100L )
	{
	c = 0.01 * i;
	b = c;
	L = rsol( a, b, c, N );
	printf( "%4.2lf %7.3lf\n", c, P );
	i += 1;
	}
}

