/*                                                                        */
/*                                                                        */
/* file MINIJOY.H                                                         */
/*                                                                        */
/* written in 1994 by Henning Ruch                                        */
/* ported to C by Christof Ruch                                           */
/*                                                                        */
/*                                                                        */

#ifndef _minijoy
#define _minijoy 1

#define MAXPLAYER 6                    /* maximum number of players */

struct TJoy
{
        signed char x,y;               /* -1 .. +1 (minus is left/up) */
        char        knopf,xtra,        /* buttons held down if != 0   */
                    lhit, rhit,        /* directions triggered if !=0 */
                    uhit, dhit,        /* directions triggered if !=0 */
                    khit, xhit;        /* buttons triggered    if !=0 */
};

/* contains all joystick status information */
/* is updated by calling GetAllJoyState     */
extern struct TJoy JoyState[MAXPLAYER];

/* you must call this before using GetAllJoyState */
void InitMultijoy ();

/* gets status of all joystick ports */
void GetAllJoyState ();


#endif
