-----------------------------------------------------------------
VOUCH  version  1.1.  Copyright (c) 1993, 1994  Awais M. Hussain.
-----------------------------------------------------------------
<hasher.c>
<hash.asm>

Implements the NIST secure hash standard [1]. A hash number, 160 bits
long, of a file is computed using the secure hash function specified
by the US National Institute of Standards and Technology (NIST),
Gaithersburg, MD 20899.

=====================================================================

1.  int hash( int  rcv, char  *fname, lenLN  *Lmhash, ptrLN  mhash ) ;

Computes the hash of file <fname> in the LN (Lmhash,mhash). Lmhash=5.
(rcv=1) => First three lines of <fname> are the VCH-header and signature,
           which are thus not included for the hash computation.

I: rcv : {0,1}-flag.
I: fname : File to be hashed.
O: Lmhash : Length of the hash LN
O: mhash  : hash LN 

======================================================================

2.  int extran( unsigned *hC, char *fname ) ;

hC= the number of characters in the first three lines of file
<fname>. Used by hash().

O: hC : 
I: fname : filename


3. int paddCount( int rcv, int hC, int *count, char *fname ) ;

count = number of zero bits to be padded to the input data as
        required by the hash algorithm. Used by hash().

I: rcv : {0,1} flag. (rcv=1) implies that the first three lines of
         the file are the header.
I: hC :  the number of characters in the first three lines of file
         <fname>.
O: count :
I: fname : filename.

4. void movrev( char *sx, char *dx, int nb ) ;

Move nb/4 long-integers (nb a multiple of 4) from source (sx) to
destination (dx), in the process reversing the order of bytes in
long-integers. 

I: sx : source string.
O: dx : destination string.
I: nb : length in bytes of each string.

5. extern 
void far hshBlk( long unsigned hx[5], long unsigned Wbuff[80] ) ; 

Process the block Wbuff[] according to the hash algorithm and update
the hash-number in hx[]. Used by hash().

I/O: hx[] : array containing the 160-bit hash number.
I: Wbuff[] : a 80-word block, the first 16 words of which contain
             input data from the file being processed, when the routine 
             is called. The space is used for its own calculations.

======================================================================

[1] NIST, ``A Secure Hash Standard,'' FIPS PUB YY, Jan. 22, 1992.
