/**<gfmr.c>***************************************************
*                       V O U C H                           *
*   VOUCH 1.1  Copyright (c) 1993, 1994  Awais M Hussain    *
*                   All rights reserved                     *
*************************************************************/
/* Consult <gfmr.man> for documentation. */

#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#include "vch.h"

extern unsigned bLen ;

unsigned Nres = 16 ;
ptrLN  rs[380] ;  /* 1..379 */
lenLN  Lrs[380] ; /* 1..379 */
static unsigned itx = 0 ;


/* Euclid's greatest common divisor */
void gcd( lenLN La, ptrLN aa, lenLN Ln, ptrLN nn,
                                      lenLN *Lgp, ptrLN gp ) ;
/* gp = gcd( aa, nn) */

/* Euclid inverse : solve for x such that aa * x mod nn = 1 */
/* 0 < aa < nn ; gcd(aa,nn) = 1 */
void inverse( lenLN La, ptrLN aa, lenLN Ln, ptrLN nn,
				  lenLN *Lia, ptrLN ia ) ;
/* ia = inverse( aa ) mod nn ;  aa < nn */

/* extend/generate residue_table required by procedure <psor> */
/*  rs[i] := power( 2, (Lpp+i-1)*32 ) mod pp ; i := 1,...,Nres-Lpp */
/* Lrs[i] = length( rs[i] )  */
/* extend residue_table */
void ext_residues( lenLN Lpp, ptrLN pp, unsigned oNres, unsigned nNres ) ;
/* generate rs[oNres+1],...,rs[nNres] ; Nres = nNres */

/* modular reduction by partial_sum_of_residues */
void psor( lenLN Lbb, ptrLN bb, lenLN Lpp, ptrLN pp,
                                       lenLN *Lrr, ptrLN rr ) ;
/* requires residue_table generated by procedure <ext_residues> */
/* The table is generated automatically by calls to ext_residues as needed.*/
/* Before the first call to psor set Nres := Lpp */
/* rr = bb partial_mod pp */

/* Modular Discrete Exponentiation */
void dexp( lenLN Lx, ptrLN xx, lenLN Ln, ptrLN nn,
                lenLN Lpp, ptrLN pp, lenLN *Le, ptrLN ee ) ;
/* requires residue_table */
/* ee = power( xx, nn )  mod pp  */

/* Modular product discrete exponentiation */
void dexp2( lenLN Lx1, ptrLN x1, lenLN Ln1, ptrLN n1,
            lenLN Lx2, ptrLN x2, lenLN Ln2, ptrLN n2,
	    lenLN Lpp, ptrLN pp, lenLN *Le, ptrLN ee ) ;
/* ee = ( power( x1, n1 ) * power( x2, n2 ) )  mod pp  */


/* dispose residue array ( rs[] ) */
void clear_rs( unsigned Lpp ) ;


/* Euclid's greatest common divisor */
void gcd( lenLN La, ptrLN aa, lenLN Ln, ptrLN nn, lenLN *Lgp, ptrLN gp )
/* gp = gcd( aa, nn) */
{
 ptrLN gc, gn ;
 lenLN Lgc, Lgn ;

 gc = (ptrLN) malloc( bLen ) ;
 gn = (ptrLN) malloc( bLen ) ;

 *Lgp = Ln ; movmem( nn, gp, 4**Lgp ) ;
 Lgc = La ; movmem( aa, gc, 4*Lgc ) ;
 while ( (Lgc>1) || (*gc!=0) ) {
  modR( *Lgp, gp, Lgc, gc, &Lgn, gn ) ;
  *Lgp = Lgc ; movmem( gc, gp, 4**Lgp ) ;
  Lgc = Lgn ; movmem( gn, gc, 4*Lgc ) ;
 }
 free( gn ) ; free( gc ) ;
}/* gcd */

/* Euclid inverse : solve for x such that aa * x mod nn = 1 */
/* 0 < aa < nn ; gcd(aa,nn) = 1 */
void inverse( lenLN La, ptrLN aa, lenLN Ln, ptrLN nn, lenLN *Lia, ptrLN ia ) 
/* ia = inverse( aa ) mod nn ;  aa < nn */
{
 int ptv = 1 ;
 lenLN Lg0, Lg1, Lg2, Lv0, Lv1, Lv2, Ly ;
 ptrLN g0, g1, g2, gt, v0, v1, v2, vt, yy ;

 g0 = (ptrLN) malloc(bLen) ;
 g1 = (ptrLN) malloc(bLen) ;
 g2 = (ptrLN) malloc(bLen) ;
 v0 = (ptrLN) malloc(bLen) ;
 v1 = (ptrLN) malloc(bLen) ;
 v2 = (ptrLN) malloc(bLen) ;
 yy = (ptrLN) malloc(bLen) ;
 Lg0 = Ln ; movmem( nn, g0, 4*Lg0 ) ;
 Lg1 = La ; movmem( aa, g1, 4*Lg1 ) ;
 Lv0 = 1 ; *v0 = 0 ; Lv1 = 1 ; *v1 = 1 ;
 while ( (Lg1 > 1) || ( *g1 != 0 ) ) {
  ptv = !ptv ;
  divide( Lg1, g1, Lg0, g0, &Ly, yy, &Lg2, g2 ) ;
  mult( Ly, yy, Lv1, v1, &Lv2, v2 ) ;
  accum( Lv0, v0, &Lv2, v2 ) ;
	       gt = g0 ;
  Lg0 = Lg1 ;  g0 = g1 ;
  Lg1 = Lg2 ;  g1 = g2 ;
	       g2 = gt ;
	       vt = v0 ;
  Lv0 = Lv1 ;  v0 = v1 ;
  Lv1 = Lv2 ;  v1 = v2 ;
	       v2 = vt ;
 }
 if (ptv) {
  *Lia = Ln ; movmem( nn, ia, 4*Ln ) ;
  subt( Lv0, v0, Lia, ia ) ;
 }
 else {
  *Lia = Lv0 ; movmem( v0, ia, 4**Lia ) ;
 }
 free( yy ) ;
 free( v2 ) ; free( v1 ) ; free( v0 ) ;
 free( g2 ) ; free( g1 ) ; free( g0 ) ;
}/* inverse */


/* extend/generate residue_table required by procedure <psor> */
/*  rs[i] := power( 2, (Lpp+i-1)*32 ) mod pp ; i := 1,...,Nres-Lpp */
/* Lrs[i] = length( rs[i] )  */
/* extend residue_table */
void ext_residues( lenLN Lpp, ptrLN pp, unsigned oNres, unsigned nNres )
/* generate residues #oNres+1,...,#nNres in      */
/* rs[oNres+1-Lpp],..,rs[nNres-Lpp]  ; Nres = nNres */
{
 int i ;
 lenLN  Ltt ;
 ptrLN  tt ;

 tt = (ptrLN) malloc(bLen)  ;
 for (i=oNres+1; i<=nNres; ++i) {
  if (i==Lpp+1) {
   rs[1] = (ptrLN) malloc(bLen) ;
   Ltt = Lpp+1 ;
   setmem( tt, 4*(Ltt-1), 0 ) ;
   *(tt+Ltt-1) = 1 ;
   modR( Ltt, tt, Lpp, pp, &Lrs[1], rs[1] ) ;
  } else {
   Ltt = Lrs[i-Lpp-1] + 1 ;
   movmem( rs[i-Lpp-1], tt+1, 4*(Ltt-1) ) ;
   *tt = 0 ;
   rs[i-Lpp] = (ptrLN) malloc(bLen) ;
   if (rs[i-Lpp]==NULL) {
    fprintf(stderr, "allocation failed: ext_residues\n") ;
    exit(203) ;
   }
   modR( Ltt, tt, Lpp, pp, &Lrs[i-Lpp], rs[i-Lpp] ) ;
  }
 }
 Nres = nNres ;
 free( tt ) ;
}/* ext_residues */


/* modular reduction by partial_sum_of_residues */
void psor( lenLN Lbb, ptrLN bb, lenLN Lpp, ptrLN pp, lenLN *Lrr, ptrLN rr ) 
/* requires residue_table generated by procedure <ext_residues> */
/* The table is generated automatically by calls to ext_residues as needed.*/
/* Before the first call to psor set Nres := Lpp */
/* rr = bb partial_mod pp */
{
 int i ;
 ptrLN  t1, t2 ;
 lenLN  Lt1 ;

 if (Lbb <= Lpp) {
  *Lrr = Lbb ; movmem( bb, rr, 4*Lbb ) ; return ;
 }
 t1 = (ptrLN) malloc(bLen) ; t2 = (ptrLN) malloc(bLen) ;
 if (Lbb>Nres) {
  ext_residues( Lpp, pp, Nres, Lbb ) ;
  ++itx ;
 }
 *Lrr = Lpp ;  movmem( bb, rr, 4**Lrr ) ;
 for (i=Lpp+1; i<=Lbb; ++i) {
  *t2 = *(bb+i-1) ;
  mult( 1, t2, Lrs[i-Lpp], rs[i-Lpp], &Lt1, t1 ) ;
  accum( Lt1, t1, Lrr, rr ) ;
 }
 free(t2) ; free(t1) ;
}/* psor */


/* Modular Discrete Exponentiation */
void dexp( lenLN Lx,  ptrLN xx, lenLN Ln,  ptrLN nn,
	   lenLN Lpp, ptrLN pp, lenLN *Le, ptrLN ee )
/* requires residue_table */
/* ee = power( xx, nn )  mod pp  */
{
 ptrLN  zz, th ;
 lenLN  Lz, Lth ;
 long unsigned cw, nw ;
 unsigned maxci, bzn ;
 int j, ci ;

 bzn = fb1( *(nn+Ln-1) ) ;
 zz = (ptrLN) malloc(bLen);
 th = (ptrLN) malloc(bLen);
 *Le = 1 ; *ee = 1 ;
 Lz = Lx ; movmem( xx, zz, 4*Lz ) ;
 for (j=1; j<=Ln; j++) {
  if (j==Ln) maxci = bzn ; else maxci = 31 ;
  cw = 1 ;  nw = *(nn+j-1) ;
  for (ci=0; ci<=maxci; ci++) {
   if ( (cw & nw) != 0 ) {
    mult( Lz, zz, *Le, ee, &Lth, th ) ;
    psor( Lth, th, Lpp, pp, Le, ee) ;
   }
   mult( Lz, zz, Lz, zz, &Lth, th ) ;
   psor( Lth, th, Lpp, pp, &Lz, zz ) ;
   cw <<= 1 ;
  }
 }
 Lth = *Le ; movmem( ee, th, 4*Lth ) ;
 modR( Lth, th, Lpp, pp, Le, ee ) ;
 free( th ) ; free( zz ) ;
}/* dexp */


/* Modular product discrete exponentiation */
void dexp2( lenLN Lx1, ptrLN x1, lenLN Ln1, ptrLN n1,
            lenLN Lx2, ptrLN x2, lenLN Ln2, ptrLN n2,
	    lenLN Lpp, ptrLN pp, lenLN *Le, ptrLN ee )
/* ee = ( power( x1, n1 ) * power( x2, n2 ) )  mod pp  */
{
 ptrLN  zz, xp ;
 lenLN Lz, Lxp ;
 unsigned bzn ;
 int ci, j ;
 long n1I, n2I ;
 
 xp = (ptrLN) malloc(bLen) ;
 zz = (ptrLN) malloc(bLen) ;
 mult( Lx1, x1, Lx2, x2, &Lxp, xp ) ;
 psor( Lxp, xp, Lpp, pp, &Lz, zz ) ;
 modR( Lz, zz, Lpp, pp, &Lxp, xp ) ;
 if ( isGreater( Ln1, n1, Ln2, n2 ) ) { 
  setmem( n2+Ln2, 4*(Ln1-Ln2), 0 ) ;
  Ln2 = Ln1 ;
  bzn = fb1( *(n1+Ln1-1) ) ;
  bzn = 31 - bzn ;
 } else {
  setmem( n1+Ln1, 4*(Ln2-Ln1), 0 ) ;
  Ln1 = Ln2 ;
  bzn = fb1( *(n2+Ln2-1) ) ;
  bzn = 31 - bzn ;
 }
 *Le = 1 ; *ee = 1 ;
 for (j=Ln1; j>=1; j--) {
  n1I = *(n1+j-1) ; n2I = *(n2+j-1) ;
  if (j<Ln1) bzn = 0 ;
  else {
   n1I <<= bzn ;
   n2I <<= bzn ;
  } 
  for (ci=bzn+1; ci<=32; ci++) { 
   mult( *Le, ee, *Le, ee, &Lz, zz ) ;
   psor( Lz, zz, Lpp, pp, Le, ee ) ;
   if (n1I<0) {
     if (n2I<0) {
      mult( *Le, ee, Lxp, xp, &Lz, zz ) ;
      psor( Lz, zz, Lpp, pp, Le, ee ) ;
     } else {
      mult( *Le, ee, Lx1, x1, &Lz, zz ) ;
      psor( Lz, zz, Lpp, pp, Le, ee ) ;
     }
   } else
     if (n2I<0) {
      mult( *Le, ee, Lx2, x2, &Lz, zz ) ;
      psor( Lz, zz, Lpp, pp, Le, ee ) ;
     }
   n1I <<= 1 ; n2I <<= 1 ;
  }
 }
 Lz = *Le ; movmem( ee, zz, 4**Le ) ;
 modR( Lz, zz, Lpp, pp, Le, ee ) ;
 free(zz) ; free(xp) ;
}/* dexp2 */

/* dispose residue array ( rs[] )  */
void clear_rs( unsigned Lpp )
{
int  i ;

if (Nres>Lpp) for (i=1; i<=Nres-Lpp; i++)  free(rs[i]) ;
}

