/**<sfio.c>***************************************************
*                       V O U C H                           *
*   VOUCH 1.1  Copyright (c) 1993, 1994  Awais M Hussain    *
*                   All rights reserved                     *
*************************************************************/
/* Consult <sfio.man> for documentation.
*/
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <mem.h>
#include <io.h>
#include "vch.h"

extern lenLN Lh1, Lqq, LkSec, LrSign, LxSec ; /* vch.c */
extern ptrLN h1, kSec, rSign, xSec ;    /* vch.c */

extern void exit_proc( char *fn, int err ) ;

/********************************************************/
/* store (pre-computed) r_signature for later use */
void write_rFile( char *fn,  long *nb, char *pswd ) ;

/* fetch (pre-computed) r_signature  */
void read_rFile( char *fn, char *pswd ) ;

/* re-encrypt r_signatures when password is changed */
void re_enc_rFile( char *fn, char *opswd, char *pswd ) ;

/* write private_key (LxSec, xSec) */
int write_prvKey( char *fn, char *pswd ) ;

/* read private_key (LxSec, xSec) */
void read_prvKey( char *fn, char *pswd ) ;


/**************************************************/
void read_rFile( char *fn, char *pswd )
{
  FILE *ff ;
  long unsigned Ls, nb, fsize ;
  int fh ;

  if ( (ff = fopen( fn, "r+b" )) == (FILE*) NULL ) exit_proc( fn, errno ) ;
  fread( &Ls, 4L, 1L, ff ) ; /* Ls = longNumberLength */
  fread( &nb, 4L, 1L, ff ) ; /* nb = number of (rSign, kSec) pairs */
  fseek( ff, (nb-1)*8*Ls, SEEK_CUR ) ; /* get to the last pair */
  fread( kSec, 4L, Ls, ff ) ;
  fseek( ff, -4*Ls, SEEK_CUR ) ;
  fwrite( rSign, 4L, Ls, ff ) ; /* overwrite kSec file space */
  fseek( ff, (nb-1)*8*Ls+Ls*4+8, SEEK_SET ) ;
  fread( rSign, 4L, Ls, ff ) ;
  LrSign = LkSec = Ls ;
  fseek( ff, 4L, SEEK_SET ) ; /* update nb */
  nb-- ;
  fwrite( &nb, 4L, 1L, ff ) ;
  fclose(ff) ;
  cryptLN( 0, pswd, &LkSec, kSec ) ;  /* decrypt (LkSec,kSec) */
  while ( (*(rSign+LrSign-1)==0) && (LrSign>1) )  LrSign-- ;
  while ( (*(kSec+LkSec-1)==0) && (LkSec>1) )  LkSec-- ;
  /* adjust file size */
  fh = open( fn, O_RDWR) ;
  fsize = filelength(fh) - 8*Ls ;
  chsize( fh, fsize ) ;
  close(fh) ;
  if (fsize<=8) remove(fn) ;
}/* read_rFile */


/************************************************************/
void write_rFile( char *fn,  long *nb, char *pswd )
{
  FILE *ff ;
  long unsigned ti ;
  unsigned Lqt ;
  int i ;

  if (Lqq & 01) Lqt = Lqq+1 ; else Lqt = Lqq ; /* make length an even number*/
  if ( access(fn,0) != 0 ) {
    ff = fopen(fn,"wb") ;
    ti = Lqt ; fwrite( &ti, 4L, 1L, ff ) ; /* lenLN */
    ti = 0 ;   fwrite( &ti, 4L, 1L, ff ) ; /* no. of (kSec, rSign) pairs */
    fclose(ff) ;
  } 
  for (i=LrSign; i<Lqt; ++i) *(rSign+i) = 0 ;
  for (i=LkSec; i<Lqt; ++i) *(kSec+i) = 0 ;
  cryptLN( 1, pswd, &Lqt, kSec ) ; 
  ff = fopen(fn,"r+b") ;
  fseek( ff, 0L, SEEK_END ) ;
  fwrite( kSec, 4L, Lqt, ff ) ;
  fwrite( rSign, 4L, Lqt, ff ) ;
  fseek( ff, 4L, SEEK_SET ) ;
  fread( &ti, 4L, 1L, ff ) ;
  fseek( ff, 4L, SEEK_SET ) ; ti++ ;
  fwrite( &ti, 4L, 1L, ff ) ;
  fclose(ff) ;
  *nb = ti ;
}/* write_rFile */


/**********************************************************/
/* uses scratch LN (Lh1, h1) */
void re_enc_rFile( char *fn, char *opswd, char *pswd )
{
  FILE *ff ;
  long unsigned Ls, nb ;
  int i ;

  if ( (ff = fopen( fn, "r+b" )) == (FILE*) NULL ) exit_proc( fn, errno ) ;
  fread( &Ls, 4, 1, ff ) ;
  fread( &nb, 4, 1, ff ) ;
  for (i=0; i<nb; ++i) {
    Lh1 = Ls ;  fread( h1, 4, Ls, ff ) ;
    cryptLN( 0, opswd, &Lh1, h1 ) ;
    cryptLN( 1, pswd, &Lh1, h1 ) ;
    memset( h1+Lh1, 0, 4*(Ls-Lh1) ) ;
    fseek( ff, -4*Ls, SEEK_CUR ) ;
    fwrite( h1, 4, Ls, ff ) ;
    fseek( ff, 4*Ls, SEEK_CUR ) ;
  }
  fclose(ff) ;
}/* re_enc_rFile */


/**************************************************/
int write_prvKey( char *fn, char *pswd )
{
  FILE *ff ;
  long ti ;

  cryptLN( 1, pswd, &LxSec, xSec ) ;
  if ( (ff = fopen( fn, "wb" )) == (FILE*) NULL ) return( errno )  ;
  ti = LxSec ;
  fwrite( &ti, 4, 1, ff ) ;
  fwrite( xSec, 4, LxSec, ff ) ;
  fclose( ff ) ;
  return(0) ;
}/* write_prvKey */

/**********************************************/
void read_prvKey( char *fn, char *pswd )
{
  FILE *ff ;
  long ti ;

  if ( (ff=fopen(fn,"rb")) == (FILE*) NULL ) exit_proc( fn, errno ) ;
  fread( &ti, 4, 1, ff ) ; LxSec = ti ;
  fread( xSec, 4, LxSec, ff ) ;
  fclose( ff ) ;
  cryptLN( 0, pswd, &LxSec, xSec ) ;
}/* read_prvKey */

