#include <stdio.h>
char *getenv();
#include <ctype.h>
#ifndef NULL
#define NULL ((void *)0)
#endif

int forkp(cmdline)
char *cmdline;
{
	register char *cp, *xp;
	int result;
	static char path[64];

	if (-1 != (result = tryfork("", cmdline)))
		return result;
	if ((cp = getenv("PATH")) != 0) 
	{
		while (*cp) 
		{
			xp = path;
			while (*cp) 
			{
				if (*cp == ';') 
				{
					++cp;
					break;
				}
				*xp++ = *cp++;
			}
			*xp = 0;
			if (path[0] != 0)
				if (-1 != (result = tryfork(path, cmdline)))
					return result;
		}
	}
	return -1;
}

static
int tryfork(dir, cmdline)
char *dir, *cmdline;
{
	static char newname[64];
	static char name[64];
	register char *cp;
	register int i;
	int wait();
	char *strrchr(),*strchr();
	
	/* get the name */
	for (i = 0, cp = cmdline; !isspace(*cp);cp++,i++)
		name[i] = *cp;
	name[i] = '\0';	/* terminate the string */
	
	strcpy(newname, dir);
	if (((cp = strchr(newname, '/')) || (cp = strchr(newname, '\\')))
				&& *(cp+1) != '\0')
		strcat(newname, "/");
	strcat(newname, name);
	if (strchr(name,'.') == NULL)
		strcat(newname,".com");
	if (-1 != fork(newname, cmdline))
		return wait();
	strcpy(strrchr(newname,'.'), ".exe");
	if (-1 != fork(newname, cmdline))
		return wait();
	return -1;
}

int fork(path, cmdline)
char *path, *cmdline;
{
	static char cmdbuf[131];
	char *f1 = NULL,*f2 = NULL;
	char fcb1[16], fcb2[16];
	fcbinit(".", fcb1);		/* initialize fcb's, in case no args */
	fcbinit(".", fcb2);
	/* skip the zeroeth arg on the command line */
	while(*cmdline && isspace(*cmdline))	/* skip blanks if any */
		++cmdline;
	while(*cmdline && !isspace(*cmdline))	/* skip non-blanks */
		++cmdline;
	for(f1 = cmdline;*f1 && isspace(*f1);)	/* find first non blank for f1 */
		++f1;
	for(f2 = f1;*f2 && !isspace(*f2);)		/* find first blank for f2 */
		++f2;
	while (*f2 && isspace(*f2))				/* find first non blank for f2 */
		++f2;
	/* f1 and f2 will be NULL if there is no argv[1] and argv[2] respectively */
	if (*f1)	
		fcbinit(f1,fcb1);
	if (*f2)
		fcbinit(f2,fcb2);
	/* make sure the command line is terminated by a carriage return */
	strncpy(&cmdbuf[1],cmdline,127);
	if (strlen(cmdline) >= 127)
		cmdbuf[128] = '\0';
	cmdbuf[0] = strlen(&cmdbuf[1]);
	strcat(&cmdbuf[1],"\r");
#ifdef DEBUG
	fprintf(stderr,"path = |%s| tail = %s\n",path,&cmdbuf[1]);
#endif
	return fexec(path, NULL, cmdbuf, fcb1, fcb2);
}
