//
//              SEND.C    BY  Brian Hill
//
//      This program will take a message as a command line argument and
// send this message out COM 1 in a format appropriate to the TSR program
// MESSAGE.C.  If MESSAGE is installed on both machines, two way communication
// is possible, otherwise SEND may be used.
//
//

#include <dos.h>
#include <string.h>
#include <stdlib.h>

/**        PROGRAM DEFINES          **/
#define SOH 1                // Start Of Header
#define EOT 4                // End OF Transmit

/**         FUNCTION PROTOTYPES     **/
void init(void);             // setup serial port
int chk_xmit();              // ok to send character out COM 1?
void xmit_char(char ch);     // send char out COM 1.

int port;                    // serial port address

main(int argc, char **argv)
{
	char string[81];        // string to send
	char *p;                // pointer to string
	char ch;                // scratch variables
	int i = 1;              //

	if(argc < 2)
	{
		printf("\nUSAGE:   send <message>");
		exit(1);
	}

	init();                 // set serial port up

	p = string;
	for(;i<argc;i++)        // move message into string from command line
	{
		strcpy(p,argv[i]);   // copy next word
		while(*p) p++;       // find end of string
		*p++ = ' ';          // space between words
	}
	*p = 0;

	/* send string thru COM 1 */
	p = string;
	xmit_char(SOH);         // signal start of transmission
	while(*p)
	{
	   xmit_char(*p);       // sent this character
	   p++;                 // point to next character
	}
	xmit_char(EOT);         // specify end of transmission

} // end of main

void init(void)
{
	int _far *lp;           // pointer to DOS info
	char ch;

	lp = (int far *) 0x00400000;    // pointer to DOS port info.
	port = *lp;                     // get port address for COM 1

	ch = inp(port + 3);             // get UART line control register info

	/* port value for 8, N, 1 = xx 000 0 11 */
	ch &= 0xC0;                     // save two highest bits (xx)
	ch |= 0x03;                     // set 8 data bits
	outp(port + 3, ch);             // set 8N1

	/* Set BPS rate to 9600  ::  115,200 / 12 = 9,600 BPS */
	outp(port + 3, ch | 0x80);      // raise Data Latch Access Bit
	outp(port    , 0x0C);           // write low byte of 12 decimal
	outp(port + 1, 0x00);           // write high byte of 0

	ch = inp(port + 3);             // lower DLAB
	outp(port + 3, ch & 0x7F);

} // end of init


int chk_xmit()                  // wait 'til port available
{
	int status;

	status = inp(port + 5); // read line status register
	return(status & 0x20);  // = xx1xxxxx binary when OK to send character
}

void xmit_char(char ch)
{
	while(chk_xmit() == 0) {;}  // wait until port available
	outp(port,ch);              //  and then send it out
}

