/* DOS_DEV.C - Skeleton 'C' MS-DOS device driver, use with DOS_DRV.ASM */

/*
 * $Author:   Phlash  $
 * $Revision:   1.0  $
 * $Date:   22 Jan 1994 20:40:02  $
 */

// DOS driver structures
typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned long DWORD;

#pragma pack(1)
typedef struct dhTag {
            struct dhTag far *next;
            WORD attributes;
            WORD Strategy;
            WORD Interrupt;
            char name[8];
            } DevHeader_t;

typedef struct {
            BYTE length;
            BYTE unit;
            BYTE command;
            WORD status;
            BYTE resv[8];
            BYTE media;
            BYTE far *address;
            WORD count;
            WORD sector;
            } ReqHeader_t;
#pragma pack()

// Declare external pointers (in DOS_DRV.ASM)
extern DevHeader_t far *DHPtr;
extern ReqHeader_t far *RHPtr;

// Declare routines in DOS_DRV.ASM
extern int near BIOSChr(char c);

// Actual device name to set up in the header during Init()
char devName[8] = "DOS_DEV ";

// Special value to identify end of _BSS segment (and also this driver)
static BYTE endData;

// Utility function, to display a string on screen via the BIOS
int Display(char far *str)
{
int i;

   for(i=0; str[i] != 0; i++)
      BIOSChr(str[i]);
   return i;
}

int Init(void)
{
char far *hiStr = "\r\n\n$Header:   C:/phil/lib/dos_drv/dos_dev.c_v   1.0   22 Jan 1994 20:40:02   Phlash  $, loaded.\r\n";
int i;

// Say hi.
   Display(hiStr);

// Change the device name
   for(i=0; i<8; i++)
      DHPtr->name[i] = devName[i];

// Set the break address for DOS loader
   RHPtr->address = &endData;
   return 0;
}

int MediaChk(void)
{
   return 0x8003;
}

int BuildBPB(void)
{
   return 0x8003;
}

int IoctlRd(void)
{
   return 0x8003;
}

int Read(void)
{
   return 0x8003;
}

int NdRead(void)
{
   return 0x8003;
}

int InpStat(void)
{
   return 0x8003;
}

int InpFlush(void)
{
   return 0x8003;
}

int Write(void)
{
   return 0x8003;
}

int WriteVfy(void)
{
   return 0x8003;
}

int OutStat(void)
{
   return 0x8003;
}

int OutFlush(void)
{
   return 0x8003;
}

int IoctlWt(void)
{
   return 0x8003;
}

int DevOpen(void)
{
   return 0x8003;
}

int DevClose(void)
{
   return 0x8003;
}

int Unknown(void)
{
   return 0x8003;
}

/* End */
